/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.provider;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.NullDigest;
import org.xipki.security.HashAlgoType;
import org.xipki.security.pkcs11.provider.P11PrivateKey;

public class P11RSADigestSignatureSpi
extends SignatureSpi {
    private Digest digest;
    private AlgorithmIdentifier digestAlgId;
    private P11PrivateKey signingKey;

    protected P11RSADigestSignatureSpi(Digest digest) {
        this.digest = digest;
        this.digestAlgId = null;
    }

    protected P11RSADigestSignatureSpi(HashAlgoType digestAlg) {
        this.digestAlgId = digestAlg.algorithmIdentifier();
        this.digest = digestAlg.createDigest();
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        throw new UnsupportedOperationException("engineVerify unsupported");
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof P11PrivateKey)) {
            throw new InvalidKeyException("privateKey is not instanceof " + P11PrivateKey.class.getName());
        }
        String algo = privateKey.getAlgorithm();
        if (!"RSA".equals(algo)) {
            throw new InvalidKeyException("privateKey is not an RSA private key: " + algo);
        }
        this.digest.reset();
        this.signingKey = (P11PrivateKey)privateKey;
    }

    @Override
    protected void engineUpdate(byte input) throws SignatureException {
        this.digest.update(input);
    }

    @Override
    protected void engineUpdate(byte[] input, int off, int len) throws SignatureException {
        this.digest.update(input, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            byte[] bytes = this.derEncode(hash);
            return this.signingKey.sign(1L, null, bytes);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new SignatureException("key too small for signature type");
        }
        catch (Exception ex) {
            throw new SignatureException(ex.getMessage(), ex);
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        throw new UnsupportedOperationException("engineVerify unsupported");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    private byte[] derEncode(byte[] hash) throws IOException {
        if (this.digestAlgId == null) {
            return hash;
        }
        DigestInfo digestInfo = new DigestInfo(this.digestAlgId, hash);
        return digestInfo.getEncoded("DER");
    }

    public static class NoneRSA
    extends P11RSADigestSignatureSpi {
        public NoneRSA() {
            super((Digest)new NullDigest());
        }
    }

    public static class SHA3_512
    extends P11RSADigestSignatureSpi {
        public SHA3_512() {
            super(HashAlgoType.SHA3_512);
        }
    }

    public static class SHA3_384
    extends P11RSADigestSignatureSpi {
        public SHA3_384() {
            super(HashAlgoType.SHA3_384);
        }
    }

    public static class SHA3_256
    extends P11RSADigestSignatureSpi {
        public SHA3_256() {
            super(HashAlgoType.SHA3_256);
        }
    }

    public static class SHA3_224
    extends P11RSADigestSignatureSpi {
        public SHA3_224() {
            super(HashAlgoType.SHA3_224);
        }
    }

    public static class SHA512
    extends P11RSADigestSignatureSpi {
        public SHA512() {
            super(HashAlgoType.SHA512);
        }
    }

    public static class SHA384
    extends P11RSADigestSignatureSpi {
        public SHA384() {
            super(HashAlgoType.SHA384);
        }
    }

    public static class SHA256
    extends P11RSADigestSignatureSpi {
        public SHA256() {
            super(HashAlgoType.SHA256);
        }
    }

    public static class SHA224
    extends P11RSADigestSignatureSpi {
        public SHA224() {
            super(HashAlgoType.SHA224);
        }
    }

    public static class SHA1
    extends P11RSADigestSignatureSpi {
        public SHA1() {
            super(HashAlgoType.SHA1);
        }
    }
}

