/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.emulator;

import iaik.pkcs.pkcs11.wrapper.Functions;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.concurrent.TimeUnit;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.crypto.macs.HMac;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.concurrent.ConcurrentBag;
import org.xipki.common.concurrent.ConcurrentBagEntry;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.HashAlgoType;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.P11EntityIdentifier;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11RSAPkcsPssParams;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.util.SignerUtil;

public class EmulatorP11Identity
extends P11Identity {
    private static final Logger LOG = LoggerFactory.getLogger(EmulatorP11Identity.class);
    private final Key signingKey;
    private final ConcurrentBag<ConcurrentBagEntry<Cipher>> rsaCiphers = new ConcurrentBag();
    private final ConcurrentBag<ConcurrentBagEntry<Signature>> dsaSignatures = new ConcurrentBag();
    private final SecureRandom random;

    public EmulatorP11Identity(P11Slot slot, P11EntityIdentifier identityId, SecretKey signingKey, int maxSessions, SecureRandom random) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        super(slot, identityId, 0);
        this.signingKey = (Key)ParamUtil.requireNonNull((String)"signingKey", (Object)signingKey);
        this.random = (SecureRandom)ParamUtil.requireNonNull((String)"random", (Object)random);
    }

    public EmulatorP11Identity(P11Slot slot, P11EntityIdentifier identityId, PrivateKey privateKey, PublicKey publicKey, X509Certificate[] certificateChain, int maxSessions, SecureRandom random) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        super(slot, identityId, publicKey, certificateChain);
        this.signingKey = (Key)ParamUtil.requireNonNull((String)"privateKey", (Object)privateKey);
        this.random = (SecureRandom)ParamUtil.requireNonNull((String)"random", (Object)random);
        if (this.publicKey instanceof RSAPublicKey) {
            String providerName = "BC";
            LOG.info("use provider {}", (Object)providerName);
            for (int i = 0; i < maxSessions; ++i) {
                Cipher rsaCipher;
                try {
                    String algo = "RSA/ECB/NoPadding";
                    rsaCipher = Cipher.getInstance("RSA/ECB/NoPadding", providerName);
                    LOG.info("use cipher algorithm {}", (Object)"RSA/ECB/NoPadding");
                }
                catch (NoSuchPaddingException ex) {
                    throw new NoSuchAlgorithmException("NoSuchPadding", ex);
                }
                catch (NoSuchAlgorithmException ex) {
                    String algo = "RSA/NONE/NoPadding";
                    try {
                        rsaCipher = Cipher.getInstance("RSA/NONE/NoPadding", providerName);
                        LOG.info("use cipher algorithm {}", (Object)"RSA/NONE/NoPadding");
                    }
                    catch (NoSuchPaddingException e1) {
                        throw new NoSuchAlgorithmException("NoSuchPadding", ex);
                    }
                }
                rsaCipher.init(1, privateKey);
                this.rsaCiphers.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((Object)rsaCipher));
            }
        } else {
            String algorithm;
            if (this.publicKey instanceof ECPublicKey) {
                algorithm = "NONEwithECDSA";
            } else if (this.publicKey instanceof DSAPublicKey) {
                algorithm = "NONEwithDSA";
            } else {
                throw new IllegalArgumentException("Currently only RSA, DSA and EC public key are supported, but not " + this.publicKey.getAlgorithm() + " (class: " + this.publicKey.getClass().getName() + ")");
            }
            for (int i = 0; i < maxSessions; ++i) {
                Signature dsaSignature = Signature.getInstance(algorithm, "BC");
                dsaSignature.initSign(privateKey, random);
                this.dsaSignatures.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((Object)dsaSignature));
            }
        }
    }

    @Override
    protected byte[] digestSecretKey0(long mechanism) throws P11TokenException {
        if (!(this.signingKey instanceof SecretKey)) {
            throw new P11TokenException("digestSecretKey could not be applied to non-SecretKey");
        }
        HashAlgoType hashAlgo = HashAlgoType.getInstanceForPkcs11HashMech(mechanism);
        if (hashAlgo == null) {
            throw new P11TokenException("unknown mechanism " + Functions.mechanismCodeToString((long)mechanism));
        }
        return hashAlgo.hash(((SecretKey)this.signingKey).getEncoded());
    }

    @Override
    protected byte[] sign0(long mechanism, P11Params parameters, byte[] content) throws P11TokenException {
        if (4161L == mechanism) {
            return this.dsaAndEcdsaSign(content, null);
        }
        if (4162L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgoType.SHA1);
        }
        if (4163L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgoType.SHA224);
        }
        if (4164L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgoType.SHA256);
        }
        if (4165L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgoType.SHA384);
        }
        if (4166L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgoType.SHA512);
        }
        if (4168L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgoType.SHA3_224);
        }
        if (4169L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgoType.SHA3_256);
        }
        if (4170L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgoType.SHA3_384);
        }
        if (4171L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgoType.SHA3_512);
        }
        if (17L == mechanism) {
            return this.dsaAndEcdsaSign(content, null);
        }
        if (18L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgoType.SHA1);
        }
        if (19L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgoType.SHA224);
        }
        if (20L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgoType.SHA256);
        }
        if (21L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgoType.SHA384);
        }
        if (22L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgoType.SHA512);
        }
        if (24L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgoType.SHA3_224);
        }
        if (25L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgoType.SHA3_256);
        }
        if (26L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgoType.SHA3_384);
        }
        if (27L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgoType.SHA3_512);
        }
        if (3L == mechanism) {
            return this.rsaX509Sign(content);
        }
        if (1L == mechanism) {
            return this.rsaPkcsSign(content, null);
        }
        if (6L == mechanism) {
            return this.rsaPkcsSign(content, HashAlgoType.SHA1);
        }
        if (70L == mechanism) {
            return this.rsaPkcsSign(content, HashAlgoType.SHA224);
        }
        if (64L == mechanism) {
            return this.rsaPkcsSign(content, HashAlgoType.SHA256);
        }
        if (65L == mechanism) {
            return this.rsaPkcsSign(content, HashAlgoType.SHA384);
        }
        if (66L == mechanism) {
            return this.rsaPkcsSign(content, HashAlgoType.SHA512);
        }
        if (102L == mechanism) {
            return this.rsaPkcsSign(content, HashAlgoType.SHA3_224);
        }
        if (96L == mechanism) {
            return this.rsaPkcsSign(content, HashAlgoType.SHA3_256);
        }
        if (97L == mechanism) {
            return this.rsaPkcsSign(content, HashAlgoType.SHA3_384);
        }
        if (98L == mechanism) {
            return this.rsaPkcsSign(content, HashAlgoType.SHA3_512);
        }
        if (13L == mechanism) {
            return this.rsaPkcsPssSign(parameters, content, null);
        }
        if (14L == mechanism) {
            return this.rsaPkcsPssSign(parameters, content, HashAlgoType.SHA1);
        }
        if (71L == mechanism) {
            return this.rsaPkcsPssSign(parameters, content, HashAlgoType.SHA224);
        }
        if (67L == mechanism) {
            return this.rsaPkcsPssSign(parameters, content, HashAlgoType.SHA256);
        }
        if (68L == mechanism) {
            return this.rsaPkcsPssSign(parameters, content, HashAlgoType.SHA384);
        }
        if (69L == mechanism) {
            return this.rsaPkcsPssSign(parameters, content, HashAlgoType.SHA512);
        }
        if (103L == mechanism) {
            return this.rsaPkcsPssSign(parameters, content, HashAlgoType.SHA3_224);
        }
        if (99L == mechanism) {
            return this.rsaPkcsPssSign(parameters, content, HashAlgoType.SHA3_256);
        }
        if (100L == mechanism) {
            return this.rsaPkcsPssSign(parameters, content, HashAlgoType.SHA3_384);
        }
        if (101L == mechanism) {
            return this.rsaPkcsPssSign(parameters, content, HashAlgoType.SHA3_512);
        }
        if (545L == mechanism) {
            return this.hmac(content, HashAlgoType.SHA1);
        }
        if (598L == mechanism) {
            return this.hmac(content, HashAlgoType.SHA224);
        }
        if (593L == mechanism) {
            return this.hmac(content, HashAlgoType.SHA256);
        }
        if (609L == mechanism) {
            return this.hmac(content, HashAlgoType.SHA384);
        }
        if (625L == mechanism) {
            return this.hmac(content, HashAlgoType.SHA512);
        }
        if (694L == mechanism) {
            return this.hmac(content, HashAlgoType.SHA3_224);
        }
        if (689L == mechanism) {
            return this.hmac(content, HashAlgoType.SHA3_256);
        }
        if (705L == mechanism) {
            return this.hmac(content, HashAlgoType.SHA3_384);
        }
        if (721L == mechanism) {
            return this.hmac(content, HashAlgoType.SHA3_512);
        }
        throw new P11TokenException("unsupported mechanism " + mechanism);
    }

    private byte[] hmac(byte[] contentToSign, HashAlgoType hashAlgo) {
        HMac hmac = new HMac(hashAlgo.createDigest());
        hmac.update(contentToSign, 0, contentToSign.length);
        byte[] signature = new byte[hmac.getMacSize()];
        hmac.doFinal(signature, 0);
        return signature;
    }

    private byte[] rsaPkcsPssSign(P11Params parameters, byte[] contentToSign, HashAlgoType hashAlgo) throws P11TokenException {
        byte[] encodedHashValue;
        if (!(parameters instanceof P11RSAPkcsPssParams)) {
            throw new P11TokenException("the parameters is not of " + P11RSAPkcsPssParams.class.getName());
        }
        P11RSAPkcsPssParams pssParam = (P11RSAPkcsPssParams)parameters;
        HashAlgoType contentHash = HashAlgoType.getInstanceForPkcs11HashMech(pssParam.hashAlgorithm());
        if (contentHash == null) {
            throw new P11TokenException("unsupported HashAlgorithm " + pssParam.hashAlgorithm());
        }
        if (hashAlgo != null && contentHash != hashAlgo) {
            throw new P11TokenException("Invalid parameters: invalid hash algorithm");
        }
        HashAlgoType mgfHash = HashAlgoType.getInstanceForPkcs11MgfMech(pssParam.maskGenerationFunction());
        if (mgfHash == null) {
            throw new P11TokenException("unsupported MaskGenerationFunction " + pssParam.hashAlgorithm());
        }
        byte[] hashValue = hashAlgo == null ? contentToSign : hashAlgo.hash(contentToSign);
        try {
            encodedHashValue = SignerUtil.EMSA_PSS_ENCODE(contentHash, hashValue, mgfHash, (int)pssParam.saltLength(), this.signatureKeyBitLength(), this.random);
        }
        catch (XiSecurityException ex) {
            throw new P11TokenException("XiSecurityException: " + ex.getMessage(), ex);
        }
        return this.rsaX509Sign(encodedHashValue);
    }

    private byte[] rsaPkcsSign(byte[] contentToSign, HashAlgoType hashAlgo) throws P11TokenException {
        byte[] paddedHash;
        int modulusBitLen = this.signatureKeyBitLength();
        try {
            if (hashAlgo == null) {
                paddedHash = SignerUtil.EMSA_PKCS1_v1_5_encoding(contentToSign, modulusBitLen);
            } else {
                byte[] hash = hashAlgo.hash(contentToSign);
                paddedHash = SignerUtil.EMSA_PKCS1_v1_5_encoding(hash, modulusBitLen, hashAlgo);
            }
        }
        catch (XiSecurityException ex) {
            throw new P11TokenException("XiSecurityException: " + ex.getMessage(), ex);
        }
        return this.rsaX509Sign(paddedHash);
    }

    private byte[] rsaX509Sign(byte[] dataToSign) throws P11TokenException {
        ConcurrentBagEntry cipher;
        try {
            cipher = (ConcurrentBagEntry)this.rsaCiphers.borrow(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new P11TokenException("could not take any idle signer");
        }
        if (cipher == null) {
            throw new P11TokenException("no idle RSA cipher available");
        }
        try {
            byte[] ex = ((Cipher)cipher.value()).doFinal(dataToSign);
            return ex;
        }
        catch (BadPaddingException ex) {
            throw new P11TokenException("BadPaddingException: " + ex.getMessage(), ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new P11TokenException("IllegalBlockSizeException: " + ex.getMessage(), ex);
        }
        finally {
            this.rsaCiphers.requite((ConcurrentBag.IConcurrentBagEntry)cipher);
        }
    }

    private byte[] dsaAndEcdsaSign(byte[] dataToSign, HashAlgoType hashAlgo) throws P11TokenException {
        ConcurrentBagEntry sig0;
        byte[] hash = hashAlgo == null ? dataToSign : hashAlgo.hash(dataToSign);
        try {
            sig0 = (ConcurrentBagEntry)this.dsaSignatures.borrow(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new P11TokenException("InterruptedException occurs while retrieving idle signature");
        }
        if (sig0 == null) {
            throw new P11TokenException("no idle DSA Signature available");
        }
        try {
            Signature sig = (Signature)sig0.value();
            sig.update(hash);
            byte[] x962Signature = sig.sign();
            byte[] byArray = SignerUtil.convertX962DSASigToPlain(x962Signature, this.signatureKeyBitLength());
            return byArray;
        }
        catch (SignatureException ex) {
            throw new P11TokenException("SignatureException: " + ex.getMessage(), ex);
        }
        catch (XiSecurityException ex) {
            throw new P11TokenException("XiSecurityException: " + ex.getMessage(), ex);
        }
        finally {
            this.dsaSignatures.requite((ConcurrentBag.IConcurrentBagEntry)sig0);
        }
    }

    Key signingKey() {
        return this.signingKey;
    }
}

