/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.X509Cert;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11ObjectIdentifier;

public class P11SlotRefreshResult {
    private final Map<P11ObjectIdentifier, P11Identity> identities = new HashMap<P11ObjectIdentifier, P11Identity>();
    private final Map<P11ObjectIdentifier, X509Cert> certificates = new HashMap<P11ObjectIdentifier, X509Cert>();
    private final Set<Long> mechanisms = new HashSet<Long>();

    public Map<P11ObjectIdentifier, P11Identity> identities() {
        return this.identities;
    }

    public Map<P11ObjectIdentifier, X509Cert> certificates() {
        return this.certificates;
    }

    public Set<Long> mechanisms() {
        return this.mechanisms;
    }

    public void addIdentity(P11Identity identity) {
        ParamUtil.requireNonNull((String)"identity", (Object)identity);
        this.identities.put(identity.identityId().objectId(), identity);
    }

    public void addMechanism(long mechanism) {
        this.mechanisms.add(mechanism);
    }

    public void addCertificate(P11ObjectIdentifier objectId, X509Cert certificate) {
        ParamUtil.requireNonNull((String)"objectId", (Object)objectId);
        ParamUtil.requireNonNull((String)"certificate", (Object)certificate);
        this.certificates.put(objectId, certificate);
    }

    public X509Cert getCertForId(byte[] id) {
        for (P11ObjectIdentifier objId : this.certificates.keySet()) {
            if (!objId.matchesId(id)) continue;
            return this.certificates.get(objId);
        }
        return null;
    }
}

