/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.util.LogUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.bc.XiContentSigner;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11EntityIdentifier;

class P11MacContentSigner
implements XiContentSigner {
    private static final Logger LOG = LoggerFactory.getLogger(P11MacContentSigner.class);
    private final P11CryptService cryptService;
    private final P11EntityIdentifier identityId;
    private final AlgorithmIdentifier algorithmIdentifier;
    private final byte[] encodedAlgorithmIdentifier;
    private final long mechanism;
    private final ByteArrayOutputStream outputStream;

    P11MacContentSigner(P11CryptService cryptService, P11EntityIdentifier identityId, AlgorithmIdentifier macAlgId) throws XiSecurityException, P11TokenException {
        this.identityId = (P11EntityIdentifier)ParamUtil.requireNonNull((String)"identityId", (Object)identityId);
        this.cryptService = (P11CryptService)ParamUtil.requireNonNull((String)"cryptService", (Object)cryptService);
        this.algorithmIdentifier = (AlgorithmIdentifier)ParamUtil.requireNonNull((String)"macAlgId", (Object)macAlgId);
        try {
            this.encodedAlgorithmIdentifier = this.algorithmIdentifier.getEncoded();
        }
        catch (IOException ex) {
            throw new XiSecurityException("could not encode AlgorithmIdentifier", ex);
        }
        ASN1ObjectIdentifier oid = macAlgId.getAlgorithm();
        if (PKCSObjectIdentifiers.id_hmacWithSHA1.equals((Object)oid)) {
            this.mechanism = 545L;
        } else if (PKCSObjectIdentifiers.id_hmacWithSHA224.equals((Object)oid)) {
            this.mechanism = 598L;
        } else if (PKCSObjectIdentifiers.id_hmacWithSHA256.equals((Object)oid)) {
            this.mechanism = 593L;
        } else if (PKCSObjectIdentifiers.id_hmacWithSHA384.equals((Object)oid)) {
            this.mechanism = 609L;
        } else if (PKCSObjectIdentifiers.id_hmacWithSHA512.equals((Object)oid)) {
            this.mechanism = 625L;
        } else if (NISTObjectIdentifiers.id_hmacWithSHA3_224.equals((Object)oid)) {
            this.mechanism = 694L;
        } else if (NISTObjectIdentifiers.id_hmacWithSHA3_256.equals((Object)oid)) {
            this.mechanism = 689L;
        } else if (NISTObjectIdentifiers.id_hmacWithSHA3_384.equals((Object)oid)) {
            this.mechanism = 705L;
        } else if (NISTObjectIdentifiers.id_hmacWithSHA3_512.equals((Object)oid)) {
            this.mechanism = 721L;
        } else {
            throw new IllegalArgumentException("unknown algorithm identifier " + oid.getId());
        }
        this.outputStream = new ByteArrayOutputStream();
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    @Override
    public byte[] getEncodedAlgorithmIdentifier() {
        return Arrays.copyOf(this.encodedAlgorithmIdentifier, this.encodedAlgorithmIdentifier.length);
    }

    public OutputStream getOutputStream() {
        this.outputStream.reset();
        return this.outputStream;
    }

    public byte[] getSignature() {
        try {
            byte[] dataToSign = this.outputStream.toByteArray();
            this.outputStream.reset();
            return this.cryptService.getIdentity(this.identityId).sign(this.mechanism, null, dataToSign);
        }
        catch (XiSecurityException ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex);
            throw new RuntimeCryptoException("XiSecurityException: " + ex.getMessage());
        }
        catch (Throwable th) {
            LogUtil.warn((Logger)LOG, (Throwable)th);
            throw new RuntimeCryptoException(th.getClass().getName() + ": " + th.getMessage());
        }
    }
}

