/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.util.LogUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.pkcs11.P11EntityIdentifier;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;

public class P11CryptService {
    private static final Logger LOG = LoggerFactory.getLogger(P11CryptService.class);
    private P11Module module;

    public P11CryptService(P11Module module) throws P11TokenException {
        this.module = (P11Module)ParamUtil.requireNonNull((String)"module", (Object)module);
    }

    public synchronized void refresh() throws P11TokenException {
        LOG.info("refreshing PKCS#11 module {}", (Object)this.module.getName());
        List<P11SlotIdentifier> slotIds = this.module.slotIdentifiers();
        for (P11SlotIdentifier slotId : slotIds) {
            P11Slot slot;
            try {
                slot = this.module.getSlot(slotId);
            }
            catch (P11TokenException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("P11TokenException while initializing slot " + slotId));
                continue;
            }
            catch (Throwable th) {
                LOG.error("unexpected error while initializing slot " + slotId, th);
                continue;
            }
            slot.refresh();
        }
        LOG.info("refreshed PKCS#11 module {}", (Object)this.module.getName());
    }

    public P11Module module() throws P11TokenException {
        return this.module;
    }

    public P11Slot getSlot(P11SlotIdentifier slotId) throws P11TokenException {
        return this.module.getSlot(slotId);
    }

    public P11Identity getIdentity(P11EntityIdentifier identityId) throws P11TokenException {
        ParamUtil.requireNonNull((String)"identityId", (Object)identityId);
        return this.module.getSlot(identityId.slotId()).getIdentity(identityId.objectId());
    }

    public String toString() {
        return this.module.toString();
    }
}

