/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.DSAParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.util.LogUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.HashAlgoType;
import org.xipki.security.X509Cert;
import org.xipki.security.exception.P11DuplicateEntityException;
import org.xipki.security.exception.P11PermissionException;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.exception.P11UnknownEntityException;
import org.xipki.security.exception.P11UnsupportedMechanismException;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11MechanismFilter;
import org.xipki.security.pkcs11.P11NewKeyControl;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.P11SlotRefreshResult;
import org.xipki.security.pkcs11.Pkcs11Functions;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.DSAParameterCache;
import org.xipki.security.util.X509Util;

public abstract class AbstractP11Slot
implements P11Slot {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractP11Slot.class);
    protected final String moduleName;
    protected final P11SlotIdentifier slotId;
    private final boolean readOnly;
    private final SecureRandom random = new SecureRandom();
    private final ConcurrentHashMap<P11ObjectIdentifier, P11Identity> identities = new ConcurrentHashMap();
    private final ConcurrentHashMap<P11ObjectIdentifier, X509Cert> certificates = new ConcurrentHashMap();
    private final Set<Long> mechanisms = new HashSet<Long>();
    private final P11MechanismFilter mechanismFilter;

    protected AbstractP11Slot(String moduleName, P11SlotIdentifier slotId, boolean readOnly, P11MechanismFilter mechanismFilter) throws P11TokenException {
        this.mechanismFilter = (P11MechanismFilter)ParamUtil.requireNonNull((String)"mechanismFilter", (Object)mechanismFilter);
        this.moduleName = ParamUtil.requireNonBlank((String)"moduleName", (String)moduleName);
        this.slotId = (P11SlotIdentifier)ParamUtil.requireNonNull((String)"slotId", (Object)slotId);
        this.readOnly = readOnly;
    }

    protected static String hex(byte[] bytes) {
        return Hex.toHexString((byte[])bytes).toUpperCase();
    }

    protected static String getDescription(byte[] keyId, char[] keyLabel) {
        StringBuilder sb = new StringBuilder();
        sb.append("id ").append(keyId == null ? "null" : Hex.toHexString((byte[])keyId));
        sb.append(" and label ").append(keyLabel == null ? "null" : new String(keyLabel));
        return sb.toString();
    }

    protected static String getDescription(byte[] keyId, String keyLabel) {
        StringBuilder sb = new StringBuilder();
        sb.append("id ").append(keyId == null ? "null" : Hex.toHexString((byte[])keyId));
        sb.append(" and label ").append(keyLabel);
        return sb.toString();
    }

    protected abstract void updateCertificate0(P11ObjectIdentifier var1, X509Certificate var2) throws P11TokenException, CertificateException;

    protected abstract void removeIdentity0(P11ObjectIdentifier var1) throws P11TokenException;

    protected abstract void addCert0(P11ObjectIdentifier var1, X509Certificate var2) throws P11TokenException, CertificateException;

    protected abstract P11Identity generateSecretKey0(long var1, int var3, String var4, P11NewKeyControl var5) throws P11TokenException;

    protected abstract P11Identity createSecretKey0(long var1, byte[] var3, String var4, P11NewKeyControl var5) throws P11TokenException;

    protected abstract P11Identity generateDSAKeypair0(BigInteger var1, BigInteger var2, BigInteger var3, String var4, P11NewKeyControl var5) throws P11TokenException;

    protected abstract P11Identity generateECKeypair0(ASN1ObjectIdentifier var1, String var2, P11NewKeyControl var3) throws P11TokenException;

    protected abstract P11Identity generateRSAKeypair0(int var1, BigInteger var2, String var3, P11NewKeyControl var4) throws P11TokenException;

    protected abstract P11SlotRefreshResult refresh0() throws P11TokenException;

    protected abstract void removeCerts0(P11ObjectIdentifier var1) throws P11TokenException;

    protected X509Cert getCertForId(byte[] id) {
        for (P11ObjectIdentifier objId : this.certificates.keySet()) {
            if (!objId.matchesId(id)) continue;
            return this.certificates.get(objId);
        }
        return null;
    }

    private void updateCaCertsOfIdentities() {
        for (P11Identity identity : this.identities.values()) {
            this.updateCaCertsOfIdentity(identity);
        }
    }

    private void updateCaCertsOfIdentity(P11Identity identity) {
        Object[] certchain = identity.certificateChain();
        if (certchain == null || certchain.length == 0) {
            return;
        }
        Object[] newCertchain = this.buildCertPath(certchain[0]);
        if (!Arrays.equals(certchain, newCertchain)) {
            try {
                identity.setCertificates((X509Certificate[])newCertchain);
            }
            catch (P11TokenException ex) {
                LOG.warn("could not set certificates for identity {}", (Object)identity.identityId());
            }
        }
    }

    private X509Certificate[] buildCertPath(X509Certificate cert) {
        LinkedList<X509Certificate> certs = new LinkedList<X509Certificate>();
        X509Certificate cur = cert;
        while (cur != null) {
            certs.add(cur);
            cur = this.getIssuerForCert(cur);
        }
        return certs.toArray(new X509Certificate[0]);
    }

    private X509Certificate getIssuerForCert(X509Certificate cert) {
        try {
            if (X509Util.isSelfSigned(cert)) {
                return null;
            }
            for (X509Cert cert2 : this.certificates.values()) {
                if (cert2.cert() == cert || !X509Util.issues(cert2.cert(), cert)) continue;
                return cert2.cert();
            }
        }
        catch (CertificateEncodingException ex) {
            LOG.warn("invalid encoding of certificate {}", (Object)ex.getMessage());
        }
        return null;
    }

    @Override
    public void refresh() throws P11TokenException {
        P11SlotRefreshResult res = this.refresh0();
        this.mechanisms.clear();
        this.certificates.clear();
        this.identities.clear();
        ArrayList<Long> ignoreMechs = new ArrayList<Long>();
        for (Long mech : res.mechanisms()) {
            if (this.mechanismFilter.isMechanismPermitted(this.slotId, mech)) {
                this.mechanisms.add(mech);
                continue;
            }
            ignoreMechs.add(mech);
        }
        this.certificates.putAll(res.certificates());
        this.identities.putAll(res.identities());
        this.updateCaCertsOfIdentities();
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("initialized module ").append(this.moduleName).append(", slot ").append(this.slotId);
            sb.append("\nsupported mechanisms:\n");
            ArrayList<Long> sortedMechs = new ArrayList<Long>(this.mechanisms);
            Collections.sort(sortedMechs);
            for (Long mech : sortedMechs) {
                sb.append("\t").append(Pkcs11Functions.getMechanismDesc(mech)).append("\n");
            }
            sb.append("\nsupported by device but ignored mechanisms:\n");
            if (ignoreMechs.isEmpty()) {
                sb.append("\tNONE\n");
            } else {
                Collections.sort(ignoreMechs);
                for (Long mech : ignoreMechs) {
                    sb.append("\t").append(Pkcs11Functions.getMechanismDesc(mech)).append("\n");
                }
            }
            List<P11ObjectIdentifier> ids = this.getSortedObjectIds(this.certificates.keySet());
            sb.append(ids.size()).append(" certificates:\n");
            for (P11ObjectIdentifier objectId : ids) {
                X509Cert entity = this.certificates.get(objectId);
                sb.append("\t").append(objectId);
                sb.append(", subject='").append(entity.subject()).append("'\n");
            }
            ids = this.getSortedObjectIds(this.identities.keySet());
            sb.append(ids.size()).append(" identities:\n");
            for (P11ObjectIdentifier objectId : ids) {
                P11Identity identity = this.identities.get(objectId);
                sb.append("\t").append(objectId);
                if (identity.publicKey() != null) {
                    sb.append(", algo=").append(identity.publicKey().getAlgorithm());
                    if (identity.certificate() != null) {
                        String subject = X509Util.getRfc4519Name(identity.certificate().getSubjectX500Principal());
                        sb.append(", subject='").append(subject).append("'");
                    }
                } else {
                    sb.append(", algo=<symmetric>");
                }
                sb.append("\n");
            }
            LOG.info(sb.toString());
        }
    }

    protected void addIdentity(P11Identity identity) throws P11DuplicateEntityException {
        if (!this.slotId.equals(identity.identityId().slotId())) {
            throw new IllegalArgumentException("invalid identity");
        }
        P11ObjectIdentifier objectId = identity.identityId().objectId();
        if (this.hasIdentity(objectId)) {
            throw new P11DuplicateEntityException(this.slotId, objectId);
        }
        this.identities.put(objectId, identity);
        this.updateCaCertsOfIdentity(identity);
    }

    @Override
    public boolean hasIdentity(P11ObjectIdentifier objectId) {
        return this.identities.containsKey(objectId);
    }

    @Override
    public Set<Long> mechanisms() {
        return Collections.unmodifiableSet(this.mechanisms);
    }

    @Override
    public boolean supportsMechanism(long mechanism) {
        return this.mechanisms.contains(mechanism);
    }

    @Override
    public void assertMechanismSupported(long mechanism) throws P11UnsupportedMechanismException {
        if (!this.mechanisms.contains(mechanism)) {
            throw new P11UnsupportedMechanismException(mechanism, this.slotId);
        }
    }

    @Override
    public Set<P11ObjectIdentifier> identityIdentifiers() {
        return Collections.unmodifiableSet(this.identities.keySet());
    }

    @Override
    public Set<P11ObjectIdentifier> certIdentifiers() {
        return Collections.unmodifiableSet(this.certificates.keySet());
    }

    @Override
    public String moduleName() {
        return this.moduleName;
    }

    @Override
    public P11SlotIdentifier slotId() {
        return this.slotId;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public P11Identity getIdentity(P11ObjectIdentifier objectId) throws P11UnknownEntityException {
        P11Identity ident = this.identities.get(objectId);
        if (ident == null) {
            throw new P11UnknownEntityException(this.slotId, objectId);
        }
        return ident;
    }

    @Override
    public P11ObjectIdentifier getObjectIdForId(byte[] id) {
        for (P11ObjectIdentifier objectId : this.identities.keySet()) {
            if (!objectId.matchesId(id)) continue;
            return objectId;
        }
        for (P11ObjectIdentifier objectId : this.certificates.keySet()) {
            if (!objectId.matchesId(id)) continue;
            return objectId;
        }
        return null;
    }

    @Override
    public P11ObjectIdentifier getObjectIdForLabel(String label) {
        for (P11ObjectIdentifier objectId : this.identities.keySet()) {
            if (!objectId.label().equals(label)) continue;
            return objectId;
        }
        for (P11ObjectIdentifier objectId : this.certificates.keySet()) {
            if (!objectId.label().equals(label)) continue;
            return objectId;
        }
        return null;
    }

    @Override
    public X509Certificate exportCert(P11ObjectIdentifier objectId) throws P11TokenException, CertificateException {
        ParamUtil.requireNonNull((String)"objectId", (Object)objectId);
        try {
            return this.getIdentity(objectId).certificate();
        }
        catch (P11UnknownEntityException p11UnknownEntityException) {
            X509Cert cert = this.certificates.get(objectId);
            if (cert == null) {
                throw new P11UnknownEntityException(this.slotId, objectId);
            }
            return cert.cert();
        }
    }

    @Override
    public void removeCerts(P11ObjectIdentifier objectId) throws P11TokenException {
        ParamUtil.requireNonNull((String)"objectId", (Object)objectId);
        this.assertWritable("removeCerts");
        if (this.identities.containsKey(objectId)) {
            this.certificates.remove(objectId);
            this.identities.get(objectId).setCertificates(null);
        } else if (this.certificates.containsKey(objectId)) {
            this.certificates.remove(objectId);
        } else {
            throw new P11UnknownEntityException(this.slotId, objectId);
        }
        this.updateCaCertsOfIdentities();
        this.removeCerts0(objectId);
    }

    @Override
    public void removeIdentity(P11ObjectIdentifier objectId) throws P11TokenException {
        ParamUtil.requireNonNull((String)"objectId", (Object)objectId);
        this.assertWritable("removeIdentity");
        if (this.identities.containsKey(objectId)) {
            this.certificates.remove(objectId);
            this.identities.get(objectId).setCertificates(null);
            this.identities.remove(objectId);
            this.updateCaCertsOfIdentities();
        }
        this.removeIdentity0(objectId);
    }

    @Override
    public P11ObjectIdentifier addCert(X509Certificate cert) throws P11TokenException, CertificateException {
        ParamUtil.requireNonNull((String)"cert", (Object)cert);
        this.assertWritable("addCert");
        byte[] encodedCert = cert.getEncoded();
        for (P11ObjectIdentifier objectId : this.certificates.keySet()) {
            X509Cert tmpCert = this.certificates.get(objectId);
            if (!Arrays.equals(encodedCert, tmpCert.encodedCert())) continue;
            return objectId;
        }
        byte[] id = this.generateId();
        String cn = X509Util.getCommonName(cert.getSubjectX500Principal());
        String label = this.generateLabel(cn);
        P11ObjectIdentifier objectId = new P11ObjectIdentifier(id, label);
        this.addCert(objectId, cert);
        return objectId;
    }

    @Override
    public void addCert(P11ObjectIdentifier objectId, X509Certificate cert) throws P11TokenException, CertificateException {
        this.addCert0(objectId, cert);
        this.certificates.put(objectId, new X509Cert(cert));
        this.updateCaCertsOfIdentities();
        LOG.info("added certificate {}", (Object)objectId);
    }

    protected byte[] generateId() throws P11TokenException {
        boolean duplicated;
        byte[] id = new byte[8];
        block0: do {
            this.random.nextBytes(id);
            duplicated = false;
            for (P11ObjectIdentifier objectId : this.identities.keySet()) {
                if (!objectId.matchesId(id)) continue;
                duplicated = true;
                break;
            }
            if (duplicated) continue;
            for (P11ObjectIdentifier objectId : this.certificates.keySet()) {
                if (!objectId.matchesId(id)) continue;
                duplicated = true;
                continue block0;
            }
        } while (duplicated);
        return id;
    }

    protected String generateLabel(String label) throws P11TokenException {
        String tmpLabel = label;
        int idx = 0;
        while (true) {
            boolean duplicated = false;
            for (P11ObjectIdentifier objectId : this.identities.keySet()) {
                if (!objectId.label().equals(label)) continue;
                duplicated = true;
                break;
            }
            if (!duplicated) {
                for (P11ObjectIdentifier objectId : this.certificates.keySet()) {
                    if (!objectId.label().equals(label)) continue;
                    duplicated = true;
                    break;
                }
            }
            if (!duplicated) {
                return tmpLabel;
            }
            tmpLabel = label + "-" + ++idx;
        }
    }

    @Override
    public P11ObjectIdentifier generateSecretKey(long keyType, int keysize, String label, P11NewKeyControl control) throws P11TokenException {
        ParamUtil.requireNonBlank((String)"label", (String)label);
        this.assertWritable("generateSecretKey");
        P11Identity identity = this.generateSecretKey0(keyType, keysize, label, control);
        this.addIdentity(identity);
        P11ObjectIdentifier objId = identity.identityId().objectId();
        LOG.info("generated secret key {}", (Object)objId);
        return objId;
    }

    @Override
    public P11ObjectIdentifier createSecretKey(long keyType, byte[] keyValue, String label, P11NewKeyControl control) throws P11TokenException {
        ParamUtil.requireNonBlank((String)"label", (String)label);
        this.assertWritable("createSecretKey");
        P11Identity identity = this.createSecretKey0(keyType, keyValue, label, control);
        this.addIdentity(identity);
        P11ObjectIdentifier objId = identity.identityId().objectId();
        LOG.info("created secret key {}", (Object)objId);
        return objId;
    }

    @Override
    public P11ObjectIdentifier generateRSAKeypair(int keysize, BigInteger publicExponent, String label, P11NewKeyControl control) throws P11TokenException {
        ParamUtil.requireNonBlank((String)"label", (String)label);
        ParamUtil.requireMin((String)"keysize", (int)keysize, (int)1024);
        if (keysize % 1024 != 0) {
            throw new IllegalArgumentException("key size is not multiple of 1024: " + keysize);
        }
        this.assertWritable("generateRSAKeypair");
        this.assertMechanismSupported(0L);
        BigInteger tmpPublicExponent = publicExponent;
        if (tmpPublicExponent == null) {
            tmpPublicExponent = BigInteger.valueOf(65537L);
        }
        P11Identity identity = this.generateRSAKeypair0(keysize, tmpPublicExponent, label, control);
        this.addIdentity(identity);
        P11ObjectIdentifier objId = identity.identityId().objectId();
        LOG.info("generated RSA keypair {}", (Object)objId);
        return objId;
    }

    @Override
    public P11ObjectIdentifier generateDSAKeypair(int plength, int qlength, String label, P11NewKeyControl control) throws P11TokenException {
        ParamUtil.requireMin((String)"plength", (int)plength, (int)1024);
        if (plength % 1024 != 0) {
            throw new IllegalArgumentException("key size is not multiple of 1024: " + plength);
        }
        this.assertWritable("generateDSAKeypair");
        this.assertMechanismSupported(16L);
        DSAParameterSpec dsaParams = DSAParameterCache.getDSAParameterSpec(plength, qlength, this.random);
        P11Identity identity = this.generateDSAKeypair0(dsaParams.getP(), dsaParams.getQ(), dsaParams.getG(), label, control);
        this.addIdentity(identity);
        P11ObjectIdentifier objId = identity.identityId().objectId();
        LOG.info("generated DSA keypair {}", (Object)objId);
        return objId;
    }

    @Override
    public P11ObjectIdentifier generateDSAKeypair(BigInteger p, BigInteger q, BigInteger g, String label, P11NewKeyControl control) throws P11TokenException {
        ParamUtil.requireNonBlank((String)"label", (String)label);
        ParamUtil.requireNonNull((String)"p", (Object)p);
        ParamUtil.requireNonNull((String)"q", (Object)q);
        ParamUtil.requireNonNull((String)"g", (Object)g);
        this.assertWritable("generateDSAKeypair");
        this.assertMechanismSupported(16L);
        P11Identity identity = this.generateDSAKeypair0(p, q, g, label, control);
        this.addIdentity(identity);
        P11ObjectIdentifier objId = identity.identityId().objectId();
        LOG.info("generated DSA keypair {}", (Object)objId);
        return objId;
    }

    @Override
    public P11ObjectIdentifier generateECKeypair(String curveNameOrOid, String label, P11NewKeyControl control) throws P11TokenException {
        ParamUtil.requireNonBlank((String)"curveNameOrOid", (String)curveNameOrOid);
        ParamUtil.requireNonBlank((String)"label", (String)label);
        this.assertWritable("generateECKeypair");
        this.assertMechanismSupported(4160L);
        ASN1ObjectIdentifier curveId = AlgorithmUtil.getCurveOidForCurveNameOrOid(curveNameOrOid);
        if (curveId == null) {
            throw new IllegalArgumentException("unknown curve " + curveNameOrOid);
        }
        P11Identity identity = this.generateECKeypair0(curveId, label, control);
        this.addIdentity(identity);
        P11ObjectIdentifier objId = identity.identityId().objectId();
        LOG.info("generated EC keypair {}", (Object)objId);
        return objId;
    }

    @Override
    public void updateCertificate(P11ObjectIdentifier objectId, X509Certificate newCert) throws P11TokenException, CertificateException {
        PublicKey newPk;
        ParamUtil.requireNonNull((String)"objectId", (Object)objectId);
        ParamUtil.requireNonNull((String)"newCert", (Object)newCert);
        this.assertWritable("updateCertificate");
        P11Identity identity = this.identities.get(objectId);
        if (identity == null) {
            throw new P11UnknownEntityException("could not find private key " + objectId);
        }
        PublicKey pk = identity.publicKey();
        if (!pk.equals(newPk = newCert.getPublicKey())) {
            throw new P11TokenException("the given certificate is not for the key " + objectId);
        }
        this.updateCertificate0(objectId, newCert);
        identity.setCertificates(new X509Certificate[]{newCert});
        this.updateCaCertsOfIdentities();
        LOG.info("updated certificate {}", (Object)objectId);
    }

    @Override
    public void showDetails(OutputStream stream, boolean verbose) throws IOException, P11TokenException {
        P11ObjectIdentifier objectId2;
        ParamUtil.requireNonNull((String)"stream", (Object)stream);
        List<P11ObjectIdentifier> sortedObjectIds = this.getSortedObjectIds(this.identities.keySet());
        int size = sortedObjectIds.size();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            objectId2 = sortedObjectIds.get(i);
            sb.append("\t").append(i + 1).append(". ").append(objectId2.label());
            sb.append(" (").append("id: ").append(objectId2.idHex()).append(")\n");
            P11Identity identity = this.identities.get(objectId2);
            if (identity.publicKey() != null) {
                String algo = identity.publicKey().getAlgorithm();
                sb.append("\t\tAlgorithm: ").append(algo).append("\n");
                X509Certificate[] certs = identity.certificateChain();
                if (certs == null || certs.length == 0) {
                    sb.append("\t\tCertificate: NONE\n");
                    continue;
                }
                for (int j = 0; j < certs.length; ++j) {
                    AbstractP11Slot.formatString(j, verbose, sb, certs[j]);
                }
                continue;
            }
            sb.append("\t\tSymmetric key\n");
        }
        sortedObjectIds.clear();
        for (P11ObjectIdentifier objectId2 : this.certificates.keySet()) {
            if (this.identities.containsKey(objectId2)) continue;
            sortedObjectIds.add(objectId2);
        }
        Collections.sort(sortedObjectIds);
        if (!sortedObjectIds.isEmpty()) {
            Collections.sort(sortedObjectIds);
            size = sortedObjectIds.size();
            for (int i = 0; i < size; ++i) {
                objectId2 = sortedObjectIds.get(i);
                sb.append("\tCert-").append(i + 1).append(". ").append(objectId2.label());
                sb.append(" (").append("id: ").append(objectId2.label()).append(")\n");
                AbstractP11Slot.formatString(null, verbose, sb, this.certificates.get(objectId2).cert());
            }
        }
        if (sb.length() > 0) {
            stream.write(sb.toString().getBytes());
        }
    }

    protected void assertWritable(String operationName) throws P11PermissionException {
        if (this.readOnly) {
            throw new P11PermissionException("Operation " + operationName + " is not permitted");
        }
    }

    private static void formatString(Integer index, boolean verbose, StringBuilder sb, X509Certificate cert) {
        String subject = X509Util.getRfc4519Name(cert.getSubjectX500Principal());
        sb.append("\t\tCertificate");
        if (index != null) {
            sb.append("[").append(index).append("]");
        }
        sb.append(": ");
        if (!verbose) {
            sb.append(subject).append("\n");
            return;
        }
        sb.append("\n");
        sb.append("\t\t\tSubject: ").append(subject).append("\n");
        String issuer = X509Util.getRfc4519Name(cert.getIssuerX500Principal());
        sb.append("\t\t\tIssuer: ").append(issuer).append("\n");
        sb.append("\t\t\tSerial: ").append(LogUtil.formatCsn((BigInteger)cert.getSerialNumber())).append("\n");
        sb.append("\t\t\tStart time: ").append(cert.getNotBefore()).append("\n");
        sb.append("\t\t\tEnd time: ").append(cert.getNotAfter()).append("\n");
        sb.append("\t\t\tSHA1 Sum: ");
        try {
            sb.append(HashAlgoType.SHA1.hexHash(cert.getEncoded()));
        }
        catch (CertificateEncodingException ex) {
            sb.append("ERROR");
        }
        sb.append("\n");
    }

    private List<P11ObjectIdentifier> getSortedObjectIds(Set<P11ObjectIdentifier> sets) {
        ArrayList<P11ObjectIdentifier> ids = new ArrayList<P11ObjectIdentifier>(sets);
        Collections.sort(ids);
        return ids;
    }
}

