/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.ObjectCreationException;
import org.xipki.common.util.Base64;
import org.xipki.common.util.IoUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.SignerFactory;
import org.xipki.security.SignerFactoryRegister;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.P11ContentSignerBuilder;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.security.pkcs11.P11EntityIdentifier;
import org.xipki.security.pkcs11.P11MacContentSignerBuilder;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs12.SoftTokenContentSignerBuilder;
import org.xipki.security.pkcs12.SoftTokenMacContentSignerBuilder;
import org.xipki.security.util.AlgorithmUtil;

public class SignerFactoryRegisterImpl
implements SignerFactoryRegister {
    private static final Logger LOG = LoggerFactory.getLogger(SignerFactoryRegisterImpl.class);
    private P11CryptServiceFactory p11CryptServiceFactory;
    private ConcurrentLinkedDeque<SignerFactory> services = new ConcurrentLinkedDeque();

    public void setP11CryptServiceFactory(P11CryptServiceFactory p11CryptServiceFactory) {
        this.p11CryptServiceFactory = p11CryptServiceFactory;
    }

    public void bindService(SignerFactory service) {
        if (service == null) {
            LOG.info("bindService invoked with null.");
            return;
        }
        boolean replaced = this.services.remove(service);
        this.services.add(service);
        String action = replaced ? "replaced" : "added";
        LOG.info("{} SignerFactory binding for {}", (Object)action, (Object)service);
    }

    public void unbindService(SignerFactory service) {
        if (service == null) {
            LOG.info("unbindService invoked with null.");
            return;
        }
        if (this.services.remove(service)) {
            LOG.info("removed SignerFactory binding for {}", (Object)service);
        } else {
            LOG.info("no SignerFactory binding found to remove for '{}'", (Object)service);
        }
    }

    @Override
    public ConcurrentContentSigner newSigner(SecurityFactory securityFactory, String type, SignerConf conf, X509Certificate[] certificateChain) throws ObjectCreationException {
        ParamUtil.requireNonBlank((String)"type", (String)type);
        if ("PKCS12".equalsIgnoreCase(type) || "JKS".equalsIgnoreCase(type) || "JCEKS".equalsIgnoreCase(type)) {
            return this.newKeystoreSigner(securityFactory, type, conf, certificateChain);
        }
        if ("PKCS11".equalsIgnoreCase(type)) {
            return this.newPkcs11Signer(securityFactory, type, conf, certificateChain);
        }
        for (SignerFactory service : this.services) {
            if (!service.canCreateSigner(type)) continue;
            return service.newSigner(type, conf, certificateChain);
        }
        throw new ObjectCreationException("could not find Factory to create Signer of type '" + type + "'");
    }

    private ConcurrentContentSigner newKeystoreSigner(SecurityFactory securityFactory, String type, SignerConf conf, X509Certificate[] certificateChain) throws ObjectCreationException {
        InputStream keystoreStream;
        char[] password;
        String passwordHint;
        String str = conf.getConfValue("parallelism");
        int parallelism = securityFactory.getDefaultSignerParallelism();
        if (str != null) {
            try {
                parallelism = Integer.parseInt(str);
            }
            catch (NumberFormatException ex) {
                throw new ObjectCreationException("invalid parallelism " + str);
            }
            if (parallelism < 1) {
                throw new ObjectCreationException("invalid parallelism " + str);
            }
        }
        if ((passwordHint = conf.getConfValue("password")) == null) {
            password = null;
        } else {
            PasswordResolver passwordResolver = securityFactory.getPasswordResolver();
            if (passwordResolver == null) {
                password = passwordHint.toCharArray();
            } else {
                try {
                    password = passwordResolver.resolvePassword(passwordHint);
                }
                catch (PasswordResolverException ex) {
                    throw new ObjectCreationException("could not resolve password. Message: " + ex.getMessage());
                }
            }
        }
        str = conf.getConfValue("keystore");
        String keyLabel = conf.getConfValue("key-label");
        if (StringUtil.startsWithIgnoreCase((String)str, (String)"base64:")) {
            keystoreStream = new ByteArrayInputStream(Base64.decode((String)str.substring("base64:".length())));
        } else if (StringUtil.startsWithIgnoreCase((String)str, (String)"file:")) {
            String fn = str.substring("file:".length());
            try {
                keystoreStream = new FileInputStream(IoUtil.expandFilepath((String)fn));
            }
            catch (FileNotFoundException ex) {
                throw new ObjectCreationException("file not found: " + fn);
            }
        } else {
            throw new ObjectCreationException("unknown keystore content format");
        }
        try {
            AlgorithmIdentifier signatureAlgId;
            AlgorithmIdentifier macAlgId = null;
            String algoName = conf.getConfValue("algo");
            if (algoName != null) {
                try {
                    macAlgId = AlgorithmUtil.getMacAlgId(algoName);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            if (macAlgId != null) {
                SoftTokenMacContentSignerBuilder signerBuilder = new SoftTokenMacContentSignerBuilder(type, keystoreStream, password, keyLabel, password);
                return signerBuilder.createSigner(macAlgId, parallelism, securityFactory.getRandom4Sign());
            }
            SoftTokenContentSignerBuilder signerBuilder = new SoftTokenContentSignerBuilder(type, keystoreStream, password, keyLabel, password, certificateChain);
            if (conf.hashAlgo() == null) {
                signatureAlgId = AlgorithmUtil.getSigAlgId(null, conf);
            } else {
                PublicKey pubKey = signerBuilder.certificate().getPublicKey();
                signatureAlgId = AlgorithmUtil.getSigAlgId(pubKey, conf);
            }
            return signerBuilder.createSigner(signatureAlgId, parallelism, securityFactory.getRandom4Sign());
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException | XiSecurityException ex) {
            throw new ObjectCreationException(String.format("%s: %s", ex.getClass().getName(), ex.getMessage()));
        }
    }

    public ConcurrentContentSigner newPkcs11Signer(SecurityFactory securityFactory, String type, SignerConf conf, X509Certificate[] certificateChain) throws ObjectCreationException {
        P11ObjectIdentifier p11ObjId;
        P11Slot slot;
        P11CryptService p11Service;
        Long slotId;
        if (this.p11CryptServiceFactory == null) {
            throw new ObjectCreationException("p11CryptServiceFactory is not set");
        }
        String str = conf.getConfValue("parallelism");
        int parallelism = securityFactory.getDefaultSignerParallelism();
        if (str != null) {
            try {
                parallelism = Integer.parseInt(str);
            }
            catch (NumberFormatException ex) {
                throw new ObjectCreationException("invalid parallelism " + str);
            }
            if (parallelism < 1) {
                throw new ObjectCreationException("invalid parallelism " + str);
            }
        }
        String moduleName = conf.getConfValue("module");
        str = conf.getConfValue("slot");
        Integer slotIndex = str == null ? null : Integer.valueOf(Integer.parseInt(str));
        str = conf.getConfValue("slot-id");
        Long l = slotId = str == null ? null : Long.valueOf(Long.parseLong(str));
        if (slotIndex == null && slotId == null || slotIndex != null && slotId != null) {
            throw new ObjectCreationException("exactly one of slot (index) and slot-id must be specified");
        }
        String keyLabel = conf.getConfValue("key-label");
        str = conf.getConfValue("key-id");
        byte[] keyId = null;
        if (str != null) {
            keyId = Hex.decode((String)str);
        }
        if (keyId == null && keyLabel == null || keyId != null && keyLabel != null) {
            throw new ObjectCreationException("exactly one of key-id and key-label must be specified");
        }
        try {
            P11SlotIdentifier p11SlotId;
            p11Service = this.p11CryptServiceFactory.getP11CryptService(moduleName);
            P11Module module = p11Service.module();
            if (slotId != null) {
                p11SlotId = module.getSlotIdForId(slotId);
            } else if (slotIndex != null) {
                p11SlotId = module.getSlotIdForIndex(slotIndex);
            } else {
                throw new RuntimeException("should not reach here");
            }
            slot = module.getSlot(p11SlotId);
        }
        catch (P11TokenException | XiSecurityException ex) {
            throw new ObjectCreationException(ex.getMessage(), (Throwable)ex);
        }
        P11ObjectIdentifier p11ObjectIdentifier = p11ObjId = keyId != null ? slot.getObjectIdForId(keyId) : slot.getObjectIdForLabel(keyLabel);
        if (p11ObjId == null) {
            String str2 = keyId != null ? "id " + Hex.toHexString((byte[])keyId) : "label " + keyLabel;
            throw new ObjectCreationException("cound not find identity with " + str2);
        }
        P11EntityIdentifier entityId = new P11EntityIdentifier(slot.slotId(), p11ObjId);
        try {
            AlgorithmIdentifier signatureAlgId;
            AlgorithmIdentifier macAlgId = null;
            String algoName = conf.getConfValue("algo");
            if (algoName != null) {
                try {
                    macAlgId = AlgorithmUtil.getMacAlgId(algoName);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            if (macAlgId != null) {
                P11MacContentSignerBuilder signerBuilder = new P11MacContentSignerBuilder(p11Service, entityId);
                return signerBuilder.createSigner(macAlgId, parallelism);
            }
            if (conf.hashAlgo() == null) {
                signatureAlgId = AlgorithmUtil.getSigAlgId(null, conf);
            } else {
                PublicKey pubKey = slot.getIdentity(p11ObjId).publicKey();
                signatureAlgId = AlgorithmUtil.getSigAlgId(pubKey, conf);
            }
            P11ContentSignerBuilder signerBuilder = new P11ContentSignerBuilder(p11Service, securityFactory, entityId, certificateChain);
            return signerBuilder.createSigner(signatureAlgId, parallelism);
        }
        catch (NoSuchAlgorithmException | P11TokenException | XiSecurityException ex) {
            throw new ObjectCreationException(ex.getMessage(), (Throwable)ex);
        }
    }
}

