/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.util.Base64;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.operator.RuntimeOperatorException;
import org.bouncycastle.util.encoders.Hex;
import org.xipki.common.concurrent.ConcurrentBag;
import org.xipki.common.concurrent.ConcurrentBagEntry;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.HashAlgoType;

class HashCalculator {
    private static final int PARALLELISM = 50;
    private static final ConcurrentHashMap<HashAlgoType, ConcurrentBag<ConcurrentBagEntry<Digest>>> MDS_MAP = new ConcurrentHashMap();

    private HashCalculator() {
    }

    private static ConcurrentBag<ConcurrentBagEntry<Digest>> getMessageDigests(HashAlgoType hashAlgo) {
        ConcurrentBag mds = new ConcurrentBag();
        for (int i = 0; i < 50; ++i) {
            Digest md = hashAlgo.createDigest();
            mds.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((Object)md));
        }
        return mds;
    }

    public static String base64Sha1(byte[] data) {
        return HashCalculator.base64Hash(HashAlgoType.SHA1, data);
    }

    public static String hexSha1(byte[] data) {
        return HashCalculator.hexHash(HashAlgoType.SHA1, data);
    }

    public static byte[] sha1(byte[] data) {
        return HashCalculator.hash(HashAlgoType.SHA1, data);
    }

    public static String base64Sha256(byte[] data) {
        return HashCalculator.base64Hash(HashAlgoType.SHA256, data);
    }

    public static String hexSha256(byte[] data) {
        return HashCalculator.hexHash(HashAlgoType.SHA256, data);
    }

    public static byte[] sha256(byte[] data) {
        return HashCalculator.hash(HashAlgoType.SHA256, data);
    }

    public static String hexHash(HashAlgoType hashAlgoType, byte[] data) {
        byte[] bytes = HashCalculator.hash(hashAlgoType, data);
        return bytes == null ? null : Hex.toHexString((byte[])bytes).toUpperCase();
    }

    public static String base64Hash(HashAlgoType hashAlgoType, byte[] data) {
        byte[] bytes = HashCalculator.hash(hashAlgoType, data);
        return bytes == null ? null : Base64.getEncoder().encodeToString(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hash(HashAlgoType hashAlgoType, byte[] data) {
        ParamUtil.requireNonNull((String)"hashAlgoType", (Object)((Object)hashAlgoType));
        ParamUtil.requireNonNull((String)"data", (Object)data);
        if (!MDS_MAP.containsKey((Object)hashAlgoType)) {
            throw new IllegalArgumentException("unknown hash algo " + (Object)((Object)hashAlgoType));
        }
        ConcurrentBag<ConcurrentBagEntry<Digest>> mds = MDS_MAP.get((Object)hashAlgoType);
        ConcurrentBagEntry md0 = null;
        for (int i = 0; i < 3; ++i) {
            try {
                md0 = (ConcurrentBagEntry)mds.borrow(10L, TimeUnit.SECONDS);
                break;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
        }
        if (md0 == null) {
            throw new RuntimeOperatorException("could not get idle MessageDigest");
        }
        try {
            Digest md = (Digest)md0.value();
            md.reset();
            md.update(data, 0, data.length);
            byte[] bytes = new byte[md.getDigestSize()];
            md.doFinal(bytes, 0);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            mds.requite((ConcurrentBag.IConcurrentBagEntry)md0);
        }
    }

    static {
        MDS_MAP.put(HashAlgoType.SHA1, HashCalculator.getMessageDigests(HashAlgoType.SHA1));
        MDS_MAP.put(HashAlgoType.SHA224, HashCalculator.getMessageDigests(HashAlgoType.SHA224));
        MDS_MAP.put(HashAlgoType.SHA256, HashCalculator.getMessageDigests(HashAlgoType.SHA256));
        MDS_MAP.put(HashAlgoType.SHA384, HashCalculator.getMessageDigests(HashAlgoType.SHA384));
        MDS_MAP.put(HashAlgoType.SHA512, HashCalculator.getMessageDigests(HashAlgoType.SHA512));
        MDS_MAP.put(HashAlgoType.SHA3_224, HashCalculator.getMessageDigests(HashAlgoType.SHA3_224));
        MDS_MAP.put(HashAlgoType.SHA3_256, HashCalculator.getMessageDigests(HashAlgoType.SHA3_256));
        MDS_MAP.put(HashAlgoType.SHA3_384, HashCalculator.getMessageDigests(HashAlgoType.SHA3_384));
        MDS_MAP.put(HashAlgoType.SHA3_512, HashCalculator.getMessageDigests(HashAlgoType.SHA3_512));
    }
}

