/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.xipki.common.util.CollectionUtil;
import org.xipki.common.util.ParamUtil;

public class ExtensionExistence
extends ASN1Object {
    private List<ASN1ObjectIdentifier> needExtensions;
    private List<ASN1ObjectIdentifier> wantExtensions;

    public ExtensionExistence(List<ASN1ObjectIdentifier> needExtensions, List<ASN1ObjectIdentifier> wantExtensions) {
        List list;
        this.needExtensions = needExtensions;
        this.wantExtensions = wantExtensions;
        if (this.needExtensions == null) {
            list = Collections.emptyList();
            this.needExtensions = Collections.unmodifiableList(list);
        }
        if (this.wantExtensions == null) {
            list = Collections.emptyList();
            this.wantExtensions = Collections.unmodifiableList(list);
        }
    }

    private ExtensionExistence(ASN1Sequence seq) {
        int size = seq.size();
        if (size > 2) {
            throw new IllegalArgumentException("wrong number of elements in sequence");
        }
        for (int i = 0; i < size; ++i) {
            ASN1TaggedObject tagObject = ASN1TaggedObject.getInstance((Object)seq.getObjectAt(i));
            int tag = tagObject.getTagNo();
            ParamUtil.requireRange((String)"tag", (int)tag, (int)0, (int)1);
            ASN1Sequence subSeq = ASN1Sequence.getInstance((Object)tagObject.getObject());
            LinkedList<ASN1ObjectIdentifier> oids = new LinkedList<ASN1ObjectIdentifier>();
            int subSize = subSeq.size();
            for (int j = 0; j < subSize; ++j) {
                oids.add(ASN1ObjectIdentifier.getInstance((Object)subSeq.getObjectAt(j)));
            }
            if (tag == 0) {
                this.needExtensions = Collections.unmodifiableList(oids);
                continue;
            }
            this.wantExtensions = Collections.unmodifiableList(oids);
        }
        if (this.needExtensions == null) {
            List list = Collections.emptyList();
            this.needExtensions = Collections.unmodifiableList(list);
        }
        if (this.wantExtensions == null) {
            List list = Collections.emptyList();
            this.wantExtensions = Collections.unmodifiableList(list);
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vec;
        ASN1EncodableVector vector = new ASN1EncodableVector();
        if (CollectionUtil.isNonEmpty(this.needExtensions)) {
            vec = new ASN1EncodableVector();
            for (ASN1ObjectIdentifier m : this.needExtensions) {
                vec.add((ASN1Encodable)m);
            }
            vector.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERSequence(vec)));
        }
        if (CollectionUtil.isNonEmpty(this.wantExtensions)) {
            vec = new ASN1EncodableVector();
            for (ASN1ObjectIdentifier m : this.wantExtensions) {
                vec.add((ASN1Encodable)m);
            }
            vector.add((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)new DERSequence(vec)));
        }
        return new DERSequence(vector);
    }

    public List<ASN1ObjectIdentifier> needExtensions() {
        return this.needExtensions;
    }

    public List<ASN1ObjectIdentifier> wantExtensions() {
        return this.wantExtensions;
    }

    public static ExtensionExistence getInstance(Object obj) {
        if (obj == null || obj instanceof ExtensionExistence) {
            return (ExtensionExistence)((Object)obj);
        }
        if (obj instanceof ASN1Sequence) {
            return new ExtensionExistence((ASN1Sequence)obj);
        }
        if (obj instanceof byte[]) {
            try {
                return ExtensionExistence.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("unable to parse encoded general name");
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }
}

