/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.concurrent.ConcurrentBag;
import org.xipki.common.util.LogUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.password.PasswordResolver;
import org.xipki.security.AlgorithmCode;
import org.xipki.security.ConcurrentBagEntrySigner;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.bc.XiContentSigner;
import org.xipki.security.exception.NoIdleSignerException;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.util.AlgorithmUtil;

public class DefaultConcurrentContentSigner
implements ConcurrentContentSigner {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConcurrentContentSigner.class);
    private static final AtomicInteger NAME_INDEX = new AtomicInteger(1);
    private static int defaultSignServiceTimeout = 10000;
    private final String name;
    private final String algorithmName;
    private final ConcurrentBag<ConcurrentBagEntrySigner> signers = new ConcurrentBag();
    private final boolean mac;
    private byte[] sha1DigestOfMacKey;
    private final Key signingKey;
    private final AlgorithmCode algorithmCode;
    private PublicKey publicKey;
    private X509Certificate[] certificateChain;
    private X509CertificateHolder[] certificateChainAsBcObjects;

    public DefaultConcurrentContentSigner(boolean mac, List<XiContentSigner> signers) throws NoSuchAlgorithmException {
        this(mac, signers, null);
    }

    public DefaultConcurrentContentSigner(boolean mac, List<XiContentSigner> signers, Key signingKey) throws NoSuchAlgorithmException {
        ParamUtil.requireNonEmpty((String)"signers", signers);
        this.mac = mac;
        AlgorithmIdentifier algorithmIdentifier = signers.get(0).getAlgorithmIdentifier();
        this.algorithmName = AlgorithmUtil.getSigOrMacAlgoName(algorithmIdentifier);
        this.algorithmCode = AlgorithmUtil.getSigOrMacAlgoCode(algorithmIdentifier);
        for (XiContentSigner signer : signers) {
            this.signers.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntrySigner(signer));
        }
        this.signingKey = signingKey;
        this.name = "defaultSigner-" + NAME_INDEX.getAndIncrement();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isMac() {
        return this.mac;
    }

    public void setSha1DigestOfMacKey(byte[] sha1Digest) {
        if (sha1Digest == null) {
            this.sha1DigestOfMacKey = null;
        } else if (sha1Digest.length == 20) {
            this.sha1DigestOfMacKey = Arrays.copyOf(sha1Digest, 20);
        } else {
            throw new IllegalArgumentException("invalid sha1Digest.length (" + sha1Digest.length + " != 20)");
        }
    }

    @Override
    public byte[] getSha1DigestOfMacKey() {
        return this.sha1DigestOfMacKey == null ? null : Arrays.copyOf(this.sha1DigestOfMacKey, 20);
    }

    @Override
    public AlgorithmCode algorithmCode() {
        return this.algorithmCode;
    }

    @Override
    public ConcurrentBagEntrySigner borrowContentSigner() throws NoIdleSignerException {
        return this.borrowContentSigner(defaultSignServiceTimeout);
    }

    @Override
    public ConcurrentBagEntrySigner borrowContentSigner(int soTimeout) throws NoIdleSignerException {
        ConcurrentBagEntrySigner signer = null;
        try {
            signer = (ConcurrentBagEntrySigner)this.signers.borrow((long)soTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (signer == null) {
            throw new NoIdleSignerException("no idle signer available");
        }
        return signer;
    }

    @Override
    public void requiteContentSigner(ConcurrentBagEntrySigner signer) {
        this.signers.requite((ConcurrentBag.IConcurrentBagEntry)signer);
    }

    @Override
    public void initialize(String conf, PasswordResolver passwordResolver) throws XiSecurityException {
    }

    @Override
    public Key getSigningKey() {
        return this.signingKey;
    }

    @Override
    public void setCertificateChain(X509Certificate[] certificateChain) {
        if (certificateChain == null || certificateChain.length == 0) {
            this.certificateChain = null;
            this.certificateChainAsBcObjects = null;
            return;
        }
        this.certificateChain = certificateChain;
        this.setPublicKey(certificateChain[0].getPublicKey());
        int n = certificateChain.length;
        this.certificateChainAsBcObjects = new X509CertificateHolder[n];
        for (int i = 0; i < n; ++i) {
            X509Certificate cert = this.certificateChain[i];
            try {
                this.certificateChainAsBcObjects[i] = new X509CertificateHolder(cert.getEncoded());
                continue;
            }
            catch (IOException | CertificateEncodingException ex) {
                throw new IllegalArgumentException(String.format("%s occurred while parsing certificate at index %d: %s", ex.getClass().getName(), i, ex.getMessage()), ex);
            }
        }
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public X509Certificate getCertificate() {
        return this.certificateChain != null && this.certificateChain.length > 0 ? this.certificateChain[0] : null;
    }

    @Override
    public X509CertificateHolder getCertificateAsBcObject() {
        return this.certificateChainAsBcObjects != null && this.certificateChainAsBcObjects.length > 0 ? this.certificateChainAsBcObjects[0] : null;
    }

    @Override
    public X509Certificate[] getCertificateChain() {
        return this.certificateChain;
    }

    @Override
    public X509CertificateHolder[] getCertificateChainAsBcObjects() {
        return this.certificateChainAsBcObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isHealthy() {
        ConcurrentBagEntrySigner signer = null;
        try {
            signer = this.borrowContentSigner();
            OutputStream stream = ((XiContentSigner)signer.value()).getOutputStream();
            stream.write(new byte[]{1, 2, 3, 4});
            byte[] signature = ((XiContentSigner)signer.value()).getSignature();
            boolean bl = signature != null && signature.length > 0;
            return bl;
        }
        catch (Exception ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (signer != null) {
                this.requiteContentSigner(signer);
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] sign(byte[] data) throws NoIdleSignerException, SignatureException {
        ConcurrentBagEntrySigner contentSigner = this.borrowContentSigner();
        try {
            OutputStream signatureStream = ((XiContentSigner)contentSigner.value()).getOutputStream();
            try {
                signatureStream.write(data);
            }
            catch (IOException ex) {
                throw new SignatureException("could not write data to SignatureStream: " + ex.getMessage(), ex);
            }
            byte[] byArray = ((XiContentSigner)contentSigner.value()).getSignature();
            return byArray;
        }
        finally {
            this.requiteContentSigner(contentSigner);
        }
    }

    static {
        String propKey = "org.xipki.security.signservice.timeout";
        String str = System.getProperty("org.xipki.security.signservice.timeout");
        if (str != null) {
            int vi = Integer.parseInt(str);
            if (vi < 0 || vi > 60000) {
                LOG.error("invalid {}: {}", (Object)"org.xipki.security.signservice.timeout", (Object)vi);
            } else {
                LOG.info("use {}: {}", (Object)"org.xipki.security.signservice.timeout", (Object)vi);
                defaultSignServiceTimeout = vi;
            }
        }
    }
}

