/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.api;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.xipki.common.util.ParamUtil;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.ocsp.api.CertStatusInfo;
import org.xipki.ocsp.api.OcspStoreException;
import org.xipki.ocsp.api.RequestIssuer;
import org.xipki.security.HashAlgoType;

public abstract class OcspStore {
    protected static final long DAY = 86400000L;
    protected String name;
    protected boolean unknownSerialAsGood;
    protected int retentionInterval;
    protected boolean includeArchiveCutoff;
    protected boolean includeCrlId;
    protected boolean ignoreExpiredCert;
    protected boolean ignoreNotYetValidCert;

    public abstract boolean canResolveIssuer(RequestIssuer var1);

    public abstract X509Certificate getIssuerCert(RequestIssuer var1);

    public abstract CertStatusInfo getCertStatus(Date var1, RequestIssuer var2, BigInteger var3, boolean var4, boolean var5, boolean var6, HashAlgoType var7) throws OcspStoreException;

    public abstract void init(String var1, DataSourceWrapper var2) throws OcspStoreException;

    public abstract void shutdown() throws OcspStoreException;

    public abstract boolean isHealthy();

    public void setName(String name) {
        this.name = ParamUtil.requireNonBlank((String)"name", (String)name);
    }

    public String name() {
        return this.name;
    }

    public boolean isUnknownSerialAsGood() {
        return this.unknownSerialAsGood;
    }

    public void setUnknownSerialAsGood(boolean unknownSerialAsGood) {
        this.unknownSerialAsGood = unknownSerialAsGood;
    }

    public boolean isIncludeArchiveCutoff() {
        return this.includeArchiveCutoff;
    }

    public void setIncludeArchiveCutoff(boolean includeArchiveCutoff) {
        this.includeArchiveCutoff = includeArchiveCutoff;
    }

    public int retentionInterval() {
        return this.retentionInterval;
    }

    public void setRetentionInterval(int retentionInterval) {
        this.retentionInterval = retentionInterval;
    }

    public boolean isIncludeCrlId() {
        return this.includeCrlId;
    }

    public void setIncludeCrlId(boolean includeCrlId) {
        this.includeCrlId = includeCrlId;
    }

    public boolean isIgnoreExpiredCert() {
        return this.ignoreExpiredCert;
    }

    public void setIgnoreExpiredCert(boolean ignoreExpiredCert) {
        this.ignoreExpiredCert = ignoreExpiredCert;
    }

    public boolean isIgnoreNotYetValidCert() {
        return this.ignoreNotYetValidCert;
    }

    public void setIgnoreNotYetValidCert(boolean ignoreNotYetValidCert) {
        this.ignoreNotYetValidCert = ignoreNotYetValidCert;
    }
}

