/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.gradle.plugins.gwt;

import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.War;
import org.wisepersist.gradle.plugins.gwt.ExplodedWar;
import org.wisepersist.gradle.plugins.gwt.GwtBasePlugin;
import org.wisepersist.gradle.plugins.gwt.GwtCompile;
import org.wisepersist.gradle.plugins.gwt.GwtDev;
import org.wisepersist.gradle.plugins.gwt.GwtDraftCompile;
import org.wisepersist.gradle.plugins.gwt.GwtPluginExtension;
import org.wisepersist.gradle.plugins.gwt.internal.ActionClosure;

public class GwtWarPlugin
implements Plugin<Project> {
    public static final String TASK_WAR_TEMPLATE = "warTemplate";
    public static final String TASK_DRAFT_WAR = "draftWar";
    public static final String TASK_GWT_DEV = "gwtDev";
    public static final String TASK_GWT_SUPER_DEV = "gwtSuperDev";
    private static final Logger logger = Logging.getLogger(GwtWarPlugin.class);

    public void apply(final Project project) {
        project.getPlugins().apply(WarPlugin.class);
        GwtBasePlugin gwtBasePlugin = (GwtBasePlugin)project.getPlugins().apply(GwtBasePlugin.class);
        final GwtPluginExtension extension = gwtBasePlugin.getExtension();
        final GwtCompile compileTask = (GwtCompile)project.getTasks().getByName("compileGwt");
        GwtDraftCompile draftCompileTask = (GwtDraftCompile)project.getTasks().getByName("draftCompileGwt");
        final War warTask = (War)project.getTasks().getByName("war");
        logger.debug("Configuring war plugin with GWT settings");
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project t) {
                String modulePathPrefix = extension.getModulePathPrefix();
                if (modulePathPrefix == null || modulePathPrefix.isEmpty()) {
                    warTask.from(new Object[]{compileTask.getOutputs()});
                    return;
                }
                warTask.into((Object)(modulePathPrefix == null ? "" : modulePathPrefix), new ActionClosure<CopySpec>(this, new Action<CopySpec>(){

                    public void execute(CopySpec spec) {
                        spec.from(new Object[]{compileTask.getOutputs()});
                        spec.exclude(new String[]{"WEB-INF"});
                    }
                }));
                warTask.into((Object)"", new ActionClosure<CopySpec>(this, new Action<CopySpec>(){

                    public void execute(CopySpec spec) {
                        spec.from(new Object[]{compileTask.getOutputs()});
                        spec.include(new String[]{"WEB-INF"});
                    }
                }));
            }
        });
        final WarPluginConvention warPluginConvention = (WarPluginConvention)project.getConvention().getPlugins().get("war");
        ExplodedWar warTemplateTask = (ExplodedWar)project.getTasks().create(TASK_WAR_TEMPLATE, ExplodedWar.class);
        warTemplateTask.setGroup("GWT");
        warTemplateTask.from(new Callable<File>(){

            @Override
            public File call() {
                return warPluginConvention.getWebAppDir();
            }
        });
        warTemplateTask.dependsOn(new Object[]{new Callable<FileCollection>(){

            @Override
            public FileCollection call() throws Exception {
                return ((SourceSet)((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main")).getRuntimeClasspath();
            }
        }});
        warTemplateTask.classpath(new Callable<FileCollection>(){

            @Override
            public FileCollection call() throws Exception {
                return warTask.getClasspath();
            }
        });
        ((IConventionAware)warTemplateTask).getConventionMapping().map("destinationDir", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return extension.getDevWar();
            }
        });
        warTemplateTask.setDescription("Creates an exploded web application template to be used by GWT dev mode and eclipse to ensure src/main/webapp stays clean");
        GwtDev devModeTask = (GwtDev)project.getTasks().create(TASK_GWT_DEV, GwtDev.class);
        devModeTask.setDescription("Runs the GWT development mode");
        ((IConventionAware)devModeTask).getConventionMapping().map("war", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return extension.getDevWar();
            }
        });
        War draftWar = (War)project.getTasks().create(TASK_DRAFT_WAR, War.class);
        draftWar.from(new Object[]{draftCompileTask.getOutputs()});
        String appendix = "draft";
        draftWar.getArchiveAppendix().convention((Object)appendix);
        draftWar.getArchiveAppendix().set((Object)appendix);
        draftWar.setDescription("Creates a war using the output of the task draftCompileGwt");
        devModeTask.dependsOn(new Object[]{"classes"});
        devModeTask.dependsOn(new Object[]{warTemplateTask});
    }
}

