/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.telemetry.api;

import io.smallrye.opentelemetry.api.OpenTelemetryConfig;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.config.Config;

public class MicroProfileTelemetryCdiExtension
implements Extension {
    private final Map<String, String> serverConfig;

    public MicroProfileTelemetryCdiExtension(Map<String, String> serverConfig) {
        this.serverConfig = serverConfig;
    }

    public void registerOpenTelemetryConfigBean(@Observes AfterBeanDiscovery abd, BeanManager beanManager) {
        abd.addBean().scope(Singleton.class).addQualifier((Annotation)Default.Literal.INSTANCE).types(new Type[]{OpenTelemetryConfig.class}).createWith(c -> {
            Config appConfig = (Config)beanManager.createInstance().select(Config.class, new Annotation[0]).get();
            HashMap<String, String> properties = new HashMap<String, String>(this.serverConfig);
            properties.put("otel.sdk.disabled", "true");
            properties.put("otel.experimental.sdk.enabled", "false");
            for (String propertyName : appConfig.getPropertyNames()) {
                if (!propertyName.startsWith("otel.") && !propertyName.startsWith("OTEL_")) continue;
                appConfig.getOptionalValue(propertyName, String.class).ifPresent(value -> properties.put(propertyName, (String)value));
            }
            return () -> properties;
        });
    }
}

