/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.ee.subsystem.EeSubsystemRootResource;

enum Element {
    GLOBAL_MODULES("global-modules"),
    MODULE("module"),
    EAR_SUBDEPLOYMENTS_ISOLATED(EeSubsystemRootResource.EAR_SUBDEPLOYMENTS_ISOLATED.getXmlName()),
    SPEC_DESCRIPTOR_PROPERTY_REPLACEMENT(EeSubsystemRootResource.SPEC_DESCRIPTOR_PROPERTY_REPLACEMENT.getXmlName()),
    JBOSS_DESCRIPTOR_PROPERTY_REPLACEMENT(EeSubsystemRootResource.JBOSS_DESCRIPTOR_PROPERTY_REPLACEMENT.getXmlName()),
    ANNOTATION_PROPERTY_REPLACEMENT(EeSubsystemRootResource.ANNOTATION_PROPERTY_REPLACEMENT.getXmlName()),
    CONCURRENT("concurrent"),
    CONTEXT_SERVICES("context-services"),
    CONTEXT_SERVICE("context-service"),
    MANAGED_THREAD_FACTORIES("managed-thread-factories"),
    MANAGED_THREAD_FACTORY("managed-thread-factory"),
    MANAGED_EXECUTOR_SERVICES("managed-executor-services"),
    MANAGED_EXECUTOR_SERVICE("managed-executor-service"),
    MANAGED_SCHEDULED_EXECUTOR_SERVICES("managed-scheduled-executor-services"),
    MANAGED_SCHEDULED_EXECUTOR_SERVICE("managed-scheduled-executor-service"),
    DEFAULT_BINDINGS("default-bindings"),
    GLOBAL_DIRECTORIES("global-directories"),
    DIRECTORY("directory"),
    UNKNOWN(null);

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

