/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.opentracing;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.microprofile.opentracing.JaegerTracerConfigurationDefinition;
import org.wildfly.extension.microprofile.opentracing.SubsystemDefinition;
import org.wildfly.extension.microprofile.opentracing.TracerAttributes;
import org.wildfly.extension.microprofile.opentracing.resolver.JaegerTracerConfiguration;
import org.wildfly.microprofile.opentracing.smallrye.WildFlyTracerFactory;

public class JaegerTracerConfigurationAddHandler
extends AbstractAddStepHandler {
    static final JaegerTracerConfigurationAddHandler INSTANCE = new JaegerTracerConfigurationAddHandler();

    private JaegerTracerConfigurationAddHandler() {
        super(JaegerTracerConfigurationDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        super.performRuntime(context, operation, model);
        CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(SubsystemDefinition.TRACER_CAPABILITY);
        String outboundSocketBindingName = TracerAttributes.SENDER_BINDING.resolveModelAttribute(context, model).asStringOrNull();
        Supplier outboundSocketBindingSupplier = outboundSocketBindingName != null ? builder.requiresCapability("org.wildfly.network.outbound-socket-binding", OutboundSocketBinding.class, new String[]{outboundSocketBindingName}) : () -> null;
        final JaegerTracerConfiguration config = new JaegerTracerConfiguration(context, operation, outboundSocketBindingSupplier);
        final Consumer injector = builder.provides(new RuntimeCapability[]{SubsystemDefinition.TRACER_CAPABILITY});
        builder.setInstance(new Service(){

            public void start(StartContext context) {
                injector.accept(config);
                WildFlyTracerFactory.registerTracer((String)config.getName()).accept(config);
            }

            public void stop(StopContext context) {
                WildFlyTracerFactory.registerTracer((String)config.getName()).accept(null);
            }
        });
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }
}

