/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.impl.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.persistence.jdbc.impl.table.TableName;
import org.infinispan.persistence.spi.PersistenceException;

public interface TableManager {
    public static final int DEFAULT_FETCH_SIZE = 100;

    public void start() throws PersistenceException;

    public void stop() throws PersistenceException;

    public boolean tableExists(Connection var1) throws PersistenceException;

    public boolean tableExists(Connection var1, TableName var2) throws PersistenceException;

    public void createTable(Connection var1) throws PersistenceException;

    public void dropTable(Connection var1) throws PersistenceException;

    public int getFetchSize();

    public boolean isUpsertSupported();

    public TableName getTableName();

    public String getIdentifierQuoteString();

    public String getInsertRowSql();

    public String getUpdateRowSql();

    public String getUpsertRowSql();

    public String getSelectRowSql();

    public String getSelectIdRowSql();

    public String getCountNonExpiredRowsSql();

    public String getCountNonExpiredRowsSqlForSegments(int var1);

    public String getDeleteRowSql();

    public String getLoadNonExpiredAllRowsSql();

    public String getLoadNonExpiredRowsSqlForSegments(int var1);

    public String getLoadAllRowsSql();

    public String getDeleteAllRowsSql();

    public String getDeleteRowsSqlForSegments(int var1);

    public String getSelectOnlyExpiredRowsSql();

    public boolean isStringEncodingRequired();

    public String encodeString(String var1);

    public void prepareUpsertStatement(PreparedStatement var1, String var2, long var3, int var5, ByteBuffer var6) throws SQLException;

    public void prepareUpdateStatement(PreparedStatement var1, String var2, long var3, int var5, ByteBuffer var6) throws SQLException;
}

