/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend;

import java.io.Serializable;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.hibernate.search.backend.IndexWorkVisitor;
import org.hibernate.search.spi.IndexedTypeIdentifier;

public abstract class LuceneWork {
    private final Document document;
    private final IndexedTypeIdentifier entityType;
    private final String tenantId;
    private final Serializable id;
    private final String idInString;

    public LuceneWork(String tenantId, Serializable id, String idInString, IndexedTypeIdentifier typeIdentifier) {
        this(tenantId, id, idInString, typeIdentifier, null);
    }

    public LuceneWork(String tenantId, Serializable id, String idInString, IndexedTypeIdentifier typeIdentifier, Document document) {
        this.tenantId = tenantId;
        this.id = id;
        this.idInString = idInString;
        this.entityType = typeIdentifier;
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    @Deprecated
    public Class<?> getEntityClass() {
        return this.entityType.getPojoType();
    }

    public IndexedTypeIdentifier getEntityType() {
        return this.entityType;
    }

    public Serializable getId() {
        return this.id;
    }

    public String getIdInString() {
        return this.idInString;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public abstract <P, R> R acceptIndexWorkVisitor(IndexWorkVisitor<P, R> var1, P var2);

    public Map<String, String> getFieldToAnalyzerMap() {
        return null;
    }
}

