/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event.spi;

import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.event.spi.BaseEnversEventListener;
import org.hibernate.envers.internal.synchronization.AuditProcess;
import org.hibernate.envers.internal.synchronization.work.DelWorkUnit;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.persister.entity.EntityPersister;

public class EnversPostDeleteEventListenerImpl
extends BaseEnversEventListener
implements PostDeleteEventListener {
    public EnversPostDeleteEventListenerImpl(EnversService enversService) {
        super(enversService);
    }

    public void onPostDelete(PostDeleteEvent event) {
        String entityName = event.getPersister().getEntityName();
        if (this.getEnversService().getEntitiesConfigurations().isVersioned(entityName)) {
            this.checkIfTransactionInProgress((SessionImplementor)event.getSession());
            AuditProcess auditProcess = this.getEnversService().getAuditProcessManager().get(event.getSession());
            DelWorkUnit workUnit = new DelWorkUnit((SessionImplementor)event.getSession(), event.getPersister().getEntityName(), this.getEnversService(), event.getId(), event.getPersister(), event.getDeletedState());
            auditProcess.addWorkUnit(workUnit);
            if (workUnit.containsWork()) {
                this.generateBidirectionalCollectionChangeWorkUnits(auditProcess, event.getPersister(), entityName, null, event.getDeletedState(), (SessionImplementor)event.getSession());
            }
        }
    }

    public boolean requiresPostCommitHanding(EntityPersister persister) {
        return this.getEnversService().getEntitiesConfigurations().isVersioned(persister.getEntityName());
    }
}

