/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.deployment;

import org.jboss.as.security.ModuleName;
import org.jboss.as.security.plugins.ModuleClassLoaderLocator;
import org.jboss.as.security.remoting.RemotingLoginModule;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;
import org.jboss.security.plugins.ClassLoaderLocator;
import org.jboss.security.plugins.ClassLoaderLocatorFactory;

public class SecurityDependencyProcessor
implements DeploymentUnitProcessor {
    public static final ModuleIdentifier PICKETBOX_ID = ModuleIdentifier.create((String)ModuleName.PICKETBOX.getName(), (String)ModuleName.PICKETBOX.getSlot());
    public static final ModuleIdentifier REMOTING_LOGIN_MODULE = ModuleIdentifier.create((String)"org.jboss.as.security");
    public static final ModuleIdentifier AUTH_MESSAGE_API = ModuleIdentifier.create((String)"javax.security.auth.message.api");
    public static final ModuleIdentifier JACC_API = ModuleIdentifier.create((String)"javax.security.jacc.api");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, PICKETBOX_ID, false, false, false, false));
        ModuleDependency remoting = new ModuleDependency(moduleLoader, REMOTING_LOGIN_MODULE, false, false, false, false);
        remoting.addImportFilter(PathFilters.is((String)RemotingLoginModule.class.getName().replace(".", "/")), true);
        moduleSpecification.addSystemDependency(remoting);
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, JACC_API, false, false, true, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, AUTH_MESSAGE_API, false, false, true, false));
    }

    public void undeploy(DeploymentUnit context) {
        ClassLoaderLocator locator = ClassLoaderLocatorFactory.get();
        if (locator instanceof ModuleClassLoaderLocator) {
            ((ModuleClassLoaderLocator)locator).clearCache();
        }
    }
}

