/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.BiFunction;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.ObjectMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;

public class SingletonMapMarshaller<T extends Map<Object, Object>>
implements ProtoStreamMarshaller<T> {
    private final BiFunction<Object, Object, T> factory;

    public SingletonMapMarshaller(BiFunction<Object, Object, T> factory) {
        this.factory = factory;
    }

    public T readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
        Object key = ObjectMarshaller.INSTANCE.readFrom(context, reader);
        Object value = ObjectMarshaller.INSTANCE.readFrom(context, reader);
        return (T)((Map)this.factory.apply(key, value));
    }

    public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, T map) throws IOException {
        Map.Entry entry = map.entrySet().iterator().next();
        ObjectMarshaller.INSTANCE.writeTo(context, writer, entry.getKey());
        ObjectMarshaller.INSTANCE.writeTo(context, writer, entry.getValue());
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, T map) {
        Map.Entry entry = map.entrySet().iterator().next();
        OptionalInt size = ObjectMarshaller.INSTANCE.size(context, entry.getKey());
        if (size.isPresent()) {
            OptionalInt valueSize = ObjectMarshaller.INSTANCE.size(context, entry.getValue());
            size = valueSize.isPresent() ? OptionalInt.of(size.getAsInt() + valueSize.getAsInt()) : OptionalInt.empty();
        }
        return size;
    }

    public Class<? extends T> getJavaClass() {
        return ((Map)this.factory.apply(null, null)).getClass();
    }
}

