/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.util.OptionalInt;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.wildfly.clustering.marshalling.protostream.Predictable;

public class EnumMarshaller<E extends Enum<E>>
implements org.infinispan.protostream.EnumMarshaller<E>,
Predictable<E> {
    private final Class<E> enumClass;
    private final E[] values;

    public EnumMarshaller(Class<E> enumClass) {
        this.enumClass = enumClass;
        this.values = (Enum[])enumClass.getEnumConstants();
    }

    public Class<? extends E> getJavaClass() {
        return this.enumClass;
    }

    public String getTypeName() {
        Package targetPackage = this.enumClass.getPackage();
        return targetPackage != null ? targetPackage.getName() + '.' + this.enumClass.getSimpleName() : this.enumClass.getSimpleName();
    }

    public E decode(int ordinal) {
        return this.values[ordinal];
    }

    public int encode(E value) throws IllegalArgumentException {
        return ((Enum)value).ordinal();
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, E value) {
        return OptionalInt.of(Predictable.unsignedIntSize(((Enum)value).ordinal()));
    }
}

