/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

interface OperationValidator {
    public void validate(ModelNode var1) throws OperationFailedException;

    public void validateAndSet(ModelNode var1, ModelNode var2) throws OperationFailedException;

    public static class AttributeDefinitionOperationValidator
    implements OperationValidator {
        private final AttributeDefinition[] attributes;

        public AttributeDefinitionOperationValidator(AttributeDefinition ... attributes) {
            this.attributes = attributes;
        }

        @Override
        public void validate(ModelNode operation) throws OperationFailedException {
            for (AttributeDefinition definition : this.attributes) {
                String attributeName = definition.getName();
                boolean has = operation.has(attributeName);
                if (!has && definition.isRequired(operation)) {
                    throw new OperationFailedException(MessagingLogger.ROOT_LOGGER.required(definition.getName()));
                }
                if (!has) continue;
                if (!definition.isAllowed(operation)) {
                    throw new OperationFailedException(MessagingLogger.ROOT_LOGGER.invalid(definition.getName()));
                }
                definition.validateOperation(operation);
            }
        }

        @Override
        public void validateAndSet(ModelNode operation, ModelNode subModel) throws OperationFailedException {
            for (AttributeDefinition definition : this.attributes) {
                String attributeName = definition.getName();
                boolean has = operation.has(attributeName);
                if (!has && definition.isRequired(operation)) {
                    throw new OperationFailedException(MessagingLogger.ROOT_LOGGER.required(definition.getName()));
                }
                if (!has) continue;
                if (!definition.isAllowed(operation)) {
                    throw new OperationFailedException(MessagingLogger.ROOT_LOGGER.invalid(definition.getName()));
                }
                definition.validateAndSet(operation, subModel);
            }
        }
    }
}

