/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.api.core.management.ActiveMQServerControl;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.management.impl.ActiveMQServerControlImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.messaging.activemq.BridgeDefinition;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class BridgeAdd
extends AbstractAddStepHandler {
    public static final BridgeAdd INSTANCE = new BridgeAdd();

    private BridgeAdd() {
        super(BridgeDefinition.ATTRIBUTES);
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        CredentialReference.handleCredentialReferenceUpdate((OperationContext)context, (ModelNode)resource.getModel());
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName serviceName;
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController service = registry.getService(serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (service != null) {
            if (service.getState() != ServiceController.State.UP) {
                throw MessagingLogger.ROOT_LOGGER.invalidServiceState(serviceName, ServiceController.State.UP, service.getState());
            }
            String name = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            BridgeConfiguration bridgeConfig = BridgeAdd.createBridgeConfiguration(context, name, model);
            ActiveMQServerControlImpl serverControl = ((ActiveMQServer)ActiveMQServer.class.cast(service.getValue())).getActiveMQServerControl();
            BridgeAdd.createBridge(name, bridgeConfig, (ActiveMQServerControl)serverControl);
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)BridgeDefinition.CREDENTIAL_REFERENCE, (OperationContext)context, (Resource)resource);
    }

    static BridgeConfiguration createBridgeConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        String queueName = BridgeDefinition.QUEUE_NAME.resolveModelAttribute(context, model).asString();
        ModelNode forwardingNode = BridgeDefinition.FORWARDING_ADDRESS.resolveModelAttribute(context, model);
        String forwardingAddress = forwardingNode.isDefined() ? forwardingNode.asString() : null;
        ModelNode filterNode = CommonAttributes.FILTER.resolveModelAttribute(context, model);
        String filterString = filterNode.isDefined() ? filterNode.asString() : null;
        int minLargeMessageSize = CommonAttributes.MIN_LARGE_MESSAGE_SIZE.resolveModelAttribute(context, model).asInt();
        long retryInterval = CommonAttributes.RETRY_INTERVAL.resolveModelAttribute(context, model).asLong();
        double retryIntervalMultiplier = CommonAttributes.RETRY_INTERVAL_MULTIPLIER.resolveModelAttribute(context, model).asDouble();
        long maxRetryInterval = CommonAttributes.MAX_RETRY_INTERVAL.resolveModelAttribute(context, model).asLong();
        int initialConnectAttempts = BridgeDefinition.INITIAL_CONNECT_ATTEMPTS.resolveModelAttribute(context, model).asInt();
        int reconnectAttempts = BridgeDefinition.RECONNECT_ATTEMPTS.resolveModelAttribute(context, model).asInt();
        int reconnectAttemptsOnSameNode = BridgeDefinition.RECONNECT_ATTEMPTS_ON_SAME_NODE.resolveModelAttribute(context, model).asInt();
        boolean useDuplicateDetection = BridgeDefinition.USE_DUPLICATE_DETECTION.resolveModelAttribute(context, model).asBoolean();
        int confirmationWindowSize = CommonAttributes.BRIDGE_CONFIRMATION_WINDOW_SIZE.resolveModelAttribute(context, model).asInt();
        int producerWindowSize = BridgeDefinition.PRODUCER_WINDOW_SIZE.resolveModelAttribute(context, model).asInt();
        long clientFailureCheckPeriod = CommonAttributes.CHECK_PERIOD.resolveModelAttribute(context, model).asLong();
        long connectionTTL = CommonAttributes.CONNECTION_TTL.resolveModelAttribute(context, model).asLong();
        ModelNode discoveryNode = BridgeDefinition.DISCOVERY_GROUP_NAME.resolveModelAttribute(context, model);
        String discoveryGroupName = discoveryNode.isDefined() ? discoveryNode.asString() : null;
        List<String> staticConnectors = discoveryGroupName == null ? BridgeAdd.getStaticConnectors(model) : null;
        boolean ha = CommonAttributes.HA.resolveModelAttribute(context, model).asBoolean();
        String user = BridgeDefinition.USER.resolveModelAttribute(context, model).asString();
        String password = BridgeDefinition.PASSWORD.resolveModelAttribute(context, model).asString();
        BridgeConfiguration config = new BridgeConfiguration().setName(name).setQueueName(queueName).setForwardingAddress(forwardingAddress).setFilterString(filterString).setMinLargeMessageSize(minLargeMessageSize).setClientFailureCheckPeriod(clientFailureCheckPeriod).setConnectionTTL(connectionTTL).setRetryInterval(retryInterval).setMaxRetryInterval(maxRetryInterval).setRetryIntervalMultiplier(retryIntervalMultiplier).setInitialConnectAttempts(initialConnectAttempts).setReconnectAttempts(reconnectAttempts).setReconnectAttemptsOnSameNode(reconnectAttemptsOnSameNode).setUseDuplicateDetection(useDuplicateDetection).setConfirmationWindowSize(confirmationWindowSize).setProducerWindowSize(producerWindowSize).setHA(ha).setUser(user).setPassword(password);
        if (discoveryGroupName != null) {
            config.setDiscoveryGroupName(discoveryGroupName);
        } else {
            config.setStaticConnectors(staticConnectors);
        }
        ModelNode transformerClassName = CommonAttributes.TRANSFORMER_CLASS_NAME.resolveModelAttribute(context, model);
        if (transformerClassName.isDefined()) {
            config.setTransformerConfiguration(new TransformerConfiguration(transformerClassName.asString()));
        }
        return config;
    }

    private static List<String> getStaticConnectors(ModelNode model) {
        ArrayList<String> result = new ArrayList<String>();
        for (ModelNode connector : model.require("static-connectors").asList()) {
            result.add(connector.asString());
        }
        return result;
    }

    static void createBridge(String name, BridgeConfiguration bridgeConfig, ActiveMQServerControl serverControl) {
        try {
            String transformerClassName;
            String string = transformerClassName = bridgeConfig.getTransformerConfiguration() != null ? bridgeConfig.getTransformerConfiguration().getClassName() : null;
            if (bridgeConfig.getDiscoveryGroupName() != null) {
                serverControl.createBridge(name, bridgeConfig.getQueueName(), bridgeConfig.getForwardingAddress(), bridgeConfig.getFilterString(), transformerClassName, bridgeConfig.getRetryInterval(), bridgeConfig.getRetryIntervalMultiplier(), bridgeConfig.getInitialConnectAttempts(), bridgeConfig.getReconnectAttempts(), bridgeConfig.isUseDuplicateDetection(), bridgeConfig.getConfirmationWindowSize(), bridgeConfig.getClientFailureCheckPeriod(), bridgeConfig.getDiscoveryGroupName(), true, bridgeConfig.isHA(), bridgeConfig.getUser(), bridgeConfig.getPassword());
            } else {
                boolean first = true;
                String connectors = "";
                for (String connector : bridgeConfig.getStaticConnectors()) {
                    if (!first) {
                        connectors = connectors + ",";
                    } else {
                        first = false;
                    }
                    connectors = connectors + connector;
                }
                serverControl.createBridge(name, bridgeConfig.getQueueName(), bridgeConfig.getForwardingAddress(), bridgeConfig.getFilterString(), transformerClassName, bridgeConfig.getRetryInterval(), bridgeConfig.getRetryIntervalMultiplier(), bridgeConfig.getInitialConnectAttempts(), bridgeConfig.getReconnectAttempts(), bridgeConfig.isUseDuplicateDetection(), bridgeConfig.getConfirmationWindowSize(), bridgeConfig.getClientFailureCheckPeriod(), connectors, false, bridgeConfig.isHA(), bridgeConfig.getUser(), bridgeConfig.getPassword());
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

