/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter.jms;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSMessage;
import org.apache.activemq.artemis.reader.BytesMessageUtil;

public class ServerJMSBytesMessage
extends ServerJMSMessage
implements BytesMessage {
    public ServerJMSBytesMessage(ICoreMessage message) {
        super(message);
    }

    public long getBodyLength() throws JMSException {
        return this.message.getBodyBufferSize();
    }

    public boolean readBoolean() throws JMSException {
        return BytesMessageUtil.bytesReadBoolean((ActiveMQBuffer)this.getReadBodyBuffer());
    }

    public byte readByte() throws JMSException {
        return BytesMessageUtil.bytesReadByte((ActiveMQBuffer)this.getReadBodyBuffer());
    }

    public int readUnsignedByte() throws JMSException {
        return BytesMessageUtil.bytesReadUnsignedByte((ActiveMQBuffer)this.getReadBodyBuffer());
    }

    public short readShort() throws JMSException {
        return BytesMessageUtil.bytesReadShort((ActiveMQBuffer)this.getReadBodyBuffer());
    }

    public int readUnsignedShort() throws JMSException {
        return BytesMessageUtil.bytesReadUnsignedShort((ActiveMQBuffer)this.getReadBodyBuffer());
    }

    public char readChar() throws JMSException {
        return BytesMessageUtil.bytesReadChar((ActiveMQBuffer)this.getReadBodyBuffer());
    }

    public int readInt() throws JMSException {
        return BytesMessageUtil.bytesReadInt((ActiveMQBuffer)this.getReadBodyBuffer());
    }

    public long readLong() throws JMSException {
        return BytesMessageUtil.bytesReadLong((ActiveMQBuffer)this.getReadBodyBuffer());
    }

    public float readFloat() throws JMSException {
        return BytesMessageUtil.bytesReadFloat((ActiveMQBuffer)this.getReadBodyBuffer());
    }

    public double readDouble() throws JMSException {
        return BytesMessageUtil.bytesReadDouble((ActiveMQBuffer)this.getReadBodyBuffer());
    }

    public String readUTF() throws JMSException {
        return BytesMessageUtil.bytesReadUTF((ActiveMQBuffer)this.getReadBodyBuffer());
    }

    public int readBytes(byte[] value) throws JMSException {
        return BytesMessageUtil.bytesReadBytes((ActiveMQBuffer)this.getReadBodyBuffer(), (byte[])value);
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        return BytesMessageUtil.bytesReadBytes((ActiveMQBuffer)this.getReadBodyBuffer(), (byte[])value, (int)length);
    }

    public void writeBoolean(boolean value) throws JMSException {
        BytesMessageUtil.bytesWriteBoolean((ActiveMQBuffer)this.getWriteBodyBuffer(), (boolean)value);
    }

    public void writeByte(byte value) throws JMSException {
        BytesMessageUtil.bytesWriteByte((ActiveMQBuffer)this.getWriteBodyBuffer(), (byte)value);
    }

    public void writeShort(short value) throws JMSException {
        BytesMessageUtil.bytesWriteShort((ActiveMQBuffer)this.getWriteBodyBuffer(), (short)value);
    }

    public void writeChar(char value) throws JMSException {
        BytesMessageUtil.bytesWriteChar((ActiveMQBuffer)this.getWriteBodyBuffer(), (char)value);
    }

    public void writeInt(int value) throws JMSException {
        BytesMessageUtil.bytesWriteInt((ActiveMQBuffer)this.getWriteBodyBuffer(), (int)value);
    }

    public void writeLong(long value) throws JMSException {
        BytesMessageUtil.bytesWriteLong((ActiveMQBuffer)this.getWriteBodyBuffer(), (long)value);
    }

    public void writeFloat(float value) throws JMSException {
        BytesMessageUtil.bytesWriteFloat((ActiveMQBuffer)this.getWriteBodyBuffer(), (float)value);
    }

    public void writeDouble(double value) throws JMSException {
        BytesMessageUtil.bytesWriteDouble((ActiveMQBuffer)this.getWriteBodyBuffer(), (double)value);
    }

    public void writeUTF(String value) throws JMSException {
        BytesMessageUtil.bytesWriteUTF((ActiveMQBuffer)this.getWriteBodyBuffer(), (String)value);
    }

    public void writeBytes(byte[] value) throws JMSException {
        BytesMessageUtil.bytesWriteBytes((ActiveMQBuffer)this.getWriteBodyBuffer(), (byte[])value);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        BytesMessageUtil.bytesWriteBytes((ActiveMQBuffer)this.getWriteBodyBuffer(), (byte[])value, (int)offset, (int)length);
    }

    public void writeObject(Object value) throws JMSException {
        if (!BytesMessageUtil.bytesWriteObject((ActiveMQBuffer)this.getWriteBodyBuffer(), (Object)value)) {
            throw new JMSException("Can't make conversion of " + value + " to any known type");
        }
    }

    @Override
    public void encode() throws Exception {
        super.encode();
        this.getBodyLength();
    }

    @Override
    public void decode() throws Exception {
        super.decode();
    }

    public void reset() throws JMSException {
        if (!this.message.isLargeMessage()) {
            BytesMessageUtil.bytesMessageReset((ActiveMQBuffer)this.getReadBodyBuffer());
            BytesMessageUtil.bytesMessageReset((ActiveMQBuffer)this.getWriteBodyBuffer());
        }
    }
}

