/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web.deployment;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.as.web.session.SharedSessionManagerConfig;
import org.jboss.logging.Logger;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.web.WebProviderRequirement;
import org.wildfly.clustering.web.session.DistributableSessionManagementProvider;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentConfiguration;

public class DistributableWebDeploymentDependencyProcessor
implements DeploymentUnitProcessor {
    public static final AttachmentKey<DistributableWebDeploymentConfiguration> CONFIGURATION_KEY = AttachmentKey.create(DistributableWebDeploymentConfiguration.class);
    private static final Logger LOGGER = Logger.getLogger(DistributableWebDeploymentDependencyProcessor.class);

    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = context.getDeploymentUnit();
        WarMetaData warMetaData = (WarMetaData)unit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        SharedSessionManagerConfig sharedConfig = (SharedSessionManagerConfig)unit.getAttachment(SharedSessionManagerConfig.ATTACHMENT_KEY);
        if (warMetaData != null && warMetaData.getMergedJBossWebMetaData() != null && warMetaData.getMergedJBossWebMetaData().getDistributable() != null || sharedConfig != null && sharedConfig.isDistributable()) {
            CapabilityServiceSupport support = (CapabilityServiceSupport)unit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
            DistributableWebDeploymentConfiguration config = (DistributableWebDeploymentConfiguration)unit.getAttachment(CONFIGURATION_KEY);
            String name = config != null ? config.getSessionManagementName() : null;
            DistributableSessionManagementProvider management = name == null && config != null ? config.getSessionManagement() : null;
            List<Object> immutableClasses = config != null ? config.getImmutableClasses() : Collections.emptyList();
            for (String string : immutableClasses) {
                unit.addToAttachmentList(DistributableSessionManagementProvider.IMMUTABILITY_ATTACHMENT_KEY, (Object)string);
            }
            if (management != null) {
                LOGGER.debugf("%s will use a deployment-specific distributable session management provider", (Object)unit.getName());
                ServiceTarget target = context.getServiceTarget();
                DeploymentUnit deploymentUnit = unit.getParent();
                String deploymentName = deploymentUnit != null ? deploymentUnit.getName() + "." + unit.getName() : unit.getName();
                ServiceName serviceName = WebProviderRequirement.SESSION_MANAGEMENT_PROVIDER.getServiceName(support, deploymentName);
                ServiceBuilder builder = target.addService(serviceName);
                Consumer injector = builder.provides(new ServiceName[]{serviceName});
                Service service = Service.newInstance((Consumer)injector, (Object)management);
                builder.setInstance(service).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
                context.addDependency(serviceName, DistributableSessionManagementProvider.ATTACHMENT_KEY);
            } else {
                if (name != null) {
                    LOGGER.debugf("%s will use the '%s' distributable session management provider", (Object)unit.getName(), (Object)name);
                } else {
                    LOGGER.debugf("%s will use the default distributable session management provider", (Object)unit.getName());
                }
                context.addDependency(WebProviderRequirement.SESSION_MANAGEMENT_PROVIDER.getServiceName(support, name), DistributableSessionManagementProvider.ATTACHMENT_KEY);
            }
        }
    }

    public void undeploy(DeploymentUnit unit) {
        unit.removeAttachment(DistributableSessionManagementProvider.IMMUTABILITY_ATTACHMENT_KEY);
    }
}

