/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.sasl.util.SaslWrapper;

public abstract class AbstractSaslParticipant
implements SaslWrapper {
    public static final byte[] NO_BYTES = new byte[0];
    public static final int FAILED_STATE = -1;
    public static final int COMPLETE_STATE = 0;
    private final String mechanismName;
    private final CallbackHandler callbackHandler;
    private final String protocol;
    private final String serverName;
    private int state = -1;
    private SaslWrapper wrapper;

    protected AbstractSaslParticipant(String mechanismName, String protocol, String serverName, CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
        this.mechanismName = mechanismName;
        this.protocol = protocol;
        this.serverName = serverName;
    }

    protected void handleCallbacks(Callback ... callbacks) throws SaslException {
        try {
            this.tryHandleCallbacks(callbacks);
        }
        catch (UnsupportedCallbackException e) {
            throw ElytronMessages.log.mechCallbackHandlerFailedForUnknownReason(this.getMechanismName(), e).toSaslException();
        }
    }

    protected void tryHandleCallbacks(Callback ... callbacks) throws SaslException, UnsupportedCallbackException {
        Assert.checkNotNullParam("callbackHandler", this.callbackHandler);
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException | SaslException e) {
            throw e;
        }
        catch (Throwable t) {
            throw ElytronMessages.log.mechCallbackHandlerFailedForUnknownReason(this.getMechanismName(), t).toSaslException();
        }
    }

    public void init() {
    }

    public String getMechanismName() {
        return this.mechanismName;
    }

    protected String getProtocol() {
        return this.protocol;
    }

    protected String getServerName() {
        return this.serverName;
    }

    protected CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    protected SaslWrapper getWrapper() {
        return this.wrapper;
    }

    public void setNegotiationState(int newState) {
        this.state = newState;
    }

    public void negotiationComplete() {
        this.state = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] evaluateMessage(byte[] message) throws SaslException {
        boolean ok = false;
        try {
            if (this.state == 0) {
                throw ElytronMessages.log.mechMessageAfterComplete(this.getMechanismName()).toSaslException();
            }
            if (this.state == -1) {
                throw ElytronMessages.log.mechAuthenticationFailed(this.getMechanismName()).toSaslException();
            }
            byte[] result = this.evaluateMessage(this.state, message);
            ok = true;
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (!ok) {
                this.state = -1;
            }
        }
    }

    protected abstract byte[] evaluateMessage(int var1, byte[] var2) throws SaslException;

    protected void setWrapper(SaslWrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (!this.isComplete()) {
            throw ElytronMessages.log.mechAuthenticationNotComplete(this.getMechanismName());
        }
        SaslWrapper wrapper = this.wrapper;
        if (wrapper == null) {
            throw ElytronMessages.log.wrappingNotConfigured(this.getMechanismName());
        }
        if (len == 0) {
            return NO_BYTES;
        }
        return wrapper.wrap(outgoing, offset, len);
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (!this.isComplete()) {
            throw ElytronMessages.log.mechAuthenticationNotComplete(this.getMechanismName());
        }
        SaslWrapper wrapper = this.wrapper;
        if (wrapper == null) {
            throw ElytronMessages.log.wrappingNotConfigured(this.getMechanismName());
        }
        if (len == 0) {
            return NO_BYTES;
        }
        return wrapper.unwrap(incoming, offset, len);
    }

    public boolean isComplete() {
        return this.state == 0;
    }

    protected void assertComplete() {
        if (!this.isComplete()) {
            throw ElytronMessages.log.mechAuthenticationNotComplete(this.getMechanismName());
        }
    }

    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    public String getStringProperty(Map<String, ?> map, String key, String defaultVal) {
        Object val = map.get(key);
        if (val == null) {
            return defaultVal;
        }
        return String.valueOf(val);
    }

    public int getIntProperty(Map<String, ?> map, String key, int defaultVal) {
        Object val = map.get(key);
        if (val == null) {
            return defaultVal;
        }
        return Integer.parseInt(val.toString());
    }

    public void dispose() throws SaslException {
    }
}

