/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.wildfly.common.Assert;
import org.wildfly.plugin.tools.Deployment;
import org.wildfly.plugin.tools.DeploymentDescription;
import org.wildfly.plugin.tools.UndeployDescription;
import org.wildfly.plugin.tools.util.Assertions;

public class DeploymentOperations {
    static final String ENABLED = "enabled";
    static final ModelNode EMPTY_ADDRESS = new ModelNode().setEmptyList();

    static ModelNode createAddress(String ... pairs) {
        return DeploymentOperations.createAddress(Arrays.asList(pairs));
    }

    static ModelNode createAddress(Iterable<String> pairs) {
        ModelNode address = new ModelNode();
        Iterator<String> iterator = pairs.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            String value = iterator.hasNext() ? iterator.next() : "*";
            address.add(key, value);
        }
        return address;
    }

    public static Operation createAddDeploymentOperation(Deployment deployment) {
        Assert.checkNotNullParam((String)"deployment", (Object)deployment);
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create((boolean)true);
        DeploymentOperations.addDeploymentOperationStep(builder, deployment);
        return builder.build();
    }

    public static Operation createAddDeploymentOperation(Set<Deployment> deployments) {
        Assertions.requiresNotNullOrNotEmptyParameter("deployments", deployments);
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create((boolean)true);
        for (Deployment deployment : deployments) {
            DeploymentOperations.addDeploymentOperationStep(builder, deployment);
        }
        return builder.build();
    }

    public static Operation createDeployOperation(DeploymentDescription deployment) {
        Assert.checkNotNullParam((String)"deployment", (Object)deployment);
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create((boolean)true);
        DeploymentOperations.addDeployOperationStep(builder, deployment);
        return builder.build();
    }

    public static Operation createDeployOperation(Set<DeploymentDescription> deployments) {
        Assertions.requiresNotNullOrNotEmptyParameter("deployments", deployments);
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create((boolean)true);
        for (DeploymentDescription deployment : deployments) {
            DeploymentOperations.addDeployOperationStep(builder, deployment);
        }
        return builder.build();
    }

    public static Operation createReplaceOperation(Deployment deployment) {
        Assert.checkNotNullParam((String)"deployment", (Object)deployment);
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create((boolean)true);
        DeploymentOperations.addReplaceOperationSteps(builder, deployment);
        return builder.build();
    }

    public static Operation createReplaceOperation(Set<Deployment> deployments) {
        Assertions.requiresNotNullOrNotEmptyParameter("deployments", deployments);
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create((boolean)true);
        for (Deployment deployment : deployments) {
            DeploymentOperations.addReplaceOperationSteps(builder, deployment);
        }
        return builder.build();
    }

    public static Operation createRedeployOperation(DeploymentDescription deployment) {
        Assert.checkNotNullParam((String)"deployment", (Object)deployment);
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create((boolean)true);
        DeploymentOperations.addRedeployOperationStep(builder, deployment);
        return builder.build();
    }

    public static Operation createRedeployOperation(Set<DeploymentDescription> deployments) {
        Assertions.requiresNotNullOrNotEmptyParameter("deployments", deployments);
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create((boolean)true);
        for (DeploymentDescription deployment : deployments) {
            DeploymentOperations.addRedeployOperationStep(builder, deployment);
        }
        return builder.build();
    }

    public static Operation createUndeployOperation(UndeployDescription undeployDescription) {
        Assert.checkNotNullParam((String)"undeployDescription", (Object)undeployDescription);
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create((boolean)true);
        DeploymentOperations.addUndeployOperationStep(builder, undeployDescription);
        return builder.build();
    }

    public static Operation createUndeployOperation(Set<UndeployDescription> undeployDescriptions) {
        Assertions.requiresNotNullOrNotEmptyParameter("undeployDescriptions", undeployDescriptions);
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create((boolean)true);
        for (UndeployDescription undeployDescription : undeployDescriptions) {
            DeploymentOperations.addUndeployOperationStep(builder, undeployDescription);
        }
        return builder.build();
    }

    static void addDeploymentOperationStep(Operations.CompositeOperationBuilder builder, Deployment deployment) {
        String name = deployment.getName();
        ModelNode address = DeploymentOperations.createAddress("deployment", name);
        String runtimeName = deployment.getRuntimeName();
        ModelNode addOperation = Operations.createAddOperation((ModelNode)address);
        if (runtimeName != null) {
            addOperation.get("runtime-name").set(runtimeName);
        }
        addOperation.get(ENABLED).set(deployment.isEnabled());
        DeploymentOperations.addContent(builder, addOperation, deployment);
        builder.addStep(addOperation);
        Set<String> serverGroups = deployment.getServerGroups();
        if (!serverGroups.isEmpty()) {
            for (String serverGroup : serverGroups) {
                ModelNode sgAddress = DeploymentOperations.createAddress("server-group", serverGroup, "deployment", name);
                ModelNode op = Operations.createAddOperation((ModelNode)sgAddress);
                op.get(ENABLED).set(deployment.isEnabled());
                if (runtimeName != null) {
                    op.get("runtime-name").set(runtimeName);
                }
                builder.addStep(op);
            }
        }
    }

    static void addDeployOperationStep(Operations.CompositeOperationBuilder builder, DeploymentDescription deployment) {
        String name = deployment.getName();
        Set<String> serverGroups = deployment.getServerGroups();
        if (serverGroups.isEmpty()) {
            ModelNode address = DeploymentOperations.createAddress("deployment", name);
            builder.addStep(Operations.createOperation((String)"deploy", (ModelNode)address));
        } else {
            for (String serverGroup : serverGroups) {
                ModelNode address = DeploymentOperations.createAddress("server-group", serverGroup, "deployment", name);
                builder.addStep(Operations.createOperation((String)"deploy", (ModelNode)address));
            }
        }
    }

    static void addReplaceOperationSteps(Operations.CompositeOperationBuilder builder, Deployment deployment, DeploymentDescription currentDeployment, boolean allowAddIfMissing) {
        LinkedHashSet<String> serverGroups;
        String name = deployment.getName();
        String runtimeName = deployment.getRuntimeName();
        if (allowAddIfMissing && !(serverGroups = new LinkedHashSet<String>(deployment.getServerGroups())).isEmpty()) {
            serverGroups.removeAll(currentDeployment.getServerGroups());
            for (String serverGroup : serverGroups) {
                ModelNode sgAddress = DeploymentOperations.createAddress("server-group", serverGroup, "deployment", name);
                ModelNode addOp = Operations.createAddOperation((ModelNode)sgAddress);
                addOp.get(ENABLED).set(false);
                if (runtimeName != null) {
                    addOp.get("runtime-name").set(runtimeName);
                }
                builder.addStep(addOp);
            }
        }
        ModelNode op = Operations.createOperation((String)"full-replace-deployment");
        op.get("name").set(name);
        if (runtimeName != null) {
            op.get("runtime-name").set(runtimeName);
        }
        DeploymentOperations.addContent(builder, op, deployment);
        op.get(ENABLED).set(deployment.isEnabled());
        builder.addStep(op);
    }

    static void addReplaceOperationSteps(Operations.CompositeOperationBuilder builder, Deployment deployment) {
        String name = deployment.getName();
        String runtimeName = deployment.getRuntimeName();
        ModelNode op = Operations.createOperation((String)"full-replace-deployment");
        op.get("name").set(name);
        if (runtimeName != null) {
            op.get("runtime-name").set(runtimeName);
        }
        DeploymentOperations.addContent(builder, op, deployment);
        op.get(ENABLED).set(deployment.isEnabled());
        builder.addStep(op);
    }

    private static void addRedeployOperationStep(Operations.CompositeOperationBuilder builder, DeploymentDescription deployment) {
        String deploymentName = deployment.getName();
        Set<String> serverGroups = deployment.getServerGroups();
        if (serverGroups.isEmpty()) {
            builder.addStep(Operations.createOperation((String)"redeploy", (ModelNode)DeploymentOperations.createAddress("deployment", deploymentName)));
        } else {
            for (String serverGroup : serverGroups) {
                builder.addStep(Operations.createOperation((String)"redeploy", (ModelNode)DeploymentOperations.createAddress("server-group", serverGroup, "deployment", deploymentName)));
            }
        }
    }

    private static void addUndeployOperationStep(Operations.CompositeOperationBuilder builder, UndeployDescription undeployDescription) {
        String name = undeployDescription.getName();
        Set<String> serverGroups = undeployDescription.getServerGroups();
        if (serverGroups.isEmpty()) {
            ModelNode address = DeploymentOperations.createAddress("deployment", name);
            builder.addStep(Operations.createOperation((String)"undeploy", (ModelNode)address));
            if (undeployDescription.isRemoveContent()) {
                builder.addStep(Operations.createRemoveOperation((ModelNode)address));
            }
        } else {
            for (String serverGroup : serverGroups) {
                ModelNode address = DeploymentOperations.createAddress("server-group", serverGroup, "deployment", name);
                builder.addStep(Operations.createOperation((String)"undeploy", (ModelNode)address));
                if (!undeployDescription.isRemoveContent()) continue;
                builder.addStep(Operations.createRemoveOperation((ModelNode)address));
            }
            if (undeployDescription.isRemoveContent()) {
                builder.addStep(Operations.createRemoveOperation((ModelNode)DeploymentOperations.createAddress("deployment", name)));
            }
        }
    }

    private static void addContent(Operations.CompositeOperationBuilder builder, ModelNode op, Deployment deployment) {
        deployment.getContent().addContentToOperation((OperationBuilder)builder, op);
    }

    static {
        EMPTY_ADDRESS.protect();
    }
}

