/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.provisioning.model;

import java.util.HashMap;
import java.util.Map;

enum Element {
    UNKNOWN(null),
    SERVER_PROVISIONING("server-provisioning"),
    FEATURE_PACKS("feature-packs"),
    FEATURE_PACK("feature-pack"),
    ARTIFACT("artifact"),
    MODULES("modules"),
    CONFIG("config"),
    STANDALONE("standalone"),
    DOMAIN("domain"),
    PROPERTY("property"),
    SUBSYSTEMS("subsystems"),
    SUBSYSTEM("subsystem"),
    CONTENTS("contents"),
    VERSION_OVERRIDES("version-overrides"),
    VERSION_OVERRIDE("version-override"),
    COPY_ARTIFACTS("copy-artifacts"),
    FILTER("filter");

    private static final Map<String, Element> elements;
    private final String name;

    static Element of(String name) {
        Element element = elements.get(name);
        return element == null ? UNKNOWN : element;
    }

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    static {
        HashMap<String, Element> elementsMap = new HashMap<String, Element>();
        elementsMap.put(SERVER_PROVISIONING.getLocalName(), SERVER_PROVISIONING);
        elementsMap.put(FEATURE_PACKS.getLocalName(), FEATURE_PACKS);
        elementsMap.put(FEATURE_PACK.getLocalName(), FEATURE_PACK);
        elementsMap.put(ARTIFACT.getLocalName(), ARTIFACT);
        elementsMap.put(MODULES.getLocalName(), MODULES);
        elementsMap.put(FILTER.getLocalName(), FILTER);
        elementsMap.put(CONFIG.getLocalName(), CONFIG);
        elementsMap.put(STANDALONE.getLocalName(), STANDALONE);
        elementsMap.put(DOMAIN.getLocalName(), DOMAIN);
        elementsMap.put(PROPERTY.getLocalName(), PROPERTY);
        elementsMap.put(SUBSYSTEMS.getLocalName(), SUBSYSTEMS);
        elementsMap.put(SUBSYSTEM.getLocalName(), SUBSYSTEM);
        elementsMap.put(CONTENTS.getLocalName(), CONTENTS);
        elementsMap.put(VERSION_OVERRIDES.getLocalName(), VERSION_OVERRIDES);
        elementsMap.put(VERSION_OVERRIDE.getLocalName(), VERSION_OVERRIDE);
        elementsMap.put(COPY_ARTIFACTS.getLocalName(), COPY_ARTIFACTS);
        elements = elementsMap;
    }
}

