/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.pack.model;

import java.util.Comparator;
import java.util.Objects;
import org.wildfly.build.logger.ProvisioningLogger;

public class Artifact
implements Comparable<Artifact> {
    private final String groupId;
    private final String artifactId;
    private final String packaging;
    private final String classifier;
    private final String version;

    public Artifact(String groupId, String artifactId, String packaging, String classifier, String version) {
        if (groupId == null) {
            throw new IllegalArgumentException("null groupId");
        }
        this.groupId = groupId;
        if (artifactId == null) {
            throw new IllegalArgumentException("null artifactId");
        }
        this.artifactId = artifactId;
        this.packaging = packaging != null && !packaging.equals("jar") && !packaging.isEmpty() ? packaging : null;
        this.classifier = classifier != null && !classifier.isEmpty() ? classifier : null;
        this.version = version != null && !version.isEmpty() ? version : null;
    }

    public Artifact(Artifact artifact, String newVersion) {
        this(artifact.groupId, artifact.artifactId, artifact.packaging, artifact.classifier, newVersion);
    }

    public static Artifact parse(String description) {
        String[] parts = description.split(":");
        switch (parts.length) {
            case 2: {
                return new Artifact(parts[0], parts[1], null, null, null);
            }
            case 3: {
                return new Artifact(parts[0], parts[1], parts[2], null, null);
            }
            case 4: {
                return new Artifact(parts[0], parts[1], parts[2], parts[3], null);
            }
            case 5: {
                return new Artifact(parts[0], parts[1], parts[2], parts[3], parts[4]);
            }
        }
        throw ProvisioningLogger.ROOT_LOGGER.cannotParseArtifact(description);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getVersion() {
        return this.version;
    }

    public Artifact getUnversioned() {
        if (this.version == null) {
            return this;
        }
        return new Artifact(this, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Artifact artifact = (Artifact)o;
        if (this.groupId != null ? !this.groupId.equals(artifact.groupId) : artifact.groupId != null) {
            return false;
        }
        if (this.artifactId != null ? !this.artifactId.equals(artifact.artifactId) : artifact.artifactId != null) {
            return false;
        }
        if (this.classifier != null ? !this.classifier.equals(artifact.classifier) : artifact.classifier != null) {
            return false;
        }
        if (this.packaging != null ? !this.packaging.equals(artifact.packaging) : artifact.packaging != null) {
            return false;
        }
        return this.version != null ? this.version.equals(artifact.version) : artifact.version == null;
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        result = 31 * result + (this.packaging != null ? this.packaging.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public String toJBossModulesString() {
        StringBuilder sb = new StringBuilder(this.groupId).append(':').append(this.artifactId).append(':').append(this.version);
        if (this.classifier != null) {
            sb.append(':').append(this.classifier);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.groupId).append(':').append(this.artifactId);
        int pc = 0;
        if (this.packaging != null) {
            sb.append(':').append(this.packaging);
        } else {
            ++pc;
        }
        if (this.classifier != null) {
            if (pc > 0) {
                sb.append(":");
            }
            pc = 0;
            sb.append(':').append(this.classifier);
        } else {
            ++pc;
        }
        if (this.version != null) {
            for (int i = 0; i < pc; ++i) {
                sb.append(':');
            }
            sb.append(':').append(this.version);
        }
        return sb.toString();
    }

    @Override
    public int compareTo(Artifact o) {
        Comparator comp = Comparator.nullsLast(Comparator.naturalOrder());
        int result = Objects.compare(this.groupId, o.groupId, comp);
        if (result != 0) {
            return result;
        }
        result = Objects.compare(this.artifactId, o.artifactId, comp);
        if (result != 0) {
            return result;
        }
        result = Objects.compare(this.packaging, o.packaging, comp);
        if (result != 0) {
            return result;
        }
        result = Objects.compare(this.classifier, o.classifier, comp);
        if (result != 0) {
            return result;
        }
        return Objects.compare(this.version, o.version, comp);
    }
}

