import { ClientConfiguration } from "../config/ClientConfiguration";
import { BaseClient } from "./BaseClient";
import { AuthenticationResult } from "../response/AuthenticationResult";
import { OnBehalfOfRequest } from "../request/OnBehalfOfRequest";
/**
 * On-Behalf-Of client
 */
export declare class OnBehalfOfClient extends BaseClient {
    private scopeSet;
    constructor(configuration: ClientConfiguration);
    acquireToken(request: OnBehalfOfRequest): Promise<AuthenticationResult>;
    private getCachedAuthenticationResult;
    private readAccessTokenFromCache;
    private readIdTokenFromCache;
    private readAccountFromCache;
    private executeTokenRequest;
    private createTokenRequestBody;
}
