import { ClientConfiguration } from "../config/ClientConfiguration";
import { BaseClient } from "./BaseClient";
import { AuthenticationResult } from "../response/AuthenticationResult";
import { ClientCredentialRequest } from "../request/ClientCredentialRequest";
/**
 * OAuth2.0 client credential grant
 */
export declare class ClientCredentialClient extends BaseClient {
    private scopeSet;
    constructor(configuration: ClientConfiguration);
    acquireToken(request: ClientCredentialRequest): Promise<AuthenticationResult>;
    private getCachedAuthenticationResult;
    private readAccessTokenFromCache;
    private executeTokenRequest;
    private createTokenRequestBody;
}
