/*! @azure/msal-common v1.7.2 2020-11-11 */
'use strict';
/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */
/* global Reflect, Promise */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};

function __awaiter(thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * AuthErrorMessage class containing string constants used by error codes and messages.
 */
var AuthErrorMessage = {
    unexpectedError: {
        code: "unexpected_error",
        desc: "Unexpected error in authentication."
    }
};
/**
 * General error class thrown by the MSAL.js library.
 */
var AuthError = /** @class */ (function (_super) {
    __extends(AuthError, _super);
    function AuthError(errorCode, errorMessage, suberror) {
        var _this = this;
        var errorString = errorMessage ? errorCode + ": " + errorMessage : errorCode;
        _this = _super.call(this, errorString) || this;
        Object.setPrototypeOf(_this, AuthError.prototype);
        _this.errorCode = errorCode;
        _this.errorMessage = errorMessage;
        _this.suberror = suberror;
        _this.name = "AuthError";
        return _this;
    }
    /**
     * Creates an error that is thrown when something unexpected happens in the library.
     * @param errDesc
     */
    AuthError.createUnexpectedError = function (errDesc) {
        return new AuthError(AuthErrorMessage.unexpectedError.code, AuthErrorMessage.unexpectedError.desc + ": " + errDesc);
    };
    return AuthError;
}(Error));

var name = "@azure/msal-common";
var author = {
	name: "Microsoft",
	email: "nugetaad@microsoft.com",
	url: "https://www.microsoft.com"
};
var license = "MIT";
var repository = {
	type: "git",
	url: "https://github.com/AzureAD/microsoft-authentication-library-for-js.git"
};
var version = "1.7.2";
var description = "Microsoft Authentication Library for js";
var keywords = [
	"implicit",
	"authorization code",
	"PKCE",
	"js",
	"AAD",
	"msal",
	"oauth"
];
var main = "./dist/index.js";
var module = "./dist/index.es.js";
var types = "./dist/src/index.d.ts";
var browserslist = [
	"last 1 version",
	"> 1%",
	"maintained node versions",
	"not dead"
];
var engines = {
	node: ">=0.8.0"
};
var directories = {
	test: "test"
};
var files = [
	"dist"
];
var scripts = {
	clean: "shx rm -rf dist lib",
	"clean:coverage": "rimraf ../../.nyc_output/*",
	doc: "npm run doc:generate && npm run doc:deploy",
	"doc:generate": "typedoc --mode modules --excludePrivate --excludeProtected --excludeNotExported --out ./ref ./src/ --gitRevision dev",
	"doc:deploy": "gh-pages -d ref -a -e ref/msal-common",
	lint: "cd ../../ && npm run lint:common",
	"lint:fix": "npm run lint -- -- --fix",
	test: "mocha",
	"test:coverage": "nyc mocha",
	"test:coverage:only": "npm run clean:coverage && npm run test:coverage",
	"build:modules": "rollup -c",
	"build:modules:watch": "rollup -cw",
	build: "npm run clean && npm run build:modules",
	"build:all": "npm run build",
	prepack: "npm run build"
};
var devDependencies = {
	"@babel/core": "^7.7.2",
	"@babel/plugin-proposal-class-properties": "^7.7.0",
	"@babel/plugin-proposal-object-rest-spread": "^7.6.2",
	"@babel/polyfill": "^7.7.0",
	"@babel/preset-env": "^7.7.1",
	"@babel/preset-typescript": "^7.7.2",
	"@babel/register": "^7.7.0",
	"@istanbuljs/nyc-config-babel": "^2.1.1",
	"@rollup/plugin-json": "^4.0.0",
	"@types/chai": "^4.2.5",
	"@types/chai-as-promised": "^7.1.2",
	"@types/debug": "^4.1.5",
	"@types/mocha": "^5.2.7",
	"@types/sinon": "^7.5.0",
	"babel-plugin-istanbul": "^5.2.0",
	beachball: "^1.32.2",
	chai: "^4.2.0",
	"chai-as-promised": "^7.1.1",
	"gh-pages": "^3.1.0",
	husky: "^3.0.9",
	mocha: "^6.2.2",
	nyc: "^15.0.0",
	rimraf: "^3.0.2",
	rollup: "^1.24.0",
	"rollup-plugin-typescript2": "^0.24.3",
	"rollup-plugin-uglify": "^6.0.4",
	shx: "^0.3.2",
	sinon: "^7.5.0",
	tslib: "^1.10.0",
	tslint: "^5.20.0",
	typedoc: "^0.17.8",
	typescript: "^3.7.5"
};
var dependencies = {
	debug: "^4.1.1"
};
var pkg = {
	name: name,
	author: author,
	license: license,
	repository: repository,
	version: version,
	description: description,
	keywords: keywords,
	main: main,
	module: module,
	types: types,
	browserslist: browserslist,
	engines: engines,
	directories: directories,
	files: files,
	scripts: scripts,
	devDependencies: devDependencies,
	dependencies: dependencies
};

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * ClientAuthErrorMessage class containing string constants used by error codes and messages.
 */
var ClientAuthErrorMessage = {
    clientInfoDecodingError: {
        code: "client_info_decoding_error",
        desc: "The client info could not be parsed/decoded correctly. Please review the trace to determine the root cause."
    },
    clientInfoEmptyError: {
        code: "client_info_empty_error",
        desc: "The client info was empty. Please review the trace to determine the root cause."
    },
    tokenParsingError: {
        code: "token_parsing_error",
        desc: "Token cannot be parsed. Please review stack trace to determine root cause."
    },
    nullOrEmptyToken: {
        code: "null_or_empty_token",
        desc: "The token is null or empty. Please review the trace to determine the root cause."
    },
    endpointResolutionError: {
        code: "endpoints_resolution_error",
        desc: "Error: could not resolve endpoints. Please check network and try again."
    },
    hashNotDeserialized: {
        code: "hash_not_deserialized",
        desc: "The hash parameters could not be deserialized. Please review the trace to determine the root cause."
    },
    blankGuidGenerated: {
        code: "blank_guid_generated",
        desc: "The guid generated was blank. Please review the trace to determine the root cause."
    },
    invalidStateError: {
        code: "invalid_state",
        desc: "State was not the expected format. Please check the logs to determine whether the request was sent using ProtocolUtils.setRequestState()."
    },
    stateMismatchError: {
        code: "state_mismatch",
        desc: "State mismatch error. Please check your network. Continued requests may cause cache overflow."
    },
    nonceMismatchError: {
        code: "nonce_mismatch",
        desc: "Nonce mismatch error. This may be caused by a race condition in concurrent requests."
    },
    noTokensFoundError: {
        code: "no_tokens_found",
        desc: "No tokens were found for the given scopes, and no authorization code was passed to acquireToken. You must retrieve an authorization code before making a call to acquireToken()."
    },
    multipleMatchingTokens: {
        code: "multiple_matching_tokens",
        desc: "The cache contains multiple tokens satisfying the requirements. " +
            "Call AcquireToken again providing more requirements such as authority or account."
    },
    multipleMatchingAccounts: {
        code: "multiple_matching_accounts",
        desc: "The cache contains multiple accounts satisfying the given parameters. Please pass more info to obtain the correct account"
    },
    multipleMatchingAppMetadata: {
        code: "multiple_matching_appMetadata",
        desc: "The cache contains multiple appMetadata satisfying the given parameters. Please pass more info to obtain the correct appMetadata"
    },
    tokenRequestCannotBeMade: {
        code: "request_cannot_be_made",
        desc: "Token request cannot be made without authorization code or refresh token."
    },
    appendEmptyScopeError: {
        code: "cannot_append_empty_scope",
        desc: "Cannot append null or empty scope to ScopeSet. Please check the stack trace for more info."
    },
    removeEmptyScopeError: {
        code: "cannot_remove_empty_scope",
        desc: "Cannot remove null or empty scope from ScopeSet. Please check the stack trace for more info."
    },
    appendScopeSetError: {
        code: "cannot_append_scopeset",
        desc: "Cannot append ScopeSet due to error."
    },
    emptyInputScopeSetError: {
        code: "empty_input_scopeset",
        desc: "Empty input ScopeSet cannot be processed."
    },
    DeviceCodePollingCancelled: {
        code: "device_code_polling_cancelled",
        desc: "Caller has cancelled token endpoint polling during device code flow by setting DeviceCodeRequest.cancel = true."
    },
    DeviceCodeExpired: {
        code: "device_code_expired",
        desc: "Device code is expired."
    },
    NoAccountInSilentRequest: {
        code: "no_account_in_silent_request",
        desc: "Please pass an account object, silent flow is not supported without account information"
    },
    invalidCacheRecord: {
        code: "invalid_cache_record",
        desc: "Cache record object was null or undefined."
    },
    invalidCacheEnvironment: {
        code: "invalid_cache_environment",
        desc: "Invalid environment when attempting to create cache entry"
    },
    noAccountFound: {
        code: "no_account_found",
        desc: "No account found in cache for given key."
    },
    CachePluginError: {
        code: "no cache plugin set on CacheManager",
        desc: "ICachePlugin needs to be set before using readFromStorage or writeFromStorage"
    },
    noCryptoObj: {
        code: "no_crypto_object",
        desc: "No crypto object detected. This is required for the following operation: "
    },
    invalidCacheType: {
        code: "invalid_cache_type",
        desc: "Invalid cache type"
    },
    unexpectedAccountType: {
        code: "unexpected_account_type",
        desc: "Unexpected account type."
    },
    unexpectedCredentialType: {
        code: "unexpected_credential_type",
        desc: "Unexpected credential type."
    },
    invalidAssertion: {
        code: "invalid_assertion",
        desc: "Client assertion must meet requirements described in https://tools.ietf.org/html/rfc7515"
    },
    invalidClientCredential: {
        code: "invalid_client_credential",
        desc: "Client credential (secret, certificate, or assertion) must not be empty when creating a confidential client. An application should at most have one credential"
    },
    tokenRefreshRequired: {
        code: "token_refresh_required",
        desc: "Cannot return token from cache because it must be refreshed. This may be due to one of the following reasons: forceRefresh parameter is set to true, claims have been requested, there is no cached access token or it is expired."
    }
};
/**
 * Error thrown when there is an error in the client code running on the browser.
 */
var ClientAuthError = /** @class */ (function (_super) {
    __extends(ClientAuthError, _super);
    function ClientAuthError(errorCode, errorMessage) {
        var _this = _super.call(this, errorCode, errorMessage) || this;
        _this.name = "ClientAuthError";
        Object.setPrototypeOf(_this, ClientAuthError.prototype);
        return _this;
    }
    /**
     * Creates an error thrown when client info object doesn't decode correctly.
     * @param caughtError
     */
    ClientAuthError.createClientInfoDecodingError = function (caughtError) {
        return new ClientAuthError(ClientAuthErrorMessage.clientInfoDecodingError.code, ClientAuthErrorMessage.clientInfoDecodingError.desc + " Failed with error: " + caughtError);
    };
    /**
     * Creates an error thrown if the client info is empty.
     * @param rawClientInfo
     */
    ClientAuthError.createClientInfoEmptyError = function (rawClientInfo) {
        return new ClientAuthError(ClientAuthErrorMessage.clientInfoEmptyError.code, ClientAuthErrorMessage.clientInfoEmptyError.desc + " Given Object: " + rawClientInfo);
    };
    /**
     * Creates an error thrown when the id token extraction errors out.
     * @param err
     */
    ClientAuthError.createTokenParsingError = function (caughtExtractionError) {
        return new ClientAuthError(ClientAuthErrorMessage.tokenParsingError.code, ClientAuthErrorMessage.tokenParsingError.desc + " Failed with error: " + caughtExtractionError);
    };
    /**
     * Creates an error thrown when the id token string is null or empty.
     * @param invalidRawTokenString
     */
    ClientAuthError.createTokenNullOrEmptyError = function (invalidRawTokenString) {
        return new ClientAuthError(ClientAuthErrorMessage.nullOrEmptyToken.code, ClientAuthErrorMessage.nullOrEmptyToken.desc + " Raw Token Value: " + invalidRawTokenString);
    };
    /**
     * Creates an error thrown when the endpoint discovery doesn't complete correctly.
     */
    ClientAuthError.createEndpointDiscoveryIncompleteError = function (errDetail) {
        return new ClientAuthError(ClientAuthErrorMessage.endpointResolutionError.code, ClientAuthErrorMessage.endpointResolutionError.desc + " Detail: " + errDetail);
    };
    /**
     * Creates an error thrown when the hash cannot be deserialized.
     * @param hashParamObj
     */
    ClientAuthError.createHashNotDeserializedError = function (hashParamObj) {
        return new ClientAuthError(ClientAuthErrorMessage.hashNotDeserialized.code, ClientAuthErrorMessage.hashNotDeserialized.desc + " Given Object: " + hashParamObj);
    };
    /**
     * Creates an error thrown when the state cannot be parsed.
     * @param invalidState
     */
    ClientAuthError.createInvalidStateError = function (invalidState, errorString) {
        return new ClientAuthError(ClientAuthErrorMessage.invalidStateError.code, ClientAuthErrorMessage.invalidStateError.desc + " Invalid State: " + invalidState + ", Root Err: " + errorString);
    };
    /**
     * Creates an error thrown when two states do not match.
     */
    ClientAuthError.createStateMismatchError = function () {
        return new ClientAuthError(ClientAuthErrorMessage.stateMismatchError.code, ClientAuthErrorMessage.stateMismatchError.desc);
    };
    /**
     * Creates an error thrown when the nonce does not match.
     */
    ClientAuthError.createNonceMismatchError = function () {
        return new ClientAuthError(ClientAuthErrorMessage.nonceMismatchError.code, ClientAuthErrorMessage.nonceMismatchError.desc);
    };
    /**
     * Creates an error thrown when the authorization code required for a token request is null or empty.
     */
    ClientAuthError.createNoTokensFoundError = function () {
        return new ClientAuthError(ClientAuthErrorMessage.noTokensFoundError.code, ClientAuthErrorMessage.noTokensFoundError.desc);
    };
    /**
     * Throws error when multiple tokens are in cache.
     */
    ClientAuthError.createMultipleMatchingTokensInCacheError = function () {
        return new ClientAuthError(ClientAuthErrorMessage.multipleMatchingTokens.code, ClientAuthErrorMessage.multipleMatchingTokens.desc + ".");
    };
    /**
     * Throws error when multiple accounts are in cache for the given params
     */
    ClientAuthError.createMultipleMatchingAccountsInCacheError = function () {
        return new ClientAuthError(ClientAuthErrorMessage.multipleMatchingAccounts.code, ClientAuthErrorMessage.multipleMatchingAccounts.desc);
    };
    /**
     * Throws error when multiple appMetada are in cache for the given clientId.
     */
    ClientAuthError.createMultipleMatchingAppMetadataInCacheError = function () {
        return new ClientAuthError(ClientAuthErrorMessage.multipleMatchingAppMetadata.code, ClientAuthErrorMessage.multipleMatchingAppMetadata.desc);
    };
    /**
     * Throws error when no auth code or refresh token is given to ServerTokenRequestParameters.
     */
    ClientAuthError.createTokenRequestCannotBeMadeError = function () {
        return new ClientAuthError(ClientAuthErrorMessage.tokenRequestCannotBeMade.code, ClientAuthErrorMessage.tokenRequestCannotBeMade.desc);
    };
    /**
     * Throws error when attempting to append a null, undefined or empty scope to a set
     * @param givenScope
     */
    ClientAuthError.createAppendEmptyScopeToSetError = function (givenScope) {
        return new ClientAuthError(ClientAuthErrorMessage.appendEmptyScopeError.code, ClientAuthErrorMessage.appendEmptyScopeError.desc + " Given Scope: " + givenScope);
    };
    /**
     * Throws error when attempting to append a null, undefined or empty scope to a set
     * @param givenScope
     */
    ClientAuthError.createRemoveEmptyScopeFromSetError = function (givenScope) {
        return new ClientAuthError(ClientAuthErrorMessage.removeEmptyScopeError.code, ClientAuthErrorMessage.removeEmptyScopeError.desc + " Given Scope: " + givenScope);
    };
    /**
     * Throws error when attempting to append null or empty ScopeSet.
     * @param appendError
     */
    ClientAuthError.createAppendScopeSetError = function (appendError) {
        return new ClientAuthError(ClientAuthErrorMessage.appendScopeSetError.code, ClientAuthErrorMessage.appendScopeSetError.desc + " Detail Error: " + appendError);
    };
    /**
     * Throws error if ScopeSet is null or undefined.
     * @param givenScopeSet
     */
    ClientAuthError.createEmptyInputScopeSetError = function (givenScopeSet) {
        return new ClientAuthError(ClientAuthErrorMessage.emptyInputScopeSetError.code, ClientAuthErrorMessage.emptyInputScopeSetError.desc + " Given ScopeSet: " + givenScopeSet);
    };
    /**
     * Throws error if user sets CancellationToken.cancel = true during polling of token endpoint during device code flow
     */
    ClientAuthError.createDeviceCodeCancelledError = function () {
        return new ClientAuthError(ClientAuthErrorMessage.DeviceCodePollingCancelled.code, "" + ClientAuthErrorMessage.DeviceCodePollingCancelled.desc);
    };
    /**
     * Throws error if device code is expired
     */
    ClientAuthError.createDeviceCodeExpiredError = function () {
        return new ClientAuthError(ClientAuthErrorMessage.DeviceCodeExpired.code, "" + ClientAuthErrorMessage.DeviceCodeExpired.desc);
    };
    /**
     * Throws error when silent requests are made without an account object
     */
    ClientAuthError.createNoAccountInSilentRequestError = function () {
        return new ClientAuthError(ClientAuthErrorMessage.NoAccountInSilentRequest.code, "" + ClientAuthErrorMessage.NoAccountInSilentRequest.desc);
    };
    /**
     * Throws error when cache record is null or undefined.
     */
    ClientAuthError.createNullOrUndefinedCacheRecord = function () {
        return new ClientAuthError(ClientAuthErrorMessage.invalidCacheRecord.code, ClientAuthErrorMessage.invalidCacheRecord.desc);
    };
    /**
     * Throws error when provided environment is not part of the CloudDiscoveryMetadata object
     */
    ClientAuthError.createInvalidCacheEnvironmentError = function () {
        return new ClientAuthError(ClientAuthErrorMessage.invalidCacheEnvironment.code, ClientAuthErrorMessage.invalidCacheEnvironment.desc);
    };
    /**
     * Throws error when account is not found in cache.
     */
    ClientAuthError.createNoAccountFoundError = function () {
        return new ClientAuthError(ClientAuthErrorMessage.noAccountFound.code, ClientAuthErrorMessage.noAccountFound.desc);
    };
    /**
     * Throws error if ICachePlugin not set on CacheManager.
     */
    ClientAuthError.createCachePluginError = function () {
        return new ClientAuthError(ClientAuthErrorMessage.CachePluginError.code, "" + ClientAuthErrorMessage.CachePluginError.desc);
    };
    /**
     * Throws error if crypto object not found.
     * @param operationName
     */
    ClientAuthError.createNoCryptoObjectError = function (operationName) {
        return new ClientAuthError(ClientAuthErrorMessage.noCryptoObj.code, "" + ClientAuthErrorMessage.noCryptoObj.desc + operationName);
    };
    /**
     * Throws error if cache type is invalid.
     */
    ClientAuthError.createInvalidCacheTypeError = function () {
        return new ClientAuthError(ClientAuthErrorMessage.invalidCacheType.code, "" + ClientAuthErrorMessage.invalidCacheType.desc);
    };
    /**
     * Throws error if unexpected account type.
     */
    ClientAuthError.createUnexpectedAccountTypeError = function () {
        return new ClientAuthError(ClientAuthErrorMessage.unexpectedAccountType.code, "" + ClientAuthErrorMessage.unexpectedAccountType.desc);
    };
    /**
     * Throws error if unexpected credential type.
     */
    ClientAuthError.createUnexpectedCredentialTypeError = function () {
        return new ClientAuthError(ClientAuthErrorMessage.unexpectedCredentialType.code, "" + ClientAuthErrorMessage.unexpectedCredentialType.desc);
    };
    /**
     * Throws error if client assertion is not valid.
     */
    ClientAuthError.createInvalidAssertionError = function () {
        return new ClientAuthError(ClientAuthErrorMessage.invalidAssertion.code, "" + ClientAuthErrorMessage.invalidAssertion.desc);
    };
    /**
     * Throws error if client assertion is not valid.
     */
    ClientAuthError.createInvalidCredentialError = function () {
        return new ClientAuthError(ClientAuthErrorMessage.invalidClientCredential.code, "" + ClientAuthErrorMessage.invalidClientCredential.desc);
    };
    /**
     * Throws error if token cannot be retrieved from cache due to refresh being required.
     */
    ClientAuthError.createRefreshRequiredError = function () {
        return new ClientAuthError(ClientAuthErrorMessage.tokenRefreshRequired.code, ClientAuthErrorMessage.tokenRefreshRequired.desc);
    };
    return ClientAuthError;
}(AuthError));

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * @hidden
 */
var StringUtils = /** @class */ (function () {
    function StringUtils() {
    }
    /**
     * decode a JWT
     *
     * @param authToken
     */
    StringUtils.decodeAuthToken = function (authToken) {
        if (StringUtils.isEmpty(authToken)) {
            throw ClientAuthError.createTokenNullOrEmptyError(authToken);
        }
        var tokenPartsRegex = /^([^\.\s]*)\.([^\.\s]+)\.([^\.\s]*)$/;
        var matches = tokenPartsRegex.exec(authToken);
        if (!matches || matches.length < 4) {
            throw ClientAuthError.createTokenParsingError("Given token is malformed: " + JSON.stringify(authToken));
        }
        var crackedToken = {
            header: matches[1],
            JWSPayload: matches[2],
            JWSSig: matches[3]
        };
        return crackedToken;
    };
    /**
     * Check if a string is empty.
     *
     * @param str
     */
    StringUtils.isEmpty = function (str) {
        return (typeof str === "undefined" || !str || 0 === str.length);
    };
    StringUtils.startsWith = function (str, search) {
        return str.indexOf(search) === 0;
    };
    StringUtils.endsWith = function (str, search) {
        return (str.length >= search.length) && (str.lastIndexOf(search) === (str.length - search.length));
    };
    /**
     * Parses string into an object.
     *
     * @param query
     */
    StringUtils.queryStringToObject = function (query) {
        var match; // Regex for replacing addition symbol with a space
        var pl = /\+/g;
        var search = /([^&=]+)=([^&]*)/g;
        var decode = function (s) { return decodeURIComponent(decodeURIComponent(s.replace(pl, " "))); };
        var obj = {};
        match = search.exec(query);
        while (match) {
            obj[decode(match[1])] = decode(match[2]);
            match = search.exec(query);
        }
        return obj;
    };
    /**
     * Trims entries in an array.
     *
     * @param arr
     */
    StringUtils.trimArrayEntries = function (arr) {
        return arr.map(function (entry) { return entry.trim(); });
    };
    /**
     * Removes empty strings from array
     * @param arr
     */
    StringUtils.removeEmptyStringsFromArray = function (arr) {
        return arr.filter(function (entry) {
            return !StringUtils.isEmpty(entry);
        });
    };
    /**
     * Attempts to parse a string into JSON
     * @param str
     */
    StringUtils.jsonParseHelper = function (str) {
        try {
            return JSON.parse(str);
        }
        catch (e) {
            return null;
        }
    };
    return StringUtils;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * Log message level.
 */
var LogLevel;
(function (LogLevel) {
    LogLevel[LogLevel["Error"] = 0] = "Error";
    LogLevel[LogLevel["Warning"] = 1] = "Warning";
    LogLevel[LogLevel["Info"] = 2] = "Info";
    LogLevel[LogLevel["Verbose"] = 3] = "Verbose";
})(LogLevel || (LogLevel = {}));
/**
 * Class which facilitates logging of messages to a specific place.
 */
var Logger = /** @class */ (function () {
    function Logger(loggerOptions) {
        // Current log level, defaults to info.
        this.level = LogLevel.Info;
        if (loggerOptions) {
            this.localCallback = loggerOptions.loggerCallback;
            this.piiLoggingEnabled = loggerOptions.piiLoggingEnabled;
            this.level = loggerOptions.logLevel;
        }
    }
    /**
     * Log message with required options.
     */
    Logger.prototype.logMessage = function (logMessage, options) {
        if ((options.logLevel > this.level) || (!this.piiLoggingEnabled && options.containsPii)) {
            return;
        }
        var timestamp = new Date().toUTCString();
        var logHeader = StringUtils.isEmpty(this.correlationId) ? "[" + timestamp + "] : " : "[" + timestamp + "] : [" + this.correlationId + "]";
        var log = logHeader + " : " + pkg.version + " : " + LogLevel[options.logLevel] + " - " + logMessage;
        // debug(`msal:${LogLevel[options.logLevel]}${options.containsPii ? "-Pii": ""}${options.context ? `:${options.context}` : ""}`)(logMessage);
        this.executeCallback(options.logLevel, log, options.containsPii);
    };
    /**
     * Execute callback with message.
     */
    Logger.prototype.executeCallback = function (level, message, containsPii) {
        if (this.localCallback) {
            this.localCallback(level, message, containsPii);
        }
    };
    /**
     * Logs error messages.
     */
    Logger.prototype.error = function (message, correlationId) {
        this.logMessage(message, {
            logLevel: LogLevel.Error,
            containsPii: false,
            correlationId: correlationId || ""
        });
    };
    /**
     * Logs error messages with PII.
     */
    Logger.prototype.errorPii = function (message, correlationId) {
        this.logMessage(message, {
            logLevel: LogLevel.Error,
            containsPii: true,
            correlationId: correlationId || ""
        });
    };
    /**
     * Logs warning messages.
     */
    Logger.prototype.warning = function (message, correlationId) {
        this.logMessage(message, {
            logLevel: LogLevel.Warning,
            containsPii: false,
            correlationId: correlationId || ""
        });
    };
    /**
     * Logs warning messages with PII.
     */
    Logger.prototype.warningPii = function (message, correlationId) {
        this.logMessage(message, {
            logLevel: LogLevel.Warning,
            containsPii: true,
            correlationId: correlationId || ""
        });
    };
    /**
     * Logs info messages.
     */
    Logger.prototype.info = function (message, correlationId) {
        this.logMessage(message, {
            logLevel: LogLevel.Info,
            containsPii: false,
            correlationId: correlationId || ""
        });
    };
    /**
     * Logs info messages with PII.
     */
    Logger.prototype.infoPii = function (message, correlationId) {
        this.logMessage(message, {
            logLevel: LogLevel.Info,
            containsPii: true,
            correlationId: correlationId || ""
        });
    };
    /**
     * Logs verbose messages.
     */
    Logger.prototype.verbose = function (message, correlationId) {
        this.logMessage(message, {
            logLevel: LogLevel.Verbose,
            containsPii: false,
            correlationId: correlationId || ""
        });
    };
    /**
     * Logs verbose messages with PII.
     */
    Logger.prototype.verbosePii = function (message, correlationId) {
        this.logMessage(message, {
            logLevel: LogLevel.Verbose,
            containsPii: true,
            correlationId: correlationId || ""
        });
    };
    /**
     * Returns whether PII Logging is enabled or not.
     */
    Logger.prototype.isPiiLoggingEnabled = function () {
        return this.piiLoggingEnabled || false;
    };
    return Logger;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
var Constants = {
    LIBRARY_NAME: "MSAL.JS",
    SKU: "msal.js.common",
    // Prefix for all library cache entries
    CACHE_PREFIX: "msal",
    // default authority
    DEFAULT_AUTHORITY: "https://login.microsoftonline.com/common/",
    DEFAULT_AUTHORITY_HOST: "login.microsoftonline.com",
    // ADFS String
    ADFS: "adfs",
    // Default AAD Instance Discovery Endpoint
    AAD_INSTANCE_DISCOVERY_ENDPT: "https://login.microsoftonline.com/common/discovery/instance?api-version=1.1&authorization_endpoint=",
    // Resource delimiter - used for certain cache entries
    RESOURCE_DELIM: "|",
    // Placeholder for non-existent account ids/objects
    NO_ACCOUNT: "NO_ACCOUNT",
    // Claims
    CLAIMS: "claims",
    // Consumer UTID
    CONSUMER_UTID: "9188040d-6c67-4c5b-b112-36a304b66dad",
    // Default scopes
    OPENID_SCOPE: "openid",
    PROFILE_SCOPE: "profile",
    OFFLINE_ACCESS_SCOPE: "offline_access",
    // Default response type for authorization code flow
    CODE_RESPONSE_TYPE: "code",
    CODE_GRANT_TYPE: "authorization_code",
    RT_GRANT_TYPE: "refresh_token",
    FRAGMENT_RESPONSE_MODE: "fragment",
    S256_CODE_CHALLENGE_METHOD: "S256",
    URL_FORM_CONTENT_TYPE: "application/x-www-form-urlencoded;charset=utf-8",
    AUTHORIZATION_PENDING: "authorization_pending",
    NOT_DEFINED: "not_defined",
    EMPTY_STRING: "",
    FORWARD_SLASH: "/"
};
/**
 * Request header names
 */
var HeaderNames;
(function (HeaderNames) {
    HeaderNames["CONTENT_TYPE"] = "Content-Type";
    HeaderNames["X_CLIENT_CURR_TELEM"] = "x-client-current-telemetry";
    HeaderNames["X_CLIENT_LAST_TELEM"] = "x-client-last-telemetry";
    HeaderNames["RETRY_AFTER"] = "Retry-After";
    HeaderNames["X_MS_LIB_CAPABILITY"] = "x-ms-lib-capability";
    HeaderNames["X_MS_LIB_CAPABILITY_VALUE"] = "retry-after, h429";
})(HeaderNames || (HeaderNames = {}));
/**
 * Persistent cache keys MSAL which stay while user is logged in.
 */
var PersistentCacheKeys;
(function (PersistentCacheKeys) {
    PersistentCacheKeys["ID_TOKEN"] = "idtoken";
    PersistentCacheKeys["CLIENT_INFO"] = "client.info";
    PersistentCacheKeys["ADAL_ID_TOKEN"] = "adal.idtoken";
    PersistentCacheKeys["ERROR"] = "error";
    PersistentCacheKeys["ERROR_DESC"] = "error.description";
})(PersistentCacheKeys || (PersistentCacheKeys = {}));
/**
 * String constants related to AAD Authority
 */
var AADAuthorityConstants;
(function (AADAuthorityConstants) {
    AADAuthorityConstants["COMMON"] = "common";
    AADAuthorityConstants["ORGANIZATIONS"] = "organizations";
    AADAuthorityConstants["CONSUMERS"] = "consumers";
})(AADAuthorityConstants || (AADAuthorityConstants = {}));
/**
 * Keys in the hashParams sent by AAD Server
 */
var AADServerParamKeys;
(function (AADServerParamKeys) {
    AADServerParamKeys["CLIENT_ID"] = "client_id";
    AADServerParamKeys["REDIRECT_URI"] = "redirect_uri";
    AADServerParamKeys["RESPONSE_TYPE"] = "response_type";
    AADServerParamKeys["RESPONSE_MODE"] = "response_mode";
    AADServerParamKeys["GRANT_TYPE"] = "grant_type";
    AADServerParamKeys["CLAIMS"] = "claims";
    AADServerParamKeys["SCOPE"] = "scope";
    AADServerParamKeys["ERROR"] = "error";
    AADServerParamKeys["ERROR_DESCRIPTION"] = "error_description";
    AADServerParamKeys["ACCESS_TOKEN"] = "access_token";
    AADServerParamKeys["ID_TOKEN"] = "id_token";
    AADServerParamKeys["REFRESH_TOKEN"] = "refresh_token";
    AADServerParamKeys["EXPIRES_IN"] = "expires_in";
    AADServerParamKeys["STATE"] = "state";
    AADServerParamKeys["NONCE"] = "nonce";
    AADServerParamKeys["PROMPT"] = "prompt";
    AADServerParamKeys["SESSION_STATE"] = "session_state";
    AADServerParamKeys["CLIENT_INFO"] = "client_info";
    AADServerParamKeys["CODE"] = "code";
    AADServerParamKeys["CODE_CHALLENGE"] = "code_challenge";
    AADServerParamKeys["CODE_CHALLENGE_METHOD"] = "code_challenge_method";
    AADServerParamKeys["CODE_VERIFIER"] = "code_verifier";
    AADServerParamKeys["CLIENT_REQUEST_ID"] = "client-request-id";
    AADServerParamKeys["X_CLIENT_SKU"] = "x-client-SKU";
    AADServerParamKeys["X_CLIENT_VER"] = "x-client-VER";
    AADServerParamKeys["X_CLIENT_OS"] = "x-client-OS";
    AADServerParamKeys["X_CLIENT_CPU"] = "x-client-CPU";
    AADServerParamKeys["POST_LOGOUT_URI"] = "post_logout_redirect_uri";
    AADServerParamKeys["DEVICE_CODE"] = "device_code";
    AADServerParamKeys["CLIENT_SECRET"] = "client_secret";
    AADServerParamKeys["CLIENT_ASSERTION"] = "client_assertion";
    AADServerParamKeys["CLIENT_ASSERTION_TYPE"] = "client_assertion_type";
    AADServerParamKeys["TOKEN_TYPE"] = "token_type";
    AADServerParamKeys["REQ_CNF"] = "req_cnf";
    AADServerParamKeys["OBO_ASSERTION"] = "assertion";
    AADServerParamKeys["REQUESTED_TOKEN_USE"] = "requested_token_use";
    AADServerParamKeys["ON_BEHALF_OF"] = "on_behalf_of";
    AADServerParamKeys["FOCI"] = "foci";
})(AADServerParamKeys || (AADServerParamKeys = {}));
/**
 * Claims request keys
 */
var ClaimsRequestKeys;
(function (ClaimsRequestKeys) {
    ClaimsRequestKeys["ACCESS_TOKEN"] = "access_token";
    ClaimsRequestKeys["XMS_CC"] = "xms_cc";
})(ClaimsRequestKeys || (ClaimsRequestKeys = {}));
/**
 * we considered making this "enum" in the request instead of string, however it looks like the allowed list of
 * prompt values kept changing over past couple of years. There are some undocumented prompt values for some
 * internal partners too, hence the choice of generic "string" type instead of the "enum"
 */
var PromptValue = {
    LOGIN: "login",
    SELECT_ACCOUNT: "select_account",
    CONSENT: "consent",
    NONE: "none",
};
/**
 * SSO Types - generated to populate hints
 */
var SSOTypes;
(function (SSOTypes) {
    SSOTypes["ACCOUNT"] = "account";
    SSOTypes["SID"] = "sid";
    SSOTypes["LOGIN_HINT"] = "login_hint";
    SSOTypes["ID_TOKEN"] = "id_token";
    SSOTypes["DOMAIN_HINT"] = "domain_hint";
    SSOTypes["ORGANIZATIONS"] = "organizations";
    SSOTypes["CONSUMERS"] = "consumers";
    SSOTypes["ACCOUNT_ID"] = "accountIdentifier";
    SSOTypes["HOMEACCOUNT_ID"] = "homeAccountIdentifier";
})(SSOTypes || (SSOTypes = {}));
/**
 * Disallowed extra query parameters.
 */
var BlacklistedEQParams = [
    SSOTypes.SID,
    SSOTypes.LOGIN_HINT
];
/**
 * allowed values for codeVerifier
 */
var CodeChallengeMethodValues = {
    PLAIN: "plain",
    S256: "S256"
};
/**
 * allowed values for response_mode
 */
var ResponseMode;
(function (ResponseMode) {
    ResponseMode["QUERY"] = "query";
    ResponseMode["FRAGMENT"] = "fragment";
    ResponseMode["FORM_POST"] = "form_post";
})(ResponseMode || (ResponseMode = {}));
/**
 * allowed grant_type
 */
var GrantType;
(function (GrantType) {
    GrantType["IMPLICIT_GRANT"] = "implicit";
    GrantType["AUTHORIZATION_CODE_GRANT"] = "authorization_code";
    GrantType["CLIENT_CREDENTIALS_GRANT"] = "client_credentials";
    GrantType["RESOURCE_OWNER_PASSWORD_GRANT"] = "password";
    GrantType["REFRESH_TOKEN_GRANT"] = "refresh_token";
    GrantType["DEVICE_CODE_GRANT"] = "device_code";
    GrantType["JWT_BEARER"] = "urn:ietf:params:oauth:grant-type:jwt-bearer";
})(GrantType || (GrantType = {}));
/**
 * Account types in Cache
 */
var CacheAccountType;
(function (CacheAccountType) {
    CacheAccountType["MSSTS_ACCOUNT_TYPE"] = "MSSTS";
    CacheAccountType["ADFS_ACCOUNT_TYPE"] = "ADFS";
    CacheAccountType["MSAV1_ACCOUNT_TYPE"] = "MSA";
    CacheAccountType["GENERIC_ACCOUNT_TYPE"] = "Generic"; // NTLM, Kerberos, FBA, Basic etc
})(CacheAccountType || (CacheAccountType = {}));
/**
 * Separators used in cache
 */
var Separators;
(function (Separators) {
    Separators["CACHE_KEY_SEPARATOR"] = "-";
    Separators["CLIENT_INFO_SEPARATOR"] = ".";
})(Separators || (Separators = {}));
/**
 * Credential Type stored in the cache
 */
var CredentialType;
(function (CredentialType) {
    CredentialType["ID_TOKEN"] = "IdToken";
    CredentialType["ACCESS_TOKEN"] = "AccessToken";
    CredentialType["REFRESH_TOKEN"] = "RefreshToken";
})(CredentialType || (CredentialType = {}));
/**
 * Credential Type stored in the cache
 */
var CacheSchemaType;
(function (CacheSchemaType) {
    CacheSchemaType["ACCOUNT"] = "Account";
    CacheSchemaType["CREDENTIAL"] = "Credential";
    CacheSchemaType["ID_TOKEN"] = "IdToken";
    CacheSchemaType["ACCESS_TOKEN"] = "AccessToken";
    CacheSchemaType["REFRESH_TOKEN"] = "RefreshToken";
    CacheSchemaType["APP_METADATA"] = "AppMetadata";
    CacheSchemaType["TEMPORARY"] = "TempCache";
    CacheSchemaType["TELEMETRY"] = "Telemetry";
    CacheSchemaType["UNDEFINED"] = "Undefined";
    CacheSchemaType["THROTTLING"] = "Throttling";
})(CacheSchemaType || (CacheSchemaType = {}));
/**
 * Combine all cache types
 */
var CacheType;
(function (CacheType) {
    CacheType[CacheType["ADFS"] = 1001] = "ADFS";
    CacheType[CacheType["MSA"] = 1002] = "MSA";
    CacheType[CacheType["MSSTS"] = 1003] = "MSSTS";
    CacheType[CacheType["GENERIC"] = 1004] = "GENERIC";
    CacheType[CacheType["ACCESS_TOKEN"] = 2001] = "ACCESS_TOKEN";
    CacheType[CacheType["REFRESH_TOKEN"] = 2002] = "REFRESH_TOKEN";
    CacheType[CacheType["ID_TOKEN"] = 2003] = "ID_TOKEN";
    CacheType[CacheType["APP_METADATA"] = 3001] = "APP_METADATA";
    CacheType[CacheType["UNDEFINED"] = 9999] = "UNDEFINED";
})(CacheType || (CacheType = {}));
/**
 * More Cache related constants
 */
var APP_METADATA = "appmetadata";
var ClientInfo = "client_info";
var THE_FAMILY_ID = "1";
var SERVER_TELEM_CONSTANTS = {
    SCHEMA_VERSION: 2,
    MAX_HEADER_BYTES: 4000,
    CACHE_KEY: "server-telemetry",
    CATEGORY_SEPARATOR: "|",
    VALUE_SEPARATOR: ",",
    OVERFLOW_TRUE: "1",
    OVERFLOW_FALSE: "0",
    UNKNOWN_ERROR: "unknown_error"
};
/**
 * Type of the authentication request
 */
var AuthenticationScheme;
(function (AuthenticationScheme) {
    AuthenticationScheme["POP"] = "pop";
    AuthenticationScheme["BEARER"] = "Bearer";
})(AuthenticationScheme || (AuthenticationScheme = {}));
/**
 * Constants related to throttling
 */
var ThrottlingConstants = {
    // Default time to throttle RequestThumbprint in seconds
    DEFAULT_THROTTLE_TIME_SECONDS: 60,
    // Default maximum time to throttle in seconds, overrides what the server sends back
    DEFAULT_MAX_THROTTLE_TIME_SECONDS: 3600,
    // Prefix for storing throttling entries
    THROTTLING_PREFIX: "throttling"
};
var Errors = {
    INVALID_GRANT_ERROR: "invalid_grant",
    CLIENT_MISMATCH_ERROR: "client_mismatch",
};
/**
 * Password grant parameters
 */
var PasswordGrantConstants;
(function (PasswordGrantConstants) {
    PasswordGrantConstants["username"] = "username";
    PasswordGrantConstants["password"] = "password";
})(PasswordGrantConstants || (PasswordGrantConstants = {}));

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * Base type for credentials to be stored in the cache: eg: ACCESS_TOKEN, ID_TOKEN etc
 *
 * Key:Value Schema:
 *
 * Key: <home_account_id*>-<environment>-<credential_type>-<client_id>-<realm*>-<target*>
 *
 * Value Schema:
 * {
 *      homeAccountId: home account identifier for the auth scheme,
 *      environment: entity that issued the token, represented as a full host
 *      credentialType: Type of credential as a string, can be one of the following: RefreshToken, AccessToken, IdToken, Password, Cookie, Certificate, Other
 *      clientId: client ID of the application
 *      secret: Actual credential as a string
 *      familyId: Family ID identifier, usually only used for refresh tokens
 *      realm: Full tenant or organizational identifier that the account belongs to
 *      target: Permissions that are included in the token, or for refresh tokens, the resource identifier.
 *      oboAssertion: access token passed in as part of OBO request
 * }
 */
var CredentialEntity = /** @class */ (function () {
    function CredentialEntity() {
    }
    /**
     * Generate Account Id key component as per the schema: <home_account_id>-<environment>
     */
    CredentialEntity.prototype.generateAccountId = function () {
        return CredentialEntity.generateAccountIdForCacheKey(this.homeAccountId, this.environment);
    };
    /**
     * Generate Credential Id key component as per the schema: <credential_type>-<client_id>-<realm>
     */
    CredentialEntity.prototype.generateCredentialId = function () {
        return CredentialEntity.generateCredentialIdForCacheKey(this.credentialType, this.clientId, this.realm, this.familyId);
    };
    /**
     * Generate target key component as per schema: <target>
     */
    CredentialEntity.prototype.generateTarget = function () {
        return CredentialEntity.generateTargetForCacheKey(this.target);
    };
    /**
     * generates credential key
     */
    CredentialEntity.prototype.generateCredentialKey = function () {
        return CredentialEntity.generateCredentialCacheKey(this.homeAccountId, this.environment, this.credentialType, this.clientId, this.realm, this.target, this.familyId);
    };
    /**
     * returns the type of the cache (in this case credential)
     */
    CredentialEntity.prototype.generateType = function () {
        switch (this.credentialType) {
            case CredentialType.ID_TOKEN:
                return CacheType.ID_TOKEN;
            case CredentialType.ACCESS_TOKEN:
                return CacheType.ACCESS_TOKEN;
            case CredentialType.REFRESH_TOKEN:
                return CacheType.REFRESH_TOKEN;
            default: {
                throw ClientAuthError.createUnexpectedCredentialTypeError();
            }
        }
    };
    /**
     * helper function to return `CredentialType`
     * @param key
     */
    CredentialEntity.getCredentialType = function (key) {
        if (key.indexOf(CredentialType.ACCESS_TOKEN.toLowerCase()) !== -1) {
            return CredentialType.ACCESS_TOKEN;
        }
        else if (key.indexOf(CredentialType.ID_TOKEN.toLowerCase()) !== -1) {
            return CredentialType.ID_TOKEN;
        }
        else if (key.indexOf(CredentialType.REFRESH_TOKEN.toLowerCase()) !== -1) {
            return CredentialType.REFRESH_TOKEN;
        }
        return Constants.NOT_DEFINED;
    };
    /**
     * generates credential key
     */
    CredentialEntity.generateCredentialCacheKey = function (homeAccountId, environment, credentialType, clientId, realm, target, familyId) {
        var credentialKey = [
            this.generateAccountIdForCacheKey(homeAccountId, environment),
            this.generateCredentialIdForCacheKey(credentialType, clientId, realm, familyId),
            this.generateTargetForCacheKey(target),
        ];
        return credentialKey.join(Separators.CACHE_KEY_SEPARATOR).toLowerCase();
    };
    /**
     * generates Account Id for keys
     * @param homeAccountId
     * @param environment
     */
    CredentialEntity.generateAccountIdForCacheKey = function (homeAccountId, environment) {
        var accountId = [homeAccountId, environment];
        return accountId.join(Separators.CACHE_KEY_SEPARATOR).toLowerCase();
    };
    /**
     * Generates Credential Id for keys
     * @param credentialType
     * @param realm
     * @param clientId
     * @param familyId
     */
    CredentialEntity.generateCredentialIdForCacheKey = function (credentialType, clientId, realm, familyId) {
        var clientOrFamilyId = credentialType === CredentialType.REFRESH_TOKEN
            ? familyId || clientId
            : clientId;
        var credentialId = [
            credentialType,
            clientOrFamilyId,
            realm || "",
        ];
        return credentialId.join(Separators.CACHE_KEY_SEPARATOR).toLowerCase();
    };
    /**
     * Generate target key component as per schema: <target>
     */
    CredentialEntity.generateTargetForCacheKey = function (scopes) {
        return (scopes || "").toLowerCase();
    };
    return CredentialEntity;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * ClientConfigurationErrorMessage class containing string constants used by error codes and messages.
 */
var ClientConfigurationErrorMessage = {
    redirectUriNotSet: {
        code: "redirect_uri_empty",
        desc: "A redirect URI is required for all calls, and none has been set."
    },
    postLogoutUriNotSet: {
        code: "post_logout_uri_empty",
        desc: "A post logout redirect has not been set."
    },
    claimsRequestParsingError: {
        code: "claims_request_parsing_error",
        desc: "Could not parse the given claims request object."
    },
    authorityUriInsecure: {
        code: "authority_uri_insecure",
        desc: "Authority URIs must use https.  Please see here for valid authority configuration options: https://docs.microsoft.com/en-us/azure/active-directory/develop/msal-js-initializing-client-applications#configuration-options"
    },
    urlParseError: {
        code: "url_parse_error",
        desc: "URL could not be parsed into appropriate segments."
    },
    urlEmptyError: {
        code: "empty_url_error",
        desc: "URL was empty or null."
    },
    emptyScopesError: {
        code: "empty_input_scopes_error",
        desc: "Scopes cannot be passed as null, undefined or empty array because they are required to obtain an access token."
    },
    nonArrayScopesError: {
        code: "nonarray_input_scopes_error",
        desc: "Scopes cannot be passed as non-array."
    },
    clientIdSingleScopeError: {
        code: "clientid_input_scopes_error",
        desc: "Client ID can only be provided as a single scope."
    },
    invalidPrompt: {
        code: "invalid_prompt_value",
        desc: "Supported prompt values are 'login', 'select_account', 'consent' and 'none'.  Please see here for valid configuration options: https://docs.microsoft.com/en-us/azure/active-directory/develop/msal-js-initializing-client-applications#configuration-options",
    },
    invalidClaimsRequest: {
        code: "invalid_claims",
        desc: "Given claims parameter must be a stringified JSON object."
    },
    tokenRequestEmptyError: {
        code: "token_request_empty",
        desc: "Token request was empty and not found in cache."
    },
    logoutRequestEmptyError: {
        code: "logout_request_empty",
        desc: "The logout request was null or undefined."
    },
    invalidCodeChallengeMethod: {
        code: "invalid_code_challenge_method",
        desc: "code_challenge_method passed is invalid. Valid values are \"plain\" and \"S256\"."
    },
    invalidCodeChallengeParams: {
        code: "pkce_params_missing",
        desc: "Both params: code_challenge and code_challenge_method are to be passed if to be sent in the request"
    },
    knownAuthoritiesAndCloudDiscoveryMetadata: {
        code: "invalid_known_authorities",
        desc: "knownAuthorities and cloudDiscoveryMetadata cannot both be provided. Please provide cloudDiscoveryMetadata object for AAD, knownAuthorities otherwise."
    },
    invalidCloudDiscoveryMetadata: {
        code: "invalid_cloud_discovery_metadata",
        desc: "Invalid cloudDiscoveryMetadata provided. Must be a JSON object containing tenant_discovery_endpoint and metadata fields"
    },
    untrustedAuthority: {
        code: "untrusted_authority",
        desc: "The provided authority is not a trusted authority. Please include this authority in the knownAuthorities config parameter."
    }
};
/**
 * Error thrown when there is an error in configuration of the MSAL.js library.
 */
var ClientConfigurationError = /** @class */ (function (_super) {
    __extends(ClientConfigurationError, _super);
    function ClientConfigurationError(errorCode, errorMessage) {
        var _this = _super.call(this, errorCode, errorMessage) || this;
        _this.name = "ClientConfigurationError";
        Object.setPrototypeOf(_this, ClientConfigurationError.prototype);
        return _this;
    }
    /**
     * Creates an error thrown when the redirect uri is empty (not set by caller)
     */
    ClientConfigurationError.createRedirectUriEmptyError = function () {
        return new ClientConfigurationError(ClientConfigurationErrorMessage.redirectUriNotSet.code, ClientConfigurationErrorMessage.redirectUriNotSet.desc);
    };
    /**
     * Creates an error thrown when the post-logout redirect uri is empty (not set by caller)
     */
    ClientConfigurationError.createPostLogoutRedirectUriEmptyError = function () {
        return new ClientConfigurationError(ClientConfigurationErrorMessage.postLogoutUriNotSet.code, ClientConfigurationErrorMessage.postLogoutUriNotSet.desc);
    };
    /**
     * Creates an error thrown when the claims request could not be successfully parsed
     */
    ClientConfigurationError.createClaimsRequestParsingError = function (claimsRequestParseError) {
        return new ClientConfigurationError(ClientConfigurationErrorMessage.claimsRequestParsingError.code, ClientConfigurationErrorMessage.claimsRequestParsingError.desc + " Given value: " + claimsRequestParseError);
    };
    /**
     * Creates an error thrown if authority uri is given an insecure protocol.
     * @param urlString
     */
    ClientConfigurationError.createInsecureAuthorityUriError = function (urlString) {
        return new ClientConfigurationError(ClientConfigurationErrorMessage.authorityUriInsecure.code, ClientConfigurationErrorMessage.authorityUriInsecure.desc + " Given URI: " + urlString);
    };
    /**
     * Creates an error thrown if URL string does not parse into separate segments.
     * @param urlString
     */
    ClientConfigurationError.createUrlParseError = function (urlParseError) {
        return new ClientConfigurationError(ClientConfigurationErrorMessage.urlParseError.code, ClientConfigurationErrorMessage.urlParseError.desc + " Given Error: " + urlParseError);
    };
    /**
     * Creates an error thrown if URL string is empty or null.
     * @param urlString
     */
    ClientConfigurationError.createUrlEmptyError = function () {
        return new ClientConfigurationError(ClientConfigurationErrorMessage.urlEmptyError.code, ClientConfigurationErrorMessage.urlEmptyError.desc);
    };
    /**
     * Error thrown when scopes are not an array
     * @param inputScopes
     */
    ClientConfigurationError.createScopesNonArrayError = function (inputScopes) {
        return new ClientConfigurationError(ClientConfigurationErrorMessage.nonArrayScopesError.code, ClientConfigurationErrorMessage.nonArrayScopesError.desc + " Given Scopes: " + inputScopes);
    };
    /**
     * Error thrown when scopes are empty.
     * @param scopesValue
     */
    ClientConfigurationError.createEmptyScopesArrayError = function (inputScopes) {
        return new ClientConfigurationError(ClientConfigurationErrorMessage.emptyScopesError.code, ClientConfigurationErrorMessage.emptyScopesError.desc + " Given Scopes: " + inputScopes);
    };
    /**
     * Error thrown when client id scope is not provided as single scope.
     * @param inputScopes
     */
    ClientConfigurationError.createClientIdSingleScopeError = function (inputScopes) {
        return new ClientConfigurationError(ClientConfigurationErrorMessage.clientIdSingleScopeError.code, ClientConfigurationErrorMessage.clientIdSingleScopeError.desc + " Given Scopes: " + inputScopes);
    };
    /**
     * Error thrown when prompt is not an allowed type.
     * @param promptValue
     */
    ClientConfigurationError.createInvalidPromptError = function (promptValue) {
        return new ClientConfigurationError(ClientConfigurationErrorMessage.invalidPrompt.code, ClientConfigurationErrorMessage.invalidPrompt.desc + " Given value: " + promptValue);
    };
    /**
     * Creates error thrown when claims parameter is not a stringified JSON object
     */
    ClientConfigurationError.createInvalidClaimsRequestError = function () {
        return new ClientConfigurationError(ClientConfigurationErrorMessage.invalidClaimsRequest.code, ClientConfigurationErrorMessage.invalidClaimsRequest.desc);
    };
    /**
     * Throws error when token request is empty and nothing cached in storage.
     */
    ClientConfigurationError.createEmptyLogoutRequestError = function () {
        return new ClientConfigurationError(ClientConfigurationErrorMessage.logoutRequestEmptyError.code, ClientConfigurationErrorMessage.logoutRequestEmptyError.desc);
    };
    /**
     * Throws error when token request is empty and nothing cached in storage.
     */
    ClientConfigurationError.createEmptyTokenRequestError = function () {
        return new ClientConfigurationError(ClientConfigurationErrorMessage.tokenRequestEmptyError.code, ClientConfigurationErrorMessage.tokenRequestEmptyError.desc);
    };
    /**
     * Throws error when an invalid code_challenge_method is passed by the user
     */
    ClientConfigurationError.createInvalidCodeChallengeMethodError = function () {
        return new ClientConfigurationError(ClientConfigurationErrorMessage.invalidCodeChallengeMethod.code, ClientConfigurationErrorMessage.invalidCodeChallengeMethod.desc);
    };
    /**
     * Throws error when both params: code_challenge and code_challenge_method are not passed together
     */
    ClientConfigurationError.createInvalidCodeChallengeParamsError = function () {
        return new ClientConfigurationError(ClientConfigurationErrorMessage.invalidCodeChallengeParams.code, ClientConfigurationErrorMessage.invalidCodeChallengeParams.desc);
    };
    /**
     * Throws an error when the user passes both knownAuthorities and cloudDiscoveryMetadata
     */
    ClientConfigurationError.createKnownAuthoritiesCloudDiscoveryMetadataError = function () {
        return new ClientConfigurationError(ClientConfigurationErrorMessage.knownAuthoritiesAndCloudDiscoveryMetadata.code, ClientConfigurationErrorMessage.knownAuthoritiesAndCloudDiscoveryMetadata.desc);
    };
    /**
     * Throws an error when the user passes invalid cloudDiscoveryMetadata
     */
    ClientConfigurationError.createInvalidCloudDiscoveryMetadataError = function () {
        return new ClientConfigurationError(ClientConfigurationErrorMessage.invalidCloudDiscoveryMetadata.code, ClientConfigurationErrorMessage.invalidCloudDiscoveryMetadata.desc);
    };
    /**
     * Throws error when provided authority is not a member of the trusted host list
     */
    ClientConfigurationError.createUntrustedAuthorityError = function () {
        return new ClientConfigurationError(ClientConfigurationErrorMessage.untrustedAuthority.code, ClientConfigurationErrorMessage.untrustedAuthority.desc);
    };
    return ClientConfigurationError;
}(ClientAuthError));

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * The ScopeSet class creates a set of scopes. Scopes are case-insensitive, unique values, so the Set object in JS makes
 * the most sense to implement for this class. All scopes are trimmed and converted to lower case strings in intersection and union functions
 * to ensure uniqueness of strings.
 */
var ScopeSet = /** @class */ (function () {
    function ScopeSet(inputScopes) {
        var _this = this;
        // Filter empty string and null/undefined array items
        var scopeArr = inputScopes ? StringUtils.trimArrayEntries(__spreadArrays(inputScopes)) : [];
        var filteredInput = scopeArr ? StringUtils.removeEmptyStringsFromArray(scopeArr) : [];
        // Validate and filter scopes (validate function throws if validation fails)
        this.validateInputScopes(filteredInput);
        this.scopes = new Set(); // Iterator in constructor not supported by IE11
        filteredInput.forEach(function (scope) { return _this.scopes.add(scope); });
    }
    /**
     * Factory method to create ScopeSet from space-delimited string
     * @param inputScopeString
     * @param appClientId
     * @param scopesRequired
     */
    ScopeSet.fromString = function (inputScopeString) {
        inputScopeString = inputScopeString || "";
        var inputScopes = inputScopeString.split(" ");
        return new ScopeSet(inputScopes);
    };
    /**
     * Used to validate the scopes input parameter requested  by the developer.
     * @param {Array<string>} inputScopes - Developer requested permissions. Not all scopes are guaranteed to be included in the access token returned.
     * @param {boolean} scopesRequired - Boolean indicating whether the scopes array is required or not
     */
    ScopeSet.prototype.validateInputScopes = function (inputScopes) {
        // Check if scopes are required but not given or is an empty array
        if (!inputScopes || inputScopes.length < 1) {
            throw ClientConfigurationError.createEmptyScopesArrayError(inputScopes);
        }
    };
    /**
     * Check if a given scope is present in this set of scopes.
     * @param scope
     */
    ScopeSet.prototype.containsScope = function (scope) {
        var lowerCaseScopes = this.printScopesLowerCase().split(" ");
        var lowerCaseScopesSet = new ScopeSet(lowerCaseScopes);
        // compare lowercase scopes
        return !StringUtils.isEmpty(scope) ? lowerCaseScopesSet.scopes.has(scope.toLowerCase()) : false;
    };
    /**
     * Check if a set of scopes is present in this set of scopes.
     * @param scopeSet
     */
    ScopeSet.prototype.containsScopeSet = function (scopeSet) {
        var _this = this;
        if (!scopeSet || scopeSet.scopes.size <= 0) {
            return false;
        }
        return (this.scopes.size >= scopeSet.scopes.size && scopeSet.asArray().every(function (scope) { return _this.containsScope(scope); }));
    };
    /**
     * Check if set of scopes contains only the defaults
     */
    ScopeSet.prototype.containsOnlyDefaultScopes = function () {
        var defaultScopeCount = 0;
        if (this.containsScope(Constants.OPENID_SCOPE)) {
            defaultScopeCount += 1;
        }
        if (this.containsScope(Constants.PROFILE_SCOPE)) {
            defaultScopeCount += 1;
        }
        if (this.containsScope(Constants.OFFLINE_ACCESS_SCOPE)) {
            defaultScopeCount += 1;
        }
        return this.scopes.size === defaultScopeCount;
    };
    /**
     * Appends single scope if passed
     * @param newScope
     */
    ScopeSet.prototype.appendScope = function (newScope) {
        if (!StringUtils.isEmpty(newScope)) {
            this.scopes.add(newScope.trim());
        }
    };
    /**
     * Appends multiple scopes if passed
     * @param newScopes
     */
    ScopeSet.prototype.appendScopes = function (newScopes) {
        var _this = this;
        try {
            newScopes.forEach(function (newScope) { return _this.appendScope(newScope); });
        }
        catch (e) {
            throw ClientAuthError.createAppendScopeSetError(e);
        }
    };
    /**
     * Removes element from set of scopes.
     * @param scope
     */
    ScopeSet.prototype.removeScope = function (scope) {
        if (StringUtils.isEmpty(scope)) {
            throw ClientAuthError.createRemoveEmptyScopeFromSetError(scope);
        }
        this.scopes.delete(scope.trim());
    };
    /**
     * Removes default scopes from set of scopes
     * Primarily used to prevent cache misses if the default scopes are not returned from the server
     */
    ScopeSet.prototype.removeDefaultScopes = function () {
        this.scopes.delete(Constants.OFFLINE_ACCESS_SCOPE);
        this.scopes.delete(Constants.OPENID_SCOPE);
        this.scopes.delete(Constants.PROFILE_SCOPE);
    };
    /**
     * Combines an array of scopes with the current set of scopes.
     * @param otherScopes
     */
    ScopeSet.prototype.unionScopeSets = function (otherScopes) {
        if (!otherScopes) {
            throw ClientAuthError.createEmptyInputScopeSetError(otherScopes);
        }
        var unionScopes = new Set(); // Iterator in constructor not supported in IE11
        otherScopes.scopes.forEach(function (scope) { return unionScopes.add(scope.toLowerCase()); });
        this.scopes.forEach(function (scope) { return unionScopes.add(scope.toLowerCase()); });
        return unionScopes;
    };
    /**
     * Check if scopes intersect between this set and another.
     * @param otherScopes
     */
    ScopeSet.prototype.intersectingScopeSets = function (otherScopes) {
        if (!otherScopes) {
            throw ClientAuthError.createEmptyInputScopeSetError(otherScopes);
        }
        var unionScopes = this.unionScopeSets(otherScopes);
        // Do not allow default scopes to be the only intersecting scopes
        if (!otherScopes.containsOnlyDefaultScopes()) {
            otherScopes.removeDefaultScopes();
        }
        var sizeOtherScopes = otherScopes.getScopeCount();
        var sizeThisScopes = this.getScopeCount();
        var sizeUnionScopes = unionScopes.size;
        return sizeUnionScopes < (sizeThisScopes + sizeOtherScopes);
    };
    /**
     * Returns size of set of scopes.
     */
    ScopeSet.prototype.getScopeCount = function () {
        return this.scopes.size;
    };
    /**
     * Returns the scopes as an array of string values
     */
    ScopeSet.prototype.asArray = function () {
        var array = [];
        this.scopes.forEach(function (val) { return array.push(val); });
        return array;
    };
    /**
     * Prints scopes into a space-delimited string
     */
    ScopeSet.prototype.printScopes = function () {
        if (this.scopes) {
            var scopeArr = this.asArray();
            return scopeArr.join(" ");
        }
        return "";
    };
    /**
     * Prints scopes into a space-delimited lower-case string (used for caching)
     */
    ScopeSet.prototype.printScopesLowerCase = function () {
        return this.printScopes().toLowerCase();
    };
    return ScopeSet;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * Authority types supported by MSAL.
 */
var AuthorityType;
(function (AuthorityType) {
    AuthorityType[AuthorityType["Default"] = 0] = "Default";
    AuthorityType[AuthorityType["Adfs"] = 1] = "Adfs";
})(AuthorityType || (AuthorityType = {}));

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * Url object class which can perform various transformations on url strings.
 */
var UrlString = /** @class */ (function () {
    function UrlString(url) {
        this._urlString = url;
        if (StringUtils.isEmpty(this._urlString)) {
            // Throws error if url is empty
            throw ClientConfigurationError.createUrlEmptyError();
        }
        if (StringUtils.isEmpty(this.getHash())) {
            this._urlString = UrlString.canonicalizeUri(url);
        }
    }
    Object.defineProperty(UrlString.prototype, "urlString", {
        get: function () {
            return this._urlString;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Ensure urls are lower case and end with a / character.
     * @param url
     */
    UrlString.canonicalizeUri = function (url) {
        if (url) {
            url = url.toLowerCase();
        }
        if (url && !StringUtils.endsWith(url, "/")) {
            url += "/";
        }
        return url;
    };
    /**
     * Throws if urlString passed is not a valid authority URI string.
     */
    UrlString.prototype.validateAsUri = function () {
        // Attempts to parse url for uri components
        var components;
        try {
            components = this.getUrlComponents();
        }
        catch (e) {
            throw ClientConfigurationError.createUrlParseError(e);
        }
        // Throw error if URI or path segments are not parseable.
        if (!components.HostNameAndPort || !components.PathSegments) {
            throw ClientConfigurationError.createUrlParseError("Given url string: " + this.urlString);
        }
        // Throw error if uri is insecure.
        if (!components.Protocol || components.Protocol.toLowerCase() !== "https:") {
            throw ClientConfigurationError.createInsecureAuthorityUriError(this.urlString);
        }
    };
    /**
     * Function to remove query string params from url. Returns the new url.
     * @param url
     * @param name
     */
    UrlString.prototype.urlRemoveQueryStringParameter = function (name) {
        var regex = new RegExp("(\\&" + name + "=)[^\&]+");
        this._urlString = this.urlString.replace(regex, "");
        // name=value&
        regex = new RegExp("(" + name + "=)[^\&]+&");
        this._urlString = this.urlString.replace(regex, "");
        // name=value
        regex = new RegExp("(" + name + "=)[^\&]+");
        this._urlString = this.urlString.replace(regex, "");
        return this.urlString;
    };
    UrlString.removeHashFromUrl = function (url) {
        return UrlString.canonicalizeUri(url.split("#")[0]);
    };
    /**
     * Given a url like https://a:b/common/d?e=f#g, and a tenantId, returns https://a:b/tenantId/d
     * @param href The url
     * @param tenantId The tenant id to replace
     */
    UrlString.prototype.replaceTenantPath = function (tenantId) {
        var urlObject = this.getUrlComponents();
        var pathArray = urlObject.PathSegments;
        if (tenantId && (pathArray.length !== 0 && (pathArray[0] === AADAuthorityConstants.COMMON || pathArray[0] === AADAuthorityConstants.ORGANIZATIONS))) {
            pathArray[0] = tenantId;
        }
        return UrlString.constructAuthorityUriFromObject(urlObject);
    };
    /**
     * Returns the anchor part(#) of the URL
     */
    UrlString.prototype.getHash = function () {
        return UrlString.parseHash(this.urlString);
    };
    /**
     * Parses out the components from a url string.
     * @returns An object with the various components. Please cache this value insted of calling this multiple times on the same url.
     */
    UrlString.prototype.getUrlComponents = function () {
        // https://gist.github.com/curtisz/11139b2cfcaef4a261e0
        var regEx = RegExp("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
        // If url string does not match regEx, we throw an error
        var match = this.urlString.match(regEx);
        if (!match) {
            throw ClientConfigurationError.createUrlParseError("Given url string: " + this.urlString);
        }
        // Url component object
        var urlComponents = {
            Protocol: match[1],
            HostNameAndPort: match[4],
            AbsolutePath: match[5],
            QueryString: match[7]
        };
        var pathSegments = urlComponents.AbsolutePath.split("/");
        pathSegments = pathSegments.filter(function (val) { return val && val.length > 0; }); // remove empty elements
        urlComponents.PathSegments = pathSegments;
        if (!StringUtils.isEmpty(urlComponents.QueryString) && urlComponents.QueryString.endsWith("/")) {
            urlComponents.QueryString = urlComponents.QueryString.substring(0, urlComponents.QueryString.length - 1);
        }
        return urlComponents;
    };
    UrlString.getDomainFromUrl = function (url) {
        var regEx = RegExp("^([^:/?#]+://)?([^/?#]*)");
        var match = url.match(regEx);
        if (!match) {
            throw ClientConfigurationError.createUrlParseError("Given url string: " + url);
        }
        return match[2];
    };
    UrlString.getAbsoluteUrl = function (relativeUrl, baseUrl) {
        if (relativeUrl[0] === Constants.FORWARD_SLASH) {
            var url = new UrlString(baseUrl);
            var baseComponents = url.getUrlComponents();
            return baseComponents.Protocol + "//" + baseComponents.HostNameAndPort + relativeUrl;
        }
        return relativeUrl;
    };
    /**
     * Parses hash string from given string. Returns empty string if no hash symbol is found.
     * @param hashString
     */
    UrlString.parseHash = function (hashString) {
        var hashIndex1 = hashString.indexOf("#");
        var hashIndex2 = hashString.indexOf("#/");
        if (hashIndex2 > -1) {
            return hashString.substring(hashIndex2 + 2);
        }
        else if (hashIndex1 > -1) {
            return hashString.substring(hashIndex1 + 1);
        }
        return "";
    };
    UrlString.constructAuthorityUriFromObject = function (urlObject) {
        return new UrlString(urlObject.Protocol + "//" + urlObject.HostNameAndPort + "/" + urlObject.PathSegments.join("/"));
    };
    /**
     * Returns URL hash as server auth code response object.
     */
    UrlString.getDeserializedHash = function (hash) {
        // Check if given hash is empty
        if (StringUtils.isEmpty(hash)) {
            return {};
        }
        // Strip the # symbol if present
        var parsedHash = UrlString.parseHash(hash);
        // If # symbol was not present, above will return empty string, so give original hash value
        var deserializedHash = StringUtils.queryStringToObject(StringUtils.isEmpty(parsedHash) ? hash : parsedHash);
        // Check if deserialization didn't work
        if (!deserializedHash) {
            throw ClientAuthError.createHashNotDeserializedError(JSON.stringify(deserializedHash));
        }
        return deserializedHash;
    };
    /**
     * Check if the hash of the URL string contains known properties
     */
    UrlString.hashContainsKnownProperties = function (hash) {
        if (StringUtils.isEmpty(hash)) {
            return false;
        }
        var parameters = UrlString.getDeserializedHash(hash);
        return !!(parameters.code ||
            parameters.error_description ||
            parameters.error ||
            parameters.state);
    };
    return UrlString;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
var TrustedAuthority = /** @class */ (function () {
    function TrustedAuthority() {
    }
    /**
     * Set the CloudDiscoveryMetadata object from knownAuthorities or cloudDiscoveryMetadata passed into the app config
     * @param knownAuthorities
     * @param cloudDiscoveryMetadata
     */
    TrustedAuthority.setTrustedAuthoritiesFromConfig = function (knownAuthorities, cloudDiscoveryMetadata) {
        if (!this.getTrustedHostList().length) {
            if (knownAuthorities.length > 0 && !StringUtils.isEmpty(cloudDiscoveryMetadata)) {
                throw ClientConfigurationError.createKnownAuthoritiesCloudDiscoveryMetadataError();
            }
            this.createCloudDiscoveryMetadataFromKnownAuthorities(knownAuthorities);
            try {
                if (cloudDiscoveryMetadata) {
                    var parsedMetadata = JSON.parse(cloudDiscoveryMetadata);
                    this.saveCloudDiscoveryMetadata(parsedMetadata.metadata);
                }
            }
            catch (e) {
                throw ClientConfigurationError.createInvalidCloudDiscoveryMetadataError();
            }
        }
    };
    /**
     * Called to get metadata from network if CloudDiscoveryMetadata was not populated by config
     * @param networkInterface
     */
    TrustedAuthority.setTrustedAuthoritiesFromNetwork = function (authorityToVerify, networkInterface) {
        return __awaiter(this, void 0, void 0, function () {
            var instanceDiscoveryEndpoint, response, metadata, e_1, host;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        instanceDiscoveryEndpoint = "" + Constants.AAD_INSTANCE_DISCOVERY_ENDPT + authorityToVerify.urlString + "oauth2/v2.0/authorize";
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 4]);
                        return [4 /*yield*/, networkInterface.sendGetRequestAsync(instanceDiscoveryEndpoint)];
                    case 2:
                        response = _a.sent();
                        metadata = response.body.metadata;
                        this.saveCloudDiscoveryMetadata(metadata);
                        return [3 /*break*/, 4];
                    case 3:
                        e_1 = _a.sent();
                        return [2 /*return*/];
                    case 4:
                        host = authorityToVerify.getUrlComponents().HostNameAndPort;
                        if (this.getTrustedHostList().length > 0 && !this.IsInTrustedHostList(host)) {
                            // Custom Domain scenario, host is trusted because Instance Discovery call succeeded 
                            this.createCloudDiscoveryMetadataFromKnownAuthorities([host]);
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     *
     * @param metadata
     */
    TrustedAuthority.saveCloudDiscoveryMetadata = function (metadata) {
        metadata.forEach(function (entry) {
            var authorities = entry.aliases;
            authorities.forEach(function (authority) {
                TrustedAuthority.TrustedHostList[authority.toLowerCase()] = entry;
            });
        });
    };
    /**
     * Create a generic metadata object for each host passed to knownAuthorities.
     * This is mostly useful for B2C or ADFS scenarios
     * @param knownAuthorities
     */
    TrustedAuthority.createCloudDiscoveryMetadataFromKnownAuthorities = function (knownAuthorities) {
        var _this = this;
        knownAuthorities.forEach(function (authority) {
            var authorityDomain = UrlString.getDomainFromUrl(authority).toLowerCase();
            _this.TrustedHostList[authorityDomain] = {
                preferred_cache: authorityDomain,
                preferred_network: authorityDomain,
                aliases: [authorityDomain]
            };
        });
    };
    TrustedAuthority.getTrustedHostList = function () {
        return Object.keys(this.TrustedHostList);
    };
    /**
     * Get metadata for the provided host
     * @param host
     */
    TrustedAuthority.getCloudDiscoveryMetadata = function (host) {
        return this.TrustedHostList[host.toLowerCase()] || null;
    };
    /**
     * Checks to see if the host is in a list of trusted hosts
     * @param host
     */
    TrustedAuthority.IsInTrustedHostList = function (host) {
        return Object.keys(this.TrustedHostList).indexOf(host.toLowerCase()) > -1;
    };
    TrustedAuthority.TrustedHostList = {};
    return TrustedAuthority;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * Protocol modes supported by MSAL.
 */
var ProtocolMode;
(function (ProtocolMode) {
    ProtocolMode["AAD"] = "AAD";
    ProtocolMode["OIDC"] = "OIDC";
})(ProtocolMode || (ProtocolMode = {}));

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * The authority class validates the authority URIs used by the user, and retrieves the OpenID Configuration Data from the
 * endpoint. It will store the pertinent config data in this object for use during token calls.
 */
var Authority = /** @class */ (function () {
    function Authority(authority, networkInterface, protocolMode) {
        this.canonicalAuthority = authority;
        this._canonicalAuthority.validateAsUri();
        this.networkInterface = networkInterface;
        this.authorityProtocolMode = protocolMode;
    }
    Object.defineProperty(Authority.prototype, "authorityType", {
        // See above for AuthorityType
        get: function () {
            var pathSegments = this.canonicalAuthorityUrlComponents.PathSegments;
            if (pathSegments.length && pathSegments[0].toLowerCase() === Constants.ADFS) {
                return AuthorityType.Adfs;
            }
            return AuthorityType.Default;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Authority.prototype, "protocolMode", {
        /**
         * ProtocolMode enum representing the way endpoints are constructed.
         */
        get: function () {
            return this.authorityProtocolMode;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Authority.prototype, "canonicalAuthority", {
        /**
         * A URL that is the authority set by the developer
         */
        get: function () {
            return this._canonicalAuthority.urlString;
        },
        /**
         * Sets canonical authority.
         */
        set: function (url) {
            this._canonicalAuthority = new UrlString(url);
            this._canonicalAuthority.validateAsUri();
            this._canonicalAuthorityUrlComponents = null;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Authority.prototype, "canonicalAuthorityUrlComponents", {
        /**
         * Get authority components.
         */
        get: function () {
            if (!this._canonicalAuthorityUrlComponents) {
                this._canonicalAuthorityUrlComponents = this._canonicalAuthority.getUrlComponents();
            }
            return this._canonicalAuthorityUrlComponents;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Authority.prototype, "tenant", {
        /**
         * Get tenant for authority.
         */
        get: function () {
            return this.canonicalAuthorityUrlComponents.PathSegments[0];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Authority.prototype, "authorizationEndpoint", {
        /**
         * OAuth /authorize endpoint for requests
         */
        get: function () {
            if (this.discoveryComplete()) {
                return this.replaceTenant(this.tenantDiscoveryResponse.authorization_endpoint);
            }
            else {
                throw ClientAuthError.createEndpointDiscoveryIncompleteError("Discovery incomplete.");
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Authority.prototype, "tokenEndpoint", {
        /**
         * OAuth /token endpoint for requests
         */
        get: function () {
            if (this.discoveryComplete()) {
                return this.replaceTenant(this.tenantDiscoveryResponse.token_endpoint);
            }
            else {
                throw ClientAuthError.createEndpointDiscoveryIncompleteError("Discovery incomplete.");
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Authority.prototype, "deviceCodeEndpoint", {
        get: function () {
            if (this.discoveryComplete()) {
                return this.tenantDiscoveryResponse.token_endpoint.replace("/token", "/devicecode");
            }
            else {
                throw ClientAuthError.createEndpointDiscoveryIncompleteError("Discovery incomplete.");
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Authority.prototype, "endSessionEndpoint", {
        /**
         * OAuth logout endpoint for requests
         */
        get: function () {
            if (this.discoveryComplete()) {
                return this.replaceTenant(this.tenantDiscoveryResponse.end_session_endpoint);
            }
            else {
                throw ClientAuthError.createEndpointDiscoveryIncompleteError("Discovery incomplete.");
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Authority.prototype, "selfSignedJwtAudience", {
        /**
         * OAuth issuer for requests
         */
        get: function () {
            if (this.discoveryComplete()) {
                return this.replaceTenant(this.tenantDiscoveryResponse.issuer);
            }
            else {
                throw ClientAuthError.createEndpointDiscoveryIncompleteError("Discovery incomplete.");
            }
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Replaces tenant in url path with current tenant. Defaults to common.
     * @param urlString
     */
    Authority.prototype.replaceTenant = function (urlString) {
        return urlString.replace(/{tenant}|{tenantid}/g, this.tenant);
    };
    Object.defineProperty(Authority.prototype, "defaultOpenIdConfigurationEndpoint", {
        /**
         * The default open id configuration endpoint for any canonical authority.
         */
        get: function () {
            if (this.authorityType === AuthorityType.Adfs || this.protocolMode === ProtocolMode.OIDC) {
                return this.canonicalAuthority + ".well-known/openid-configuration";
            }
            return this.canonicalAuthority + "v2.0/.well-known/openid-configuration";
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Boolean that returns whethr or not tenant discovery has been completed.
     */
    Authority.prototype.discoveryComplete = function () {
        return !!this.tenantDiscoveryResponse;
    };
    /**
     * Gets OAuth endpoints from the given OpenID configuration endpoint.
     * @param openIdConfigurationEndpoint
     */
    Authority.prototype.discoverEndpoints = function (openIdConfigurationEndpoint) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.networkInterface.sendGetRequestAsync(openIdConfigurationEndpoint)];
            });
        });
    };
    Object.defineProperty(Authority.prototype, "aadInstanceDiscoveryEndpointUrl", {
        // Default AAD Instance Discovery Endpoint
        get: function () {
            return "" + Constants.AAD_INSTANCE_DISCOVERY_ENDPT + this.canonicalAuthority + "oauth2/v2.0/authorize";
        },
        enumerable: true,
        configurable: true
    });
    Authority.prototype.validateAndSetPreferredNetwork = function () {
        return __awaiter(this, void 0, void 0, function () {
            var host, preferredNetwork;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        host = this.canonicalAuthorityUrlComponents.HostNameAndPort;
                        if (!(TrustedAuthority.getTrustedHostList().length === 0)) return [3 /*break*/, 2];
                        return [4 /*yield*/, TrustedAuthority.setTrustedAuthoritiesFromNetwork(this._canonicalAuthority, this.networkInterface)];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2:
                        if (!TrustedAuthority.IsInTrustedHostList(host)) {
                            throw ClientConfigurationError.createUntrustedAuthorityError();
                        }
                        preferredNetwork = TrustedAuthority.getCloudDiscoveryMetadata(host).preferred_network;
                        if (host !== preferredNetwork) {
                            this.canonicalAuthority = this.canonicalAuthority.replace(host, preferredNetwork);
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * Perform endpoint discovery to discover the /authorize, /token and logout endpoints.
     */
    Authority.prototype.resolveEndpointsAsync = function () {
        return __awaiter(this, void 0, void 0, function () {
            var openIdConfigEndpoint, response;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.validateAndSetPreferredNetwork()];
                    case 1:
                        _a.sent();
                        openIdConfigEndpoint = this.defaultOpenIdConfigurationEndpoint;
                        return [4 /*yield*/, this.discoverEndpoints(openIdConfigEndpoint)];
                    case 2:
                        response = _a.sent();
                        this.tenantDiscoveryResponse = response.body;
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * helper function to generate environment from authority object
     * @param authority
     */
    Authority.generateEnvironmentFromAuthority = function (authority) {
        var reqEnvironment = authority.canonicalAuthorityUrlComponents.HostNameAndPort;
        return TrustedAuthority.getCloudDiscoveryMetadata(reqEnvironment) ? TrustedAuthority.getCloudDiscoveryMetadata(reqEnvironment).preferred_cache : "";
    };
    return Authority;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * Function to build a client info object
 * @param rawClientInfo
 * @param crypto
 */
function buildClientInfo(rawClientInfo, crypto) {
    if (StringUtils.isEmpty(rawClientInfo)) {
        throw ClientAuthError.createClientInfoEmptyError(rawClientInfo);
    }
    try {
        var decodedClientInfo = crypto.base64Decode(rawClientInfo);
        return JSON.parse(decodedClientInfo);
    }
    catch (e) {
        throw ClientAuthError.createClientInfoDecodingError(e);
    }
}

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * Type that defines required and optional parameters for an Account field (based on universal cache schema implemented by all MSALs).
 *
 * Key : Value Schema
 *
 * Key: <home_account_id>-<environment>-<realm*>
 *
 * Value Schema:
 * {
 *      homeAccountId: home account identifier for the auth scheme,
 *      environment: entity that issued the token, represented as a full host
 *      realm: Full tenant or organizational identifier that the account belongs to
 *      localAccountId: Original tenant-specific accountID, usually used for legacy cases
 *      username: primary username that represents the user, usually corresponds to preferred_username in the v2 endpt
 *      authorityType: Accounts authority type as a string
 *      name: Full name for the account, including given name and family name,
 *      clientInfo: Full base64 encoded client info received from ESTS
 *      lastModificationTime: last time this entity was modified in the cache
 *      lastModificationApp:
 *      oboAssertion: access token passed in as part of OBO request
 * }
 */
var AccountEntity = /** @class */ (function () {
    function AccountEntity() {
    }
    /**
     * Generate Account Id key component as per the schema: <home_account_id>-<environment>
     */
    AccountEntity.prototype.generateAccountId = function () {
        var accountId = [this.homeAccountId, this.environment];
        return accountId.join(Separators.CACHE_KEY_SEPARATOR).toLowerCase();
    };
    /**
     * Generate Account Cache Key as per the schema: <home_account_id>-<environment>-<realm*>
     */
    AccountEntity.prototype.generateAccountKey = function () {
        return AccountEntity.generateAccountCacheKey({
            homeAccountId: this.homeAccountId,
            environment: this.environment,
            tenantId: this.realm,
            username: this.username,
            localAccountId: this.localAccountId
        });
    };
    /**
     * returns the type of the cache (in this case account)
     */
    AccountEntity.prototype.generateType = function () {
        switch (this.authorityType) {
            case CacheAccountType.ADFS_ACCOUNT_TYPE:
                return CacheType.ADFS;
            case CacheAccountType.MSAV1_ACCOUNT_TYPE:
                return CacheType.MSA;
            case CacheAccountType.MSSTS_ACCOUNT_TYPE:
                return CacheType.MSSTS;
            case CacheAccountType.GENERIC_ACCOUNT_TYPE:
                return CacheType.GENERIC;
            default: {
                throw ClientAuthError.createUnexpectedAccountTypeError();
            }
        }
    };
    /**
     * Returns the AccountInfo interface for this account.
     */
    AccountEntity.prototype.getAccountInfo = function () {
        return {
            homeAccountId: this.homeAccountId,
            environment: this.environment,
            tenantId: this.realm,
            username: this.username,
            localAccountId: this.localAccountId,
            name: this.name,
        };
    };
    /**
     * Generates account key from interface
     * @param accountInterface
     */
    AccountEntity.generateAccountCacheKey = function (accountInterface) {
        var accountKey = [
            accountInterface.homeAccountId,
            accountInterface.environment || "",
            accountInterface.tenantId || "",
        ];
        return accountKey.join(Separators.CACHE_KEY_SEPARATOR).toLowerCase();
    };
    /**
     * Build Account cache from IdToken, clientInfo and authority/policy. Associated with AAD.
     * @param clientInfo
     * @param authority
     * @param idToken
     * @param policy
     */
    AccountEntity.createAccount = function (clientInfo, homeAccountId, authority, idToken, oboAssertion) {
        var account = new AccountEntity();
        account.authorityType = CacheAccountType.MSSTS_ACCOUNT_TYPE;
        account.clientInfo = clientInfo;
        account.homeAccountId = homeAccountId;
        var env = Authority.generateEnvironmentFromAuthority(authority);
        if (StringUtils.isEmpty(env)) {
            throw ClientAuthError.createInvalidCacheEnvironmentError();
        }
        account.environment = env;
        // non AAD scenarios can have empty realm
        account.realm = idToken.claims.tid || "";
        account.oboAssertion = oboAssertion;
        if (idToken) {
            // How do you account for MSA CID here?
            var localAccountId = !StringUtils.isEmpty(idToken.claims.oid)
                ? idToken.claims.oid
                : idToken.claims.sub;
            account.localAccountId = localAccountId;
            /*
             * In B2C scenarios the emails claim is used instead of preferred_username and it is an array. In most cases it will contain a single email.
             * This field should not be relied upon if a custom policy is configured to return more than 1 email.
             */
            account.username = idToken.claims.preferred_username || (idToken.claims.emails ? idToken.claims.emails[0] : "");
            account.name = idToken.claims.name;
        }
        return account;
    };
    /**
     * Builds non-AAD/ADFS account.
     * @param authority
     * @param idToken
     */
    AccountEntity.createGenericAccount = function (authority, homeAccountId, idToken, oboAssertion) {
        var account = new AccountEntity();
        account.authorityType = (authority.authorityType === AuthorityType.Adfs) ? CacheAccountType.ADFS_ACCOUNT_TYPE : CacheAccountType.GENERIC_ACCOUNT_TYPE;
        account.homeAccountId = homeAccountId;
        // non AAD scenarios can have empty realm
        account.realm = "";
        account.oboAssertion = oboAssertion;
        var env = Authority.generateEnvironmentFromAuthority(authority);
        if (StringUtils.isEmpty(env)) {
            throw ClientAuthError.createInvalidCacheEnvironmentError();
        }
        if (idToken) {
            // How do you account for MSA CID here?
            var localAccountId = !StringUtils.isEmpty(idToken.claims.oid)
                ? idToken.claims.oid
                : idToken.claims.sub;
            account.localAccountId = localAccountId;
            // upn claim for most ADFS scenarios
            account.username = idToken.claims.upn;
            account.name = idToken.claims.name;
        }
        account.environment = env;
        /*
         * add uniqueName to claims
         * account.name = idToken.claims.uniqueName;
         */
        return account;
    };
    /**
     * Generate HomeAccountId from server response
     * @param serverClientInfo
     * @param authType
     */
    AccountEntity.generateHomeAccountId = function (serverClientInfo, authType, logger, cryptoObj, idToken) {
        var accountId = idToken && idToken.claims.sub ? idToken.claims.sub : "";
        // since ADFS does not have tid and does not set client_info
        if (authType === AuthorityType.Adfs) {
            return accountId;
        }
        // for cases where there is clientInfo
        if (serverClientInfo) {
            var clientInfo = buildClientInfo(serverClientInfo, cryptoObj);
            if (!StringUtils.isEmpty(clientInfo.uid) && !StringUtils.isEmpty(clientInfo.utid)) {
                return "" + clientInfo.uid + Separators.CLIENT_INFO_SEPARATOR + clientInfo.utid;
            }
        }
        // default to "sub" claim
        logger.verbose("No client info in response");
        return accountId;
    };
    /**
     * Validates an entity: checks for all expected params
     * @param entity
     */
    AccountEntity.isAccountEntity = function (entity) {
        if (!entity) {
            return false;
        }
        return (entity.hasOwnProperty("homeAccountId") &&
            entity.hasOwnProperty("environment") &&
            entity.hasOwnProperty("realm") &&
            entity.hasOwnProperty("localAccountId") &&
            entity.hasOwnProperty("username") &&
            entity.hasOwnProperty("authorityType"));
    };
    return AccountEntity;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * Interface class which implement cache storage functions used by MSAL to perform validity checks, and store tokens.
 */
var CacheManager = /** @class */ (function () {
    function CacheManager() {
    }
    /**
     * Returns all accounts in cache
     */
    CacheManager.prototype.getAllAccounts = function () {
        var currentAccounts = this.getAccountsFilteredBy();
        var accountValues = Object.keys(currentAccounts).map(function (accountKey) { return currentAccounts[accountKey]; });
        var numAccounts = accountValues.length;
        if (numAccounts < 1) {
            return [];
        }
        else {
            var allAccounts = accountValues.map(function (value) {
                var accountObj = new AccountEntity();
                accountObj = CacheManager.toObject(accountObj, value);
                return accountObj.getAccountInfo();
            });
            return allAccounts;
        }
    };
    /**
     * saves a cache record
     * @param cacheRecord
     */
    CacheManager.prototype.saveCacheRecord = function (cacheRecord) {
        if (!cacheRecord) {
            throw ClientAuthError.createNullOrUndefinedCacheRecord();
        }
        if (!!cacheRecord.account) {
            this.setAccount(cacheRecord.account);
        }
        if (!!cacheRecord.idToken) {
            this.setIdTokenCredential(cacheRecord.idToken);
        }
        if (!!cacheRecord.accessToken) {
            this.saveAccessToken(cacheRecord.accessToken);
        }
        if (!!cacheRecord.refreshToken) {
            this.setRefreshTokenCredential(cacheRecord.refreshToken);
        }
        if (!!cacheRecord.appMetadata) {
            this.setAppMetadata(cacheRecord.appMetadata);
        }
    };
    /**
     * saves access token credential
     * @param credential
     */
    CacheManager.prototype.saveAccessToken = function (credential) {
        var _this = this;
        var currentTokenCache = this.getCredentialsFilteredBy({
            clientId: credential.clientId,
            credentialType: CredentialType.ACCESS_TOKEN,
            environment: credential.environment,
            homeAccountId: credential.homeAccountId,
            realm: credential.realm,
        });
        var currentScopes = ScopeSet.fromString(credential.target);
        var currentAccessTokens = Object.keys(currentTokenCache.accessTokens).map(function (key) { return currentTokenCache.accessTokens[key]; });
        if (currentAccessTokens) {
            currentAccessTokens.forEach(function (tokenEntity) {
                var tokenScopeSet = ScopeSet.fromString(tokenEntity.target);
                if (tokenScopeSet.intersectingScopeSets(currentScopes)) {
                    _this.removeCredential(tokenEntity);
                }
            });
        }
        this.setAccessTokenCredential(credential);
    };
    /**
     * retrieve accounts matching all provided filters; if no filter is set, get all accounts
     * not checking for casing as keys are all generated in lower case, remember to convert to lower case if object properties are compared
     * @param homeAccountId
     * @param environment
     * @param realm
     */
    CacheManager.prototype.getAccountsFilteredBy = function (accountFilter) {
        return this.getAccountsFilteredByInternal(accountFilter ? accountFilter.homeAccountId : "", accountFilter ? accountFilter.environment : "", accountFilter ? accountFilter.realm : "");
    };
    /**
     * retrieve accounts matching all provided filters; if no filter is set, get all accounts
     * not checking for casing as keys are all generated in lower case, remember to convert to lower case if object properties are compared
     * @param homeAccountId
     * @param environment
     * @param realm
     */
    CacheManager.prototype.getAccountsFilteredByInternal = function (homeAccountId, environment, realm) {
        var _this = this;
        var allCacheKeys = this.getKeys();
        var matchingAccounts = {};
        allCacheKeys.forEach(function (cacheKey) {
            var entity = _this.getAccount(cacheKey);
            if (!entity) {
                return null;
            }
            if (!StringUtils.isEmpty(homeAccountId) && !_this.matchHomeAccountId(entity, homeAccountId)) {
                return;
            }
            if (!StringUtils.isEmpty(environment) && !_this.matchEnvironment(entity, environment)) {
                return;
            }
            if (!StringUtils.isEmpty(realm) && !_this.matchRealm(entity, realm)) {
                return;
            }
            matchingAccounts[cacheKey] = entity;
        });
        return matchingAccounts;
    };
    /**
     * retrieve credentails matching all provided filters; if no filter is set, get all credentials
     * @param homeAccountId
     * @param environment
     * @param credentialType
     * @param clientId
     * @param realm
     * @param target
     */
    CacheManager.prototype.getCredentialsFilteredBy = function (filter) {
        return this.getCredentialsFilteredByInternal(filter.homeAccountId, filter.environment, filter.credentialType, filter.clientId, filter.familyId, filter.realm, filter.target, filter.oboAssertion);
    };
    /**
     * Support function to help match credentials
     * @param homeAccountId
     * @param environment
     * @param credentialType
     * @param clientId
     * @param realm
     * @param target
     */
    CacheManager.prototype.getCredentialsFilteredByInternal = function (homeAccountId, environment, credentialType, clientId, familyId, realm, target, oboAssertion) {
        var _this = this;
        var allCacheKeys = this.getKeys();
        var matchingCredentials = {
            idTokens: {},
            accessTokens: {},
            refreshTokens: {},
        };
        allCacheKeys.forEach(function (cacheKey) {
            // don't parse any non-credential type cache entities
            var credType = CredentialEntity.getCredentialType(cacheKey);
            if (credType === Constants.NOT_DEFINED) {
                return;
            }
            // Attempt retrieval
            var entity = _this.getSpecificCredential(cacheKey, credType);
            if (!entity) {
                return;
            }
            if (!StringUtils.isEmpty(oboAssertion) && !_this.matchOboAssertion(entity, oboAssertion)) {
                return;
            }
            if (!StringUtils.isEmpty(homeAccountId) && !_this.matchHomeAccountId(entity, homeAccountId)) {
                return;
            }
            if (!StringUtils.isEmpty(environment) && !_this.matchEnvironment(entity, environment)) {
                return;
            }
            if (!StringUtils.isEmpty(realm) && !_this.matchRealm(entity, realm)) {
                return;
            }
            if (!StringUtils.isEmpty(credentialType) && !_this.matchCredentialType(entity, credentialType)) {
                return;
            }
            if (!StringUtils.isEmpty(clientId) && !_this.matchClientId(entity, clientId)) {
                return;
            }
            if (!StringUtils.isEmpty(familyId) && !_this.matchFamilyId(entity, familyId)) {
                return;
            }
            /*
             * idTokens do not have "target", target specific refreshTokens do exist for some types of authentication
             * Resource specific refresh tokens case will be added when the support is deemed necessary
             */
            if (!StringUtils.isEmpty(target) && !_this.matchTarget(entity, target)) {
                return;
            }
            switch (credType) {
                case CredentialType.ID_TOKEN:
                    matchingCredentials.idTokens[cacheKey] = entity;
                    break;
                case CredentialType.ACCESS_TOKEN:
                    matchingCredentials.accessTokens[cacheKey] = entity;
                    break;
                case CredentialType.REFRESH_TOKEN:
                    matchingCredentials.refreshTokens[cacheKey] = entity;
                    break;
            }
        });
        return matchingCredentials;
    };
    /**
     * retrieve appMetadata matching all provided filters; if no filter is set, get all appMetadata
     * @param filter
     */
    CacheManager.prototype.getAppMetadataFilteredBy = function (filter) {
        return this.getAppMetadataFilteredByInternal(filter.environment, filter.clientId);
    };
    /**
     * Support function to help match appMetadata
     * @param environment
     * @param clientId
     */
    CacheManager.prototype.getAppMetadataFilteredByInternal = function (environment, clientId) {
        var _this = this;
        var allCacheKeys = this.getKeys();
        var matchingAppMetadata = {};
        allCacheKeys.forEach(function (cacheKey) {
            // don't parse any non-appMetadata type cache entities
            if (!_this.isAppMetadata(cacheKey)) {
                return;
            }
            // Attempt retrieval
            var entity = _this.getAppMetadata(cacheKey);
            if (!entity) {
                return;
            }
            if (!StringUtils.isEmpty(environment) && !_this.matchEnvironment(entity, environment)) {
                return;
            }
            if (!StringUtils.isEmpty(clientId) && !_this.matchClientId(entity, clientId)) {
                return;
            }
            matchingAppMetadata[cacheKey] = entity;
        });
        return matchingAppMetadata;
    };
    /**
     * Removes all accounts and related tokens from cache.
     */
    CacheManager.prototype.removeAllAccounts = function () {
        var _this = this;
        var allCacheKeys = this.getKeys();
        allCacheKeys.forEach(function (cacheKey) {
            var entity = _this.getAccount(cacheKey);
            if (!entity) {
                return;
            }
            _this.removeAccount(cacheKey);
        });
        return true;
    };
    /**
     * returns a boolean if the given account is removed
     * @param account
     */
    CacheManager.prototype.removeAccount = function (accountKey) {
        var account = this.getAccount(accountKey);
        if (!account) {
            throw ClientAuthError.createNoAccountFoundError();
        }
        return (this.removeAccountContext(account) && this.removeItem(accountKey, CacheSchemaType.ACCOUNT));
    };
    /**
     * returns a boolean if the given account is removed
     * @param account
     */
    CacheManager.prototype.removeAccountContext = function (account) {
        var _this = this;
        var allCacheKeys = this.getKeys();
        var accountId = account.generateAccountId();
        allCacheKeys.forEach(function (cacheKey) {
            // don't parse any non-credential type cache entities
            var credType = CredentialEntity.getCredentialType(cacheKey);
            if (credType === Constants.NOT_DEFINED) {
                return;
            }
            var cacheEntity = _this.getSpecificCredential(cacheKey, credType);
            if (!!cacheEntity && accountId === cacheEntity.generateAccountId()) {
                _this.removeCredential(cacheEntity);
            }
        });
        return true;
    };
    /**
     * returns a boolean if the given credential is removed
     * @param credential
     */
    CacheManager.prototype.removeCredential = function (credential) {
        var key = credential.generateCredentialKey();
        return this.removeItem(key, CacheSchemaType.CREDENTIAL);
    };
    /**
     * Removes all app metadata objects from cache.
     */
    CacheManager.prototype.removeAppMetadata = function () {
        var _this = this;
        var allCacheKeys = this.getKeys();
        allCacheKeys.forEach(function (cacheKey) {
            if (_this.isAppMetadata(cacheKey)) {
                _this.removeItem(cacheKey, CacheSchemaType.APP_METADATA);
            }
        });
        return true;
    };
    /**
     * Retrieve the cached credentials into a cacherecord
     * @param account
     * @param clientId
     * @param scopes
     * @param environment
     */
    CacheManager.prototype.readCacheRecord = function (account, clientId, scopes, environment) {
        var cachedAccount = this.readAccountFromCache(account);
        var cachedIdToken = this.readIdTokenFromCache(clientId, account);
        var cachedAccessToken = this.readAccessTokenFromCache(clientId, account, scopes);
        var cachedRefreshToken = this.readRefreshTokenFromCache(clientId, account, false);
        var cachedAppMetadata = this.readAppMetadataFromCache(environment, clientId);
        return {
            account: cachedAccount,
            idToken: cachedIdToken,
            accessToken: cachedAccessToken,
            refreshToken: cachedRefreshToken,
            appMetadata: cachedAppMetadata,
        };
    };
    /**
     * Retrieve AccountEntity from cache
     * @param account
     */
    CacheManager.prototype.readAccountFromCache = function (account) {
        var accountKey = AccountEntity.generateAccountCacheKey(account);
        return this.getAccount(accountKey);
    };
    /**
     * Retrieve IdTokenEntity from cache
     * @param clientId
     * @param account
     * @param inputRealm
     */
    CacheManager.prototype.readIdTokenFromCache = function (clientId, account) {
        var idTokenFilter = {
            homeAccountId: account.homeAccountId,
            environment: account.environment,
            credentialType: CredentialType.ID_TOKEN,
            clientId: clientId,
            realm: account.tenantId,
        };
        var credentialCache = this.getCredentialsFilteredBy(idTokenFilter);
        var idTokens = Object.keys(credentialCache.idTokens).map(function (key) { return credentialCache.idTokens[key]; });
        var numIdTokens = idTokens.length;
        if (numIdTokens < 1) {
            return null;
        }
        else if (numIdTokens > 1) {
            throw ClientAuthError.createMultipleMatchingTokensInCacheError();
        }
        return idTokens[0];
    };
    /**
     * Retrieve AccessTokenEntity from cache
     * @param clientId
     * @param account
     * @param scopes
     * @param inputRealm
     */
    CacheManager.prototype.readAccessTokenFromCache = function (clientId, account, scopes) {
        var accessTokenFilter = {
            homeAccountId: account.homeAccountId,
            environment: account.environment,
            credentialType: CredentialType.ACCESS_TOKEN,
            clientId: clientId,
            realm: account.tenantId,
            target: scopes.printScopesLowerCase(),
        };
        var credentialCache = this.getCredentialsFilteredBy(accessTokenFilter);
        var accessTokens = Object.keys(credentialCache.accessTokens).map(function (key) { return credentialCache.accessTokens[key]; });
        var numAccessTokens = accessTokens.length;
        if (numAccessTokens < 1) {
            return null;
        }
        else if (numAccessTokens > 1) {
            throw ClientAuthError.createMultipleMatchingTokensInCacheError();
        }
        return accessTokens[0];
    };
    /**
     * Helper to retrieve the appropriate refresh token from cache
     * @param clientId
     * @param account
     * @param familyRT
     */
    CacheManager.prototype.readRefreshTokenFromCache = function (clientId, account, familyRT) {
        var id = familyRT ? THE_FAMILY_ID : null;
        var refreshTokenFilter = {
            homeAccountId: account.homeAccountId,
            environment: account.environment,
            credentialType: CredentialType.REFRESH_TOKEN,
            clientId: clientId,
            familyId: id
        };
        var credentialCache = this.getCredentialsFilteredBy(refreshTokenFilter);
        var refreshTokens = Object.keys(credentialCache.refreshTokens).map(function (key) { return credentialCache.refreshTokens[key]; });
        var numRefreshTokens = refreshTokens.length;
        if (numRefreshTokens < 1) {
            return null;
        }
        // address the else case after remove functions address environment aliases
        return refreshTokens[0];
    };
    /**
     * Retrieve AppMetadataEntity from cache
     */
    CacheManager.prototype.readAppMetadataFromCache = function (environment, clientId) {
        var appMetadataFilter = {
            environment: environment,
            clientId: clientId,
        };
        var appMetadata = this.getAppMetadataFilteredBy(appMetadataFilter);
        var appMetadataEntries = Object.keys(appMetadata).map(function (key) { return appMetadata[key]; });
        var numAppMetadata = appMetadataEntries.length;
        if (numAppMetadata < 1) {
            return null;
        }
        else if (numAppMetadata > 1) {
            throw ClientAuthError.createMultipleMatchingAppMetadataInCacheError();
        }
        return appMetadataEntries[0];
    };
    /**
     * Return the family_id value associated  with FOCI
     * @param environment
     * @param clientId
     */
    CacheManager.prototype.isAppMetadataFOCI = function (environment, clientId) {
        var appMetadata = this.readAppMetadataFromCache(environment, clientId);
        return appMetadata && appMetadata.familyId === THE_FAMILY_ID;
    };
    /**
     * helper to match account ids
     * @param value
     * @param homeAccountId
     */
    CacheManager.prototype.matchHomeAccountId = function (entity, homeAccountId) {
        return entity.homeAccountId && homeAccountId === entity.homeAccountId;
    };
    /**
     * helper to match assertion
     * @param value
     * @param oboAssertion
     */
    CacheManager.prototype.matchOboAssertion = function (entity, oboAssertion) {
        return entity.oboAssertion && oboAssertion === entity.oboAssertion;
    };
    /**
     * helper to match environment
     * @param value
     * @param environment
     */
    CacheManager.prototype.matchEnvironment = function (entity, environment) {
        var cloudMetadata = TrustedAuthority.getCloudDiscoveryMetadata(environment);
        if (cloudMetadata && cloudMetadata.aliases.indexOf(entity.environment) > -1) {
            return true;
        }
        return false;
    };
    /**
     * helper to match credential type
     * @param entity
     * @param credentialType
     */
    CacheManager.prototype.matchCredentialType = function (entity, credentialType) {
        return (entity.credentialType && credentialType.toLowerCase() === entity.credentialType.toLowerCase());
    };
    /**
     * helper to match client ids
     * @param entity
     * @param clientId
     */
    CacheManager.prototype.matchClientId = function (entity, clientId) {
        return entity.clientId && clientId === entity.clientId;
    };
    /**
     * helper to match family ids
     * @param entity
     * @param familyId
     */
    CacheManager.prototype.matchFamilyId = function (entity, familyId) {
        return entity.familyId && familyId === entity.familyId;
    };
    /**
     * helper to match realm
     * @param entity
     * @param realm
     */
    CacheManager.prototype.matchRealm = function (entity, realm) {
        return entity.realm && realm === entity.realm;
    };
    /**
     * Returns true if the target scopes are a subset of the current entity's scopes, false otherwise.
     * @param entity
     * @param target
     */
    CacheManager.prototype.matchTarget = function (entity, target) {
        if (entity.credentialType !== CredentialType.ACCESS_TOKEN || StringUtils.isEmpty(entity.target)) {
            return false;
        }
        var entityScopeSet = ScopeSet.fromString(entity.target);
        var requestTargetScopeSet = ScopeSet.fromString(target);
        if (!requestTargetScopeSet.containsOnlyDefaultScopes()) {
            requestTargetScopeSet.removeDefaultScopes(); // ignore default scopes
        }
        return entityScopeSet.containsScopeSet(requestTargetScopeSet);
    };
    /**
     * returns if a given cache entity is of the type appmetadata
     * @param key
     */
    CacheManager.prototype.isAppMetadata = function (key) {
        return key.indexOf(APP_METADATA) !== -1;
    };
    /**
     * Returns the specific credential (IdToken/AccessToken/RefreshToken) from the cache
     * @param key
     * @param credType
     */
    CacheManager.prototype.getSpecificCredential = function (key, credType) {
        switch (credType) {
            case CredentialType.ID_TOKEN: {
                return this.getIdTokenCredential(key);
            }
            case CredentialType.ACCESS_TOKEN: {
                return this.getAccessTokenCredential(key);
            }
            case CredentialType.REFRESH_TOKEN: {
                return this.getRefreshTokenCredential(key);
            }
            default:
                return null;
        }
    };
    /**
     * Helper to convert serialized data to object
     * @param obj
     * @param json
     */
    CacheManager.toObject = function (obj, json) {
        for (var propertyName in json) {
            obj[propertyName] = json[propertyName];
        }
        return obj;
    };
    return CacheManager;
}());
var DefaultStorageClass = /** @class */ (function (_super) {
    __extends(DefaultStorageClass, _super);
    function DefaultStorageClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    DefaultStorageClass.prototype.setAccount = function () {
        var notImplErr = "Storage interface - setAccount() has not been implemented for the cacheStorage interface.";
        throw AuthError.createUnexpectedError(notImplErr);
    };
    DefaultStorageClass.prototype.getAccount = function () {
        var notImplErr = "Storage interface - getAccount() has not been implemented for the cacheStorage interface.";
        throw AuthError.createUnexpectedError(notImplErr);
    };
    DefaultStorageClass.prototype.setIdTokenCredential = function () {
        var notImplErr = "Storage interface - setIdTokenCredential() has not been implemented for the cacheStorage interface.";
        throw AuthError.createUnexpectedError(notImplErr);
    };
    DefaultStorageClass.prototype.getIdTokenCredential = function () {
        var notImplErr = "Storage interface - getIdTokenCredential() has not been implemented for the cacheStorage interface.";
        throw AuthError.createUnexpectedError(notImplErr);
    };
    DefaultStorageClass.prototype.setAccessTokenCredential = function () {
        var notImplErr = "Storage interface - setAccessTokenCredential() has not been implemented for the cacheStorage interface.";
        throw AuthError.createUnexpectedError(notImplErr);
    };
    DefaultStorageClass.prototype.getAccessTokenCredential = function () {
        var notImplErr = "Storage interface - getAccessTokenCredential() has not been implemented for the cacheStorage interface.";
        throw AuthError.createUnexpectedError(notImplErr);
    };
    DefaultStorageClass.prototype.setRefreshTokenCredential = function () {
        var notImplErr = "Storage interface - setRefreshTokenCredential() has not been implemented for the cacheStorage interface.";
        throw AuthError.createUnexpectedError(notImplErr);
    };
    DefaultStorageClass.prototype.getRefreshTokenCredential = function () {
        var notImplErr = "Storage interface - getRefreshTokenCredential() has not been implemented for the cacheStorage interface.";
        throw AuthError.createUnexpectedError(notImplErr);
    };
    DefaultStorageClass.prototype.setAppMetadata = function () {
        var notImplErr = "Storage interface - setAppMetadata() has not been implemented for the cacheStorage interface.";
        throw AuthError.createUnexpectedError(notImplErr);
    };
    DefaultStorageClass.prototype.getAppMetadata = function () {
        var notImplErr = "Storage interface - getAppMetadata() has not been implemented for the cacheStorage interface.";
        throw AuthError.createUnexpectedError(notImplErr);
    };
    DefaultStorageClass.prototype.setServerTelemetry = function () {
        var notImplErr = "Storage interface - setServerTelemetry() has not been implemented for the cacheStorage interface.";
        throw AuthError.createUnexpectedError(notImplErr);
    };
    DefaultStorageClass.prototype.getServerTelemetry = function () {
        var notImplErr = "Storage interface - getServerTelemetry() has not been implemented for the cacheStorage interface.";
        throw AuthError.createUnexpectedError(notImplErr);
    };
    DefaultStorageClass.prototype.setThrottlingCache = function () {
        var notImplErr = "Storage interface - setThrottlingCache() has not been implemented for the cacheStorage interface.";
        throw AuthError.createUnexpectedError(notImplErr);
    };
    DefaultStorageClass.prototype.getThrottlingCache = function () {
        var notImplErr = "Storage interface - getThrottlingCache() has not been implemented for the cacheStorage interface.";
        throw AuthError.createUnexpectedError(notImplErr);
    };
    DefaultStorageClass.prototype.removeItem = function () {
        var notImplErr = "Storage interface - removeItem() has not been implemented for the cacheStorage interface.";
        throw AuthError.createUnexpectedError(notImplErr);
    };
    DefaultStorageClass.prototype.containsKey = function () {
        var notImplErr = "Storage interface - containsKey() has not been implemented for the cacheStorage interface.";
        throw AuthError.createUnexpectedError(notImplErr);
    };
    DefaultStorageClass.prototype.getKeys = function () {
        var notImplErr = "Storage interface - getKeys() has not been implemented for the cacheStorage interface.";
        throw AuthError.createUnexpectedError(notImplErr);
    };
    DefaultStorageClass.prototype.clear = function () {
        var notImplErr = "Storage interface - clear() has not been implemented for the cacheStorage interface.";
        throw AuthError.createUnexpectedError(notImplErr);
    };
    return DefaultStorageClass;
}(CacheManager));

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
// Token renewal offset default in seconds
var DEFAULT_TOKEN_RENEWAL_OFFSET_SEC = 300;
var DEFAULT_AUTH_OPTIONS = {
    clientId: "",
    authority: null,
    knownAuthorities: [],
    cloudDiscoveryMetadata: "",
    clientCapabilities: [],
    protocolMode: ProtocolMode.AAD
};
var DEFAULT_SYSTEM_OPTIONS = {
    tokenRenewalOffsetSeconds: DEFAULT_TOKEN_RENEWAL_OFFSET_SEC
};
var DEFAULT_LOGGER_IMPLEMENTATION = {
    loggerCallback: function () {
        // allow users to not set loggerCallback
    },
    piiLoggingEnabled: false,
    logLevel: LogLevel.Info
};
var DEFAULT_NETWORK_IMPLEMENTATION = {
    sendGetRequestAsync: function () {
        return __awaiter(this, void 0, void 0, function () {
            var notImplErr;
            return __generator(this, function (_a) {
                notImplErr = "Network interface - sendGetRequestAsync() has not been implemented";
                throw AuthError.createUnexpectedError(notImplErr);
            });
        });
    },
    sendPostRequestAsync: function () {
        return __awaiter(this, void 0, void 0, function () {
            var notImplErr;
            return __generator(this, function (_a) {
                notImplErr = "Network interface - sendPostRequestAsync() has not been implemented";
                throw AuthError.createUnexpectedError(notImplErr);
            });
        });
    }
};
var DEFAULT_CRYPTO_IMPLEMENTATION = {
    createNewGuid: function () {
        var notImplErr = "Crypto interface - createNewGuid() has not been implemented";
        throw AuthError.createUnexpectedError(notImplErr);
    },
    base64Decode: function () {
        var notImplErr = "Crypto interface - base64Decode() has not been implemented";
        throw AuthError.createUnexpectedError(notImplErr);
    },
    base64Encode: function () {
        var notImplErr = "Crypto interface - base64Encode() has not been implemented";
        throw AuthError.createUnexpectedError(notImplErr);
    },
    generatePkceCodes: function () {
        return __awaiter(this, void 0, void 0, function () {
            var notImplErr;
            return __generator(this, function (_a) {
                notImplErr = "Crypto interface - generatePkceCodes() has not been implemented";
                throw AuthError.createUnexpectedError(notImplErr);
            });
        });
    },
    getPublicKeyThumbprint: function () {
        return __awaiter(this, void 0, void 0, function () {
            var notImplErr;
            return __generator(this, function (_a) {
                notImplErr = "Crypto interface - getPublicKeyThumbprint() has not been implemented";
                throw AuthError.createUnexpectedError(notImplErr);
            });
        });
    },
    signJwt: function () {
        return __awaiter(this, void 0, void 0, function () {
            var notImplErr;
            return __generator(this, function (_a) {
                notImplErr = "Crypto interface - signJwt() has not been implemented";
                throw AuthError.createUnexpectedError(notImplErr);
            });
        });
    }
};
var DEFAULT_LIBRARY_INFO = {
    sku: Constants.SKU,
    version: version,
    cpu: "",
    os: ""
};
var DEFAULT_CLIENT_CREDENTIALS = {
    clientSecret: "",
    clientAssertion: null
};
/**
 * Function that sets the default options when not explicitly configured from app developer
 *
 * @param Configuration
 *
 * @returns Configuration
 */
function buildClientConfiguration(_a) {
    var userAuthOptions = _a.authOptions, userSystemOptions = _a.systemOptions, userLoggerOption = _a.loggerOptions, storageImplementation = _a.storageInterface, networkImplementation = _a.networkInterface, cryptoImplementation = _a.cryptoInterface, clientCredentials = _a.clientCredentials, libraryInfo = _a.libraryInfo, serverTelemetryManager = _a.serverTelemetryManager, persistencePlugin = _a.persistencePlugin, serializableCache = _a.serializableCache;
    return {
        authOptions: __assign(__assign({}, DEFAULT_AUTH_OPTIONS), userAuthOptions),
        systemOptions: __assign(__assign({}, DEFAULT_SYSTEM_OPTIONS), userSystemOptions),
        loggerOptions: __assign(__assign({}, DEFAULT_LOGGER_IMPLEMENTATION), userLoggerOption),
        storageInterface: storageImplementation || new DefaultStorageClass(),
        networkInterface: networkImplementation || DEFAULT_NETWORK_IMPLEMENTATION,
        cryptoInterface: cryptoImplementation || DEFAULT_CRYPTO_IMPLEMENTATION,
        clientCredentials: clientCredentials || DEFAULT_CLIENT_CREDENTIALS,
        libraryInfo: __assign(__assign({}, DEFAULT_LIBRARY_INFO), libraryInfo),
        serverTelemetryManager: serverTelemetryManager || null,
        persistencePlugin: persistencePlugin || null,
        serializableCache: serializableCache || null
    };
}

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * Error thrown when there is an error with the server code, for example, unavailability.
 */
var ServerError = /** @class */ (function (_super) {
    __extends(ServerError, _super);
    function ServerError(errorCode, errorMessage, subError) {
        var _this = _super.call(this, errorCode, errorMessage) || this;
        _this.name = "ServerError";
        _this.subError = subError;
        Object.setPrototypeOf(_this, ServerError.prototype);
        return _this;
    }
    return ServerError;
}(AuthError));

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
var ThrottlingUtils = /** @class */ (function () {
    function ThrottlingUtils() {
    }
    /**
     * Prepares a RequestThumbprint to be stored as a key.
     * @param thumbprint
     */
    ThrottlingUtils.generateThrottlingStorageKey = function (thumbprint) {
        return ThrottlingConstants.THROTTLING_PREFIX + "." + JSON.stringify(thumbprint);
    };
    /**
     * Performs necessary throttling checks before a network request.
     * @param cacheManager
     * @param thumbprint
     */
    ThrottlingUtils.preProcess = function (cacheManager, thumbprint) {
        var key = ThrottlingUtils.generateThrottlingStorageKey(thumbprint);
        var value = cacheManager.getThrottlingCache(key);
        if (value) {
            if (value.throttleTime < Date.now()) {
                cacheManager.removeItem(key, CacheSchemaType.THROTTLING);
                return;
            }
            throw new ServerError(value.errorCodes.join(" "), value.errorMessage, value.subError);
        }
    };
    /**
     * Performs necessary throttling checks after a network request.
     * @param cacheManager
     * @param thumbprint
     * @param response
     */
    ThrottlingUtils.postProcess = function (cacheManager, thumbprint, response) {
        if (ThrottlingUtils.checkResponseStatus(response) || ThrottlingUtils.checkResponseForRetryAfter(response)) {
            var thumbprintValue = {
                throttleTime: ThrottlingUtils.calculateThrottleTime(parseInt(response.headers[HeaderNames.RETRY_AFTER])),
                error: response.body.error,
                errorCodes: response.body.error_codes,
                errorMessage: response.body.error_description,
                subError: response.body.suberror
            };
            cacheManager.setThrottlingCache(ThrottlingUtils.generateThrottlingStorageKey(thumbprint), thumbprintValue);
        }
    };
    /**
     * Checks a NetworkResponse object's status codes against 429 or 5xx
     * @param response
     */
    ThrottlingUtils.checkResponseStatus = function (response) {
        return response.status == 429 || response.status >= 500 && response.status < 600;
    };
    /**
     * Checks a NetworkResponse object's RetryAfter header
     * @param response
     */
    ThrottlingUtils.checkResponseForRetryAfter = function (response) {
        if (response.headers) {
            return response.headers.hasOwnProperty(HeaderNames.RETRY_AFTER) && (response.status < 200 || response.status >= 300);
        }
        return false;
    };
    /**
     * Calculates the Unix-time value for a throttle to expire given throttleTime in seconds.
     * @param throttleTime
     */
    ThrottlingUtils.calculateThrottleTime = function (throttleTime) {
        if (throttleTime <= 0) {
            throttleTime = null;
        }
        var currentSeconds = Date.now() / 1000;
        return Math.floor(Math.min(currentSeconds + (throttleTime || ThrottlingConstants.DEFAULT_THROTTLE_TIME_SECONDS), currentSeconds + ThrottlingConstants.DEFAULT_MAX_THROTTLE_TIME_SECONDS) * 1000);
    };
    ThrottlingUtils.removeThrottle = function (cacheManager, clientId, authority, scopes, homeAccountIdentifier) {
        var thumbprint = {
            clientId: clientId,
            authority: authority,
            scopes: scopes,
            homeAccountIdentifier: homeAccountIdentifier
        };
        var key = this.generateThrottlingStorageKey(thumbprint);
        return cacheManager.removeItem(key, CacheSchemaType.THROTTLING);
    };
    return ThrottlingUtils;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
var NetworkManager = /** @class */ (function () {
    function NetworkManager(networkClient, cacheManager) {
        this.networkClient = networkClient;
        this.cacheManager = cacheManager;
    }
    /**
     * Wraps sendPostRequestAsync with necessary preflight and postflight logic
     * @param thumbprint
     * @param tokenEndpoint
     * @param options
     */
    NetworkManager.prototype.sendPostRequest = function (thumbprint, tokenEndpoint, options) {
        return __awaiter(this, void 0, void 0, function () {
            var response;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        ThrottlingUtils.preProcess(this.cacheManager, thumbprint);
                        return [4 /*yield*/, this.networkClient.sendPostRequestAsync(tokenEndpoint, options)];
                    case 1:
                        response = _a.sent();
                        ThrottlingUtils.postProcess(this.cacheManager, thumbprint, response);
                        // Placeholder for Telemetry hook
                        return [2 /*return*/, response];
                }
            });
        });
    };
    return NetworkManager;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * Base application class which will construct requests to send to and handle responses from the Microsoft STS using the authorization code flow.
 */
var BaseClient = /** @class */ (function () {
    function BaseClient(configuration) {
        // Set the configuration
        this.config = buildClientConfiguration(configuration);
        // Initialize the logger
        this.logger = new Logger(this.config.loggerOptions);
        // Initialize crypto
        this.cryptoUtils = this.config.cryptoInterface;
        // Initialize storage interface
        this.cacheManager = this.config.storageInterface;
        // Set the network interface
        this.networkClient = this.config.networkInterface;
        // Set the NetworkManager
        this.networkManager = new NetworkManager(this.networkClient, this.cacheManager);
        // Set TelemetryManager
        this.serverTelemetryManager = this.config.serverTelemetryManager;
        TrustedAuthority.setTrustedAuthoritiesFromConfig(this.config.authOptions.knownAuthorities, this.config.authOptions.cloudDiscoveryMetadata);
        this.authority = this.config.authOptions.authority;
    }
    /**
     * Creates default headers for requests to token endpoint
     */
    BaseClient.prototype.createDefaultTokenRequestHeaders = function () {
        var headers = this.createDefaultLibraryHeaders();
        headers[HeaderNames.CONTENT_TYPE] = Constants.URL_FORM_CONTENT_TYPE;
        headers[HeaderNames.X_MS_LIB_CAPABILITY] = HeaderNames.X_MS_LIB_CAPABILITY_VALUE;
        if (this.serverTelemetryManager) {
            headers[HeaderNames.X_CLIENT_CURR_TELEM] = this.serverTelemetryManager.generateCurrentRequestHeaderValue();
            headers[HeaderNames.X_CLIENT_LAST_TELEM] = this.serverTelemetryManager.generateLastRequestHeaderValue();
        }
        return headers;
    };
    /**
     * addLibraryData
     */
    BaseClient.prototype.createDefaultLibraryHeaders = function () {
        var headers = {};
        // client info headers
        headers[AADServerParamKeys.X_CLIENT_SKU] = this.config.libraryInfo.sku;
        headers[AADServerParamKeys.X_CLIENT_VER] = this.config.libraryInfo.version;
        headers[AADServerParamKeys.X_CLIENT_OS] = this.config.libraryInfo.os;
        headers[AADServerParamKeys.X_CLIENT_CPU] = this.config.libraryInfo.cpu;
        return headers;
    };
    /**
     * Http post to token endpoint
     * @param tokenEndpoint
     * @param queryString
     * @param headers
     * @param thumbprint
     */
    BaseClient.prototype.executePostToTokenEndpoint = function (tokenEndpoint, queryString, headers, thumbprint) {
        return __awaiter(this, void 0, void 0, function () {
            var response;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.networkManager.sendPostRequest(thumbprint, tokenEndpoint, { body: queryString, headers: headers })];
                    case 1:
                        response = _a.sent();
                        if (this.config.serverTelemetryManager && response.status < 500 && response.status !== 429) {
                            // Telemetry data successfully logged by server, clear Telemetry cache
                            this.config.serverTelemetryManager.clearTelemetryCache();
                        }
                        return [2 /*return*/, response];
                }
            });
        });
    };
    return BaseClient;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * Validates server consumable params from the "request" objects
 */
var RequestValidator = /** @class */ (function () {
    function RequestValidator() {
    }
    /**
     * Utility to check if the `redirectUri` in the request is a non-null value
     * @param redirectUri
     */
    RequestValidator.validateRedirectUri = function (redirectUri) {
        if (StringUtils.isEmpty(redirectUri)) {
            throw ClientConfigurationError.createRedirectUriEmptyError();
        }
    };
    /**
     * Utility to validate prompt sent by the user in the request
     * @param prompt
     */
    RequestValidator.validatePrompt = function (prompt) {
        if ([
            PromptValue.LOGIN,
            PromptValue.SELECT_ACCOUNT,
            PromptValue.CONSENT,
            PromptValue.NONE
        ].indexOf(prompt) < 0) {
            throw ClientConfigurationError.createInvalidPromptError(prompt);
        }
    };
    RequestValidator.validateClaims = function (claims) {
        try {
            JSON.parse(claims);
        }
        catch (e) {
            throw ClientConfigurationError.createInvalidClaimsRequestError();
        }
    };
    /**
     * Utility to validate code_challenge and code_challenge_method
     * @param codeChallenge
     * @param codeChallengeMethod
     */
    RequestValidator.validateCodeChallengeParams = function (codeChallenge, codeChallengeMethod) {
        if (StringUtils.isEmpty(codeChallenge) || StringUtils.isEmpty(codeChallengeMethod)) {
            throw ClientConfigurationError.createInvalidCodeChallengeParamsError();
        }
        else {
            this.validateCodeChallengeMethod(codeChallengeMethod);
        }
    };
    /**
     * Utility to validate code_challenge_method
     * @param codeChallengeMethod
     */
    RequestValidator.validateCodeChallengeMethod = function (codeChallengeMethod) {
        if ([
            CodeChallengeMethodValues.PLAIN,
            CodeChallengeMethodValues.S256
        ].indexOf(codeChallengeMethod) < 0) {
            throw ClientConfigurationError.createInvalidCodeChallengeMethodError();
        }
    };
    /**
     * Removes unnecessary or duplicate query parameters from extraQueryParameters
     * @param request
     */
    RequestValidator.sanitizeEQParams = function (eQParams, queryParams) {
        if (!eQParams) {
            return null;
        }
        // Remove any query parameters already included in SSO params
        queryParams.forEach(function (value, key) {
            if (eQParams[key]) {
                delete eQParams[key];
            }
        });
        return eQParams;
    };
    return RequestValidator;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
var RequestParameterBuilder = /** @class */ (function () {
    function RequestParameterBuilder() {
        this.parameters = new Map();
    }
    /**
     * add response_type = code
     */
    RequestParameterBuilder.prototype.addResponseTypeCode = function () {
        this.parameters.set(AADServerParamKeys.RESPONSE_TYPE, encodeURIComponent(Constants.CODE_RESPONSE_TYPE));
    };
    /**
     * add response_mode. defaults to query.
     * @param responseMode
     */
    RequestParameterBuilder.prototype.addResponseMode = function (responseMode) {
        this.parameters.set(AADServerParamKeys.RESPONSE_MODE, encodeURIComponent((responseMode) ? responseMode : ResponseMode.QUERY));
    };
    /**
     * add scopes. set addOidcScopes to false to prevent default scopes in non-user scenarios
     * @param scopeSet
     * @param addOidcScopes
     */
    RequestParameterBuilder.prototype.addScopes = function (scopes, addOidcScopes) {
        if (addOidcScopes === void 0) { addOidcScopes = true; }
        var requestScopes = addOidcScopes ? __spreadArrays(scopes || [], [Constants.OPENID_SCOPE, Constants.PROFILE_SCOPE]) : scopes || [];
        var scopeSet = new ScopeSet(requestScopes);
        this.parameters.set(AADServerParamKeys.SCOPE, encodeURIComponent(scopeSet.printScopes()));
    };
    /**
     * add clientId
     * @param clientId
     */
    RequestParameterBuilder.prototype.addClientId = function (clientId) {
        this.parameters.set(AADServerParamKeys.CLIENT_ID, encodeURIComponent(clientId));
    };
    /**
     * add redirect_uri
     * @param redirectUri
     */
    RequestParameterBuilder.prototype.addRedirectUri = function (redirectUri) {
        RequestValidator.validateRedirectUri(redirectUri);
        this.parameters.set(AADServerParamKeys.REDIRECT_URI, encodeURIComponent(redirectUri));
    };
    /**
     * add domain_hint
     * @param domainHint
     */
    RequestParameterBuilder.prototype.addDomainHint = function (domainHint) {
        this.parameters.set(SSOTypes.DOMAIN_HINT, encodeURIComponent(domainHint));
    };
    /**
     * add login_hint
     * @param loginHint
     */
    RequestParameterBuilder.prototype.addLoginHint = function (loginHint) {
        this.parameters.set(SSOTypes.LOGIN_HINT, encodeURIComponent(loginHint));
    };
    /**
     * add sid
     * @param sid
     */
    RequestParameterBuilder.prototype.addSid = function (sid) {
        this.parameters.set(SSOTypes.SID, encodeURIComponent(sid));
    };
    /**
     * add claims
     * @param claims
     */
    RequestParameterBuilder.prototype.addClaims = function (claims, clientCapabilities) {
        var mergedClaims = this.addClientCapabilitiesToClaims(claims, clientCapabilities);
        RequestValidator.validateClaims(mergedClaims);
        this.parameters.set(AADServerParamKeys.CLAIMS, encodeURIComponent(mergedClaims));
    };
    /**
     * add correlationId
     * @param correlationId
     */
    RequestParameterBuilder.prototype.addCorrelationId = function (correlationId) {
        this.parameters.set(AADServerParamKeys.CLIENT_REQUEST_ID, encodeURIComponent(correlationId));
    };
    /**
     * add library info query params
     * @param libraryInfo
     */
    RequestParameterBuilder.prototype.addLibraryInfo = function (libraryInfo) {
        // Telemetry Info
        this.parameters.set(AADServerParamKeys.X_CLIENT_SKU, libraryInfo.sku);
        this.parameters.set(AADServerParamKeys.X_CLIENT_VER, libraryInfo.version);
        this.parameters.set(AADServerParamKeys.X_CLIENT_OS, libraryInfo.os);
        this.parameters.set(AADServerParamKeys.X_CLIENT_CPU, libraryInfo.cpu);
    };
    /**
     * add prompt
     * @param prompt
     */
    RequestParameterBuilder.prototype.addPrompt = function (prompt) {
        RequestValidator.validatePrompt(prompt);
        this.parameters.set("" + AADServerParamKeys.PROMPT, encodeURIComponent(prompt));
    };
    /**
     * add state
     * @param state
     */
    RequestParameterBuilder.prototype.addState = function (state) {
        if (!StringUtils.isEmpty(state)) {
            this.parameters.set(AADServerParamKeys.STATE, encodeURIComponent(state));
        }
    };
    /**
     * add nonce
     * @param nonce
     */
    RequestParameterBuilder.prototype.addNonce = function (nonce) {
        this.parameters.set(AADServerParamKeys.NONCE, encodeURIComponent(nonce));
    };
    /**
     * add code_challenge and code_challenge_method
     * - throw if either of them are not passed
     * @param codeChallenge
     * @param codeChallengeMethod
     */
    RequestParameterBuilder.prototype.addCodeChallengeParams = function (codeChallenge, codeChallengeMethod) {
        RequestValidator.validateCodeChallengeParams(codeChallenge, codeChallengeMethod);
        if (codeChallenge && codeChallengeMethod) {
            this.parameters.set(AADServerParamKeys.CODE_CHALLENGE, encodeURIComponent(codeChallenge));
            this.parameters.set(AADServerParamKeys.CODE_CHALLENGE_METHOD, encodeURIComponent(codeChallengeMethod));
        }
        else {
            throw ClientConfigurationError.createInvalidCodeChallengeParamsError();
        }
    };
    /**
     * add the `authorization_code` passed by the user to exchange for a token
     * @param code
     */
    RequestParameterBuilder.prototype.addAuthorizationCode = function (code) {
        this.parameters.set(AADServerParamKeys.CODE, encodeURIComponent(code));
    };
    /**
     * add the `authorization_code` passed by the user to exchange for a token
     * @param code
     */
    RequestParameterBuilder.prototype.addDeviceCode = function (code) {
        this.parameters.set(AADServerParamKeys.DEVICE_CODE, encodeURIComponent(code));
    };
    /**
     * add the `refreshToken` passed by the user
     * @param refreshToken
     */
    RequestParameterBuilder.prototype.addRefreshToken = function (refreshToken) {
        this.parameters.set(AADServerParamKeys.REFRESH_TOKEN, encodeURIComponent(refreshToken));
    };
    /**
     * add the `code_verifier` passed by the user to exchange for a token
     * @param codeVerifier
     */
    RequestParameterBuilder.prototype.addCodeVerifier = function (codeVerifier) {
        this.parameters.set(AADServerParamKeys.CODE_VERIFIER, encodeURIComponent(codeVerifier));
    };
    /**
     * add client_secret
     * @param clientSecret
     */
    RequestParameterBuilder.prototype.addClientSecret = function (clientSecret) {
        this.parameters.set(AADServerParamKeys.CLIENT_SECRET, encodeURIComponent(clientSecret));
    };
    /**
     * add clientAssertion for confidential client flows
     * @param clientAssertion
     */
    RequestParameterBuilder.prototype.addClientAssertion = function (clientAssertion) {
        this.parameters.set(AADServerParamKeys.CLIENT_ASSERTION, encodeURIComponent(clientAssertion));
    };
    /**
     * add clientAssertionType for confidential client flows
     * @param clientAssertionType
     */
    RequestParameterBuilder.prototype.addClientAssertionType = function (clientAssertionType) {
        this.parameters.set(AADServerParamKeys.CLIENT_ASSERTION_TYPE, encodeURIComponent(clientAssertionType));
    };
    /**
     * add OBO assertion for confidential client flows
     * @param clientAssertion
     */
    RequestParameterBuilder.prototype.addOboAssertion = function (oboAssertion) {
        this.parameters.set(AADServerParamKeys.OBO_ASSERTION, encodeURIComponent(oboAssertion));
    };
    /**
     * add grant type
     * @param grantType
     */
    RequestParameterBuilder.prototype.addRequestTokenUse = function (tokenUse) {
        this.parameters.set(AADServerParamKeys.REQUESTED_TOKEN_USE, encodeURIComponent(tokenUse));
    };
    /**
     * add grant type
     * @param grantType
     */
    RequestParameterBuilder.prototype.addGrantType = function (grantType) {
        this.parameters.set(AADServerParamKeys.GRANT_TYPE, encodeURIComponent(grantType));
    };
    /**
     * add client info
     *
     */
    RequestParameterBuilder.prototype.addClientInfo = function () {
        this.parameters.set(ClientInfo, "1");
    };
    /**
     * add extraQueryParams
     * @param eQparams
     */
    RequestParameterBuilder.prototype.addExtraQueryParameters = function (eQparams) {
        var _this = this;
        RequestValidator.sanitizeEQParams(eQparams, this.parameters);
        Object.keys(eQparams).forEach(function (key) {
            _this.parameters.set(key, eQparams[key]);
        });
    };
    RequestParameterBuilder.prototype.addClientCapabilitiesToClaims = function (claims, clientCapabilities) {
        var mergedClaims;
        // Parse provided claims into JSON object or initialize empty object
        if (StringUtils.isEmpty(claims)) {
            mergedClaims = {};
        }
        else {
            try {
                mergedClaims = JSON.parse(claims);
            }
            catch (e) {
                throw ClientConfigurationError.createInvalidClaimsRequestError();
            }
        }
        if (clientCapabilities && clientCapabilities.length > 0) {
            if (!mergedClaims.hasOwnProperty(ClaimsRequestKeys.ACCESS_TOKEN)) {
                // Add access_token key to claims object
                mergedClaims[ClaimsRequestKeys.ACCESS_TOKEN] = {};
            }
            // Add xms_cc claim with provided clientCapabilities to access_token key
            mergedClaims[ClaimsRequestKeys.ACCESS_TOKEN][ClaimsRequestKeys.XMS_CC] = {
                values: clientCapabilities
            };
        }
        return JSON.stringify(mergedClaims);
    };
    /**
     * adds `username` for Password Grant flow
     * @param username
     */
    RequestParameterBuilder.prototype.addUsername = function (username) {
        this.parameters.set(PasswordGrantConstants.username, username);
    };
    /**
     * adds `password` for Password Grant flow
     * @param password
     */
    RequestParameterBuilder.prototype.addPassword = function (password) {
        this.parameters.set(PasswordGrantConstants.password, password);
    };
    /**
     * add pop_jwk to query params
     * @param cnfString
     */
    RequestParameterBuilder.prototype.addPopToken = function (cnfString) {
        if (!StringUtils.isEmpty(cnfString)) {
            this.parameters.set(AADServerParamKeys.TOKEN_TYPE, AuthenticationScheme.POP);
            this.parameters.set(AADServerParamKeys.REQ_CNF, encodeURIComponent(cnfString));
        }
    };
    /**
     * Utility to create a URL from the params map
     */
    RequestParameterBuilder.prototype.createQueryString = function () {
        var queryParameterArray = new Array();
        this.parameters.forEach(function (value, key) {
            queryParameterArray.push(key + "=" + value);
        });
        return queryParameterArray.join("&");
    };
    return RequestParameterBuilder;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * JWT Token representation class. Parses token string and generates claims object.
 */
var AuthToken = /** @class */ (function () {
    function AuthToken(rawToken, crypto) {
        if (StringUtils.isEmpty(rawToken)) {
            throw ClientAuthError.createTokenNullOrEmptyError(rawToken);
        }
        this.rawToken = rawToken;
        this.claims = AuthToken.extractTokenClaims(rawToken, crypto);
    }
    /**
     * Extract token by decoding the rawToken
     *
     * @param encodedToken
     */
    AuthToken.extractTokenClaims = function (encodedToken, crypto) {
        // token will be decoded to get the username
        var decodedToken = StringUtils.decodeAuthToken(encodedToken);
        if (!decodedToken) {
            return null;
        }
        try {
            var base64TokenPayload = decodedToken.JWSPayload;
            // base64Decode() should throw an error if there is an issue
            var base64Decoded = crypto.base64Decode(base64TokenPayload);
            return JSON.parse(base64Decoded);
        }
        catch (err) {
            throw ClientAuthError.createTokenParsingError(err);
        }
    };
    return AuthToken;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * Utility class which exposes functions for managing date and time operations.
 */
var TimeUtils = /** @class */ (function () {
    function TimeUtils() {
    }
    /**
     * return the current time in Unix time (seconds).
     */
    TimeUtils.nowSeconds = function () {
        // Date.getTime() returns in milliseconds.
        return Math.round(new Date().getTime() / 1000.0);
    };
    /**
     * check if a token is expired based on given UTC time in seconds.
     * @param expiresOn
     */
    TimeUtils.isTokenExpired = function (expiresOn, offset) {
        // check for access token expiry
        var expirationSec = Number(expiresOn) || 0;
        var offsetCurrentTimeSec = TimeUtils.nowSeconds() + offset;
        // If current time + offset is greater than token expiration time, then token is expired.
        return (offsetCurrentTimeSec > expirationSec);
    };
    return TimeUtils;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * ID_TOKEN Cache
 *
 * Key:Value Schema:
 *
 * Key Example: uid.utid-login.microsoftonline.com-idtoken-clientId-contoso.com-
 *
 * Value Schema:
 * {
 *      homeAccountId: home account identifier for the auth scheme,
 *      environment: entity that issued the token, represented as a full host
 *      credentialType: Type of credential as a string, can be one of the following: RefreshToken, AccessToken, IdToken, Password, Cookie, Certificate, Other
 *      clientId: client ID of the application
 *      secret: Actual credential as a string
 *      realm: Full tenant or organizational identifier that the account belongs to
 * }
 */
var IdTokenEntity = /** @class */ (function (_super) {
    __extends(IdTokenEntity, _super);
    function IdTokenEntity() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Create IdTokenEntity
     * @param homeAccountId
     * @param authenticationResult
     * @param clientId
     * @param authority
     */
    IdTokenEntity.createIdTokenEntity = function (homeAccountId, environment, idToken, clientId, tenantId, oboAssertion) {
        var idTokenEntity = new IdTokenEntity();
        idTokenEntity.credentialType = CredentialType.ID_TOKEN;
        idTokenEntity.homeAccountId = homeAccountId;
        idTokenEntity.environment = environment;
        idTokenEntity.clientId = clientId;
        idTokenEntity.secret = idToken;
        idTokenEntity.realm = tenantId;
        idTokenEntity.oboAssertion = oboAssertion;
        return idTokenEntity;
    };
    /**
     * Validates an entity: checks for all expected params
     * @param entity
     */
    IdTokenEntity.isIdTokenEntity = function (entity) {
        if (!entity) {
            return false;
        }
        return (entity.hasOwnProperty("homeAccountId") &&
            entity.hasOwnProperty("environment") &&
            entity.hasOwnProperty("credentialType") &&
            entity.hasOwnProperty("realm") &&
            entity.hasOwnProperty("clientId") &&
            entity.hasOwnProperty("secret") &&
            entity["credentialType"] === CredentialType.ID_TOKEN);
    };
    return IdTokenEntity;
}(CredentialEntity));

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * ACCESS_TOKEN Credential Type
 *
 * Key:Value Schema:
 *
 * Key Example: uid.utid-login.microsoftonline.com-accesstoken-clientId-contoso.com-user.read
 *
 * Value Schema:
 * {
 *      homeAccountId: home account identifier for the auth scheme,
 *      environment: entity that issued the token, represented as a full host
 *      credentialType: Type of credential as a string, can be one of the following: RefreshToken, AccessToken, IdToken, Password, Cookie, Certificate, Other
 *      clientId: client ID of the application
 *      secret: Actual credential as a string
 *      familyId: Family ID identifier, usually only used for refresh tokens
 *      realm: Full tenant or organizational identifier that the account belongs to
 *      target: Permissions that are included in the token, or for refresh tokens, the resource identifier.
 *      cachedAt: Absolute device time when entry was created in the cache.
 *      expiresOn: Token expiry time, calculated based on current UTC time in seconds. Represented as a string.
 *      extendedExpiresOn: Additional extended expiry time until when token is valid in case of server-side outage. Represented as string in UTC seconds.
 *      keyId: used for POP and SSH tokenTypes
 *      tokenType: Type of the token issued. Usually "Bearer"
 * }
 */
var AccessTokenEntity = /** @class */ (function (_super) {
    __extends(AccessTokenEntity, _super);
    function AccessTokenEntity() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Create AccessTokenEntity
     * @param homeAccountId
     * @param environment
     * @param accessToken
     * @param clientId
     * @param tenantId
     * @param scopes
     * @param expiresOn
     * @param extExpiresOn
     */
    AccessTokenEntity.createAccessTokenEntity = function (homeAccountId, environment, accessToken, clientId, tenantId, scopes, expiresOn, extExpiresOn, tokenType, oboAssertion) {
        var atEntity = new AccessTokenEntity();
        atEntity.homeAccountId = homeAccountId;
        atEntity.credentialType = CredentialType.ACCESS_TOKEN;
        atEntity.secret = accessToken;
        var currentTime = TimeUtils.nowSeconds();
        atEntity.cachedAt = currentTime.toString();
        /*
         * Token expiry time.
         * This value should be  calculated based on the current UTC time measured locally and the value  expires_in Represented as a string in JSON.
         */
        atEntity.expiresOn = expiresOn.toString();
        atEntity.extendedExpiresOn = extExpiresOn.toString();
        atEntity.environment = environment;
        atEntity.clientId = clientId;
        atEntity.realm = tenantId;
        atEntity.target = scopes;
        atEntity.oboAssertion = oboAssertion;
        atEntity.tokenType = StringUtils.isEmpty(tokenType) ? AuthenticationScheme.BEARER : tokenType;
        return atEntity;
    };
    /**
     * Validates an entity: checks for all expected params
     * @param entity
     */
    AccessTokenEntity.isAccessTokenEntity = function (entity) {
        if (!entity) {
            return false;
        }
        return (entity.hasOwnProperty("homeAccountId") &&
            entity.hasOwnProperty("environment") &&
            entity.hasOwnProperty("credentialType") &&
            entity.hasOwnProperty("realm") &&
            entity.hasOwnProperty("clientId") &&
            entity.hasOwnProperty("secret") &&
            entity.hasOwnProperty("target") &&
            entity["credentialType"] === CredentialType.ACCESS_TOKEN);
    };
    return AccessTokenEntity;
}(CredentialEntity));

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * REFRESH_TOKEN Cache
 *
 * Key:Value Schema:
 *
 * Key Example: uid.utid-login.microsoftonline.com-refreshtoken-clientId--
 *
 * Value:
 * {
 *      homeAccountId: home account identifier for the auth scheme,
 *      environment: entity that issued the token, represented as a full host
 *      credentialType: Type of credential as a string, can be one of the following: RefreshToken, AccessToken, IdToken, Password, Cookie, Certificate, Other
 *      clientId: client ID of the application
 *      secret: Actual credential as a string
 *      familyId: Family ID identifier, '1' represents Microsoft Family
 *      realm: Full tenant or organizational identifier that the account belongs to
 *      target: Permissions that are included in the token, or for refresh tokens, the resource identifier.
 * }
 */
var RefreshTokenEntity = /** @class */ (function (_super) {
    __extends(RefreshTokenEntity, _super);
    function RefreshTokenEntity() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Create RefreshTokenEntity
     * @param homeAccountId
     * @param authenticationResult
     * @param clientId
     * @param authority
     */
    RefreshTokenEntity.createRefreshTokenEntity = function (homeAccountId, environment, refreshToken, clientId, familyId, oboAssertion) {
        var rtEntity = new RefreshTokenEntity();
        rtEntity.clientId = clientId;
        rtEntity.credentialType = CredentialType.REFRESH_TOKEN;
        rtEntity.environment = environment;
        rtEntity.homeAccountId = homeAccountId;
        rtEntity.secret = refreshToken;
        rtEntity.oboAssertion = oboAssertion;
        if (familyId)
            rtEntity.familyId = familyId;
        return rtEntity;
    };
    /**
     * Validates an entity: checks for all expected params
     * @param entity
     */
    RefreshTokenEntity.isRefreshTokenEntity = function (entity) {
        if (!entity) {
            return false;
        }
        return (entity.hasOwnProperty("homeAccountId") &&
            entity.hasOwnProperty("environment") &&
            entity.hasOwnProperty("credentialType") &&
            entity.hasOwnProperty("clientId") &&
            entity.hasOwnProperty("secret") &&
            entity["credentialType"] === CredentialType.REFRESH_TOKEN);
    };
    return RefreshTokenEntity;
}(CredentialEntity));

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * InteractionRequiredAuthErrorMessage class containing string constants used by error codes and messages.
 */
var InteractionRequiredAuthErrorMessage = [
    "interaction_required",
    "consent_required",
    "login_required"
];
var InteractionRequiredAuthSubErrorMessage = [
    "message_only",
    "additional_action",
    "basic_action",
    "user_password_expired",
    "consent_required"
];
/**
 * Error thrown when user interaction is required at the auth server.
 */
var InteractionRequiredAuthError = /** @class */ (function (_super) {
    __extends(InteractionRequiredAuthError, _super);
    function InteractionRequiredAuthError(errorCode, errorMessage, subError) {
        var _this = _super.call(this, errorCode, errorMessage, subError) || this;
        _this.name = "InteractionRequiredAuthError";
        Object.setPrototypeOf(_this, InteractionRequiredAuthError.prototype);
        return _this;
    }
    InteractionRequiredAuthError.isInteractionRequiredError = function (errorCode, errorString, subError) {
        var isInteractionRequiredErrorCode = !StringUtils.isEmpty(errorCode) && InteractionRequiredAuthErrorMessage.indexOf(errorCode) > -1;
        var isInteractionRequiredSubError = !StringUtils.isEmpty(subError) && InteractionRequiredAuthSubErrorMessage.indexOf(subError) > -1;
        var isInteractionRequiredErrorDesc = !StringUtils.isEmpty(errorString) && InteractionRequiredAuthErrorMessage.some(function (irErrorCode) {
            return errorString.indexOf(irErrorCode) > -1;
        });
        return isInteractionRequiredErrorCode || isInteractionRequiredErrorDesc || isInteractionRequiredSubError;
    };
    return InteractionRequiredAuthError;
}(ServerError));

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
var CacheRecord = /** @class */ (function () {
    function CacheRecord(accountEntity, idTokenEntity, accessTokenEntity, refreshTokenEntity, appMetadataEntity) {
        this.account = accountEntity;
        this.idToken = idTokenEntity;
        this.accessToken = accessTokenEntity;
        this.refreshToken = refreshTokenEntity;
        this.appMetadata = appMetadataEntity;
    }
    return CacheRecord;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * Class which provides helpers for OAuth 2.0 protocol specific values
 */
var ProtocolUtils = /** @class */ (function () {
    function ProtocolUtils() {
    }
    /**
     * Appends user state with random guid, or returns random guid.
     * @param userState
     * @param randomGuid
     */
    ProtocolUtils.setRequestState = function (cryptoObj, userState, meta) {
        var libraryState = ProtocolUtils.generateLibraryState(cryptoObj, meta);
        return !StringUtils.isEmpty(userState) ? "" + libraryState + Constants.RESOURCE_DELIM + userState : libraryState;
    };
    /**
     * Generates the state value used by the common library.
     * @param randomGuid
     * @param cryptoObj
     */
    ProtocolUtils.generateLibraryState = function (cryptoObj, meta) {
        if (!cryptoObj) {
            throw ClientAuthError.createNoCryptoObjectError("generateLibraryState");
        }
        // Create a state object containing a unique id and the timestamp of the request creation
        var stateObj = {
            id: cryptoObj.createNewGuid(),
            ts: TimeUtils.nowSeconds()
        };
        if (meta) {
            stateObj.meta = meta;
        }
        var stateString = JSON.stringify(stateObj);
        return cryptoObj.base64Encode(stateString);
    };
    /**
     * Parses the state into the RequestStateObject, which contains the LibraryState info and the state passed by the user.
     * @param state
     * @param cryptoObj
     */
    ProtocolUtils.parseRequestState = function (cryptoObj, state) {
        if (!cryptoObj) {
            throw ClientAuthError.createNoCryptoObjectError("parseRequestState");
        }
        if (StringUtils.isEmpty(state)) {
            throw ClientAuthError.createInvalidStateError(state, "Null, undefined or empty state");
        }
        try {
            // Split the state between library state and user passed state and decode them separately
            var splitState = decodeURIComponent(state).split(Constants.RESOURCE_DELIM);
            var libraryState = splitState[0];
            var userState = splitState.length > 1 ? splitState.slice(1).join(Constants.RESOURCE_DELIM) : "";
            var libraryStateString = cryptoObj.base64Decode(libraryState);
            var libraryStateObj = JSON.parse(libraryStateString);
            return {
                userRequestState: !StringUtils.isEmpty(userState) ? userState : "",
                libraryState: libraryStateObj
            };
        }
        catch (e) {
            throw ClientAuthError.createInvalidStateError(state, e);
        }
    };
    return ProtocolUtils;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
var KeyLocation;
(function (KeyLocation) {
    KeyLocation["SW"] = "sw";
    KeyLocation["UHW"] = "uhw";
})(KeyLocation || (KeyLocation = {}));
var PopTokenGenerator = /** @class */ (function () {
    function PopTokenGenerator(cryptoUtils) {
        this.cryptoUtils = cryptoUtils;
    }
    PopTokenGenerator.prototype.generateCnf = function (resourceRequestMethod, resourceRequestUri) {
        return __awaiter(this, void 0, void 0, function () {
            var kidThumbprint, reqCnf;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.cryptoUtils.getPublicKeyThumbprint(resourceRequestMethod, resourceRequestUri)];
                    case 1:
                        kidThumbprint = _a.sent();
                        reqCnf = {
                            kid: kidThumbprint,
                            xms_ksl: KeyLocation.SW
                        };
                        return [2 /*return*/, this.cryptoUtils.base64Encode(JSON.stringify(reqCnf))];
                }
            });
        });
    };
    PopTokenGenerator.prototype.signPopToken = function (accessToken, resourceRequestMethod, resourceRequestUri) {
        return __awaiter(this, void 0, void 0, function () {
            var tokenClaims, resourceUrlString, resourceUrlComponents;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        tokenClaims = AuthToken.extractTokenClaims(accessToken, this.cryptoUtils);
                        resourceUrlString = new UrlString(resourceRequestUri);
                        resourceUrlComponents = resourceUrlString.getUrlComponents();
                        return [4 /*yield*/, this.cryptoUtils.signJwt({
                                at: accessToken,
                                ts: "" + TimeUtils.nowSeconds(),
                                m: resourceRequestMethod.toUpperCase(),
                                u: resourceUrlComponents.HostNameAndPort || "",
                                nonce: this.cryptoUtils.createNewGuid(),
                                p: resourceUrlComponents.AbsolutePath,
                                q: [[], resourceUrlComponents.QueryString],
                            }, tokenClaims.cnf.kid)];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    return PopTokenGenerator;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * APP_METADATA Cache
 *
 * Key:Value Schema:
 *
 * Key: appmetadata-<environment>-<client_id>
 *
 * Value:
 * {
 *      clientId: client ID of the application
 *      environment: entity that issued the token, represented as a full host
 *      familyId: Family ID identifier, '1' represents Microsoft Family
 * }
 */
var AppMetadataEntity = /** @class */ (function () {
    function AppMetadataEntity() {
    }
    /**
     * Generate AppMetadata Cache Key as per the schema: appmetadata-<environment>-<client_id>
     */
    AppMetadataEntity.prototype.generateAppMetadataKey = function () {
        return AppMetadataEntity.generateAppMetadataCacheKey(this.environment, this.clientId);
    };
    /**
     * Generate AppMetadata Cache Key
     */
    AppMetadataEntity.generateAppMetadataCacheKey = function (environment, clientId) {
        var appMetaDataKeyArray = [
            APP_METADATA,
            environment,
            clientId,
        ];
        return appMetaDataKeyArray.join(Separators.CACHE_KEY_SEPARATOR).toLowerCase();
    };
    /**
     * Creates AppMetadataEntity
     * @param clientId
     * @param environment
     * @param familyId
     */
    AppMetadataEntity.createAppMetadataEntity = function (clientId, environment, familyId) {
        var appMetadata = new AppMetadataEntity();
        appMetadata.clientId = clientId;
        appMetadata.environment = environment;
        if (familyId) {
            appMetadata.familyId = familyId;
        }
        return appMetadata;
    };
    /**
     * Validates an entity: checks for all expected params
     * @param entity
     */
    AppMetadataEntity.isAppMetadataEntity = function (key, entity) {
        if (!entity) {
            return false;
        }
        return (key.indexOf(APP_METADATA) === 0 &&
            entity.hasOwnProperty("clientId") &&
            entity.hasOwnProperty("environment"));
    };
    return AppMetadataEntity;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
var TokenCacheContext = /** @class */ (function () {
    function TokenCacheContext(tokenCache, hasChanged) {
        this.cache = tokenCache;
        this.hasChanged = hasChanged;
    }
    Object.defineProperty(TokenCacheContext.prototype, "cacheHasChanged", {
        get: function () {
            return this.hasChanged;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TokenCacheContext.prototype, "tokenCache", {
        get: function () {
            return this.cache;
        },
        enumerable: true,
        configurable: true
    });
    return TokenCacheContext;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * Class that handles response parsing.
 */
var ResponseHandler = /** @class */ (function () {
    function ResponseHandler(clientId, cacheStorage, cryptoObj, logger, serializableCache, persistencePlugin) {
        this.clientId = clientId;
        this.cacheStorage = cacheStorage;
        this.cryptoObj = cryptoObj;
        this.logger = logger;
        this.serializableCache = serializableCache;
        this.persistencePlugin = persistencePlugin;
    }
    /**
     * Function which validates server authorization code response.
     * @param serverResponseHash
     * @param cachedState
     * @param cryptoObj
     */
    ResponseHandler.prototype.validateServerAuthorizationCodeResponse = function (serverResponseHash, cachedState, cryptoObj) {
        if (decodeURIComponent(serverResponseHash.state) !== decodeURIComponent(cachedState)) {
            throw ClientAuthError.createStateMismatchError();
        }
        // Check for error
        if (serverResponseHash.error || serverResponseHash.error_description || serverResponseHash.suberror) {
            if (InteractionRequiredAuthError.isInteractionRequiredError(serverResponseHash.error, serverResponseHash.error_description, serverResponseHash.suberror)) {
                throw new InteractionRequiredAuthError(serverResponseHash.error, serverResponseHash.error_description, serverResponseHash.suberror);
            }
            throw new ServerError(serverResponseHash.error, serverResponseHash.error_description, serverResponseHash.suberror);
        }
        if (serverResponseHash.client_info) {
            buildClientInfo(serverResponseHash.client_info, cryptoObj);
        }
    };
    /**
     * Function which validates server authorization token response.
     * @param serverResponse
     */
    ResponseHandler.prototype.validateTokenResponse = function (serverResponse) {
        // Check for error
        if (serverResponse.error || serverResponse.error_description || serverResponse.suberror) {
            if (InteractionRequiredAuthError.isInteractionRequiredError(serverResponse.error, serverResponse.error_description, serverResponse.suberror)) {
                throw new InteractionRequiredAuthError(serverResponse.error, serverResponse.error_description, serverResponse.suberror);
            }
            var errString = serverResponse.error_codes + " - [" + serverResponse.timestamp + "]: " + serverResponse.error_description + " - Correlation ID: " + serverResponse.correlation_id + " - Trace ID: " + serverResponse.trace_id;
            throw new ServerError(serverResponse.error, errString);
        }
    };
    /**
     * Returns a constructed token response based on given string. Also manages the cache updates and cleanups.
     * @param serverTokenResponse
     * @param authority
     */
    ResponseHandler.prototype.handleServerTokenResponse = function (serverTokenResponse, authority, resourceRequestMethod, resourceRequestUri, cachedNonce, cachedState, requestScopes, oboAssertion, handlingRefreshTokenResponse) {
        return __awaiter(this, void 0, void 0, function () {
            var idTokenObj, requestStateObj, cacheRecord, cacheContext, key, account;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        idTokenObj = null;
                        if (!StringUtils.isEmpty(serverTokenResponse.id_token)) {
                            // create an idToken object (not entity)
                            idTokenObj = new AuthToken(serverTokenResponse.id_token, this.cryptoObj);
                            // token nonce check (TODO: Add a warning if no nonce is given?)
                            if (!StringUtils.isEmpty(cachedNonce)) {
                                if (idTokenObj.claims.nonce !== cachedNonce) {
                                    throw ClientAuthError.createNonceMismatchError();
                                }
                            }
                        }
                        // generate homeAccountId
                        this.homeAccountIdentifier = AccountEntity.generateHomeAccountId(serverTokenResponse.client_info, authority.authorityType, this.logger, this.cryptoObj, idTokenObj);
                        requestStateObj = null;
                        if (!StringUtils.isEmpty(cachedState)) {
                            requestStateObj = ProtocolUtils.parseRequestState(this.cryptoObj, cachedState);
                        }
                        cacheRecord = this.generateCacheRecord(serverTokenResponse, idTokenObj, authority, requestStateObj && requestStateObj.libraryState, requestScopes, oboAssertion);
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, , 4, 7]);
                        if (!(this.persistencePlugin && this.serializableCache)) return [3 /*break*/, 3];
                        this.logger.verbose("Persistence enabled, calling beforeCacheAccess");
                        cacheContext = new TokenCacheContext(this.serializableCache, true);
                        return [4 /*yield*/, this.persistencePlugin.beforeCacheAccess(cacheContext)];
                    case 2:
                        _a.sent();
                        _a.label = 3;
                    case 3:
                        /*
                         * When saving a refreshed tokens to the cache, it is expected that the account that was used is present in the cache.
                         * If not present, we should return null, as it's the case that another application called removeAccount in between
                         * the calls to getAllAccounts and acquireTokenSilent. We should not overwrite that removal.
                         */
                        if (handlingRefreshTokenResponse && cacheRecord.account) {
                            key = cacheRecord.account.generateAccountKey();
                            account = this.cacheStorage.getAccount(key);
                            if (!account) {
                                this.logger.warning("Account used to refresh tokens not in persistence, refreshed tokens will not be stored in the cache");
                                return [2 /*return*/, null];
                            }
                        }
                        this.cacheStorage.saveCacheRecord(cacheRecord);
                        return [3 /*break*/, 7];
                    case 4:
                        if (!(this.persistencePlugin && this.serializableCache && cacheContext)) return [3 /*break*/, 6];
                        this.logger.verbose("Persistence enabled, calling afterCacheAccess");
                        return [4 /*yield*/, this.persistencePlugin.afterCacheAccess(cacheContext)];
                    case 5:
                        _a.sent();
                        _a.label = 6;
                    case 6: return [7 /*endfinally*/];
                    case 7: return [2 /*return*/, ResponseHandler.generateAuthenticationResult(this.cryptoObj, cacheRecord, idTokenObj, false, requestStateObj, resourceRequestMethod, resourceRequestUri)];
                }
            });
        });
    };
    /**
     * Generates CacheRecord
     * @param serverTokenResponse
     * @param idTokenObj
     * @param authority
     */
    ResponseHandler.prototype.generateCacheRecord = function (serverTokenResponse, idTokenObj, authority, libraryState, requestScopes, oboAssertion) {
        var env = Authority.generateEnvironmentFromAuthority(authority);
        if (StringUtils.isEmpty(env)) {
            throw ClientAuthError.createInvalidCacheEnvironmentError();
        }
        // IdToken: non AAD scenarios can have empty realm
        var cachedIdToken = null;
        var cachedAccount = null;
        if (!StringUtils.isEmpty(serverTokenResponse.id_token)) {
            cachedIdToken = IdTokenEntity.createIdTokenEntity(this.homeAccountIdentifier, env, serverTokenResponse.id_token, this.clientId, idTokenObj.claims.tid || "", oboAssertion);
            cachedAccount = this.generateAccountEntity(serverTokenResponse, idTokenObj, authority, oboAssertion);
        }
        // AccessToken
        var cachedAccessToken = null;
        if (!StringUtils.isEmpty(serverTokenResponse.access_token)) {
            // If scopes not returned in server response, use request scopes
            var responseScopes = serverTokenResponse.scope ? ScopeSet.fromString(serverTokenResponse.scope) : new ScopeSet(requestScopes || []);
            // Expiration calculation
            var currentTime = TimeUtils.nowSeconds();
            // If the request timestamp was sent in the library state, use that timestamp to calculate expiration. Otherwise, use current time.
            var timestamp = libraryState ? libraryState.ts : currentTime;
            var tokenExpirationSeconds = timestamp + serverTokenResponse.expires_in;
            var extendedTokenExpirationSeconds = tokenExpirationSeconds + serverTokenResponse.ext_expires_in;
            // non AAD scenarios can have empty realm
            cachedAccessToken = AccessTokenEntity.createAccessTokenEntity(this.homeAccountIdentifier, env, serverTokenResponse.access_token, this.clientId, idTokenObj ? idTokenObj.claims.tid || "" : authority.tenant, responseScopes.printScopes(), tokenExpirationSeconds, extendedTokenExpirationSeconds, serverTokenResponse.token_type, oboAssertion);
        }
        // refreshToken
        var cachedRefreshToken = null;
        if (!StringUtils.isEmpty(serverTokenResponse.refresh_token)) {
            cachedRefreshToken = RefreshTokenEntity.createRefreshTokenEntity(this.homeAccountIdentifier, env, serverTokenResponse.refresh_token, this.clientId, serverTokenResponse.foci, oboAssertion);
        }
        // appMetadata
        var cachedAppMetadata = null;
        if (!StringUtils.isEmpty(serverTokenResponse.foci)) {
            cachedAppMetadata = AppMetadataEntity.createAppMetadataEntity(this.clientId, env, serverTokenResponse.foci);
        }
        return new CacheRecord(cachedAccount, cachedIdToken, cachedAccessToken, cachedRefreshToken, cachedAppMetadata);
    };
    /**
     * Generate Account
     * @param serverTokenResponse
     * @param idToken
     * @param authority
     */
    ResponseHandler.prototype.generateAccountEntity = function (serverTokenResponse, idToken, authority, oboAssertion) {
        var authorityType = authority.authorityType;
        // ADFS does not require client_info in the response
        if (authorityType === AuthorityType.Adfs) {
            this.logger.verbose("Authority type is ADFS, creating ADFS account");
            return AccountEntity.createGenericAccount(authority, this.homeAccountIdentifier, idToken, oboAssertion);
        }
        // This fallback applies to B2C as well as they fall under an AAD account type.
        if (StringUtils.isEmpty(serverTokenResponse.client_info) && authority.protocolMode === "AAD") {
            throw ClientAuthError.createClientInfoEmptyError(serverTokenResponse.client_info);
        }
        return serverTokenResponse.client_info ?
            AccountEntity.createAccount(serverTokenResponse.client_info, this.homeAccountIdentifier, authority, idToken, oboAssertion) :
            AccountEntity.createGenericAccount(authority, this.homeAccountIdentifier, idToken, oboAssertion);
    };
    /**
     * Creates an @AuthenticationResult from @CacheRecord , @IdToken , and a boolean that states whether or not the result is from cache.
     *
     * Optionally takes a state string that is set as-is in the response.
     *
     * @param cacheRecord
     * @param idTokenObj
     * @param fromTokenCache
     * @param stateString
     */
    ResponseHandler.generateAuthenticationResult = function (cryptoObj, cacheRecord, idTokenObj, fromTokenCache, requestState, resourceRequestMethod, resourceRequestUri) {
        return __awaiter(this, void 0, void 0, function () {
            var accessToken, responseScopes, expiresOn, extExpiresOn, familyId, popTokenGenerator, uid, tid;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        accessToken = "";
                        responseScopes = [];
                        expiresOn = null;
                        extExpiresOn = null;
                        familyId = null;
                        if (!cacheRecord.accessToken) return [3 /*break*/, 4];
                        if (!(cacheRecord.accessToken.tokenType === AuthenticationScheme.POP)) return [3 /*break*/, 2];
                        popTokenGenerator = new PopTokenGenerator(cryptoObj);
                        return [4 /*yield*/, popTokenGenerator.signPopToken(cacheRecord.accessToken.secret, resourceRequestMethod, resourceRequestUri)];
                    case 1:
                        accessToken = _a.sent();
                        return [3 /*break*/, 3];
                    case 2:
                        accessToken = cacheRecord.accessToken.secret;
                        _a.label = 3;
                    case 3:
                        responseScopes = ScopeSet.fromString(cacheRecord.accessToken.target).asArray();
                        expiresOn = new Date(Number(cacheRecord.accessToken.expiresOn) * 1000);
                        extExpiresOn = new Date(Number(cacheRecord.accessToken.extendedExpiresOn) * 1000);
                        _a.label = 4;
                    case 4:
                        if (cacheRecord.appMetadata) {
                            familyId = cacheRecord.appMetadata.familyId === THE_FAMILY_ID ? THE_FAMILY_ID : null;
                        }
                        uid = idTokenObj ? idTokenObj.claims.oid || idTokenObj.claims.sub : "";
                        tid = idTokenObj ? idTokenObj.claims.tid : "";
                        return [2 /*return*/, {
                                uniqueId: uid,
                                tenantId: tid,
                                scopes: responseScopes,
                                account: cacheRecord.account ? cacheRecord.account.getAccountInfo() : null,
                                idToken: idTokenObj ? idTokenObj.rawToken : "",
                                idTokenClaims: idTokenObj ? idTokenObj.claims : null,
                                accessToken: accessToken,
                                fromCache: fromTokenCache,
                                expiresOn: expiresOn,
                                extExpiresOn: extExpiresOn,
                                familyId: familyId,
                                tokenType: cacheRecord.accessToken ? cacheRecord.accessToken.tokenType : "",
                                state: requestState ? requestState.userRequestState : ""
                            }];
                }
            });
        });
    };
    return ResponseHandler;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * Oauth2.0 Authorization Code client
 */
var AuthorizationCodeClient = /** @class */ (function (_super) {
    __extends(AuthorizationCodeClient, _super);
    function AuthorizationCodeClient(configuration) {
        return _super.call(this, configuration) || this;
    }
    /**
     * Creates the URL of the authorization request letting the user input credentials and consent to the
     * application. The URL target the /authorize endpoint of the authority configured in the
     * application object.
     *
     * Once the user inputs their credentials and consents, the authority will send a response to the redirect URI
     * sent in the request and should contain an authorization code, which can then be used to acquire tokens via
     * acquireToken(AuthorizationCodeRequest)
     * @param request
     */
    AuthorizationCodeClient.prototype.getAuthCodeUrl = function (request) {
        return __awaiter(this, void 0, void 0, function () {
            var queryString;
            return __generator(this, function (_a) {
                queryString = this.createAuthCodeUrlQueryString(request);
                return [2 /*return*/, this.authority.authorizationEndpoint + "?" + queryString];
            });
        });
    };
    /**
     * API to acquire a token in exchange of 'authorization_code` acquired by the user in the first leg of the
     * authorization_code_grant
     * @param request
     */
    AuthorizationCodeClient.prototype.acquireToken = function (request, cachedNonce, cachedState) {
        return __awaiter(this, void 0, void 0, function () {
            var response, responseHandler;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.logger.info("in acquireToken call");
                        if (!request || StringUtils.isEmpty(request.code)) {
                            throw ClientAuthError.createTokenRequestCannotBeMadeError();
                        }
                        return [4 /*yield*/, this.executeTokenRequest(this.authority, request)];
                    case 1:
                        response = _a.sent();
                        responseHandler = new ResponseHandler(this.config.authOptions.clientId, this.cacheManager, this.cryptoUtils, this.logger, this.config.serializableCache, this.config.persistencePlugin);
                        // Validate response. This function throws a server error if an error is returned by the server.
                        responseHandler.validateTokenResponse(response.body);
                        return [4 /*yield*/, responseHandler.handleServerTokenResponse(response.body, this.authority, request.resourceRequestMethod, request.resourceRequestUri, cachedNonce, cachedState)];
                    case 2: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    /**
     * Handles the hash fragment response from public client code request. Returns a code response used by
     * the client to exchange for a token in acquireToken.
     * @param hashFragment
     */
    AuthorizationCodeClient.prototype.handleFragmentResponse = function (hashFragment, cachedState) {
        // Handle responses.
        var responseHandler = new ResponseHandler(this.config.authOptions.clientId, this.cacheManager, this.cryptoUtils, this.logger);
        // Create UrlString object to remove leading # using getHash()
        var hashUrlString = new UrlString(hashFragment);
        // Deserialize hash fragment response parameters.
        var serverParams = UrlString.getDeserializedHash(hashUrlString.getHash());
        // Get code response
        responseHandler.validateServerAuthorizationCodeResponse(serverParams, cachedState, this.cryptoUtils);
        return serverParams.code;
    };
    /**
     * Use to log out the current user, and redirect the user to the postLogoutRedirectUri.
     * Default behaviour is to redirect the user to `window.location.href`.
     * @param authorityUri
     */
    AuthorizationCodeClient.prototype.getLogoutUri = function (logoutRequest) {
        // Throw error if logoutRequest is null/undefined
        if (!logoutRequest) {
            throw ClientConfigurationError.createEmptyLogoutRequestError();
        }
        if (logoutRequest.account) {
            // Clear given account.
            this.cacheManager.removeAccount(AccountEntity.generateAccountCacheKey(logoutRequest.account));
        }
        else {
            // Clear all accounts and tokens
            this.cacheManager.clear();
        }
        // Get postLogoutRedirectUri.
        var postLogoutUriParam = logoutRequest.postLogoutRedirectUri ?
            "?" + AADServerParamKeys.POST_LOGOUT_URI + "=" + encodeURIComponent(logoutRequest.postLogoutRedirectUri) : "";
        var correlationIdParam = logoutRequest.correlationId ?
            "&" + AADServerParamKeys.CLIENT_REQUEST_ID + "=" + encodeURIComponent(logoutRequest.correlationId) : "";
        // Construct logout URI.
        var logoutUri = "" + this.authority.endSessionEndpoint + postLogoutUriParam + correlationIdParam;
        return logoutUri;
    };
    /**
     * Executes POST request to token endpoint
     * @param authority
     * @param request
     */
    AuthorizationCodeClient.prototype.executeTokenRequest = function (authority, request) {
        return __awaiter(this, void 0, void 0, function () {
            var thumbprint, requestBody, headers;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        thumbprint = {
                            clientId: this.config.authOptions.clientId,
                            authority: authority.canonicalAuthority,
                            scopes: request.scopes
                        };
                        return [4 /*yield*/, this.createTokenRequestBody(request)];
                    case 1:
                        requestBody = _a.sent();
                        headers = this.createDefaultTokenRequestHeaders();
                        return [2 /*return*/, this.executePostToTokenEndpoint(authority.tokenEndpoint, requestBody, headers, thumbprint)];
                }
            });
        });
    };
    /**
     * Generates a map for all the params to be sent to the service
     * @param request
     */
    AuthorizationCodeClient.prototype.createTokenRequestBody = function (request) {
        return __awaiter(this, void 0, void 0, function () {
            var parameterBuilder, clientAssertion, popTokenGenerator, cnfString, correlationId;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        parameterBuilder = new RequestParameterBuilder();
                        parameterBuilder.addClientId(this.config.authOptions.clientId);
                        // validate the redirectUri (to be a non null value)
                        parameterBuilder.addRedirectUri(request.redirectUri);
                        // Add scope array, parameter builder will add default scopes and dedupe
                        parameterBuilder.addScopes(request.scopes);
                        // add code: user set, not validated
                        parameterBuilder.addAuthorizationCode(request.code);
                        // add code_verifier if passed
                        if (request.codeVerifier) {
                            parameterBuilder.addCodeVerifier(request.codeVerifier);
                        }
                        if (this.config.clientCredentials.clientSecret) {
                            parameterBuilder.addClientSecret(this.config.clientCredentials.clientSecret);
                        }
                        if (this.config.clientCredentials.clientAssertion) {
                            clientAssertion = this.config.clientCredentials.clientAssertion;
                            parameterBuilder.addClientAssertion(clientAssertion.assertion);
                            parameterBuilder.addClientAssertionType(clientAssertion.assertionType);
                        }
                        parameterBuilder.addGrantType(GrantType.AUTHORIZATION_CODE_GRANT);
                        parameterBuilder.addClientInfo();
                        if (!(request.authenticationScheme === AuthenticationScheme.POP)) return [3 /*break*/, 2];
                        popTokenGenerator = new PopTokenGenerator(this.cryptoUtils);
                        return [4 /*yield*/, popTokenGenerator.generateCnf(request.resourceRequestMethod, request.resourceRequestUri)];
                    case 1:
                        cnfString = _a.sent();
                        parameterBuilder.addPopToken(cnfString);
                        _a.label = 2;
                    case 2:
                        correlationId = request.correlationId || this.config.cryptoInterface.createNewGuid();
                        parameterBuilder.addCorrelationId(correlationId);
                        if (!StringUtils.isEmpty(request.claims) || this.config.authOptions.clientCapabilities && this.config.authOptions.clientCapabilities.length > 0) {
                            parameterBuilder.addClaims(request.claims, this.config.authOptions.clientCapabilities);
                        }
                        return [2 /*return*/, parameterBuilder.createQueryString()];
                }
            });
        });
    };
    /**
     * This API validates the `AuthorizationCodeUrlRequest` and creates a URL
     * @param request
     */
    AuthorizationCodeClient.prototype.createAuthCodeUrlQueryString = function (request) {
        var parameterBuilder = new RequestParameterBuilder();
        parameterBuilder.addClientId(this.config.authOptions.clientId);
        var requestScopes = __spreadArrays(request.scopes || [], request.extraScopesToConsent || []);
        parameterBuilder.addScopes(requestScopes);
        // validate the redirectUri (to be a non null value)
        parameterBuilder.addRedirectUri(request.redirectUri);
        // generate the correlationId if not set by the user and add
        var correlationId = request.correlationId || this.config.cryptoInterface.createNewGuid();
        parameterBuilder.addCorrelationId(correlationId);
        // add response_mode. If not passed in it defaults to query.
        parameterBuilder.addResponseMode(request.responseMode);
        // add response_type = code
        parameterBuilder.addResponseTypeCode();
        // add library info parameters
        parameterBuilder.addLibraryInfo(this.config.libraryInfo);
        // add client_info=1
        parameterBuilder.addClientInfo();
        if (request.codeChallenge) {
            parameterBuilder.addCodeChallengeParams(request.codeChallenge, request.codeChallengeMethod);
        }
        if (request.prompt) {
            parameterBuilder.addPrompt(request.prompt);
        }
        if (request.domainHint) {
            parameterBuilder.addDomainHint(request.domainHint);
        }
        // Add sid or loginHint with preference for sid -> loginHint -> username of AccountInfo object
        if (request.sid) {
            parameterBuilder.addSid(request.sid);
        }
        else if (request.loginHint) {
            parameterBuilder.addLoginHint(request.loginHint);
        }
        else if (request.account && request.account.username) {
            parameterBuilder.addLoginHint(request.account.username);
        }
        if (request.nonce) {
            parameterBuilder.addNonce(request.nonce);
        }
        if (request.state) {
            parameterBuilder.addState(request.state);
        }
        if (!StringUtils.isEmpty(request.claims) || this.config.authOptions.clientCapabilities && this.config.authOptions.clientCapabilities.length > 0) {
            parameterBuilder.addClaims(request.claims, this.config.authOptions.clientCapabilities);
        }
        if (request.extraQueryParameters) {
            parameterBuilder.addExtraQueryParameters(request.extraQueryParameters);
        }
        return parameterBuilder.createQueryString();
    };
    return AuthorizationCodeClient;
}(BaseClient));

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * OAuth2.0 Device code client
 */
var DeviceCodeClient = /** @class */ (function (_super) {
    __extends(DeviceCodeClient, _super);
    function DeviceCodeClient(configuration) {
        return _super.call(this, configuration) || this;
    }
    /**
     * Gets device code from device code endpoint, calls back to with device code response, and
     * polls token endpoint to exchange device code for tokens
     * @param request
     */
    DeviceCodeClient.prototype.acquireToken = function (request) {
        return __awaiter(this, void 0, void 0, function () {
            var deviceCodeResponse, response, responseHandler;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getDeviceCode(request)];
                    case 1:
                        deviceCodeResponse = _a.sent();
                        request.deviceCodeCallback(deviceCodeResponse);
                        return [4 /*yield*/, this.acquireTokenWithDeviceCode(request, deviceCodeResponse)];
                    case 2:
                        response = _a.sent();
                        responseHandler = new ResponseHandler(this.config.authOptions.clientId, this.cacheManager, this.cryptoUtils, this.logger, this.config.serializableCache, this.config.persistencePlugin);
                        // Validate response. This function throws a server error if an error is returned by the server.
                        responseHandler.validateTokenResponse(response);
                        return [4 /*yield*/, responseHandler.handleServerTokenResponse(response, this.authority, request.resourceRequestMethod, request.resourceRequestUri)];
                    case 3: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    /**
     * Creates device code request and executes http GET
     * @param request
     */
    DeviceCodeClient.prototype.getDeviceCode = function (request) {
        return __awaiter(this, void 0, void 0, function () {
            var queryString, headers, thumbprint;
            return __generator(this, function (_a) {
                queryString = this.createQueryString(request);
                headers = this.createDefaultTokenRequestHeaders();
                thumbprint = {
                    clientId: this.config.authOptions.clientId,
                    authority: request.authority,
                    scopes: request.scopes
                };
                return [2 /*return*/, this.executePostRequestToDeviceCodeEndpoint(this.authority.deviceCodeEndpoint, queryString, headers, thumbprint)];
            });
        });
    };
    /**
     * Executes POST request to device code endpoint
     * @param deviceCodeEndpoint
     * @param queryString
     * @param headers
     */
    DeviceCodeClient.prototype.executePostRequestToDeviceCodeEndpoint = function (deviceCodeEndpoint, queryString, headers, thumbprint) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, userCode, deviceCode, verificationUri, expiresIn, interval, message;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, this.networkManager.sendPostRequest(thumbprint, deviceCodeEndpoint, {
                            body: queryString,
                            headers: headers
                        })];
                    case 1:
                        _a = (_b.sent()).body, userCode = _a.user_code, deviceCode = _a.device_code, verificationUri = _a.verification_uri, expiresIn = _a.expires_in, interval = _a.interval, message = _a.message;
                        return [2 /*return*/, {
                                userCode: userCode,
                                deviceCode: deviceCode,
                                verificationUri: verificationUri,
                                expiresIn: expiresIn,
                                interval: interval,
                                message: message
                            }];
                }
            });
        });
    };
    /**
     * Create device code endpoint query parameters and returns string
     */
    DeviceCodeClient.prototype.createQueryString = function (request) {
        var parameterBuilder = new RequestParameterBuilder();
        parameterBuilder.addScopes(request.scopes);
        parameterBuilder.addClientId(this.config.authOptions.clientId);
        if (!StringUtils.isEmpty(request.claims) || this.config.authOptions.clientCapabilities && this.config.authOptions.clientCapabilities.length > 0) {
            parameterBuilder.addClaims(request.claims, this.config.authOptions.clientCapabilities);
        }
        return parameterBuilder.createQueryString();
    };
    /**
     * Creates token request with device code response and polls token endpoint at interval set by the device code
     * response
     * @param request
     * @param deviceCodeResponse
     */
    DeviceCodeClient.prototype.acquireTokenWithDeviceCode = function (request, deviceCodeResponse) {
        return __awaiter(this, void 0, void 0, function () {
            var requestBody, headers, deviceCodeExpirationTime, pollingIntervalMilli;
            var _this = this;
            return __generator(this, function (_a) {
                requestBody = this.createTokenRequestBody(request, deviceCodeResponse);
                headers = this.createDefaultTokenRequestHeaders();
                deviceCodeExpirationTime = TimeUtils.nowSeconds() + deviceCodeResponse.expiresIn;
                pollingIntervalMilli = deviceCodeResponse.interval * 1000;
                /*
                 * Poll token endpoint while (device code is not expired AND operation has not been cancelled by
                 * setting CancellationToken.cancel = true). POST request is sent at interval set by pollingIntervalMilli
                 */
                return [2 /*return*/, new Promise(function (resolve, reject) {
                        var intervalId = setInterval(function () { return __awaiter(_this, void 0, void 0, function () {
                            var thumbprint, response, error_1;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0:
                                        _a.trys.push([0, 5, , 6]);
                                        if (!request.cancel) return [3 /*break*/, 1];
                                        this.logger.error("Token request cancelled by setting DeviceCodeRequest.cancel = true");
                                        clearInterval(intervalId);
                                        reject(ClientAuthError.createDeviceCodeCancelledError());
                                        return [3 /*break*/, 4];
                                    case 1:
                                        if (!(TimeUtils.nowSeconds() > deviceCodeExpirationTime)) return [3 /*break*/, 2];
                                        this.logger.error("Device code expired. Expiration time of device code was " + deviceCodeExpirationTime);
                                        clearInterval(intervalId);
                                        reject(ClientAuthError.createDeviceCodeExpiredError());
                                        return [3 /*break*/, 4];
                                    case 2:
                                        thumbprint = {
                                            clientId: this.config.authOptions.clientId,
                                            authority: request.authority,
                                            scopes: request.scopes
                                        };
                                        return [4 /*yield*/, this.executePostToTokenEndpoint(this.authority.tokenEndpoint, requestBody, headers, thumbprint)];
                                    case 3:
                                        response = _a.sent();
                                        if (response.body && response.body.error == Constants.AUTHORIZATION_PENDING) {
                                            // user authorization is pending. Sleep for polling interval and try again
                                            this.logger.info(response.body.error_description);
                                        }
                                        else {
                                            clearInterval(intervalId);
                                            resolve(response.body);
                                        }
                                        _a.label = 4;
                                    case 4: return [3 /*break*/, 6];
                                    case 5:
                                        error_1 = _a.sent();
                                        clearInterval(intervalId);
                                        reject(error_1);
                                        return [3 /*break*/, 6];
                                    case 6: return [2 /*return*/];
                                }
                            });
                        }); }, pollingIntervalMilli);
                    })];
            });
        });
    };
    /**
     * Creates query parameters and converts to string.
     * @param request
     * @param deviceCodeResponse
     */
    DeviceCodeClient.prototype.createTokenRequestBody = function (request, deviceCodeResponse) {
        var requestParameters = new RequestParameterBuilder();
        requestParameters.addScopes(request.scopes);
        requestParameters.addClientId(this.config.authOptions.clientId);
        requestParameters.addGrantType(GrantType.DEVICE_CODE_GRANT);
        requestParameters.addDeviceCode(deviceCodeResponse.deviceCode);
        var correlationId = request.correlationId || this.config.cryptoInterface.createNewGuid();
        requestParameters.addCorrelationId(correlationId);
        requestParameters.addClientInfo();
        if (!StringUtils.isEmpty(request.claims) || this.config.authOptions.clientCapabilities && this.config.authOptions.clientCapabilities.length > 0) {
            requestParameters.addClaims(request.claims, this.config.authOptions.clientCapabilities);
        }
        return requestParameters.createQueryString();
    };
    return DeviceCodeClient;
}(BaseClient));

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * OAuth2.0 refresh token client
 */
var RefreshTokenClient = /** @class */ (function (_super) {
    __extends(RefreshTokenClient, _super);
    function RefreshTokenClient(configuration) {
        return _super.call(this, configuration) || this;
    }
    RefreshTokenClient.prototype.acquireToken = function (request) {
        return __awaiter(this, void 0, void 0, function () {
            var response, responseHandler;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.executeTokenRequest(request, this.authority)];
                    case 1:
                        response = _a.sent();
                        responseHandler = new ResponseHandler(this.config.authOptions.clientId, this.cacheManager, this.cryptoUtils, this.logger, this.config.serializableCache, this.config.persistencePlugin);
                        responseHandler.validateTokenResponse(response.body);
                        return [2 /*return*/, responseHandler.handleServerTokenResponse(response.body, this.authority, request.resourceRequestMethod, request.resourceRequestUri, null, null, null, null, true)];
                }
            });
        });
    };
    /**
     * Gets cached refresh token and attaches to request, then calls acquireToken API
     * @param request
     */
    RefreshTokenClient.prototype.acquireTokenByRefreshToken = function (request) {
        return __awaiter(this, void 0, void 0, function () {
            var isFOCI, noFamilyRTInCache, clientMismatchErrorWithFamilyRT;
            return __generator(this, function (_a) {
                // Cannot renew token if no request object is given.
                if (!request) {
                    throw ClientConfigurationError.createEmptyTokenRequestError();
                }
                // We currently do not support silent flow for account === null use cases; This will be revisited for confidential flow usecases
                if (!request.account) {
                    throw ClientAuthError.createNoAccountInSilentRequestError();
                }
                isFOCI = this.cacheManager.isAppMetadataFOCI(request.account.environment, this.config.authOptions.clientId);
                // if the app is part of the family, retrive a Family refresh token if present and make a refreshTokenRequest
                if (isFOCI) {
                    try {
                        return [2 /*return*/, this.acquireTokenWithCachedRefreshToken(request, true)];
                    }
                    catch (e) {
                        noFamilyRTInCache = e instanceof ClientAuthError && e.errorCode === ClientAuthErrorMessage.noTokensFoundError.code;
                        clientMismatchErrorWithFamilyRT = e instanceof ServerError && e.errorCode === Errors.INVALID_GRANT_ERROR && e.subError === Errors.CLIENT_MISMATCH_ERROR;
                        // if family Refresh Token (FRT) cache acquisition fails or if client_mismatch error is seen with FRT, reattempt with application Refresh Token (ART)
                        if (noFamilyRTInCache || clientMismatchErrorWithFamilyRT) {
                            return [2 /*return*/, this.acquireTokenWithCachedRefreshToken(request, false)];
                            // throw in all other cases
                        }
                        else {
                            throw e;
                        }
                    }
                }
                // fall back to application refresh token acquisition
                return [2 /*return*/, this.acquireTokenWithCachedRefreshToken(request, false)];
            });
        });
    };
    /**
     * makes a network call to acquire tokens by exchanging RefreshToken available in userCache; throws if refresh token is not cached
     * @param request
     */
    RefreshTokenClient.prototype.acquireTokenWithCachedRefreshToken = function (request, foci) {
        return __awaiter(this, void 0, void 0, function () {
            var refreshToken, refreshTokenRequest;
            return __generator(this, function (_a) {
                refreshToken = this.cacheManager.readRefreshTokenFromCache(this.config.authOptions.clientId, request.account, foci);
                // no refresh Token
                if (!refreshToken) {
                    throw ClientAuthError.createNoTokensFoundError();
                }
                refreshTokenRequest = __assign(__assign({}, request), { refreshToken: refreshToken.secret });
                return [2 /*return*/, this.acquireToken(refreshTokenRequest)];
            });
        });
    };
    /**
     * Constructs the network message and makes a NW call to the underlying secure token service
     * @param request
     * @param authority
     */
    RefreshTokenClient.prototype.executeTokenRequest = function (request, authority) {
        return __awaiter(this, void 0, void 0, function () {
            var requestBody, headers, thumbprint;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.createTokenRequestBody(request)];
                    case 1:
                        requestBody = _a.sent();
                        headers = this.createDefaultTokenRequestHeaders();
                        thumbprint = {
                            clientId: this.config.authOptions.clientId,
                            authority: authority.canonicalAuthority,
                            scopes: request.scopes
                        };
                        return [2 /*return*/, this.executePostToTokenEndpoint(authority.tokenEndpoint, requestBody, headers, thumbprint)];
                }
            });
        });
    };
    /**
     * Helper function to create the token request body
     * @param request
     */
    RefreshTokenClient.prototype.createTokenRequestBody = function (request) {
        return __awaiter(this, void 0, void 0, function () {
            var parameterBuilder, correlationId, clientAssertion, popTokenGenerator, _a, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        parameterBuilder = new RequestParameterBuilder();
                        parameterBuilder.addClientId(this.config.authOptions.clientId);
                        parameterBuilder.addScopes(request.scopes);
                        parameterBuilder.addGrantType(GrantType.REFRESH_TOKEN_GRANT);
                        parameterBuilder.addClientInfo();
                        correlationId = request.correlationId || this.config.cryptoInterface.createNewGuid();
                        parameterBuilder.addCorrelationId(correlationId);
                        parameterBuilder.addRefreshToken(request.refreshToken);
                        if (this.config.clientCredentials.clientSecret) {
                            parameterBuilder.addClientSecret(this.config.clientCredentials.clientSecret);
                        }
                        if (this.config.clientCredentials.clientAssertion) {
                            clientAssertion = this.config.clientCredentials.clientAssertion;
                            parameterBuilder.addClientAssertion(clientAssertion.assertion);
                            parameterBuilder.addClientAssertionType(clientAssertion.assertionType);
                        }
                        if (!(request.authenticationScheme === AuthenticationScheme.POP)) return [3 /*break*/, 2];
                        popTokenGenerator = new PopTokenGenerator(this.cryptoUtils);
                        _b = (_a = parameterBuilder).addPopToken;
                        return [4 /*yield*/, popTokenGenerator.generateCnf(request.resourceRequestMethod, request.resourceRequestUri)];
                    case 1:
                        _b.apply(_a, [_c.sent()]);
                        _c.label = 2;
                    case 2:
                        if (!StringUtils.isEmpty(request.claims) || this.config.authOptions.clientCapabilities && this.config.authOptions.clientCapabilities.length > 0) {
                            parameterBuilder.addClaims(request.claims, this.config.authOptions.clientCapabilities);
                        }
                        return [2 /*return*/, parameterBuilder.createQueryString()];
                }
            });
        });
    };
    return RefreshTokenClient;
}(BaseClient));

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * OAuth2.0 client credential grant
 */
var ClientCredentialClient = /** @class */ (function (_super) {
    __extends(ClientCredentialClient, _super);
    function ClientCredentialClient(configuration) {
        return _super.call(this, configuration) || this;
    }
    ClientCredentialClient.prototype.acquireToken = function (request) {
        return __awaiter(this, void 0, void 0, function () {
            var cachedAuthenticationResult;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.scopeSet = new ScopeSet(request.scopes || []);
                        if (!request.skipCache) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.executeTokenRequest(request, this.authority)];
                    case 1: return [2 /*return*/, _a.sent()];
                    case 2: return [4 /*yield*/, this.getCachedAuthenticationResult()];
                    case 3:
                        cachedAuthenticationResult = _a.sent();
                        if (!(cachedAuthenticationResult != null)) return [3 /*break*/, 4];
                        return [2 /*return*/, cachedAuthenticationResult];
                    case 4: return [4 /*yield*/, this.executeTokenRequest(request, this.authority)];
                    case 5: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    ClientCredentialClient.prototype.getCachedAuthenticationResult = function () {
        return __awaiter(this, void 0, void 0, function () {
            var cachedAccessToken;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        cachedAccessToken = this.readAccessTokenFromCache();
                        if (!cachedAccessToken ||
                            TimeUtils.isTokenExpired(cachedAccessToken.expiresOn, this.config.systemOptions.tokenRenewalOffsetSeconds)) {
                            return [2 /*return*/, null];
                        }
                        return [4 /*yield*/, ResponseHandler.generateAuthenticationResult(this.cryptoUtils, {
                                account: null,
                                accessToken: cachedAccessToken,
                                idToken: null,
                                refreshToken: null,
                                appMetadata: null
                            }, null, true)];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    ClientCredentialClient.prototype.readAccessTokenFromCache = function () {
        var accessTokenFilter = {
            homeAccountId: "",
            environment: this.authority.canonicalAuthorityUrlComponents.HostNameAndPort,
            credentialType: CredentialType.ACCESS_TOKEN,
            clientId: this.config.authOptions.clientId,
            realm: this.authority.tenant,
            target: this.scopeSet.printScopesLowerCase()
        };
        var credentialCache = this.cacheManager.getCredentialsFilteredBy(accessTokenFilter);
        var accessTokens = Object.keys(credentialCache.accessTokens).map(function (key) { return credentialCache.accessTokens[key]; });
        if (accessTokens.length < 1) {
            return null;
        }
        else if (accessTokens.length > 1) {
            throw ClientAuthError.createMultipleMatchingTokensInCacheError();
        }
        return accessTokens[0];
    };
    ClientCredentialClient.prototype.executeTokenRequest = function (request, authority) {
        return __awaiter(this, void 0, void 0, function () {
            var requestBody, headers, thumbprint, response, responseHandler, tokenResponse;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        requestBody = this.createTokenRequestBody(request);
                        headers = this.createDefaultTokenRequestHeaders();
                        thumbprint = {
                            clientId: this.config.authOptions.clientId,
                            authority: request.authority,
                            scopes: request.scopes
                        };
                        return [4 /*yield*/, this.executePostToTokenEndpoint(authority.tokenEndpoint, requestBody, headers, thumbprint)];
                    case 1:
                        response = _a.sent();
                        responseHandler = new ResponseHandler(this.config.authOptions.clientId, this.cacheManager, this.cryptoUtils, this.logger, this.config.serializableCache, this.config.persistencePlugin);
                        responseHandler.validateTokenResponse(response.body);
                        return [4 /*yield*/, responseHandler.handleServerTokenResponse(response.body, this.authority, request.resourceRequestMethod, request.resourceRequestUri, null, null, request.scopes)];
                    case 2:
                        tokenResponse = _a.sent();
                        return [2 /*return*/, tokenResponse];
                }
            });
        });
    };
    ClientCredentialClient.prototype.createTokenRequestBody = function (request) {
        var parameterBuilder = new RequestParameterBuilder();
        parameterBuilder.addClientId(this.config.authOptions.clientId);
        parameterBuilder.addScopes(request.scopes, false);
        parameterBuilder.addGrantType(GrantType.CLIENT_CREDENTIALS_GRANT);
        var correlationId = request.correlationId || this.config.cryptoInterface.createNewGuid();
        parameterBuilder.addCorrelationId(correlationId);
        if (this.config.clientCredentials.clientSecret) {
            parameterBuilder.addClientSecret(this.config.clientCredentials.clientSecret);
        }
        if (this.config.clientCredentials.clientAssertion) {
            var clientAssertion = this.config.clientCredentials.clientAssertion;
            parameterBuilder.addClientAssertion(clientAssertion.assertion);
            parameterBuilder.addClientAssertionType(clientAssertion.assertionType);
        }
        if (!StringUtils.isEmpty(request.claims) || this.config.authOptions.clientCapabilities && this.config.authOptions.clientCapabilities.length > 0) {
            parameterBuilder.addClaims(request.claims, this.config.authOptions.clientCapabilities);
        }
        return parameterBuilder.createQueryString();
    };
    return ClientCredentialClient;
}(BaseClient));

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * On-Behalf-Of client
 */
var OnBehalfOfClient = /** @class */ (function (_super) {
    __extends(OnBehalfOfClient, _super);
    function OnBehalfOfClient(configuration) {
        return _super.call(this, configuration) || this;
    }
    OnBehalfOfClient.prototype.acquireToken = function (request) {
        return __awaiter(this, void 0, void 0, function () {
            var cachedAuthenticationResult;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.scopeSet = new ScopeSet(request.scopes || []);
                        if (!request.skipCache) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.executeTokenRequest(request, this.authority)];
                    case 1: return [2 /*return*/, _a.sent()];
                    case 2:
                        cachedAuthenticationResult = this.getCachedAuthenticationResult(request);
                        if (!(cachedAuthenticationResult != null)) return [3 /*break*/, 3];
                        return [2 /*return*/, cachedAuthenticationResult];
                    case 3: return [4 /*yield*/, this.executeTokenRequest(request, this.authority)];
                    case 4: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    OnBehalfOfClient.prototype.getCachedAuthenticationResult = function (request) {
        return __awaiter(this, void 0, void 0, function () {
            var cachedAccessToken, cachedIdToken, idTokenObject, cachedAccount, localAccountId, accountInfo;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        cachedAccessToken = this.readAccessTokenFromCache(request);
                        if (!cachedAccessToken ||
                            TimeUtils.isTokenExpired(cachedAccessToken.expiresOn, this.config.systemOptions.tokenRenewalOffsetSeconds)) {
                            return [2 /*return*/, null];
                        }
                        cachedIdToken = this.readIdTokenFromCache(request);
                        idTokenObject = null;
                        cachedAccount = null;
                        if (cachedIdToken) {
                            idTokenObject = new AuthToken(cachedIdToken.secret, this.config.cryptoInterface);
                            localAccountId = idTokenObject.claims.oid ? idTokenObject.claims.oid : idTokenObject.claims.sub;
                            accountInfo = {
                                homeAccountId: cachedIdToken.homeAccountId,
                                environment: cachedIdToken.environment,
                                tenantId: cachedIdToken.realm,
                                username: null,
                                localAccountId: localAccountId
                            };
                            cachedAccount = this.readAccountFromCache(accountInfo);
                        }
                        return [4 /*yield*/, ResponseHandler.generateAuthenticationResult(this.cryptoUtils, {
                                account: cachedAccount,
                                accessToken: cachedAccessToken,
                                idToken: cachedIdToken,
                                refreshToken: null,
                                appMetadata: null,
                            }, idTokenObject, true)];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    OnBehalfOfClient.prototype.readAccessTokenFromCache = function (request) {
        var accessTokenFilter = {
            environment: this.authority.canonicalAuthorityUrlComponents.HostNameAndPort,
            credentialType: CredentialType.ACCESS_TOKEN,
            clientId: this.config.authOptions.clientId,
            realm: this.authority.tenant,
            target: this.scopeSet.printScopesLowerCase(),
            oboAssertion: request.oboAssertion
        };
        var credentialCache = this.cacheManager.getCredentialsFilteredBy(accessTokenFilter);
        var accessTokens = Object.keys(credentialCache.accessTokens).map(function (key) { return credentialCache.accessTokens[key]; });
        var numAccessTokens = accessTokens.length;
        if (numAccessTokens < 1) {
            return null;
        }
        else if (numAccessTokens > 1) {
            throw ClientAuthError.createMultipleMatchingTokensInCacheError();
        }
        return accessTokens[0];
    };
    OnBehalfOfClient.prototype.readIdTokenFromCache = function (request) {
        var idTokenFilter = {
            environment: this.authority.canonicalAuthorityUrlComponents.HostNameAndPort,
            credentialType: CredentialType.ID_TOKEN,
            clientId: this.config.authOptions.clientId,
            realm: this.authority.tenant,
            oboAssertion: request.oboAssertion
        };
        var credentialCache = this.cacheManager.getCredentialsFilteredBy(idTokenFilter);
        var idTokens = Object.keys(credentialCache.idTokens).map(function (key) { return credentialCache.idTokens[key]; });
        // When acquiring a token on behalf of an application, there might not be an id token in the cache
        if (idTokens.length < 1) {
            return null;
        }
        return idTokens[0];
    };
    OnBehalfOfClient.prototype.readAccountFromCache = function (account) {
        return this.cacheManager.readAccountFromCache(account);
    };
    OnBehalfOfClient.prototype.executeTokenRequest = function (request, authority) {
        return __awaiter(this, void 0, void 0, function () {
            var requestBody, headers, thumbprint, response, responseHandler, tokenResponse;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        requestBody = this.createTokenRequestBody(request);
                        headers = this.createDefaultTokenRequestHeaders();
                        thumbprint = {
                            clientId: this.config.authOptions.clientId,
                            authority: request.authority,
                            scopes: request.scopes
                        };
                        return [4 /*yield*/, this.executePostToTokenEndpoint(authority.tokenEndpoint, requestBody, headers, thumbprint)];
                    case 1:
                        response = _a.sent();
                        responseHandler = new ResponseHandler(this.config.authOptions.clientId, this.cacheManager, this.cryptoUtils, this.logger, this.config.serializableCache, this.config.persistencePlugin);
                        responseHandler.validateTokenResponse(response.body);
                        return [4 /*yield*/, responseHandler.handleServerTokenResponse(response.body, this.authority, request.resourceRequestMethod, request.resourceRequestUri, null, null, request.scopes, request.oboAssertion)];
                    case 2:
                        tokenResponse = _a.sent();
                        return [2 /*return*/, tokenResponse];
                }
            });
        });
    };
    OnBehalfOfClient.prototype.createTokenRequestBody = function (request) {
        var parameterBuilder = new RequestParameterBuilder();
        parameterBuilder.addClientId(this.config.authOptions.clientId);
        parameterBuilder.addScopes(request.scopes);
        parameterBuilder.addGrantType(GrantType.JWT_BEARER);
        parameterBuilder.addClientInfo();
        var correlationId = request.correlationId || this.config.cryptoInterface.createNewGuid();
        parameterBuilder.addCorrelationId(correlationId);
        parameterBuilder.addRequestTokenUse(AADServerParamKeys.ON_BEHALF_OF);
        parameterBuilder.addOboAssertion(request.oboAssertion);
        if (this.config.clientCredentials.clientSecret) {
            parameterBuilder.addClientSecret(this.config.clientCredentials.clientSecret);
        }
        if (this.config.clientCredentials.clientAssertion) {
            var clientAssertion = this.config.clientCredentials.clientAssertion;
            parameterBuilder.addClientAssertion(clientAssertion.assertion);
            parameterBuilder.addClientAssertionType(clientAssertion.assertionType);
        }
        return parameterBuilder.createQueryString();
    };
    return OnBehalfOfClient;
}(BaseClient));

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
var SilentFlowClient = /** @class */ (function (_super) {
    __extends(SilentFlowClient, _super);
    function SilentFlowClient(configuration) {
        return _super.call(this, configuration) || this;
    }
    /**
     * Retrieves a token from cache if it is still valid, or uses the cached refresh token to renew
     * the given token and returns the renewed token
     * @param request
     */
    SilentFlowClient.prototype.acquireToken = function (request) {
        return __awaiter(this, void 0, void 0, function () {
            var e_1, refreshTokenClient;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, this.acquireCachedToken(request)];
                    case 1: return [2 /*return*/, _a.sent()];
                    case 2:
                        e_1 = _a.sent();
                        if (e_1 instanceof ClientAuthError && e_1.errorCode === ClientAuthErrorMessage.tokenRefreshRequired.code) {
                            refreshTokenClient = new RefreshTokenClient(this.config);
                            return [2 /*return*/, refreshTokenClient.acquireTokenByRefreshToken(request)];
                        }
                        else {
                            throw e_1;
                        }
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    /**
     * Retrieves token from cache or throws an error if it must be refreshed.
     * @param request
     */
    SilentFlowClient.prototype.acquireCachedToken = function (request) {
        return __awaiter(this, void 0, void 0, function () {
            var requestScopes, environment, cacheRecord;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        // Cannot renew token if no request object is given.
                        if (!request) {
                            throw ClientConfigurationError.createEmptyTokenRequestError();
                        }
                        // We currently do not support silent flow for account === null use cases; This will be revisited for confidential flow usecases
                        if (!request.account) {
                            throw ClientAuthError.createNoAccountInSilentRequestError();
                        }
                        requestScopes = new ScopeSet(request.scopes || []);
                        environment = request.authority || Authority.generateEnvironmentFromAuthority(this.authority);
                        cacheRecord = this.cacheManager.readCacheRecord(request.account, this.config.authOptions.clientId, requestScopes, environment);
                        if (!this.isRefreshRequired(request, cacheRecord.accessToken)) return [3 /*break*/, 1];
                        throw ClientAuthError.createRefreshRequiredError();
                    case 1:
                        if (this.config.serverTelemetryManager) {
                            this.config.serverTelemetryManager.incrementCacheHits();
                        }
                        return [4 /*yield*/, this.generateResultFromCacheRecord(cacheRecord, request.resourceRequestMethod, request.resourceRequestUri)];
                    case 2: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    /**
     * Helper function to build response object from the CacheRecord
     * @param cacheRecord
     */
    SilentFlowClient.prototype.generateResultFromCacheRecord = function (cacheRecord, resourceRequestMethod, resourceRequestUri) {
        return __awaiter(this, void 0, void 0, function () {
            var idTokenObj;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        idTokenObj = new AuthToken(cacheRecord.idToken.secret, this.config.cryptoInterface);
                        return [4 /*yield*/, ResponseHandler.generateAuthenticationResult(this.cryptoUtils, cacheRecord, idTokenObj, true, null, resourceRequestMethod, resourceRequestUri)];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    /**
     * Given a request object and an accessTokenEntity determine if the accessToken needs to be refreshed
     * @param request
     * @param cachedAccessToken
     */
    SilentFlowClient.prototype.isRefreshRequired = function (request, cachedAccessToken) {
        if (request.forceRefresh || request.claims) {
            // Must refresh due to request parameters
            return true;
        }
        else if (!cachedAccessToken || TimeUtils.isTokenExpired(cachedAccessToken.expiresOn, this.config.systemOptions.tokenRenewalOffsetSeconds)) {
            // Must refresh due to expired or non-existent access_token
            return true;
        }
        return false;
    };
    return SilentFlowClient;
}(BaseClient));

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * Oauth2.0 Password grant client
 * Note: We are only supporting public clients for password grant and for purely testing purposes
 */
var UsernamePasswordClient = /** @class */ (function (_super) {
    __extends(UsernamePasswordClient, _super);
    function UsernamePasswordClient(configuration) {
        return _super.call(this, configuration) || this;
    }
    /**
     * API to acquire a token by passing the username and password to the service in exchage of credentials
     * password_grant
     * @param request
     */
    UsernamePasswordClient.prototype.acquireToken = function (request) {
        return __awaiter(this, void 0, void 0, function () {
            var response, responseHandler, tokenResponse;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.logger.info("in acquireToken call");
                        return [4 /*yield*/, this.executeTokenRequest(this.authority, request)];
                    case 1:
                        response = _a.sent();
                        responseHandler = new ResponseHandler(this.config.authOptions.clientId, this.cacheManager, this.cryptoUtils, this.logger, this.config.serializableCache, this.config.persistencePlugin);
                        // Validate response. This function throws a server error if an error is returned by the server.
                        responseHandler.validateTokenResponse(response.body);
                        tokenResponse = responseHandler.handleServerTokenResponse(response.body, this.authority);
                        return [2 /*return*/, tokenResponse];
                }
            });
        });
    };
    /**
     * Executes POST request to token endpoint
     * @param authority
     * @param request
     */
    UsernamePasswordClient.prototype.executeTokenRequest = function (authority, request) {
        return __awaiter(this, void 0, void 0, function () {
            var thumbprint, requestBody, headers;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        thumbprint = {
                            clientId: this.config.authOptions.clientId,
                            authority: authority.canonicalAuthority,
                            scopes: request.scopes
                        };
                        return [4 /*yield*/, this.createTokenRequestBody(request)];
                    case 1:
                        requestBody = _a.sent();
                        headers = this.createDefaultTokenRequestHeaders();
                        return [2 /*return*/, this.executePostToTokenEndpoint(authority.tokenEndpoint, requestBody, headers, thumbprint)];
                }
            });
        });
    };
    /**
     * Generates a map for all the params to be sent to the service
     * @param request
     */
    UsernamePasswordClient.prototype.createTokenRequestBody = function (request) {
        var parameterBuilder = new RequestParameterBuilder();
        parameterBuilder.addClientId(this.config.authOptions.clientId);
        parameterBuilder.addUsername(request.username);
        parameterBuilder.addPassword(request.password);
        parameterBuilder.addScopes(request.scopes);
        parameterBuilder.addGrantType(GrantType.RESOURCE_OWNER_PASSWORD_GRANT);
        parameterBuilder.addClientInfo();
        var correlationId = request.correlationId || this.config.cryptoInterface.createNewGuid();
        parameterBuilder.addCorrelationId(correlationId);
        if (!StringUtils.isEmpty(request.claims) || this.config.authOptions.clientCapabilities && this.config.authOptions.clientCapabilities.length > 0) {
            parameterBuilder.addClaims(request.claims, this.config.authOptions.clientCapabilities);
        }
        return parameterBuilder.createQueryString();
    };
    return UsernamePasswordClient;
}(BaseClient));

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
var AuthorityFactory = /** @class */ (function () {
    function AuthorityFactory() {
    }
    /**
     * Create an authority object of the correct type based on the url
     * Performs basic authority validation - checks to see if the authority is of a valid type (i.e. aad, b2c, adfs)
     *
     * Also performs endpoint discovery.
     *
     * @param authorityUri
     * @param networkClient
     * @param protocolMode
     */
    AuthorityFactory.createDiscoveredInstance = function (authorityUri, networkClient, protocolMode) {
        return __awaiter(this, void 0, void 0, function () {
            var acquireTokenAuthority, e_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        acquireTokenAuthority = AuthorityFactory.createInstance(authorityUri, networkClient, protocolMode);
                        if (acquireTokenAuthority.discoveryComplete()) {
                            return [2 /*return*/, acquireTokenAuthority];
                        }
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 4]);
                        return [4 /*yield*/, acquireTokenAuthority.resolveEndpointsAsync()];
                    case 2:
                        _a.sent();
                        return [2 /*return*/, acquireTokenAuthority];
                    case 3:
                        e_1 = _a.sent();
                        throw ClientAuthError.createEndpointDiscoveryIncompleteError(e_1);
                    case 4: return [2 /*return*/];
                }
            });
        });
    };
    /**
     * Create an authority object of the correct type based on the url
     * Performs basic authority validation - checks to see if the authority is of a valid type (i.e. aad, b2c, adfs)
     *
     * Does not perform endpoint discovery.
     *
     * @param authorityUrl
     * @param networkInterface
     * @param protocolMode
     */
    AuthorityFactory.createInstance = function (authorityUrl, networkInterface, protocolMode) {
        // Throw error if authority url is empty
        if (StringUtils.isEmpty(authorityUrl)) {
            throw ClientConfigurationError.createUrlEmptyError();
        }
        return new Authority(authorityUrl, networkInterface, protocolMode);
    };
    return AuthorityFactory;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
var ServerTelemetryEntity = /** @class */ (function () {
    function ServerTelemetryEntity() {
        this.failedRequests = [];
        this.errors = [];
        this.cacheHits = 0;
    }
    /**
     * validates if a given cache entry is "Telemetry", parses <key,value>
     * @param key
     * @param entity
     */
    ServerTelemetryEntity.isServerTelemetryEntity = function (key, entity) {
        var validateKey = key.indexOf(SERVER_TELEM_CONSTANTS.CACHE_KEY) === 0;
        var validateEntity = true;
        if (entity) {
            validateEntity =
                entity.hasOwnProperty("failedRequests") &&
                    entity.hasOwnProperty("errors") &&
                    entity.hasOwnProperty("cacheHits");
        }
        return validateKey && validateEntity;
    };
    return ServerTelemetryEntity;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
var ThrottlingEntity = /** @class */ (function () {
    function ThrottlingEntity() {
    }
    /**
     * validates if a given cache entry is "Throttling", parses <key,value>
     * @param key
     * @param entity
     */
    ThrottlingEntity.isThrottlingEntity = function (key, entity) {
        var validateKey = false;
        if (key) {
            validateKey = key.indexOf(ThrottlingConstants.THROTTLING_PREFIX) === 0;
        }
        var validateEntity = true;
        if (entity) {
            validateEntity = entity.hasOwnProperty("throttleTime");
        }
        return validateKey && validateEntity;
    };
    return ThrottlingEntity;
}());

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
var ServerTelemetryManager = /** @class */ (function () {
    function ServerTelemetryManager(telemetryRequest, cacheManager) {
        this.cacheManager = cacheManager;
        this.apiId = telemetryRequest.apiId;
        this.correlationId = telemetryRequest.correlationId;
        this.forceRefresh = telemetryRequest.forceRefresh || false;
        this.telemetryCacheKey = SERVER_TELEM_CONSTANTS.CACHE_KEY + Separators.CACHE_KEY_SEPARATOR + telemetryRequest.clientId;
    }
    /**
     * API to add MSER Telemetry to request
     */
    ServerTelemetryManager.prototype.generateCurrentRequestHeaderValue = function () {
        var forceRefreshInt = this.forceRefresh ? 1 : 0;
        var request = "" + this.apiId + SERVER_TELEM_CONSTANTS.VALUE_SEPARATOR + forceRefreshInt;
        var platformFields = ""; // TODO: Determine what we want to include
        return [SERVER_TELEM_CONSTANTS.SCHEMA_VERSION, request, platformFields].join(SERVER_TELEM_CONSTANTS.CATEGORY_SEPARATOR);
    };
    /**
     * API to add MSER Telemetry for the last failed request
     */
    ServerTelemetryManager.prototype.generateLastRequestHeaderValue = function () {
        var lastRequests = this.getLastRequests();
        var maxErrors = ServerTelemetryManager.maxErrorsToSend(lastRequests);
        var failedRequests = lastRequests.failedRequests.slice(0, 2 * maxErrors).join(SERVER_TELEM_CONSTANTS.VALUE_SEPARATOR);
        var errors = lastRequests.errors.slice(0, maxErrors).join(SERVER_TELEM_CONSTANTS.VALUE_SEPARATOR);
        var errorCount = lastRequests.errors.length;
        // Indicate whether this header contains all data or partial data
        var overflow = maxErrors < errorCount ? SERVER_TELEM_CONSTANTS.OVERFLOW_TRUE : SERVER_TELEM_CONSTANTS.OVERFLOW_FALSE;
        var platformFields = [errorCount, overflow].join(SERVER_TELEM_CONSTANTS.VALUE_SEPARATOR);
        return [SERVER_TELEM_CONSTANTS.SCHEMA_VERSION, lastRequests.cacheHits, failedRequests, errors, platformFields].join(SERVER_TELEM_CONSTANTS.CATEGORY_SEPARATOR);
    };
    /**
     * API to cache token failures for MSER data capture
     * @param error
     */
    ServerTelemetryManager.prototype.cacheFailedRequest = function (error) {
        var lastRequests = this.getLastRequests();
        lastRequests.failedRequests.push(this.apiId, this.correlationId);
        if (!StringUtils.isEmpty(error.suberror)) {
            lastRequests.errors.push(error.suberror);
        }
        else if (!StringUtils.isEmpty(error.errorCode)) {
            lastRequests.errors.push(error.errorCode);
        }
        else if (!!error && error.toString()) {
            lastRequests.errors.push(error.toString());
        }
        else {
            lastRequests.errors.push(SERVER_TELEM_CONSTANTS.UNKNOWN_ERROR);
        }
        this.cacheManager.setServerTelemetry(this.telemetryCacheKey, lastRequests);
        return;
    };
    /**
     * Update server telemetry cache entry by incrementing cache hit counter
     */
    ServerTelemetryManager.prototype.incrementCacheHits = function () {
        var lastRequests = this.getLastRequests();
        lastRequests.cacheHits += 1;
        this.cacheManager.setServerTelemetry(this.telemetryCacheKey, lastRequests);
        return lastRequests.cacheHits;
    };
    /**
     * Get the server telemetry entity from cache or initialize a new one
     */
    ServerTelemetryManager.prototype.getLastRequests = function () {
        var initialValue = new ServerTelemetryEntity();
        var lastRequests = this.cacheManager.getServerTelemetry(this.telemetryCacheKey);
        return lastRequests || initialValue;
    };
    /**
     * Remove server telemetry cache entry
     */
    ServerTelemetryManager.prototype.clearTelemetryCache = function () {
        var lastRequests = this.getLastRequests();
        var numErrorsFlushed = ServerTelemetryManager.maxErrorsToSend(lastRequests);
        var errorCount = lastRequests.errors.length;
        if (numErrorsFlushed === errorCount) {
            // All errors were sent on last request, clear Telemetry cache
            this.cacheManager.removeItem(this.telemetryCacheKey);
        }
        else {
            // Partial data was flushed to server, construct a new telemetry cache item with errors that were not flushed
            var serverTelemEntity = new ServerTelemetryEntity();
            serverTelemEntity.failedRequests = lastRequests.failedRequests.slice(numErrorsFlushed * 2); // failedRequests contains 2 items for each error
            serverTelemEntity.errors = lastRequests.errors.slice(numErrorsFlushed);
            this.cacheManager.setServerTelemetry(this.telemetryCacheKey, serverTelemEntity);
        }
    };
    /**
     * Returns the maximum number of errors that can be flushed to the server in the next network request
     * @param serverTelemetryEntity
     */
    ServerTelemetryManager.maxErrorsToSend = function (serverTelemetryEntity) {
        var i;
        var maxErrors = 0;
        var dataSize = 0;
        var errorCount = serverTelemetryEntity.errors.length;
        for (i = 0; i < errorCount; i++) {
            // failedRequests parameter contains pairs of apiId and correlationId, multiply index by 2 to preserve pairs
            var apiId = serverTelemetryEntity.failedRequests[2 * i] || Constants.EMPTY_STRING;
            var correlationId = serverTelemetryEntity.failedRequests[2 * i + 1] || Constants.EMPTY_STRING;
            var errorCode = serverTelemetryEntity.errors[i] || Constants.EMPTY_STRING;
            // Count number of characters that would be added to header, each character is 1 byte. Add 3 at the end to account for separators
            dataSize += apiId.toString().length + correlationId.toString().length + errorCode.length + 3;
            if (dataSize < SERVER_TELEM_CONSTANTS.MAX_HEADER_BYTES) {
                // Adding this entry to the header would still keep header size below the limit
                maxErrors += 1;
            }
            else {
                break;
            }
        }
        return maxErrors;
    };
    return ServerTelemetryManager;
}());

export { AccessTokenEntity, AccountEntity, AppMetadataEntity, AuthError, AuthErrorMessage, AuthToken, AuthenticationScheme, Authority, AuthorityFactory, AuthorityType, AuthorizationCodeClient, CacheAccountType, CacheManager, CacheSchemaType, CacheType, ClientAuthError, ClientAuthErrorMessage, ClientConfigurationError, ClientConfigurationErrorMessage, ClientCredentialClient, Constants, CredentialEntity, CredentialType, DEFAULT_SYSTEM_OPTIONS, DeviceCodeClient, AuthToken as IdToken, IdTokenEntity, InteractionRequiredAuthError, LogLevel, Logger, NetworkManager, OnBehalfOfClient, PersistentCacheKeys, PromptValue, ProtocolMode, ProtocolUtils, RefreshTokenClient, RefreshTokenEntity, ResponseMode, ServerError, ServerTelemetryEntity, ServerTelemetryManager, SilentFlowClient, StringUtils, ThrottlingEntity, ThrottlingUtils, TimeUtils, TokenCacheContext, TrustedAuthority, UrlString, UsernamePasswordClient };
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
