
var Lorem = function (faker) {
  var self = this;
  var Helpers = faker.helpers;

  self.words = function (num) {
      if (typeof num == 'undefined') { num = 3; }
      return Helpers.shuffle(faker.definitions.lorem.words).slice(0, num);
  };

  self.sentence = function (wordCount, range) {
      if (typeof wordCount == 'undefined') { wordCount = 3; }
      if (typeof range == 'undefined') { range = 7; }

      // strange issue with the node_min_test failing for captialize, please fix and add faker.lorem.back
      //return  faker.lorem.words(wordCount + Helpers.randomNumber(range)).join(' ').capitalize();

      var sentence = faker.lorem.words(wordCount + faker.random.number(range)).join(' ');
      return sentence.charAt(0).toUpperCase() + sentence.slice(1) + '.';
  };

  self.sentences = function (sentenceCount) {
      if (typeof sentenceCount == 'undefined') { sentenceCount = 3; }
      var sentences = [];
      for (sentenceCount; sentenceCount > 0; sentenceCount--) {
        sentences.push(faker.lorem.sentence());
      }
      return sentences.join("\n");
  };

  self.paragraph = function (sentenceCount) {
      if (typeof sentenceCount == 'undefined') { sentenceCount = 3; }
      return faker.lorem.sentences(sentenceCount + faker.random.number(3));
  };

  self.paragraphs = function (paragraphCount, separator) {
    if (typeof separator === "undefined") {
      separator = "\n \r";
    }
    if (typeof paragraphCount == 'undefined') { paragraphCount = 3; }
    var paragraphs = [];
    for (paragraphCount; paragraphCount > 0; paragraphCount--) {
        paragraphs.push(faker.lorem.paragraph());
    }
    return paragraphs.join(separator);
  }
  
  return self;
};


module["exports"] = Lorem;
