function Address (faker) {
  var f = faker.fake,
      Helpers = faker.helpers;

  this.zipCode = function(format) {
    // if zip format is not specified, use the zip format defined for the locale
    if (typeof format === 'undefined') {
      var localeFormat = faker.definitions.address.postcode;
      if (typeof localeFormat === 'string') {
        format = localeFormat;
      } else {
        format = faker.random.arrayElement(localeFormat);
      }
    }
    return Helpers.replaceSymbols(format);
  }

  this.city = function (format) {
    var formats = [
      '{{address.cityPrefix}} {{name.firstName}} {{address.citySuffix}}',
      '{{address.cityPrefix}} {{name.firstName}}',
      '{{name.firstName}} {{address.citySuffix}}',
      '{{name.lastName}} {{address.citySuffix}}'
    ];

    if (typeof format !== "number") {
      format = faker.random.number(formats.length - 1);
    }

    return f(formats[format]);

  }

  this.cityPrefix = function () {
    return faker.random.arrayElement(faker.definitions.address.city_prefix);
  }

  this.citySuffix = function () {
    return faker.random.arrayElement(faker.definitions.address.city_suffix);
  }

  this.streetName = function () {
      var result;
      var suffix = faker.address.streetSuffix();
      if (suffix !== "") {
          suffix = " " + suffix
      }

      switch (faker.random.number(1)) {
      case 0:
          result = faker.name.lastName() + suffix;
          break;
      case 1:
          result = faker.name.firstName() + suffix;
          break;
      }
      return result;
  }

  //
  // TODO: change all these methods that accept a boolean to instead accept an options hash.
  //
  this.streetAddress = function (useFullAddress) {
      if (useFullAddress === undefined) { useFullAddress = false; }
      var address = "";
      switch (faker.random.number(2)) {
      case 0:
          address = Helpers.replaceSymbolWithNumber("#####") + " " + faker.address.streetName();
          break;
      case 1:
          address = Helpers.replaceSymbolWithNumber("####") +  " " + faker.address.streetName();
          break;
      case 2:
          address = Helpers.replaceSymbolWithNumber("###") + " " + faker.address.streetName();
          break;
      }
      return useFullAddress ? (address + " " + faker.address.secondaryAddress()) : address;
  }

  this.streetSuffix = function () {
      return faker.random.arrayElement(faker.definitions.address.street_suffix);
  }
  
  this.streetPrefix = function () {
      return faker.random.arrayElement(faker.definitions.address.street_prefix);
  }

  this.secondaryAddress = function () {
      return Helpers.replaceSymbolWithNumber(faker.random.arrayElement(
          [
              'Apt. ###',
              'Suite ###'
          ]
      ));
  }

  this.county = function () {
    return faker.random.arrayElement(faker.definitions.address.county);
  }

  this.country = function () {
    return faker.random.arrayElement(faker.definitions.address.country);
  }

  this.countryCode = function () {
    return faker.random.arrayElement(faker.definitions.address.country_code);
  }

  this.state = function (useAbbr) {
      return faker.random.arrayElement(faker.definitions.address.state);
  }

  this.stateAbbr = function () {
      return faker.random.arrayElement(faker.definitions.address.state_abbr);
  }

  this.latitude = function () {
      return (faker.random.number(180 * 10000) / 10000.0 - 90.0).toFixed(4);
  }

  this.longitude = function () {
      return (faker.random.number(360 * 10000) / 10000.0 - 180.0).toFixed(4);
  }
  
  return this;
}


module.exports = Address;
