/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.cff;

import java.io.IOException;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASMemoryInStream;
import org.verapdf.pd.font.CFFNumber;
import org.verapdf.pd.font.cff.CFFIndex;
import org.verapdf.pd.font.type1.BaseCharStringParser;

class Type2CharStringParser
extends BaseCharStringParser {
    private static final int TWO_POWER_16 = 65536;

    Type2CharStringParser(ASInputStream stream) throws IOException {
        super(stream);
    }

    Type2CharStringParser(ASInputStream stream, CFFIndex localSubrs, int bias, CFFIndex globalSubrs, int gBias) throws IOException {
        super(stream, localSubrs, bias, globalSubrs, gBias);
    }

    @Override
    protected boolean processNextOperator(int nextByte) throws IOException {
        switch (nextByte) {
            case 19: 
            case 20: {
                if (this.stack.empty()) break;
                this.setWidth((CFFNumber)this.stack.get(0));
                break;
            }
            case 14: {
                if (this.stack.empty() || this.stack.size() == 4) break;
                this.setWidth((CFFNumber)this.stack.get(0));
                break;
            }
            case 4: 
            case 22: {
                if (this.stack.size() <= 1) break;
                this.setWidth((CFFNumber)this.stack.get(0));
                break;
            }
            case 21: {
                if (this.stack.size() <= 2) break;
                this.setWidth((CFFNumber)this.stack.get(0));
                break;
            }
            case 1: 
            case 3: 
            case 18: 
            case 23: {
                if (this.stack.size() % 2 != 1) break;
                this.setWidth((CFFNumber)this.stack.get(0));
                break;
            }
            case 28: {
                this.stack.push(this.readNextNumber(nextByte));
                return false;
            }
            case 10: {
                return this.execSubr(this.localSubrs, this.bias);
            }
            case 29: {
                return this.execSubr(this.globalSubrs, this.gBias);
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: {
                break;
            }
            case 11: {
                return false;
            }
        }
        return true;
    }

    private boolean execSubr(CFFIndex subrs, int bias) throws IOException {
        int subrNum = (int)((CFFNumber)this.stack.pop()).getInteger();
        if (subrs.size() > subrNum + bias) {
            byte[] subr = subrs.get(subrNum + bias);
            ASMemoryInStream subrStream = new ASMemoryInStream(subr, subr.length, false);
            this.addStream(subrStream);
        }
        return false;
    }

    @Override
    protected CFFNumber readNextNumber(int firstByte) throws IOException {
        byte[] buf = new byte[4];
        if (firstByte == 28) {
            this.readStreams(buf, 2);
            return new CFFNumber((short)((buf[0] & 0xFF) << 8 | buf[1] & 0xFF));
        }
        this.readStreams(buf, 4);
        int integer = 0;
        for (int i = 0; i < 3; ++i) {
            integer |= buf[i] & 0xFF;
            integer <<= 8;
        }
        float res = integer |= buf[3] & 0xFF;
        return new CFFNumber(res / 65536.0f);
    }
}

