/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import java.util.Set;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.io.ConfigIOServiceProducer;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.Path;

@WebListener
public class LockCleanupSessionListener
implements HttpSessionListener {
    private static final Logger logger = LoggerFactory.getLogger(LockCleanupSessionListener.class);

    public void sessionCreated(HttpSessionEvent se) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent se) {
        ConfigIOServiceProducer ioServiceProducer = ConfigIOServiceProducer.getInstance();
        IOService ioService = ioServiceProducer.configIOService();
        FileSystem fileSystem = ioServiceProducer.configFileSystem();
        Set locks = (Set)se.getSession().getAttribute("uf-locks");
        if (locks != null) {
            try {
                ioService.startBatch(fileSystem);
                for (LockInfo lock : locks) {
                    try {
                        Path lockPath = Paths.convert(PathFactory.newLock((org.uberfire.backend.vfs.Path)lock.getFile()));
                        if (!ioService.readAllString(lockPath).equals(lock.lockedBy())) continue;
                        ioService.delete(lockPath, new DeleteOption[0]);
                    }
                    catch (NoSuchFileException e) {
                        logger.debug("Problem when releasing lock on session end (lock no longer exists): " + lock, (Throwable)e);
                    }
                    catch (Throwable t) {
                        logger.warn("Problem when releasing lock on session end: " + lock, t);
                    }
                }
            }
            finally {
                ioService.endBatch();
            }
        }
    }
}

