/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.cli;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jline.Completor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandsCompletor
implements Completor {
    private final List<String> availableCommands = new ArrayList<String>();

    public CommandsCompletor(Collection<String> commands) {
        this.availableCommands.addAll(commands);
        Collections.sort(this.availableCommands, String.CASE_INSENSITIVE_ORDER);
    }

    @Override
    public int complete(String buffer, int cursor, List candidates) {
        String completionToken = buffer;
        String[] tokens = buffer.split(" ");
        String lastToken = null;
        if (tokens.length > 0) {
            lastToken = tokens[tokens.length - 1];
        }
        for (String availableCommand : this.availableCommands) {
            if (availableCommand.startsWith(buffer)) {
                candidates.add(availableCommand);
            }
            if (lastToken == null || !availableCommand.startsWith(lastToken)) continue;
            completionToken = lastToken;
            candidates.add(availableCommand);
        }
        return cursor - completionToken.length();
    }
}

