/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity5.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.expression.EvaluationContext;
import org.springframework.web.server.ServerWebExchange;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.expression.IExpressionObjects;
import org.thymeleaf.extras.springsecurity5.util.ISpringVersionSpecificUtility;
import org.thymeleaf.spring5.expression.ThymeleafEvaluationContextWrapper;
import org.thymeleaf.spring5.web.webflux.ISpringWebFluxWebExchange;
import org.thymeleaf.web.IWebExchange;
import org.thymeleaf.web.servlet.IServletWebExchange;

final class Spring5VersionSpecificUtility
implements ISpringVersionSpecificUtility {
    Spring5VersionSpecificUtility() {
    }

    @Override
    public EvaluationContext wrapEvaluationContext(EvaluationContext evaluationContext, IExpressionObjects expresionObjects) {
        ThymeleafEvaluationContextWrapper thymeleafEvaluationContext = new ThymeleafEvaluationContextWrapper(evaluationContext);
        thymeleafEvaluationContext.setExpressionObjects(expresionObjects);
        return thymeleafEvaluationContext;
    }

    @Override
    public boolean isWebContext(IContext context) {
        return context instanceof IWebContext;
    }

    @Override
    public boolean isWebMvcContext(IContext context) {
        IWebContext webContext;
        IWebExchange webExchange;
        return context instanceof IWebContext && (webExchange = (webContext = (IWebContext)context).getExchange()) instanceof IServletWebExchange;
    }

    @Override
    public boolean isWebFluxContext(IContext context) {
        if (!this.isWebContext(context)) {
            return false;
        }
        return Spring5VersionSpecificUtility.getWebExchange(context) instanceof ISpringWebFluxWebExchange;
    }

    @Override
    public HttpServletRequest getHttpServletRequest(IContext context) {
        return (HttpServletRequest)Spring5VersionSpecificUtility.getServletWebExchange(context).getNativeRequestObject();
    }

    @Override
    public HttpServletResponse getHttpServletResponse(IContext context) {
        return (HttpServletResponse)Spring5VersionSpecificUtility.getServletWebExchange(context).getNativeResponseObject();
    }

    @Override
    public ServerWebExchange getServerWebExchange(IContext context) {
        IWebExchange webExchange = Spring5VersionSpecificUtility.getWebExchange(context);
        if (webExchange instanceof ISpringWebFluxWebExchange) {
            ISpringWebFluxWebExchange webFluxWebExchange = (ISpringWebFluxWebExchange)webExchange;
            return (ServerWebExchange)webFluxWebExchange.getNativeExchangeObject();
        }
        throw new TemplateProcessingException("Cannot obtain ServerWebExchange from a non-WebFlux context implementation (\"" + context.getClass().getName() + "\")");
    }

    private static IServletWebExchange getServletWebExchange(IContext context) {
        IWebExchange webExchange = Spring5VersionSpecificUtility.getWebExchange(context);
        if (webExchange instanceof IServletWebExchange) {
            return (IServletWebExchange)webExchange;
        }
        throw new TemplateProcessingException("Cannot obtain IServletWebExchange from a non-Servlet context implementation (\"" + context.getClass().getName() + "\")");
    }

    private static IWebExchange getWebExchange(IContext context) {
        if (context instanceof IWebContext) {
            IWebContext webContext = (IWebContext)context;
            return webContext.getExchange();
        }
        throw new TemplateProcessingException("Cannot obtain IWebExchange from a non-Servlet context implementation (\"" + context.getClass().getName() + "\")");
    }
}

