/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.tools.logger;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.pattern.Abbreviator;
import ch.qos.logback.classic.pattern.TargetLengthBasedClassNameAbbreviator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.LayoutBase;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.fusesource.jansi.Ansi;

public class TestifyLayout
extends LayoutBase<ILoggingEvent> {
    public static final String METHOD_MDC_KEY = "method";
    public static final String TEST_MDC_KEY = "test";
    private final Abbreviator abbreviator = new TargetLengthBasedClassNameAbbreviator(36);

    public String doLayout(ILoggingEvent event) {
        StringBuilder builder = new StringBuilder(512);
        Map mdcMap = event.getMDCPropertyMap();
        LocalDateTime dateTime = Instant.ofEpochMilli(event.getTimeStamp()).atZone(ZoneOffset.UTC).toLocalDateTime();
        String loggerName = event.getLoggerName();
        String foramttedDateTime = this.paddRight(dateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME), 23);
        builder.append("[").append(foramttedDateTime).append("]").append("[").append(this.getLevelMessage(event.getLevel())).append("]");
        if (mdcMap.containsKey(TEST_MDC_KEY) && mdcMap.containsKey(METHOD_MDC_KEY)) {
            builder.append("[").append(this.getMagentaMessage((String)mdcMap.get(TEST_MDC_KEY))).append("]").append("[").append(this.getMagentaMessage((String)mdcMap.get(METHOD_MDC_KEY))).append("]");
        }
        String abbreviateLoggerName = this.abbreviator.abbreviate(loggerName);
        builder.append("[").append(this.getMagentaMessage(abbreviateLoggerName)).append("]").append(": ").append(event.getFormattedMessage()).append(CoreConstants.LINE_SEPARATOR);
        return builder.toString();
    }

    String getMagentaMessage(String loggerName) {
        return Ansi.ansi().bold().fgMagenta().a(loggerName).reset().toString();
    }

    String getLevelMessage(Level level) {
        Ansi.Color color;
        String message = this.paddRight(level.toString(), 5);
        switch (level.toInt()) {
            case 40000: {
                color = Ansi.Color.RED;
                break;
            }
            case 30000: {
                color = Ansi.Color.RED;
                break;
            }
            case 20000: {
                color = Ansi.Color.BLUE;
                break;
            }
            default: {
                color = Ansi.Color.DEFAULT;
            }
        }
        return Ansi.ansi().bold().fg(color).a(message).reset().toString();
    }

    String paddRight(String value, int maxColumns) {
        return String.format("%1$-" + maxColumns + "s", value);
    }
}

