/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.level.system;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import org.testifyproject.ClientInstance;
import org.testifyproject.ClientProvider;
import org.testifyproject.Instance;
import org.testifyproject.ResourceController;
import org.testifyproject.ServerInstance;
import org.testifyproject.ServerProvider;
import org.testifyproject.ServiceInstance;
import org.testifyproject.ServiceProvider;
import org.testifyproject.SutDescriptor;
import org.testifyproject.TestConfigurer;
import org.testifyproject.TestContext;
import org.testifyproject.TestDescriptor;
import org.testifyproject.TestRunner;
import org.testifyproject.annotation.Application;
import org.testifyproject.annotation.Hint;
import org.testifyproject.core.DefaultServerProvider;
import org.testifyproject.core.DefaultServiceProvider;
import org.testifyproject.core.util.ExceptionUtil;
import org.testifyproject.core.util.LoggingUtil;
import org.testifyproject.core.util.ReflectionUtil;
import org.testifyproject.core.util.ServiceLocatorUtil;
import org.testifyproject.extension.CollaboratorReifier;
import org.testifyproject.extension.FinalReifier;
import org.testifyproject.extension.PostVerifier;
import org.testifyproject.extension.PreVerifier;
import org.testifyproject.extension.Verifier;
import org.testifyproject.extension.annotation.SystemCategory;

@SystemCategory
public class SystemTestRunner
implements TestRunner {
    ResourceController resourceController;
    private final ServiceLocatorUtil serviceLocatorUtil;
    private final ReflectionUtil reflectionUtil;

    public SystemTestRunner() {
        this(ServiceLocatorUtil.INSTANCE, ReflectionUtil.INSTANCE);
    }

    SystemTestRunner(ServiceLocatorUtil serviceLocatorUtil, ReflectionUtil reflectionUtil) {
        this.serviceLocatorUtil = serviceLocatorUtil;
        this.reflectionUtil = reflectionUtil;
    }

    public void start(TestContext testContext) {
        TestConfigurer testConfigurer = testContext.getTestConfigurer();
        TestDescriptor testDescriptor = testContext.getTestDescriptor();
        Optional foundSutDescriptor = testContext.getSutDescriptor();
        Object testInstance = testContext.getTestInstance();
        Collection guidelines = testDescriptor.getGuidelines();
        Optional foundApplication = testDescriptor.getApplication();
        foundApplication.ifPresent(application -> {
            try {
                this.serviceLocatorUtil.findAllWithFilter(CollaboratorReifier.class, new Class[]{SystemCategory.class}).forEach(p -> p.reify(testContext));
                this.serviceLocatorUtil.findAllWithFilter(PreVerifier.class, guidelines, new Class[]{SystemCategory.class}).forEach(p -> p.verify(testContext));
                testContext.verify();
                this.resourceController = (ResourceController)this.serviceLocatorUtil.getOne(ResourceController.class);
                this.resourceController.start(testContext);
                ServerProvider serverProvider = this.createServerProvider(testContext, (Application)application);
                ClientProvider clientProvider = this.createClientProvider(testContext, (Application)application);
                this.createServer(testContext, testConfigurer, serverProvider, (Application)application);
                this.createClient(testContext, testConfigurer, clientProvider, (Application)application);
            }
            catch (Exception ex) {
                throw ExceptionUtil.INSTANCE.propagate((Throwable)ex);
            }
            ServiceInstance serviceInstance = this.createService(testContext, testDescriptor, testConfigurer);
            if (foundSutDescriptor.isPresent()) {
                SutDescriptor sutDescriptor = (SutDescriptor)foundSutDescriptor.get();
                this.createSut(testContext, sutDescriptor, serviceInstance, testInstance);
            }
            this.serviceLocatorUtil.findAllWithFilter(FinalReifier.class, new Class[]{SystemCategory.class}).forEach(p -> p.reify(testContext));
            this.serviceLocatorUtil.findAllWithFilter(Verifier.class, guidelines, new Class[]{SystemCategory.class}).forEach(p -> p.verify(testContext));
            testContext.verify();
        });
    }

    public void stop(TestContext testContext) {
        TestDescriptor testDescriptor = testContext.getTestDescriptor();
        Object testInstance = testContext.getTestInstance();
        Optional sutDescriptor = testContext.getSutDescriptor();
        Collection guidelines = testDescriptor.getGuidelines();
        this.serviceLocatorUtil.findAllWithFilter(PostVerifier.class, guidelines, new Class[]{SystemCategory.class}).forEach(p -> p.verify(testContext));
        testContext.verify();
        testDescriptor.getFieldDescriptors().forEach(p -> p.destroy(testInstance));
        sutDescriptor.ifPresent(p -> p.destroy(testInstance));
        Optional foundClientInstance = testContext.findProperty("appClientInstance");
        Optional foundClientProvider = testContext.findProperty("appClientProvider");
        if (foundClientInstance.isPresent() && foundClientProvider.isPresent()) {
            ClientInstance clientInstance = (ClientInstance)foundClientInstance.get();
            ClientProvider clientProvider = (ClientProvider)foundClientProvider.get();
            try {
                clientProvider.destroy(clientInstance);
            }
            catch (Exception e) {
                LoggingUtil.INSTANCE.error("Could not destroy client provider '{}'", new Object[]{clientProvider.getClass().getSimpleName(), e});
            }
        }
        Optional foundServerInstance = testContext.findProperty("appServerInstance");
        Optional foundServerProvider = testContext.findProperty("appServerProvider");
        if (foundServerInstance.isPresent() && foundServerProvider.isPresent()) {
            ServerInstance serverInstance = (ServerInstance)foundServerInstance.get();
            ServerProvider serverProvider = (ServerProvider)foundServerProvider.get();
            try {
                serverProvider.stop(serverInstance);
            }
            catch (Exception e) {
                LoggingUtil.INSTANCE.error("Could not destroy server provider '{}'", new Object[]{serverProvider.getClass().getSimpleName(), e});
            }
        }
        this.resourceController.stop(testContext);
    }

    ServerProvider createServerProvider(TestContext testContext, Application application) {
        Object serverProvider;
        Class serverProviderType = application.serverProvider();
        if (ServerProvider.class.equals((Object)serverProviderType)) {
            String start = application.start();
            String stop = application.stop();
            serverProvider = !start.isEmpty() && !stop.isEmpty() ? new DefaultServerProvider() : (ServerProvider)this.serviceLocatorUtil.getOne(serverProviderType);
        } else {
            serverProvider = (ServerProvider)this.reflectionUtil.newInstance(serverProviderType, new Object[0]);
        }
        testContext.addProperty("appServerProvider", serverProvider);
        return serverProvider;
    }

    ClientProvider createClientProvider(TestContext testContext, Application application) {
        Class clientProviderType = application.clientProvider();
        ClientProvider clientProvider = clientProviderType.equals(ClientProvider.class) ? (ClientProvider)this.serviceLocatorUtil.getOne(clientProviderType) : (ClientProvider)this.reflectionUtil.newInstance(clientProviderType, new Object[0]);
        testContext.addProperty("appClientProvider", (Object)clientProvider);
        return clientProvider;
    }

    ServiceInstance createService(TestContext testContext, TestDescriptor testDescriptor, TestConfigurer testConfigurer) {
        ServiceInstance serviceInstance;
        Optional foundServiceInstance = testContext.findProperty("serviceInstance");
        if (foundServiceInstance.isPresent()) {
            serviceInstance = (ServiceInstance)foundServiceInstance.get();
        } else {
            ServiceProvider serviceProvider = (ServiceProvider)this.serviceLocatorUtil.getFromHintOrDefault(testContext, ServiceProvider.class, DefaultServiceProvider.class, Hint::serviceProvider);
            Object serviceContext = serviceProvider.create(testContext);
            testConfigurer.configure(testContext, serviceContext);
            serviceInstance = serviceProvider.configure(testContext, serviceContext);
            testContext.addProperty("serviceInstance", (Object)serviceInstance);
            serviceProvider.postConfigure(testContext, serviceInstance);
        }
        return serviceInstance;
    }

    void createServer(TestContext testContext, TestConfigurer testConfigurer, ServerProvider serverProvider, Application application) throws Exception {
        Object serverConfig = serverProvider.configure(testContext);
        serverConfig = testConfigurer.configure(testContext, serverConfig);
        ServerInstance serverInstance = serverProvider.start(testContext, application, serverConfig);
        testContext.addProperty("appServerInstance", (Object)serverInstance).addProperty(serverInstance.getFqn(), (Object)serverInstance.getProperties()).addProperty("baseURI", (Object)serverInstance.getBaseURI()).addProperty("appServer", serverInstance.getServer().getValue());
    }

    void createClient(TestContext testContext, TestConfigurer testConfigurer, ClientProvider clientProvider, Application application) {
        URI baseURI = (URI)testContext.getProperty("baseURI");
        Object clientConfig = clientProvider.configure(testContext, application, baseURI);
        clientConfig = testConfigurer.configure(testContext, clientConfig);
        ClientInstance clientInstance = clientProvider.create(testContext, application, baseURI, clientConfig);
        testContext.addProperty("appClientInstance", (Object)clientInstance).addProperty(clientInstance.getFqn(), (Object)clientInstance.getProperties()).addProperty("appClient", clientInstance.getClient().getValue());
        clientInstance.getClientSupplier().map(Instance::getValue).ifPresent(value -> testContext.addProperty("appClientSupplier", value));
    }

    void createSut(TestContext testContext, SutDescriptor sutDescriptor, ServiceInstance serviceInstance, Object testInstance) {
        Class sutType = sutDescriptor.getType();
        Optional foundClientInstance = testContext.findProperty("appClientInstance");
        Object sutValue = null;
        if (ClientInstance.class.isAssignableFrom(sutType)) {
            sutValue = serviceInstance.getService((Type)sutType, new Annotation[0]);
        } else if (foundClientInstance.isPresent()) {
            ClientInstance clientInstance = (ClientInstance)foundClientInstance.get();
            Instance client = clientInstance.getClient();
            String clientName = client.getName();
            Class clientContract = client.getContract();
            if (sutType.isAssignableFrom(clientContract)) {
                try {
                    sutValue = serviceInstance.getService((Type)sutType, clientName);
                }
                catch (Exception e) {
                    LoggingUtil.INSTANCE.debug("could not find client of type '{}'", new Object[]{clientContract});
                }
                if (sutValue == null) {
                    sutValue = client.getValue();
                }
            }
            Optional foundClientSupplier = clientInstance.getClientSupplier();
            if (sutValue == null && foundClientSupplier.isPresent()) {
                Instance clientSupplier = (Instance)foundClientSupplier.get();
                String clientSupplierName = clientSupplier.getName();
                Class clientSupplierContract = clientSupplier.getContract();
                if (sutType.isAssignableFrom(clientSupplierContract)) {
                    try {
                        sutValue = serviceInstance.getService((Type)sutType, clientSupplierName);
                    }
                    catch (Exception e) {
                        LoggingUtil.INSTANCE.debug("could not find client supplier of type '{}'", new Object[]{clientContract, e});
                    }
                }
            }
        }
        sutDescriptor.setValue(testInstance, sutValue);
    }
}

