/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.upgradability.interaction.localtoolkit.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.ReadWriteLock;
import org.terracotta.toolkit.concurrent.locks.ToolkitLock;
import org.terracotta.toolkit.concurrent.locks.ToolkitReadWriteLock;
import org.terracotta.toolkit.internal.collections.ToolkitListInternal;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LockedIterator;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LockedListIterator;
import org.terracotta.upgradability.interaction.localtoolkit.concurrent.locks.AnonymousLocalReadWriteLock;
import org.terracotta.upgradability.interaction.localtoolkit.object.LocalDestroyableToolkitObject;

public class LocalList<E>
extends LocalDestroyableToolkitObject
implements ToolkitListInternal<E> {
    private final ToolkitReadWriteLock lock;
    private final List<E> backing;

    public LocalList(String name) {
        this(name, new AnonymousLocalReadWriteLock(), new ArrayList());
    }

    private LocalList(String name, ToolkitReadWriteLock lock, List<E> backing) {
        super(name);
        this.lock = lock;
        this.backing = backing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            int n = this.backing.size();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            boolean bl = this.backing.isEmpty();
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            boolean bl = this.backing.contains(o);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    public Iterator<E> iterator() {
        return new LockedIterator<E>((ReadWriteLock)this.lock, this.backing.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            Object[] objectArray = this.backing.toArray();
            return objectArray;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T[] toArray(T[] a) {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            T[] TArray = this.backing.toArray(a);
            return TArray;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(E e) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            boolean bl = this.backing.add(e);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            boolean bl = this.backing.remove(o);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection<?> c) {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            boolean bl = this.backing.containsAll(c);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection<? extends E> c) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            boolean bl = this.backing.addAll(c);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int index, Collection<? extends E> c) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            boolean bl = this.backing.addAll(index, c);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection<?> c) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            boolean bl = this.backing.removeAll(c);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection<?> c) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            boolean bl = this.backing.retainAll(c);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            this.backing.clear();
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E get(int index) {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            E e = this.backing.get(index);
            return e;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E set(int index, E element) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            E e = this.backing.set(index, element);
            return e;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, E element) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            this.backing.add(index, element);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E remove(int index) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            E e = this.backing.remove(index);
            return e;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object o) {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            int n = this.backing.indexOf(o);
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object o) {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            int n = this.backing.lastIndexOf(o);
            return n;
        }
        finally {
            l.unlock();
        }
    }

    public ListIterator<E> listIterator() {
        return new LockedListIterator<E>((ReadWriteLock)this.lock, this.backing.listIterator());
    }

    public ListIterator<E> listIterator(int index) {
        return new LockedListIterator<E>((ReadWriteLock)this.lock, this.backing.listIterator(index));
    }

    public List<E> subList(int fromIndex, int toIndex) {
        return new LocalList<E>(this.getName(), this.lock, this.backing.subList(fromIndex, toIndex));
    }

    public ToolkitReadWriteLock getReadWriteLock() {
        return this.lock;
    }

    public boolean unlockedAdd(E e) {
        return this.add(e);
    }
}

