/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.upgradability.interaction.localtoolkit.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import org.terracotta.toolkit.cache.ToolkitCacheListener;
import org.terracotta.toolkit.cluster.ClusterNode;
import org.terracotta.toolkit.concurrent.locks.ToolkitLock;
import org.terracotta.toolkit.concurrent.locks.ToolkitReadWriteLock;
import org.terracotta.toolkit.config.Configuration;
import org.terracotta.toolkit.internal.cache.ToolkitCacheInternal;
import org.terracotta.toolkit.internal.cache.ToolkitValueComparator;
import org.terracotta.toolkit.internal.cache.VersionUpdateListener;
import org.terracotta.toolkit.internal.cache.VersionedValue;
import org.terracotta.toolkit.search.QueryBuilder;
import org.terracotta.toolkit.search.attribute.ToolkitAttributeExtractor;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LockedCollection;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LockedSet;
import org.terracotta.upgradability.interaction.localtoolkit.concurrent.locks.AnonymousLocalReadWriteLock;
import org.terracotta.upgradability.interaction.localtoolkit.object.LocalDestroyableToolkitObject;

public class LocalCache<K, V>
extends LocalDestroyableToolkitObject
implements ToolkitCacheInternal<K, V> {
    private final ToolkitReadWriteLock lock = new AnonymousLocalReadWriteLock();
    private final Map<K, V> backing = new HashMap();
    private final Configuration config;

    public LocalCache(String name, Configuration config, Class<K> keyType, Class<V> valueType) {
        super(name);
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNoReturn(Object key) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            this.backing.remove(key);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putNoReturn(K key, V value) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            this.backing.put(key, value);
        }
        finally {
            l.unlock();
        }
    }

    public Map<K, V> getAll(Collection<? extends K> keys) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setConfigField(String name, Serializable value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ToolkitReadWriteLock createLockForKey(K key) {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getQuiet(Object key) {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            V v = this.backing.get(key);
            return v;
        }
        finally {
            l.unlock();
        }
    }

    public Map<K, V> getAllQuiet(Collection<K> keys) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void putNoReturn(K key, V value, long createTimeInSecs, int maxTTISeconds, int maxTTLSeconds) {
        this.putNoReturn(key, value);
    }

    public V putIfAbsent(K key, V value, long createTimeInSecs, int maxTTISeconds, int maxTTLSeconds) {
        return this.putIfAbsent(key, value);
    }

    public void addListener(ToolkitCacheListener<K> listener) {
    }

    public void removeListener(ToolkitCacheListener<K> listener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsent(K key, V value) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            if (this.backing.containsKey(key)) {
                V v = this.backing.get(key);
                return v;
            }
            this.backing.put(key, value);
            V v = null;
            return v;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object key, Object value) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            if (this.backing.containsKey(key) && value.equals(this.backing.get(key))) {
                this.backing.remove(key);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(K key, V oldValue, V newValue) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            if (this.backing.containsKey(key) && oldValue.equals(this.backing.get(key))) {
                this.backing.put(key, newValue);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V replace(K key, V value) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            if (this.backing.containsKey(key)) {
                V v = this.backing.put(key, value);
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            int n = this.backing.size();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            boolean bl = this.backing.isEmpty();
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            boolean bl = this.backing.containsKey(key);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            boolean bl = this.backing.containsValue(value);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(Object key) {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            V v = this.backing.get(key);
            return v;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            V v = this.backing.put(key, value);
            return v;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(Object key) {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            V v = this.backing.remove(key);
            return v;
        }
        finally {
            l.unlock();
        }
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ToolkitLock l = this.lock.writeLock();
        l.lock();
        try {
            this.backing.clear();
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<K> keySet() {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            LockedSet<K> lockedSet = new LockedSet<K>((ReadWriteLock)this.lock, this.backing.keySet());
            return lockedSet;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<V> values() {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            LockedCollection<V> lockedCollection = new LockedCollection<V>((ReadWriteLock)this.lock, this.backing.values());
            return lockedCollection;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Map.Entry<K, V>> entrySet() {
        ToolkitLock l = this.lock.readLock();
        l.lock();
        try {
            LockedSet<Map.Entry<K, V>> lockedSet = new LockedSet<Map.Entry<K, V>>((ReadWriteLock)this.lock, this.backing.entrySet());
            return lockedSet;
        }
        finally {
            l.unlock();
        }
    }

    public void setAttributeExtractor(ToolkitAttributeExtractor<K, V> attrExtractor) {
    }

    public QueryBuilder createQueryBuilder() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map<Object, Set<ClusterNode>> getNodesWithKeys(Set portableKeys) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void unlockedPutNoReturn(K k, V v, int createTime, int customTTI, int customTTL) {
        this.putNoReturn(k, v, createTime, createTime, createTime);
    }

    public void unlockedPutNoReturnVersioned(K k, V v, long version, int createTime, int customTTI, int customTTL) {
        this.putVersioned(k, v, version, createTime, customTTI, customTTL);
    }

    public void unlockedRemoveNoReturn(Object k) {
        this.removeNoReturn(k);
    }

    public void unlockedRemoveNoReturnVersioned(Object key, long version) {
        this.removeVersioned(key, version);
    }

    public V unlockedGet(Object k, boolean quiet) {
        return this.get(k);
    }

    public Map<K, V> unlockedGetAll(Collection<K> keys, boolean quiet) {
        if (quiet) {
            return this.getAllQuiet(keys);
        }
        return this.getAll(keys);
    }

    public void clearLocalCache() {
    }

    public V unsafeLocalGet(Object key) {
        return this.get(key);
    }

    public boolean containsLocalKey(Object key) {
        return this.containsKey(key);
    }

    public int localSize() {
        return this.size();
    }

    public Set<K> localKeySet() {
        return this.keySet();
    }

    public long localOnHeapSizeInBytes() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long localOffHeapSizeInBytes() {
        return 0L;
    }

    public int localOnHeapSize() {
        return this.localSize();
    }

    public int localOffHeapSize() {
        return 0;
    }

    public boolean containsKeyLocalOnHeap(Object key) {
        return this.containsLocalKey(key);
    }

    public boolean containsKeyLocalOffHeap(Object key) {
        return false;
    }

    public V put(K key, V value, int createTimeInSecs, int customMaxTTISeconds, int customMaxTTLSeconds) {
        return this.put(key, value);
    }

    public void putVersioned(K key, V value, long version) {
        this.put(key, value);
    }

    public void putVersioned(K key, V value, long version, int createTimeInSecs, int customMaxTTISeconds, int customMaxTTLSeconds) {
        this.putVersioned(key, value, version);
    }

    public void disposeLocally() {
    }

    public void removeAll(Set<K> keys) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeVersioned(Object key, long version) {
        this.removeNoReturn(key);
    }

    public void registerVersionUpdateListener(VersionUpdateListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void putIfAbsentVersioned(K k, V v, long l) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void putIfAbsentVersioned(K k, V v, long l, int i, int i1, int i2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Set<K> keySetForSegment(int i) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public VersionedValue<V> getVersionedValue(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void clearVersioned() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void quickClear() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int quickSize() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean remove(Object o, Object o1, ToolkitValueComparator<V> tvc) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean replace(K k, V v, V v1, ToolkitValueComparator<V> tvc) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isBulkLoadEnabled() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isNodeBulkLoadEnabled() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setNodeBulkLoadEnabled(boolean bln) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void waitUntilBulkLoadComplete() throws InterruptedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

