/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.upgradability.interaction.localtoolkit;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.terracotta.toolkit.ToolkitFeature;
import org.terracotta.toolkit.ToolkitFeatureType;
import org.terracotta.toolkit.ToolkitFeatureTypeInternal;
import org.terracotta.toolkit.atomic.ToolkitTransactionController;
import org.terracotta.toolkit.builder.ToolkitCacheConfigBuilder;
import org.terracotta.toolkit.builder.ToolkitStoreConfigBuilder;
import org.terracotta.toolkit.cache.ToolkitCache;
import org.terracotta.toolkit.cluster.ClusterInfo;
import org.terracotta.toolkit.collections.ToolkitBlockingQueue;
import org.terracotta.toolkit.collections.ToolkitList;
import org.terracotta.toolkit.collections.ToolkitMap;
import org.terracotta.toolkit.collections.ToolkitSet;
import org.terracotta.toolkit.collections.ToolkitSortedMap;
import org.terracotta.toolkit.collections.ToolkitSortedSet;
import org.terracotta.toolkit.concurrent.ToolkitBarrier;
import org.terracotta.toolkit.concurrent.atomic.ToolkitAtomicLong;
import org.terracotta.toolkit.concurrent.locks.ToolkitLock;
import org.terracotta.toolkit.concurrent.locks.ToolkitReadWriteLock;
import org.terracotta.toolkit.config.Configuration;
import org.terracotta.toolkit.events.ToolkitNotifier;
import org.terracotta.toolkit.feature.NonStopFeature;
import org.terracotta.toolkit.feature.SearchFeature;
import org.terracotta.toolkit.internal.ToolkitInternal;
import org.terracotta.toolkit.internal.ToolkitLogger;
import org.terracotta.toolkit.internal.ToolkitProperties;
import org.terracotta.toolkit.internal.concurrent.locks.ToolkitLockTypeInternal;
import org.terracotta.toolkit.internal.feature.LicenseFeature;
import org.terracotta.toolkit.monitoring.OperatorEventLevel;
import org.terracotta.toolkit.store.ToolkitStore;
import org.terracotta.upgradability.interaction.localtoolkit.atomic.LocalToolkitTransactionController;
import org.terracotta.upgradability.interaction.localtoolkit.cache.LocalCache;
import org.terracotta.upgradability.interaction.localtoolkit.cluster.LocalClusterInfo;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LocalBlockingQueue;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LocalList;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LocalMap;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LocalSet;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LocalSortedSet;
import org.terracotta.upgradability.interaction.localtoolkit.collections.LocalStore;
import org.terracotta.upgradability.interaction.localtoolkit.concurrent.locks.LocalConcurrentLock;
import org.terracotta.upgradability.interaction.localtoolkit.concurrent.locks.NamedLocalReadWriteLock;
import org.terracotta.upgradability.interaction.localtoolkit.events.LocalNotifier;
import org.terracotta.upgradability.interaction.localtoolkit.feature.LocalNonStopFeature;
import org.terracotta.upgradability.interaction.localtoolkit.feature.LocalSearchFeature;
import org.terracotta.upgradability.interaction.localtoolkit.internal.LocalLogger;
import org.terracotta.upgradability.interaction.localtoolkit.internal.LocalProperties;
import org.terracotta.upgradability.interaction.localtoolkit.internal.feature.LocalLicenseFeature;

public class LocalToolkit
implements ToolkitInternal {
    private final String clientUuid = UUID.randomUUID().toString();
    private final ClusterInfo clusterInfo = new LocalClusterInfo();
    private final ToolkitTransactionController transactionController = new LocalToolkitTransactionController();
    private final LicenseFeature license = new LocalLicenseFeature();
    private final NonStopFeature nonstop = new LocalNonStopFeature();
    private final SearchFeature search = new LocalSearchFeature();
    private final ToolkitProperties properties = new LocalProperties();
    private final Collection<Runnable> shutdownHooks = new CopyOnWriteArrayList<Runnable>();
    private final ConcurrentMap<ToolkitObjectIdentifier, Object> objects = new ConcurrentHashMap<ToolkitObjectIdentifier, Object>();

    public ToolkitLock getLock(String name, ToolkitLockTypeInternal tlti) {
        if (ToolkitLockTypeInternal.CONCURRENT.equals((Object)tlti)) {
            return new LocalConcurrentLock(name);
        }
        ToolkitReadWriteLock lock = this.getReadWriteLock(name);
        switch (tlti) {
            case SYNCHRONOUS_WRITE: 
            case WRITE: {
                return lock.writeLock();
            }
            case READ: {
                return lock.readLock();
            }
        }
        throw new UnsupportedOperationException();
    }

    public void registerBeforeShutdownHook(Runnable r) {
        this.shutdownHooks.add(r);
    }

    public void waitUntilAllTransactionsComplete() {
    }

    public ToolkitLogger getLogger(String string) {
        return new LocalLogger(string);
    }

    public String getClientUUID() {
        return this.clientUuid;
    }

    public ToolkitProperties getProperties() {
        return this.properties;
    }

    public <T extends ToolkitFeature> T getFeature(ToolkitFeatureTypeInternal<T> tfti) {
        if (ToolkitFeatureTypeInternal.TRANSACTION.equals(tfti)) {
            return (T)((ToolkitFeature)tfti.getFeatureClass().cast(this.transactionController));
        }
        if (ToolkitFeatureTypeInternal.LICENSE.equals(tfti)) {
            return (T)((ToolkitFeature)tfti.getFeatureClass().cast(this.license));
        }
        throw new UnsupportedOperationException("Feature: " + tfti + " not supported");
    }

    public <E> ToolkitList<E> getList(final String string, Class<E> type) {
        return this.getOrCreateToolkitObject(ToolkitList.class, string, new Callable(){

            public Object call() throws Exception {
                return new LocalList(string);
            }
        });
    }

    public <V> ToolkitStore<String, V> getStore(final String name, final Configuration config, final Class<V> type) {
        return this.getOrCreateToolkitObject(ToolkitStore.class, name, new Callable<ToolkitStore>(){

            @Override
            public ToolkitStore<String, V> call() throws Exception {
                return new LocalStore(name, config, type);
            }
        });
    }

    public <V> ToolkitStore<String, V> getStore(String string, Class<V> type) {
        return this.getStore(string, new ToolkitStoreConfigBuilder().build(), type);
    }

    public <K, V> ToolkitMap<K, V> getMap(final String name, Class<K> keyType, Class<V> valueType) {
        return this.getOrCreateToolkitObject(ToolkitMap.class, name, new Callable<ToolkitMap>(){

            @Override
            public ToolkitMap call() throws Exception {
                return new LocalMap(name);
            }
        });
    }

    public <K extends Comparable<? super K>, V> ToolkitSortedMap<K, V> getSortedMap(String string, Class<K> type, Class<V> type1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <E> ToolkitBlockingQueue<E> getBlockingQueue(final String name, final int capacity, final Class<E> type) {
        return this.getOrCreateToolkitObject(ToolkitBlockingQueue.class, name, new Callable<ToolkitBlockingQueue>(){

            @Override
            public ToolkitBlockingQueue<E> call() throws Exception {
                return new LocalBlockingQueue(name, capacity, type);
            }
        });
    }

    public <E> ToolkitBlockingQueue<E> getBlockingQueue(final String name, final Class<E> type) {
        return this.getOrCreateToolkitObject(ToolkitBlockingQueue.class, name, new Callable<ToolkitBlockingQueue>(){

            @Override
            public ToolkitBlockingQueue<E> call() throws Exception {
                return new LocalBlockingQueue(name, type);
            }
        });
    }

    public ClusterInfo getClusterInfo() {
        return this.clusterInfo;
    }

    public ToolkitLock getLock(String string) {
        return this.getLock(string, ToolkitLockTypeInternal.WRITE);
    }

    public ToolkitReadWriteLock getReadWriteLock(final String name) {
        return this.getOrCreateToolkitObject(ToolkitReadWriteLock.class, name, new Callable<ToolkitReadWriteLock>(){

            @Override
            public ToolkitReadWriteLock call() throws Exception {
                return new NamedLocalReadWriteLock(name);
            }
        });
    }

    public <E> ToolkitNotifier<E> getNotifier(final String name, Class<E> type) {
        return this.getOrCreateToolkitObject(ToolkitNotifier.class, name, new Callable<ToolkitNotifier>(){

            @Override
            public ToolkitNotifier call() throws Exception {
                return new LocalNotifier(name);
            }
        });
    }

    public ToolkitAtomicLong getAtomicLong(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ToolkitBarrier getBarrier(String string, int i) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void fireOperatorEvent(OperatorEventLevel oel, String string, String string1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <E extends Comparable<? super E>> ToolkitSortedSet<E> getSortedSet(final String name, final Class<E> type) {
        return this.getOrCreateToolkitObject(ToolkitSortedSet.class, name, new Callable<ToolkitSortedSet>(){

            @Override
            public ToolkitSortedSet<E> call() throws Exception {
                return new LocalSortedSet(name, type);
            }
        });
    }

    public <E> ToolkitSet<E> getSet(final String name, final Class<E> type) {
        return this.getOrCreateToolkitObject(ToolkitSet.class, name, new Callable<ToolkitSet>(){

            @Override
            public ToolkitSet call() throws Exception {
                return new LocalSet(name, type);
            }
        });
    }

    public <V> ToolkitCache<String, V> getCache(final String name, final Configuration config, final Class<V> type) {
        return this.getOrCreateToolkitObject(ToolkitCache.class, name, new Callable<ToolkitCache>(){

            @Override
            public ToolkitCache<String, V> call() throws Exception {
                return new LocalCache(name, config, String.class, type);
            }
        });
    }

    public <V> ToolkitCache<String, V> getCache(String string, Class<V> type) {
        return this.getCache(string, new ToolkitCacheConfigBuilder().build(), type);
    }

    public void shutdown() {
        for (Runnable r : this.shutdownHooks) {
            new Thread(r).start();
        }
    }

    public <T extends ToolkitFeature> T getFeature(ToolkitFeatureType<T> tft) {
        if (ToolkitFeatureType.NONSTOP.equals(tft)) {
            return (T)((ToolkitFeature)tft.getFeatureClass().cast(this.nonstop));
        }
        if (ToolkitFeatureType.SEARCH.equals(tft)) {
            return (T)((ToolkitFeature)tft.getFeatureClass().cast(this.search));
        }
        throw new UnsupportedOperationException("Feature: " + tft + " not supported");
    }

    private <T> T getOrCreateToolkitObject(Class<T> klazz, String name, Callable<T> generator) {
        ToolkitObjectIdentifier id = new ToolkitObjectIdentifier(klazz, name);
        Object existing = this.objects.get(id);
        if (existing == null) {
            T created;
            try {
                created = generator.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            existing = this.objects.putIfAbsent(id, created);
            if (existing == null) {
                return created;
            }
        }
        return (T)existing;
    }

    static class ToolkitObjectIdentifier {
        private final Class<?> klazz;
        private final String name;

        public ToolkitObjectIdentifier(Class<?> klazz, String name) {
            this.klazz = klazz;
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ToolkitObjectIdentifier) {
                ToolkitObjectIdentifier other = (ToolkitObjectIdentifier)obj;
                return this.klazz.equals(other.klazz) && this.name.equals(other.name);
            }
            return false;
        }

        public int hashCode() {
            return this.klazz.hashCode() ^ this.name.hashCode();
        }
    }
}

