/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ExecTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static String exec(String command, List<String> params, File workDir) {
        String param2;
        File outputFile;
        try {
            outputFile = File.createTempFile("exec", ".out");
            outputFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Project dummyProject = new Project();
        dummyProject.init();
        ExecTask execTask = new ExecTask();
        execTask.setProject(dummyProject);
        execTask.setOutput(outputFile);
        execTask.setDir(workDir != null ? workDir : new File(System.getProperty("user.dir")));
        execTask.setExecutable(command);
        if (params != null) {
            for (String param2 : params) {
                execTask.createArg().setValue(param2);
            }
        }
        FileReader reader = null;
        try {
            execTask.execute();
            reader = new FileReader(outputFile);
            param2 = IOUtils.toString((Reader)reader);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                outputFile.delete();
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        outputFile.delete();
        return param2;
    }

    public static String getSvnInfo(String svnRepo) {
        String svnCommand = "svn";
        String svnHome = System.getenv("SVN_HOME");
        if (svnHome != null) {
            svnCommand = svnHome + "/bin/svn";
        }
        return Util.exec(svnCommand, Arrays.asList("info", svnRepo), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getZipEntries(File file) throws IOException {
        StringBuilder buff = new StringBuilder();
        ZipFile zipFile = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                buff.append(zipEntries.nextElement().getName()).append("\n");
            }
            String string = buff.toString();
            return string;
        }
        finally {
            zipFile.close();
        }
    }
}

