/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.artifact.MavenMetadataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnforceMatchingDependenciesMojo
extends AbstractMojo {
    protected MavenProject project;
    protected MavenProjectBuilder projectBuilder;
    protected ArtifactMetadataSource metadataSource;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    protected List remoteRepositories;
    protected ArtifactRepository localRepository;
    private String enforceArtifactId;
    private String enforceGroupId;
    private String enforceType;
    private String enforceVersion;
    private String excludeGroupIds;

    public void execute() throws MojoExecutionException {
        try {
            Artifact enforceArtifact = this.artifactFactory.createArtifact(this.enforceGroupId, this.enforceArtifactId, this.enforceVersion, "", this.enforceType);
            this.artifactResolver.resolve(enforceArtifact, this.remoteRepositories, this.localRepository);
            Artifact pomArtifact = this.artifactFactory.createArtifact(this.enforceGroupId, this.enforceArtifactId, this.enforceVersion, "", "pom");
            MavenProject projectForPom = null;
            projectForPom = this.projectBuilder.buildFromRepository(pomArtifact, this.remoteRepositories, this.localRepository);
            List dependencies = projectForPom.getDependencies();
            Set dependencyArtifacts = MavenMetadataSource.createArtifacts((ArtifactFactory)this.artifactFactory, (List)dependencies, null, null, null);
            dependencyArtifacts.add(projectForPom.getArtifact());
            ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(dependencyArtifacts, pomArtifact, Collections.EMPTY_MAP, this.localRepository, this.remoteRepositories, this.metadataSource, null, Collections.EMPTY_LIST);
            Set<Artifact> enforceArtifacts = EnforceMatchingDependenciesMojo.filterCompileAndRuntimeScope(result.getArtifacts());
            this.getLog().debug((CharSequence)("enforce artifacts before exclusions: " + enforceArtifacts));
            if (this.excludeGroupIds != null) {
                enforceArtifacts = EnforceMatchingDependenciesMojo.filterExcludeGroupIds(enforceArtifacts, this.excludeGroupIds);
                this.getLog().debug((CharSequence)("enforce artifacts after exclusions: " + enforceArtifacts));
            }
            Set<Artifact> thisProjectartifacts = EnforceMatchingDependenciesMojo.filterCompileAndRuntimeScope(this.project.getArtifacts());
            this.getLog().debug((CharSequence)("current artifacts: " + thisProjectartifacts));
            if (!thisProjectartifacts.containsAll(enforceArtifacts)) {
                HashSet<Artifact> missingArtifacts = new HashSet<Artifact>(enforceArtifacts);
                missingArtifacts.removeAll(thisProjectartifacts);
                String message = "This pom is missing some dependencies of the enforcing artifact " + enforceArtifact + "\n";
                message = message + "Missing " + missingArtifacts;
                throw new MojoFailureException(message);
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)e.getMessage());
            throw new MojoExecutionException("Error", e);
        }
    }

    private static Set<Artifact> filterCompileAndRuntimeScope(Set<Artifact> artifacts) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (Artifact a : artifacts) {
            if (!a.getArtifactHandler().isAddedToClasspath() || !"compile".equals(a.getScope()) && !"runtime".equals(a.getScope())) continue;
            result.add(a);
        }
        return result;
    }

    private static Set<Artifact> filterExcludeGroupIds(Set<Artifact> artifacts, String excludeGroupIds) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        List<String> excludes = Arrays.asList(excludeGroupIds.split("\\s*,\\s*"));
        for (Artifact a : artifacts) {
            if (excludes.contains(a.getGroupId())) continue;
            result.add(a);
        }
        return result;
    }
}

