/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.forge.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayBuildInfoMojo
extends AbstractMojo {
    protected MavenProject project;
    private String includes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set<String> includedGroupIds = this.parseIncludesGroupIds();
        this.getLog().info((CharSequence)("Includes '" + includedGroupIds.toString() + "'"));
        Set artifacts = this.project.getArtifacts();
        for (Artifact artifact : artifacts) {
            if (!this.isIncluded(includedGroupIds, artifact)) continue;
            this.getLog().info((CharSequence)("Build info for artifact " + artifact));
            this.displayBuildInfo(artifact);
        }
    }

    private Set<String> parseIncludesGroupIds() {
        if (this.includes == null || this.includes.equals("")) {
            return Collections.EMPTY_SET;
        }
        return new TreeSet<String>(Arrays.asList(this.includes.trim().split("\\s*,\\s*")));
    }

    private boolean isIncluded(Set<String> groupIds, Artifact artifact) {
        if (!"jar".equals(artifact.getType())) {
            return false;
        }
        String artifactGroupId = artifact.getGroupId();
        for (String includedGroupId : groupIds) {
            if (!artifactGroupId.startsWith(includedGroupId)) continue;
            return true;
        }
        return false;
    }

    private void displayBuildInfo(Artifact artifact) throws MojoExecutionException {
        File artifactFile = artifact.getFile();
        if (artifactFile != null && artifactFile.exists()) {
            this.getLog().info((CharSequence)this.getBuildInfo(artifact));
        } else {
            this.getLog().warn((CharSequence)("Couldn't find artifact " + artifact + " in local repo"));
        }
    }

    private String getBuildInfo(Artifact artifact) throws MojoExecutionException {
        try {
            File artifactFile = artifact.getFile();
            JarFile artifactJar = new JarFile(artifactFile);
            Manifest manifest = artifactJar.getManifest();
            StringBuilder sb = new StringBuilder();
            Attributes attributes = manifest.getMainAttributes();
            for (Object key : attributes.keySet()) {
                String name = ((Attributes.Name)key).toString();
                if (!name.startsWith("Build")) continue;
                sb.append(name).append(": ").append(attributes.get(key)).append("\n");
            }
            return sb.toString();
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed reading manifest", (Exception)ex);
        }
    }
}

