/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.loader.tcjar;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.terracotta.agent.loader.Jar;
import org.terracotta.agent.loader.JarManager;

public class Handler
extends URLStreamHandler {
    public static final String TC_JAR_PROTOCOL = "tcjar";
    private static final JarManager JAR_MANAGER = new JarManager();

    protected URLConnection openConnection(URL url) throws IOException {
        byte[] data;
        int lastIndex;
        if (!url.getProtocol().equals(TC_JAR_PROTOCOL)) {
            throw new IOException("wrong protocol: " + url.getProtocol());
        }
        String path = url.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((lastIndex = path.lastIndexOf("!/")) < 0) {
            throw new IOException("unexpected path: " + path);
        }
        int firstIndex = path.indexOf("!/");
        if (firstIndex == lastIndex) {
            Jar jar = JAR_MANAGER.get(new URL(path));
            if (jar == null) {
                throw new IOException("No such resource: " + path);
            }
            try {
                return new Connection(url, jar.contents());
            }
            catch (Exception e) {
                IOException ioe = new IOException("Failed to read: " + path);
                ioe.initCause(e);
                throw ioe;
            }
        }
        URL baseUrl = new URL(path.substring(0, lastIndex));
        String resource = path.substring(lastIndex + 2);
        Jar jar = JAR_MANAGER.get(baseUrl);
        try {
            data = jar.lookup(resource);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Failed to find: " + resource);
            ioe.initCause(e);
            throw ioe;
        }
        if (data == null) {
            throw new IOException("No such resouce: " + resource);
        }
        return new Connection(url, data);
    }

    public static Jar getOrCreate(URL u) {
        return JAR_MANAGER.getOrCreate(u);
    }

    private static class Connection
    extends URLConnection {
        private final byte[] content;

        public Connection(URL url, byte[] content) {
            super(url);
            this.content = content;
        }

        public void connect() {
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.content);
        }
    }
}

