/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.loader;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.terracotta.agent.loader.Jar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCClassLoader
extends ClassLoader {
    private final List<Jar> jars;
    private final Map<String, byte[]> extraClassDefs;

    public TCClassLoader(List<Jar> jars, ClassLoader parent) throws Exception {
        this(jars, parent, Collections.EMPTY_MAP);
    }

    public TCClassLoader(List<Jar> jars, ClassLoader parent, Map<String, byte[]> extraClassDefs) throws Exception {
        super(parent);
        this.extraClassDefs = new HashMap<String, byte[]>(extraClassDefs);
        this.jars = new ArrayList<Jar>(jars);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        LookupResult result;
        byte[] classBytes = this.extraClassDefs.remove(name);
        if (classBytes != null) {
            return this.defineClass(name, classBytes, 0, classBytes.length);
        }
        String resource = name.replace('.', '/').concat(".class");
        try {
            result = this.lookup(resource);
        }
        catch (Exception e) {
            throw new ClassNotFoundException(name, e);
        }
        if (result != null) {
            String pkg = TCClassLoader.packageFor(name);
            if (pkg != null && this.getPackage(pkg) == null) {
                this.definePackage(pkg, "", "", "", "", "", "", null);
            }
            ProtectionDomain pd = result.getSource().getProtectionDomain();
            return this.defineClass(name, result.getData(), 0, result.getData().length, pd);
        }
        throw new ClassNotFoundException(name);
    }

    private static String packageFor(String className) {
        int lastDot = className.lastIndexOf(46);
        if (lastDot >= 0) {
            return className.substring(0, lastDot);
        }
        return null;
    }

    private LookupResult lookup(String res) throws Exception {
        for (Jar jar : this.jars) {
            byte[] classBytes = jar.lookup(res);
            if (classBytes == null) continue;
            return new LookupResult(classBytes, jar);
        }
        return null;
    }

    private Jar locate(String res) throws Exception {
        for (Jar jar : this.jars) {
            if (!jar.hasResource(res)) continue;
            return jar;
        }
        return null;
    }

    @Override
    protected URL findResource(String name) {
        Jar jar;
        if (name == null) {
            throw new NullPointerException();
        }
        try {
            jar = this.locate(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (jar == null) {
            return null;
        }
        try {
            return new URL("tcjar:///" + jar.getSource() + "!/" + name);
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class LookupResult {
        private final Jar source;
        private final byte[] data;

        LookupResult(byte[] data, Jar source) {
            this.data = data;
            this.source = source;
        }

        byte[] getData() {
            return this.data;
        }

        Jar getSource() {
            return this.source;
        }
    }
}

