/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.loader;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.terracotta.agent.loader.Jar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarManager {
    private static final long DEFAULT_IDLE_TIME = 30000L;
    private final Map<URL, Jar> jars = new HashMap<URL, Jar>();
    private Thread idleThread;
    private final long idleTime;

    public JarManager() {
        this(30000L);
    }

    public JarManager(long idleTime) {
        this.idleTime = idleTime;
    }

    public synchronized Jar getOrCreate(URL source) {
        if (source == null) {
            throw new NullPointerException("null source");
        }
        Jar jar = this.jars.get(source);
        if (jar == null) {
            jar = new Jar(source, this);
            this.jars.put(source, jar);
        }
        return jar;
    }

    public synchronized Jar get(URL source) {
        if (source == null) {
            throw new NullPointerException("null source");
        }
        return this.jars.get(source);
    }

    synchronized void jarOpened(Jar jar) {
        if (this.idleThread == null) {
            this.idleThread = new IdleThread(this, this.idleTime);
            this.idleThread.start();
        }
    }

    synchronized Collection<Jar> getJarsSnapshot() {
        return new ArrayList<Jar>(this.jars.values());
    }

    private static class IdleThread
    extends Thread {
        private final long idle;
        private final JarManager manager;

        IdleThread(JarManager manager, long idle) {
            this.manager = manager;
            this.idle = idle;
            this.setName("JarManager idle thread");
            this.setDaemon(true);
        }

        public void run() {
            long sleep = Math.max(1000L, this.idle / 10L);
            block2: while (true) {
                try {
                    IdleThread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                Iterator<Jar> i$ = this.manager.getJarsSnapshot().iterator();
                while (true) {
                    if (!i$.hasNext()) continue block2;
                    Jar jar = i$.next();
                    jar.deflateIfIdle(this.idle);
                }
                break;
            }
        }
    }
}

