/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent;

import com.tc.aspectwerkz.transform.InstrumentationContext;
import com.tc.bundles.VirtualTimRepository;
import com.tc.config.schema.IllegalConfigurationChangeHandler;
import com.tc.config.schema.setup.FatalIllegalConfigurationChangeHandler;
import com.tc.config.schema.setup.L1TVSConfigurationSetupManager;
import com.tc.config.schema.setup.StandardTVSConfigurationSetupManagerFactory;
import com.tc.logging.NullTCLogger;
import com.tc.logging.TCLogger;
import com.tc.object.bytecode.hook.impl.DefaultWeavingStrategy;
import com.tc.object.config.DSOClientConfigHelper;
import com.tc.object.config.StandardDSOClientConfigHelperImpl;
import com.tc.object.logging.InstrumentationLogger;
import com.tc.object.logging.NullInstrumentationLogger;
import com.tc.plugins.ModulesLoader;
import com.terracottatech.config.Client;
import com.terracottatech.config.Module;
import com.terracottatech.config.Modules;
import com.terracottatech.config.TcConfigDocument;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.terracotta.agent.loader.Jar;
import org.terracotta.agent.loader.TCClassLoader;
import org.terracotta.agent.loader.Util;
import org.terracotta.agent.loader.tcjar.Handler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Agent {
    private static final String SIGAR_LIB_PATH_PROPERTY_NAME = "org.hyperic.sigar.path";
    private static final String TIM_LIST = "/META-INF/terracotta/timlist";
    private static final AtomicBoolean ACTIVATED = new AtomicBoolean(false);
    private static final List<Jar> L1_JARS = Collections.synchronizedList(new ArrayList());
    private static final List<Jar> TIM_JARS = Collections.synchronizedList(new ArrayList());
    private static final Map<String, URL> VIRTUAL_TIM_JARS = new ConcurrentHashMap<String, URL>();

    public static Map<String, URL> getVirtualTIMs() {
        return Collections.unmodifiableMap(VIRTUAL_TIM_JARS);
    }

    public static List<Jar> getL1Jars() {
        return Collections.unmodifiableList(L1_JARS);
    }

    public static List<Jar> getTIMJars() {
        return Collections.unmodifiableList(TIM_JARS);
    }

    public static boolean wasActivated() {
        return ACTIVATED.get();
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        String[] timsToLoad;
        if (!ACTIVATED.compareAndSet(false, true)) {
            throw new AssertionError((Object)"activated more than once");
        }
        Agent.setupUrlStreamHandler();
        System.setProperty("tc.active", "true");
        System.setProperty("tc.dso.globalmode", "false");
        URL source = Agent.class.getProtectionDomain().getCodeSource().getLocation();
        ArrayList<URL> virtualL1Jars = new ArrayList<URL>();
        ZipInputStream agentJar = null;
        try {
            File sigarTmpDir = Agent.createTempDir("tmpSigarJars");
            agentJar = new ZipInputStream(source.openStream());
            ZipEntry entry = agentJar.getNextEntry();
            while (entry != null) {
                if (entry.getName().startsWith("L1") && entry.getName().endsWith(".jar")) {
                    virtualL1Jars.add(new URL("jar:" + source.toExternalForm() + "!/" + entry.getName()));
                } else if (entry.getName().startsWith("TIMs") && entry.getName().endsWith(".jar")) {
                    String baseJar = Agent.baseName(entry);
                    URL timJarUrl = new URL("jar:" + source.toExternalForm() + "!/" + entry.getName());
                    Jar timJar = Handler.getOrCreate(timJarUrl);
                    TIM_JARS.add(timJar);
                    VIRTUAL_TIM_JARS.put(baseJar, new URL("tcjar:" + timJarUrl.toExternalForm()));
                }
                if (entry.getName().toLowerCase().contains("sigar")) {
                    Agent.handleSigarZipEntry(agentJar, entry, sigarTmpDir);
                }
                entry = agentJar.getNextEntry();
            }
            System.setProperty(SIGAR_LIB_PATH_PROPERTY_NAME, sigarTmpDir.getAbsolutePath());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            if (agentJar != null) {
                try {
                    agentJar.close();
                }
                catch (IOException ioe) {}
            }
        }
        if (virtualL1Jars.isEmpty()) {
            throw new AssertionError((Object)"No terracotta L1 libraries found in agent");
        }
        InputStream in = Agent.class.getResourceAsStream(TIM_LIST);
        if (in == null) {
            System.err.println("Missing resource: /META-INF/terracotta/timlist");
            System.exit(1);
        }
        try {
            timsToLoad = Agent.readTimList(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (URL u : virtualL1Jars) {
            L1_JARS.add(Handler.getOrCreate(u));
        }
        HashMap<String, byte[]> extraClasses = new HashMap<String, byte[]>();
        extraClasses.put(Boot.class.getName(), Agent.getBootClassBytes());
        try {
            TCClassLoader l1Loader = new TCClassLoader(L1_JARS, null, extraClasses);
            Class<?> bootClass = l1Loader.loadClass(Boot.class.getName());
            Constructor<?> cstr = bootClass.getConstructor(String[].class, Map.class);
            Object boot = cstr.newInstance(timsToLoad, VIRTUAL_TIM_JARS);
            inst.addTransformer((ClassFileTransformer)boot);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBootClassBytes() {
        ClassLoader loader = Agent.class.getClassLoader();
        String res = Boot.class.getName().replace('.', '/').concat(".class");
        try {
            return Util.extract(loader.getResourceAsStream(res));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void handleSigarZipEntry(ZipInputStream agentJar, ZipEntry entry, File sigarTmpDir) throws IOException {
        if (entry.getName().contains(Agent.baseLibraryName())) {
            Agent.extractSigarZipEntry(agentJar, entry, sigarTmpDir);
        }
    }

    private static void extractSigarZipEntry(ZipInputStream jar, ZipEntry entry, File outputDir) throws IOException {
        byte[] content = Agent.getCurrentZipEntry(jar);
        String outName = Agent.baseName(entry);
        int index = outName.lastIndexOf(45);
        if (index > 0) {
            String ext = outName.substring(outName.lastIndexOf(46));
            outName = outName.substring(0, index) + ext;
        }
        File outFile = new File(outputDir, outName);
        Agent.writeFile(outFile, content);
        outFile.deleteOnExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(File file, byte[] contents) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(contents);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static byte[] getCurrentZipEntry(ZipInputStream zis) throws IOException {
        int n;
        byte[] buf = new byte[1024];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while ((n = zis.read(buf, 0, 1024)) > -1) {
            bout.write(buf, 0, n);
        }
        bout.close();
        return bout.toByteArray();
    }

    public static File createTempDir(String prefix) throws IOException {
        File tempDir = File.createTempFile(prefix, Long.toString(System.nanoTime()));
        if (!tempDir.delete()) {
            throw new IOException("Could not delete temp file: " + tempDir.getAbsolutePath());
        }
        if (!tempDir.mkdir()) {
            throw new IOException("Could not create temp directory: " + tempDir.getAbsolutePath());
        }
        tempDir.deleteOnExit();
        return tempDir;
    }

    private static void setupUrlStreamHandler() {
        String prop = "java.protocol.handler.pkgs";
        String handlers = System.getProperty(prop, "");
        if (handlers.length() > 0 && !handlers.endsWith("|")) {
            handlers = handlers + "|";
        }
        handlers = handlers + "org.terracotta.agent.loader";
        System.setProperty(prop, handlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] readTimList(InputStream in) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            String[] stringArray = lines.toArray(new String[lines.size()]);
            return stringArray;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioe) {}
        }
    }

    private static String baseName(ZipEntry entry) {
        return new File(entry.getName()).getName();
    }

    public static String baseLibraryName() {
        String name = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        String version = System.getProperty("os.version");
        String majorVersion = version.substring(0, 1);
        StringBuffer buf = new StringBuffer();
        if (arch.endsWith("86")) {
            arch = "x86";
        }
        if (name.equals("Linux")) {
            buf.append(arch).append("-linux");
        } else if (name.indexOf("Windows") > -1) {
            buf.append(arch).append("-winnt");
        } else if (name.equals("SunOS")) {
            if (arch.startsWith("sparcv") && "64".equals(System.getProperty("sun.arch.data.model"))) {
                arch = "sparc64";
            }
            buf.append(arch).append("-solaris");
        } else if (name.equals("HP-UX")) {
            arch = arch.startsWith("IA64") ? "ia64" : "pa";
            if (version.indexOf("11") > -1) {
                buf.append(arch).append("-hpux-11");
            }
        } else if (name.equals("AIX")) {
            buf.append("ppc-aix-").append(majorVersion);
        } else if (name.equals("Mac OS X")) {
            buf.append("universal-macosx");
        } else if (name.equals("FreeBSD")) {
            buf.append(arch).append("-freebsd-").append(majorVersion);
        } else if (name.equals("OpenBSD")) {
            buf.append(arch).append("-openbsd-").append(majorVersion);
        } else if (name.equals("NetBSD")) {
            buf.append(arch).append("-netbsd-").append(majorVersion);
        } else if (name.equals("OSF1")) {
            buf.append("alpha-osf1-").append(majorVersion);
        } else if (name.equals("NetWare")) {
            buf.append("x86-netware-").append(majorVersion);
        }
        if (buf.length() == 0) {
            return null;
        }
        String prefix = "libsigar-";
        if (name.startsWith("Windows")) {
            prefix = "sigar-";
        }
        return prefix + buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Boot
    implements ClassFileTransformer {
        private final DefaultWeavingStrategy weavingStrategy;
        private final DSOClientConfigHelper clientConfig;

        public Boot(String[] tims, Map<String, URL> virtualTimJars) throws Exception {
            ArrayList<VirtualTimRepository> repo = new ArrayList<VirtualTimRepository>();
            repo.add(new VirtualTimRepository(virtualTimJars));
            this.clientConfig = new StandardDSOClientConfigHelperImpl(this.createConfigSetupManager(tims), false);
            ModulesLoader.initModules((DSOClientConfigHelper)this.clientConfig, null, (boolean)true, repo);
            this.weavingStrategy = new DefaultWeavingStrategy(this.clientConfig, (InstrumentationLogger)new NullInstrumentationLogger(), true);
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
            try {
                return this.doTransform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }

        private byte[] doTransform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
            if (loader instanceof TCClassLoader) {
                return null;
            }
            if (loader == null || className.startsWith("java.") || className.startsWith("javax.")) {
                return null;
            }
            className = className.replace('/', '.');
            InstrumentationContext context = new InstrumentationContext(className, classfileBuffer, loader);
            this.weavingStrategy.transform(className, context);
            return context.getCurrentBytecode();
        }

        private File buildTcConfigFile(String[] tims) throws Exception {
            TcConfigDocument doc = TcConfigDocument.Factory.newInstance();
            TcConfigDocument.TcConfig tcConfig = doc.addNewTcConfig();
            Client clients = tcConfig.addNewClients();
            Modules modules = clients.addNewModules();
            for (String tim : tims) {
                Module module = modules.addNewModule();
                module.setName(tim);
            }
            File tmpFile = File.createTempFile("tc-config", ".xml");
            tmpFile.deleteOnExit();
            Agent.writeFile(tmpFile, doc.toString().getBytes());
            return tmpFile;
        }

        private L1TVSConfigurationSetupManager createConfigSetupManager(String[] tims) throws Exception {
            File tcConfigFile = this.buildTcConfigFile(tims);
            Option configFileOption = new Option("f", "config", true, "configuration file (optional)");
            configFileOption.setArgName("file-or-URL");
            configFileOption.setType(String.class);
            configFileOption.setRequired(false);
            Options options = new Options();
            options.addOption(configFileOption);
            String[] newArgs = new String[2];
            newArgs[newArgs.length - 2] = "-f";
            newArgs[newArgs.length - 1] = tcConfigFile.getAbsolutePath();
            CommandLine cmdLine = new PosixParser().parse(options, newArgs);
            StandardTVSConfigurationSetupManagerFactory factory = new StandardTVSConfigurationSetupManagerFactory(cmdLine, false, (IllegalConfigurationChangeHandler)new FatalIllegalConfigurationChangeHandler());
            NullTCLogger logger = new NullTCLogger();
            L1TVSConfigurationSetupManager setupManager = factory.createL1TVSConfigurationSetupManager((TCLogger)logger);
            tcConfigFile.delete();
            return setupManager;
        }
    }
}

